/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableResidue;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import edu.jas.structure.ValueFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class SolvableResidueRing<C extends GcdRingElem<C>>
implements RingFactory<SolvableResidue<C>>,
QuotPairFactory<GenPolynomial<C>, SolvableResidue<C>>,
ValueFactory<GenPolynomial<C>, SolvableResidue<C>> {
    private static final Logger logger = Logger.getLogger(SolvableResidueRing.class);
    protected final SolvableGroebnerBaseAbstract<C> bb;
    public final SolvableIdeal<C> ideal;
    public final GenSolvablePolynomialRing<C> ring;
    protected int isField = -1;

    public SolvableResidueRing(SolvableIdeal<C> solvableIdeal) {
        this(solvableIdeal, false);
    }

    public SolvableResidueRing(SolvableIdeal<C> solvableIdeal, boolean bl) {
        this.ideal = solvableIdeal.GB();
        this.ring = this.ideal.getRing();
        this.bb = new SolvableGroebnerBaseSeq();
        if (bl) {
            this.isField = 1;
            return;
        }
        if (this.ideal.isONE()) {
            logger.warn((Object)"ideal is one, so all residues are 0");
        }
    }

    @Override
    public GenSolvablePolynomialRing<C> pairFactory() {
        return this.ring;
    }

    @Override
    public GenSolvablePolynomialRing<C> valueFactory() {
        return this.ring;
    }

    @Override
    public SolvableResidue<C> create(GenPolynomial<C> genPolynomial) {
        return new SolvableResidue(this, (GenSolvablePolynomial)genPolynomial);
    }

    @Override
    public SolvableResidue<C> create(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 != null && !genPolynomial2.isONE()) {
            throw new UnsupportedOperationException("d must be 1, but d = " + genPolynomial2);
        }
        return new SolvableResidue(this, (GenSolvablePolynomial)genPolynomial);
    }

    @Override
    public boolean isFinite() {
        return this.ideal.commonZeroTest() <= 0 && this.ring.coFac.isFinite();
    }

    @Override
    public SolvableResidue<C> copy(SolvableResidue<C> solvableResidue) {
        if (solvableResidue == null) {
            return this.getZERO();
        }
        SolvableResidue solvableResidue2 = new SolvableResidue(this, solvableResidue.val);
        return solvableResidue2;
    }

    @Override
    public SolvableResidue<C> getZERO() {
        return new SolvableResidue(this, this.ring.getZERO());
    }

    @Override
    public SolvableResidue<C> getONE() {
        SolvableResidue solvableResidue = new SolvableResidue(this, this.ring.getONE());
        if (solvableResidue.isZERO()) {
            logger.warn((Object)"ideal is one, so all residues are 0");
        }
        return solvableResidue;
    }

    @Override
    public List<SolvableResidue<C>> generators() {
        List list = this.ring.generators();
        ArrayList<SolvableResidue<C>> arrayList = new ArrayList<SolvableResidue<C>>(list.size());
        TreeSet treeSet = new TreeSet();
        ArrayList arrayList2 = new ArrayList(list.size());
        SolvableIdeal<C> solvableIdeal = new SolvableIdeal<C>(this.ring, arrayList2);
        SolvableResidueRing<C> solvableResidueRing = new SolvableResidueRing<C>(solvableIdeal);
        for (GenPolynomial genPolynomial : list) {
            SolvableResidue<C> solvableResidue;
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial;
            SolvableResidue solvableResidue2 = new SolvableResidue(this, genSolvablePolynomial);
            if (solvableResidue2.isZERO() || !solvableResidue2.isONE() && solvableResidue2.val.isConstant() || (solvableResidue = new SolvableResidue<C>(solvableResidueRing, solvableResidue2.val)).isZERO() || !solvableResidue.isONE() && solvableResidue.val.isConstant() || (solvableResidue2 = new SolvableResidue(this, solvableResidue.val)).isZERO()) continue;
            if (!(solvableResidue2 = solvableResidue2.monic()).isONE() && !solvableResidue2.val.isConstant()) {
                arrayList2.add(solvableResidue2.val);
                solvableIdeal = new SolvableIdeal<C>(this.ring, arrayList2);
                solvableResidueRing = new SolvableResidueRing<C>(solvableIdeal);
            }
            treeSet.add(solvableResidue2);
        }
        arrayList.addAll(treeSet);
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.ideal.isMaximal()) {
            this.isField = 1;
            return true;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public SolvableResidue<C> fromInteger(BigInteger bigInteger) {
        return new SolvableResidue(this, this.ring.fromInteger(bigInteger));
    }

    @Override
    public SolvableResidue<C> fromInteger(long l) {
        return new SolvableResidue(this, this.ring.fromInteger(l));
    }

    public String toString() {
        return "SolvableResidueRing[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "SRC(" + this.ideal.list.toScript() + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof SolvableResidueRing)) {
            return false;
        }
        SolvableResidueRing solvableResidueRing = null;
        try {
            solvableResidueRing = (SolvableResidueRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (solvableResidueRing == null) {
            return false;
        }
        if (!this.ring.equals(solvableResidueRing.ring)) {
            return false;
        }
        return this.ideal.equals(solvableResidueRing.ideal);
    }

    public int hashCode() {
        int n = this.ideal.hashCode();
        return n;
    }

    @Override
    public SolvableResidue<C> random(int n) {
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        return new SolvableResidue(this, genPolynomial);
    }

    public SolvableResidue<C> random(int n, int n2, int n3, float f) {
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.random(n, n2, n3, f)).monic();
        return new SolvableResidue(this, genPolynomial);
    }

    @Override
    public SolvableResidue<C> random(int n, Random random) {
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.random(n, random)).monic();
        return new SolvableResidue(this, genPolynomial);
    }

    @Override
    public SolvableResidue<C> parse(String string) {
        GenPolynomial genPolynomial = this.ring.parse(string);
        return new SolvableResidue(this, genPolynomial);
    }

    @Override
    public SolvableResidue<C> parse(Reader reader) {
        GenPolynomial genPolynomial = this.ring.parse(reader);
        return new SolvableResidue(this, genPolynomial);
    }
}

