/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GCDSimpleTest
extends TestCase {
    GreatestCommonDivisorAbstract<BigInteger> ufd;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GCDSimpleTest.suite());
    }

    public GCDSimpleTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDSimpleTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = new GreatestCommonDivisorSimple<BigInteger>();
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testBaseGcdSimple() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        for (int i = 0; i < 5; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2, this.el + 2, this.q);
            this.c = this.c.multiply((BigInteger)((Object)this.dfac.univariate(0)));
            if (this.c.isZERO()) continue;
            this.c = this.ufd.basePrimitivePart(this.c).abs();
            GCDSimpleTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigInteger)((Object)this.c));
            this.b = this.b.multiply((BigInteger)((Object)this.c));
            this.d = this.ufd.baseGcd(this.a, this.b);
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            this.e = PolyUtil.basePseudoRemainder(this.a, this.d);
            GCDSimpleTest.assertTrue((String)("gcd(a,b) | a" + this.e), (boolean)this.e.isZERO());
            this.e = PolyUtil.basePseudoRemainder(this.b, this.d);
            GCDSimpleTest.assertTrue((String)("gcd(a,b) | b" + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testRecursiveGCDSimple() {
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 2, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        for (int i = 0; i < 3; ++i) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.ufd.recursivePrimitivePart(this.cr).abs();
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            GCDSimpleTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.ar = this.ar.multiply((GenPolynomial<BigInteger>)this.cr);
            this.br = this.br.multiply((GenPolynomial<BigInteger>)this.cr);
            this.dr = this.ufd.recursiveUnivariateGcd(this.ar, this.br);
            this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
            GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
            this.er = PolyUtil.recursivePseudoRemainder(this.ar, this.dr);
            GCDSimpleTest.assertTrue((String)("gcd(a,b) | a" + this.er), (boolean)this.er.isZERO());
            this.er = PolyUtil.recursivePseudoRemainder(this.br, this.dr);
            GCDSimpleTest.assertTrue((String)("gcd(a,b) | b" + this.er), (boolean)this.er.isZERO());
        }
    }

    public void testArbitraryRecursiveGCDSimple() {
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 2, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        for (int i = 0; i < 3; ++i) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.ufd.recursivePrimitivePart(this.cr).abs();
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            GCDSimpleTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.ar = this.ar.multiply((GenPolynomial<BigInteger>)this.cr);
            this.br = this.br.multiply((GenPolynomial<BigInteger>)this.cr);
            this.dr = this.ufd.recursiveGcd(this.ar, this.br);
            this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
            GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
            this.er = PolyUtil.recursivePseudoRemainder(this.ar, this.dr);
            GCDSimpleTest.assertTrue((String)("gcd(a,b) | a" + this.er), (boolean)this.er.isZERO());
            this.er = PolyUtil.recursivePseudoRemainder(this.br, this.dr);
            GCDSimpleTest.assertTrue((String)("gcd(a,b) | b" + this.er), (boolean)this.er.isZERO());
        }
    }

    public void testGCDSimple() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 4, this.to);
        for (int i = 0; i < 2; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.c.multiply((BigInteger)((Object)this.dfac.univariate(0)));
            this.c = this.ufd.primitivePart(this.c).abs();
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDSimpleTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigInteger)((Object)this.c));
            this.b = this.b.multiply((BigInteger)((Object)this.c));
            this.d = this.ufd.gcd(this.a, this.b);
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            this.e = PolyUtil.basePseudoRemainder(this.a, this.d);
            GCDSimpleTest.assertTrue((String)("gcd(a,b) | a " + this.e), (boolean)this.e.isZERO());
            this.e = PolyUtil.basePseudoRemainder(this.b, this.d);
            GCDSimpleTest.assertTrue((String)("gcd(a,b) | b " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testBaseResultant() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        GreatestCommonDivisorSimple<RingElem<BigInteger>> greatestCommonDivisorSimple = new GreatestCommonDivisorSimple<RingElem<BigInteger>>();
        GreatestCommonDivisorSubres<RingElem<BigInteger>> greatestCommonDivisorSubres = new GreatestCommonDivisorSubres<RingElem<BigInteger>>();
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q);
            this.c = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q);
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            if (this.c.isConstant()) {
                this.c = this.dfac.univariate(0, 1L);
            }
            GCDSimpleTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.d = greatestCommonDivisorSimple.baseResultant(this.a, this.b);
            this.e = greatestCommonDivisorSubres.baseResultant(this.a, this.b);
            GCDSimpleTest.assertEquals((String)("d == e: " + this.d.subtract((BigInteger)((Object)this.e))), (int)((GenPolynomial)this.d.abs()).signum(), (int)((GenPolynomial)this.e.abs()).signum());
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial = this.a.multiply((BigInteger)((Object)this.c));
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial2 = this.b.multiply((BigInteger)((Object)this.c));
            this.d = greatestCommonDivisorSimple.baseResultant(genPolynomial, genPolynomial2);
            GCDSimpleTest.assertTrue((String)("d == 0: " + this.d), (boolean)this.d.isZERO());
            this.e = greatestCommonDivisorSubres.baseResultant(genPolynomial, genPolynomial2);
            GCDSimpleTest.assertTrue((String)("e == 0: " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testRecursiveResultantSimple() {
        this.di = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 2, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple();
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        for (int i = 0; i < 1; ++i) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.ufd.recursivePrimitivePart(this.cr).abs();
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            if (this.cr.isConstant()) {
                this.cr = this.rfac.univariate(0, 1L);
            }
            GCDSimpleTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.dr = greatestCommonDivisorSimple.recursiveUnivariateResultant(this.ar, this.br);
            this.er = greatestCommonDivisorSubres.recursiveUnivariateResultant(this.ar, this.br);
            GCDSimpleTest.assertEquals((String)("dr == er: " + this.dr.subtract((GenPolynomial<BigInteger>)this.er)), (int)((GenPolynomial)this.dr.abs()).signum(), (int)((GenPolynomial)this.er.abs()).signum());
            GenPolynomial genPolynomial = this.ar.multiply((GenPolynomial<BigInteger>)this.cr);
            GenPolynomial genPolynomial2 = this.br.multiply((GenPolynomial<BigInteger>)this.cr);
            this.dr = greatestCommonDivisorSimple.recursiveUnivariateResultant(genPolynomial, genPolynomial2);
            this.er = greatestCommonDivisorSubres.recursiveUnivariateResultant(genPolynomial, genPolynomial2);
            GCDSimpleTest.assertEquals((String)("dr == er: " + this.dr.subtract((GenPolynomial<BigInteger>)this.er)), (int)this.dr.signum(), (int)this.er.signum());
        }
    }
}

