/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.gb.DGroebnerBaseSeq;
import edu.jas.gb.EGroebnerBaseSeq;
import edu.jas.gb.GBProxy;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.OrderedMinPairlist;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.OrderedSyzPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.ReductionSeq;
import edu.jas.gbufd.GroebnerBasePseudoParallel;
import edu.jas.gbufd.GroebnerBasePseudoRecParallel;
import edu.jas.gbufd.GroebnerBasePseudoRecSeq;
import edu.jas.gbufd.GroebnerBasePseudoSeq;
import edu.jas.gbufd.GroebnerBaseQuotient;
import edu.jas.gbufd.GroebnerBaseRational;
import edu.jas.gbufd.RGroebnerBasePseudoSeq;
import edu.jas.gbufd.RGroebnerBaseSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import org.apache.log4j.Logger;

public class GBFactory {
    private static final Logger logger = Logger.getLogger(GBFactory.class);

    protected GBFactory() {
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getImplementation() {
        logger.warn((Object)"no coefficent factory given, assuming field coeffcients");
        GroebnerBaseSeq groebnerBaseSeq = new GroebnerBaseSeq();
        return groebnerBaseSeq;
    }

    public static GroebnerBaseAbstract<ModLong> getImplementation(ModLongRing modLongRing) {
        return GBFactory.getImplementation(modLongRing, new OrderedPairlist<ModLong>());
    }

    public static GroebnerBaseAbstract<ModLong> getImplementation(ModLongRing modLongRing, PairList<ModLong> pairList) {
        GroebnerBaseAbstract groebnerBaseAbstract = modLongRing.isField() ? new GroebnerBaseSeq<ModLong>(pairList) : new GroebnerBasePseudoSeq<ModLong>(modLongRing, pairList);
        return groebnerBaseAbstract;
    }

    public static GroebnerBaseAbstract<ModInteger> getImplementation(ModIntegerRing modIntegerRing) {
        return GBFactory.getImplementation(modIntegerRing, new OrderedPairlist<ModInteger>());
    }

    public static GroebnerBaseAbstract<ModInteger> getImplementation(ModIntegerRing modIntegerRing, PairList<ModInteger> pairList) {
        GroebnerBaseAbstract groebnerBaseAbstract = modIntegerRing.isField() ? new GroebnerBaseSeq<ModInteger>(pairList) : new GroebnerBasePseudoSeq<ModInteger>(modIntegerRing, pairList);
        return groebnerBaseAbstract;
    }

    public static GroebnerBaseAbstract<BigInteger> getImplementation(BigInteger bigInteger) {
        return GBFactory.getImplementation(bigInteger, Algo.igb);
    }

    public static GroebnerBaseAbstract<BigInteger> getImplementation(BigInteger bigInteger, Algo algo) {
        return GBFactory.getImplementation(bigInteger, algo, new OrderedPairlist<BigInteger>());
    }

    public static GroebnerBaseAbstract<BigInteger> getImplementation(BigInteger bigInteger, PairList<BigInteger> pairList) {
        return GBFactory.getImplementation(bigInteger, Algo.igb, pairList);
    }

    public static GroebnerBaseAbstract<BigInteger> getImplementation(BigInteger bigInteger, Algo algo, PairList<BigInteger> pairList) {
        EGroebnerBaseSeq<BigInteger> eGroebnerBaseSeq;
        switch (algo) {
            case igb: {
                eGroebnerBaseSeq = new GroebnerBasePseudoSeq<BigInteger>(bigInteger, pairList);
                break;
            }
            case egb: {
                eGroebnerBaseSeq = new EGroebnerBaseSeq();
                break;
            }
            case dgb: {
                eGroebnerBaseSeq = new DGroebnerBaseSeq();
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm not available for BigInteger " + (Object)((Object)algo));
            }
        }
        return eGroebnerBaseSeq;
    }

    public static GroebnerBaseAbstract<BigRational> getImplementation(BigRational bigRational) {
        return GBFactory.getImplementation(bigRational, Algo.qgb);
    }

    public static GroebnerBaseAbstract<BigRational> getImplementation(BigRational bigRational, Algo algo) {
        return GBFactory.getImplementation(bigRational, algo, new OrderedPairlist<BigRational>());
    }

    public static GroebnerBaseAbstract<BigRational> getImplementation(BigRational bigRational, PairList<BigRational> pairList) {
        return GBFactory.getImplementation(bigRational, Algo.qgb, pairList);
    }

    public static GroebnerBaseAbstract<BigRational> getImplementation(BigRational bigRational, Algo algo, PairList<BigRational> pairList) {
        GroebnerBaseAbstract groebnerBaseAbstract;
        switch (algo) {
            case qgb: {
                groebnerBaseAbstract = new GroebnerBaseSeq<BigRational>(pairList);
                break;
            }
            case ffgb: {
                OrderedPairlist orderedPairlist = pairList instanceof OrderedMinPairlist ? new OrderedMinPairlist() : (pairList instanceof OrderedSyzPairlist ? new OrderedSyzPairlist() : new OrderedPairlist());
                groebnerBaseAbstract = new GroebnerBaseRational(orderedPairlist);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm not available for " + bigRational.toScriptFactory() + ", Algo = " + (Object)((Object)algo));
            }
        }
        return groebnerBaseAbstract;
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<Quotient<C>> getImplementation(QuotientRing<C> quotientRing) {
        return GBFactory.getImplementation(quotientRing, Algo.qgb);
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<Quotient<C>> getImplementation(QuotientRing<C> quotientRing, Algo algo) {
        return GBFactory.getImplementation(quotientRing, algo, new OrderedPairlist<Quotient<C>>());
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<Quotient<C>> getImplementation(QuotientRing<C> quotientRing, PairList<Quotient<C>> pairList) {
        return GBFactory.getImplementation(quotientRing, Algo.qgb, pairList);
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<Quotient<C>> getImplementation(QuotientRing<C> quotientRing, Algo algo, PairList<Quotient<C>> pairList) {
        GroebnerBaseAbstract groebnerBaseAbstract;
        switch (algo) {
            case qgb: {
                groebnerBaseAbstract = new GroebnerBaseSeq<Quotient<C>>(new ReductionSeq(), pairList);
                break;
            }
            case ffgb: {
                OrderedPairlist orderedPairlist = pairList instanceof OrderedMinPairlist ? new OrderedMinPairlist() : (pairList instanceof OrderedSyzPairlist ? new OrderedSyzPairlist() : new OrderedPairlist());
                groebnerBaseAbstract = new GroebnerBaseQuotient<C>(quotientRing, orderedPairlist);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm not available for Quotient " + (Object)((Object)algo));
            }
        }
        return groebnerBaseAbstract;
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> genPolynomialRing) {
        return GBFactory.getImplementation(genPolynomialRing, Algo.igb);
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> genPolynomialRing, Algo algo) {
        return GBFactory.getImplementation(genPolynomialRing, algo, new OrderedPairlist<GenPolynomial<C>>());
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> genPolynomialRing, PairList<GenPolynomial<C>> pairList) {
        return GBFactory.getImplementation(genPolynomialRing, Algo.igb, pairList);
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> genPolynomialRing, Algo algo, PairList<GenPolynomial<C>> pairList) {
        GroebnerBaseAbstract groebnerBaseAbstract;
        switch (algo) {
            case igb: {
                groebnerBaseAbstract = new GroebnerBasePseudoRecSeq<C>(genPolynomialRing, pairList);
                break;
            }
            case egb: {
                if (genPolynomialRing.nvar > 1 || !genPolynomialRing.coFac.isField()) {
                    throw new IllegalArgumentException("coefficients not univariate or not over a field" + genPolynomialRing);
                }
                groebnerBaseAbstract = new EGroebnerBaseSeq();
                break;
            }
            case dgb: {
                if (genPolynomialRing.nvar > 1 || !genPolynomialRing.coFac.isField()) {
                    throw new IllegalArgumentException("coefficients not univariate or not over a field" + genPolynomialRing);
                }
                groebnerBaseAbstract = new DGroebnerBaseSeq();
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm not available for GenPolynomial<C> " + (Object)((Object)algo));
            }
        }
        return groebnerBaseAbstract;
    }

    public static <C extends RingElem<C>> GroebnerBaseAbstract<Product<C>> getImplementation(ProductRing<C> productRing) {
        RGroebnerBaseSeq<Product<C>> rGroebnerBaseSeq = productRing.onlyFields() ? new RGroebnerBaseSeq<Product<C>>() : new RGroebnerBasePseudoSeq<C>(productRing);
        return rGroebnerBaseSeq;
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getImplementation(RingFactory<C> ringFactory) {
        return GBFactory.getImplementation(ringFactory, new OrderedPairlist());
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getImplementation(RingFactory<C> ringFactory, PairList<C> pairList) {
        logger.debug((Object)("fac = " + ringFactory.getClass().getName()));
        if (ringFactory.isField()) {
            return new GroebnerBaseSeq<C>(pairList);
        }
        GroebnerBaseAbstract groebnerBaseAbstract = null;
        RingFactory<C> ringFactory2 = ringFactory;
        if (ringFactory2 instanceof GenPolynomialRing) {
            OrderedPairlist orderedPairlist = pairList instanceof OrderedMinPairlist ? new OrderedMinPairlist() : (pairList instanceof OrderedSyzPairlist ? new OrderedSyzPairlist() : new OrderedPairlist());
            GenPolynomialRing genPolynomialRing = (GenPolynomialRing)ringFactory2;
            GroebnerBasePseudoRecSeq groebnerBasePseudoRecSeq = new GroebnerBasePseudoRecSeq(genPolynomialRing, orderedPairlist);
            groebnerBaseAbstract = groebnerBasePseudoRecSeq;
        } else {
            ProductRing productRing;
            groebnerBaseAbstract = ringFactory2 instanceof ProductRing ? ((productRing = (ProductRing)ringFactory2).onlyFields() ? new RGroebnerBaseSeq() : new RGroebnerBasePseudoSeq(productRing)) : new GroebnerBasePseudoSeq<C>(ringFactory, pairList);
        }
        logger.debug((Object)("bba = " + groebnerBaseAbstract.getClass().getName()));
        return groebnerBaseAbstract;
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getProxy(RingFactory<C> ringFactory) {
        return GBFactory.getProxy(ringFactory, new OrderedPairlist());
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getProxy(RingFactory<C> ringFactory, PairList<C> pairList) {
        int n;
        if (ComputerThreads.NO_THREADS) {
            return GBFactory.getImplementation(ringFactory, pairList);
        }
        logger.debug((Object)("fac = " + ringFactory.getClass().getName()));
        int n2 = n = ComputerThreads.N_CPUS > 2 ? ComputerThreads.N_CPUS - 1 : 2;
        if (ringFactory.isField()) {
            GroebnerBaseSeq<C> groebnerBaseSeq = new GroebnerBaseSeq<C>(pairList);
            GroebnerBaseParallel<C> groebnerBaseParallel = new GroebnerBaseParallel<C>(n, pairList);
            return new GBProxy<C>(groebnerBaseSeq, groebnerBaseParallel);
        }
        if (ringFactory.characteristic().signum() == 0) {
            if (ringFactory instanceof GenPolynomialRing) {
                GenPolynomialRing genPolynomialRing = (GenPolynomialRing)ringFactory;
                OrderedPairlist orderedPairlist = new OrderedPairlist();
                GroebnerBasePseudoRecSeq groebnerBasePseudoRecSeq = new GroebnerBasePseudoRecSeq(genPolynomialRing, orderedPairlist);
                GroebnerBasePseudoRecParallel groebnerBasePseudoRecParallel = new GroebnerBasePseudoRecParallel(n, genPolynomialRing, orderedPairlist);
                return new GBProxy(groebnerBasePseudoRecSeq, groebnerBasePseudoRecParallel);
            }
            GroebnerBasePseudoSeq<C> groebnerBasePseudoSeq = new GroebnerBasePseudoSeq<C>(ringFactory, pairList);
            GroebnerBasePseudoParallel<C> groebnerBasePseudoParallel = new GroebnerBasePseudoParallel<C>(n, ringFactory, pairList);
            return new GBProxy<C>(groebnerBasePseudoSeq, groebnerBasePseudoParallel);
        }
        return GBFactory.getImplementation(ringFactory, pairList);
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<GenPolynomial<C>> getProxy(GenPolynomialRing<C> genPolynomialRing) {
        if (ComputerThreads.NO_THREADS) {
            return GBFactory.getImplementation(genPolynomialRing);
        }
        logger.debug((Object)("fac = " + genPolynomialRing.getClass().getName()));
        int n = ComputerThreads.N_CPUS > 2 ? ComputerThreads.N_CPUS - 1 : 2;
        OrderedPairlist orderedPairlist = new OrderedPairlist();
        GroebnerBasePseudoRecSeq groebnerBasePseudoRecSeq = new GroebnerBasePseudoRecSeq(genPolynomialRing, orderedPairlist);
        GroebnerBasePseudoRecParallel groebnerBasePseudoRecParallel = new GroebnerBasePseudoRecParallel(n, genPolynomialRing, orderedPairlist);
        return new GBProxy<GenPolynomial<C>>(groebnerBasePseudoRecSeq, groebnerBasePseudoRecParallel);
    }

    public static enum Algo {
        igb,
        egb,
        dgb,
        qgb,
        ffgb;

    }
}

