/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.Counter;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;

class Broadcaster
extends Thread {
    private static final Logger logger = Logger.getLogger(Broadcaster.class);
    private final SocketChannel channel;
    private final List bcaster;
    private Counter listElem;
    private final SortedMap<Counter, Object> theList;

    public Broadcaster(SocketChannel socketChannel, List list, Counter counter, SortedMap<Counter, Object> sortedMap) {
        this.channel = socketChannel;
        this.bcaster = list;
        this.listElem = counter;
        this.theList = sortedMap;
    }

    public void closeChannel() {
        this.channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChannel(Object object, Object object2) throws IOException {
        SocketChannel socketChannel = this.channel;
        synchronized (socketChannel) {
            this.channel.send(object);
            this.channel.send(object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(Object object) {
        Counter counter = null;
        Object object2 = this.listElem;
        synchronized (object2) {
            this.listElem.add(1);
            counter = new Counter(this.listElem.intValue());
        }
        object2 = this.theList;
        synchronized (object2) {
            this.theList.put(counter, object);
        }
        object2 = this.bcaster;
        synchronized (object2) {
            for (Broadcaster broadcaster : this.bcaster) {
                try {
                    broadcaster.sendChannel(counter, object);
                }
                catch (IOException iOException) {
                    try {
                        broadcaster.closeChannel();
                        while (broadcaster.isAlive()) {
                            broadcaster.interrupt();
                            broadcaster.join(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.bcaster.remove(broadcaster);
                }
            }
        }
    }

    @Override
    public void run() {
        boolean bl = true;
        while (bl) {
            try {
                Object object = this.channel.receive();
                this.broadcast(object);
                if (!this.isInterrupted()) continue;
                bl = false;
            }
            catch (IOException iOException) {
                bl = false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
                classNotFoundException.printStackTrace();
            }
        }
        logger.debug((Object)("broadcaster terminated " + this));
        this.channel.close();
    }

    @Override
    public String toString() {
        return "Broadcaster(" + this.channel + "," + this.bcaster.size() + "," + this.listElem + ")";
    }
}

