/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.OrderedWordPairlist;
import edu.jas.gb.WordGroebnerBaseAbstract;
import edu.jas.gb.WordPair;
import edu.jas.gb.WordPairList;
import edu.jas.gb.WordReduction;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.RingElem;
import java.util.List;
import org.apache.log4j.Logger;

public class WordGroebnerBaseSeq<C extends RingElem<C>>
extends WordGroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(WordGroebnerBaseSeq.class);
    private final boolean debug = logger.isDebugEnabled();

    public WordGroebnerBaseSeq() {
    }

    public WordGroebnerBaseSeq(WordReduction<C> wordReduction) {
        super(wordReduction);
    }

    public WordGroebnerBaseSeq(WordReduction<C> wordReduction, WordPairList<C> wordPairList) {
        super(wordReduction, wordPairList);
    }

    @Override
    public List<GenWordPolynomial<C>> GB(List<GenWordPolynomial<C>> list) {
        List<GenWordPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolyUtil.wordMonic(list2)).size() <= 1) {
            return list2;
        }
        GenWordPolynomialRing genWordPolynomialRing = list2.get((int)0).ring;
        if (!genWordPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        OrderedWordPairlist orderedWordPairlist = (OrderedWordPairlist)this.strategy.create(genWordPolynomialRing);
        orderedWordPairlist.put(list2);
        logger.info((Object)("start " + orderedWordPairlist));
        while (orderedWordPairlist.hasNext()) {
            List list3;
            WordPair wordPair = orderedWordPairlist.removeNext();
            if (wordPair == null) continue;
            GenWordPolynomial genWordPolynomial = wordPair.pi;
            GenWordPolynomial genWordPolynomial2 = wordPair.pj;
            if (this.debug) {
                logger.info((Object)("pi   = " + genWordPolynomial + ", pj = " + genWordPolynomial2));
            }
            if ((list3 = this.red.SPolynomials(genWordPolynomial, genWordPolynomial2)).isEmpty()) continue;
            for (GenWordPolynomial genWordPolynomial3 : list3) {
                if (genWordPolynomial3.isZERO()) continue;
                if (this.debug) {
                    logger.info((Object)("ht(S) = " + genWordPolynomial3.leadingWord()));
                }
                boolean bl = orderedWordPairlist.criterion3(wordPair.i, wordPair.j, genWordPolynomial3.leadingWord());
                GenWordPolynomial<C> genWordPolynomial4 = this.red.normalform(list2, genWordPolynomial3);
                if (this.debug) {
                    logger.info((Object)("ht(H) = " + genWordPolynomial4.monic()));
                }
                if (genWordPolynomial4.isZERO()) continue;
                if (!bl) {
                    logger.info((Object)("criterion3(" + wordPair.i + "," + wordPair.j + ") wrong: " + genWordPolynomial3.leadingWord() + " --> " + genWordPolynomial4.leadingWord()));
                }
                genWordPolynomial4 = genWordPolynomial4.monic();
                if (this.debug) {
                    logger.info((Object)("ht(H) = " + genWordPolynomial4.leadingWord()));
                }
                if (genWordPolynomial4.isONE()) {
                    list2.clear();
                    list2.add(genWordPolynomial4);
                    return list2;
                }
                if (this.debug) {
                    logger.info((Object)("H = " + genWordPolynomial4));
                }
                if (genWordPolynomial4.length() <= 0) continue;
                list2.add(genWordPolynomial4);
                orderedWordPairlist.put(genWordPolynomial4);
            }
        }
        list2 = this.minimalGB(list2);
        logger.info((Object)("" + orderedWordPairlist));
        return list2;
    }
}

