/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.integrate.LogIntegral;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Integral<C extends GcdRingElem<C>>
implements Serializable {
    public final GenPolynomial<C> num;
    public final GenPolynomial<C> den;
    public final GenPolynomial<C> pol;
    public final List<GenPolynomial<C>> rational;
    public final List<LogIntegral<C>> logarithm;

    public Integral(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, GenPolynomial<C> genPolynomial3) {
        this(genPolynomial, genPolynomial2, genPolynomial3, new ArrayList<GenPolynomial<C>>());
    }

    public Integral(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, GenPolynomial<C> genPolynomial3, List<GenPolynomial<C>> list) {
        this(genPolynomial, genPolynomial2, genPolynomial3, list, new ArrayList<LogIntegral<C>>());
    }

    public Integral(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, GenPolynomial<C> genPolynomial3, List<GenPolynomial<C>> list, List<LogIntegral<C>> list2) {
        this.num = genPolynomial;
        this.den = genPolynomial2;
        this.pol = genPolynomial3;
        this.rational = list;
        this.logarithm = list2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("integral( (" + this.num.toString());
        stringBuffer.append(") / (");
        stringBuffer.append(this.den.toString() + ") )");
        stringBuffer.append(" =\n");
        if (!this.pol.isZERO()) {
            stringBuffer.append(this.pol.toString());
        }
        boolean bl = true;
        if (this.rational.size() != 0) {
            if (!this.pol.isZERO()) {
                stringBuffer.append(" + ");
            }
            for (int i = 0; i < this.rational.size(); ++i) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" + ");
                }
                stringBuffer.append("(" + this.rational.get(i++) + ")/(");
                stringBuffer.append(this.rational.get(i) + ")");
            }
        }
        if (this.logarithm.size() != 0) {
            if (!this.pol.isZERO() || this.rational.size() != 0) {
                stringBuffer.append(" + ");
            }
            bl = true;
            for (LogIntegral<C> logIntegral : this.logarithm) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" + ");
                }
                stringBuffer.append(logIntegral);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = this.num.hashCode();
        n = n * 37 + this.den.hashCode();
        n = n * 37 + this.pol.hashCode();
        n = n * 37 + this.rational.hashCode();
        n = n * 37 + this.logarithm.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        Integral integral = null;
        try {
            integral = (Integral)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (integral == null) {
            return false;
        }
        return this.num.equals(integral.num) && this.den.equals(integral.den) && this.pol.equals(integral.pol) && this.rational.equals(integral.rational) && this.logarithm.equals(integral.logarithm);
    }
}

