/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ComplexTest
extends TestCase {
    ComplexRing<BigInteger> fac;
    GenPolynomialRing<BigRational> pfac;
    ComplexRing<GenPolynomial<BigRational>> mfac;
    Complex<BigInteger> a;
    Complex<BigInteger> b;
    Complex<BigInteger> c;
    Complex<BigInteger> d;
    Complex<BigInteger> e;
    Complex<GenPolynomial<BigRational>> ap;
    Complex<GenPolynomial<BigRational>> bp;
    Complex<GenPolynomial<BigRational>> cp;
    Complex<GenPolynomial<BigRational>> dp;
    Complex<GenPolynomial<BigRational>> ep;
    int rl = 1;
    int kl = 13;
    int ll = 7;
    int el = 3;
    float q = 0.4f;
    int il = 2;
    long p = 0xFFFFFFFFFFFFFA3L;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ComplexTest.suite());
    }

    public ComplexTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ComplexTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ep = null;
        this.dp = null;
        this.cp = null;
        this.bp = null;
        this.ap = null;
        BigInteger bigInteger = new BigInteger(1L);
        this.fac = new ComplexRing<BigInteger>(bigInteger);
        this.pfac = new GenPolynomialRing<BigRational>(new BigRational(1L), 1);
        GenPolynomial<BigRational> genPolynomial = this.pfac.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isConstant()) {
            genPolynomial = this.pfac.random(this.kl, this.ll, this.el, this.q);
        }
        this.mfac = new ComplexRing<BigRational>(this.pfac);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ep = null;
        this.dp = null;
        this.cp = null;
        this.bp = null;
        this.ap = null;
        this.fac = null;
        this.pfac = null;
        this.mfac = null;
    }

    public void testIntConstruction() {
        this.c = this.fac.getONE();
        ComplexTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ComplexTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        ComplexTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        ComplexTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testPolyConstruction() {
        this.cp = this.mfac.getONE();
        ComplexTest.assertTrue((String)"isZERO( cp )", (!this.cp.isZERO() ? 1 : 0) != 0);
        ComplexTest.assertTrue((String)"isONE( cp )", (boolean)this.cp.isONE());
        this.dp = this.mfac.getZERO();
        ComplexTest.assertTrue((String)"isZERO( dp )", (boolean)this.dp.isZERO());
        ComplexTest.assertTrue((String)"isONE( dp )", (!this.dp.isONE() ? 1 : 0) != 0);
    }

    public void testIntRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.kl * (i + 1));
            if (this.a.isZERO()) continue;
            ComplexTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            ComplexTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testPolyRandom() {
        for (int i = 0; i < 7; ++i) {
            this.ap = this.mfac.random(this.kl + i);
            if (this.ap.isZERO()) continue;
            ComplexTest.assertTrue((String)(" not isZERO( ap" + i + " )"), (!this.ap.isZERO() ? 1 : 0) != 0);
            ComplexTest.assertTrue((String)(" not isONE( ap" + i + " )"), (!this.ap.isONE() ? 1 : 0) != 0);
        }
    }

    public void testIntAddition() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        ComplexTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        ComplexTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        ComplexTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((Complex<BigInteger>)this.fac.getZERO());
        this.d = this.a.subtract((Complex<BigInteger>)this.fac.getZERO());
        ComplexTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((Complex)this.fac.getZERO()).sum(this.a);
        this.d = ((Complex)this.fac.getZERO()).subtract(this.a.negate());
        ComplexTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testPolyAddition() {
        this.ap = this.mfac.random(this.kl);
        this.bp = this.mfac.random(this.kl);
        this.cp = this.ap.sum(this.bp);
        this.dp = this.cp.subtract(this.bp);
        ComplexTest.assertEquals((String)"a+b-b = a", this.ap, this.dp);
        this.cp = this.ap.sum(this.bp);
        this.dp = this.bp.sum(this.ap);
        ComplexTest.assertEquals((String)"a+b = b+a", this.cp, this.dp);
        this.cp = this.mfac.random(this.kl);
        this.dp = this.cp.sum(this.ap.sum(this.bp));
        this.ep = this.cp.sum(this.ap).sum(this.bp);
        ComplexTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.dp, this.ep);
        this.cp = this.ap.sum((Complex<GenPolynomial<BigRational>>)this.mfac.getZERO());
        this.dp = this.ap.subtract((Complex<GenPolynomial<BigRational>>)this.mfac.getZERO());
        ComplexTest.assertEquals((String)"a+0 = a-0", this.cp, this.dp);
        this.cp = ((Complex)this.mfac.getZERO()).sum(this.ap);
        this.dp = ((Complex)this.mfac.getZERO()).subtract(this.ap.negate());
        ComplexTest.assertEquals((String)"0+a = 0+(-a)", this.cp, this.dp);
    }

    public void testIntMultiplication() {
        this.a = this.fac.random(this.kl);
        if (this.a.isZERO()) {
            return;
        }
        ComplexTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl);
        if (this.b.isZERO()) {
            return;
        }
        ComplexTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        ComplexTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ComplexTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        ComplexTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        ComplexTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        ComplexTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        ComplexTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        ComplexTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((Complex<BigInteger>)this.fac.getONE());
        this.d = ((Complex)this.fac.getONE()).multiply(this.a);
        ComplexTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply(this.a);
            ComplexTest.assertTrue((String)"a*1/a = 1", (boolean)this.d.isONE());
        }
    }

    public void testPolyMultiplication() {
        this.ap = this.mfac.random(this.kl);
        if (this.ap.isZERO()) {
            return;
        }
        ComplexTest.assertTrue((String)"not isZERO( a )", (!this.ap.isZERO() ? 1 : 0) != 0);
        this.bp = this.mfac.random(this.kl);
        if (this.bp.isZERO()) {
            return;
        }
        ComplexTest.assertTrue((String)"not isZERO( b )", (!this.bp.isZERO() ? 1 : 0) != 0);
        this.cp = this.bp.multiply(this.ap);
        this.dp = this.ap.multiply(this.bp);
        ComplexTest.assertTrue((String)"not isZERO( c )", (!this.cp.isZERO() ? 1 : 0) != 0);
        ComplexTest.assertTrue((String)"not isZERO( d )", (!this.dp.isZERO() ? 1 : 0) != 0);
        this.ep = this.dp.subtract(this.cp);
        ComplexTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.ep), (boolean)this.ep.isZERO());
        ComplexTest.assertTrue((String)"a*b = b*a", (boolean)this.cp.equals(this.dp));
        ComplexTest.assertEquals((String)"a*b = b*a", this.cp, this.dp);
        this.cp = this.mfac.random(this.kl);
        this.dp = this.ap.multiply(this.bp.multiply(this.cp));
        this.ep = this.ap.multiply(this.bp).multiply(this.cp);
        ComplexTest.assertEquals((String)"a(bc) = (ab)c", this.dp, this.ep);
        ComplexTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.dp.equals(this.ep));
        this.cp = this.ap.multiply((Complex<GenPolynomial<BigRational>>)this.mfac.getONE());
        this.dp = ((Complex)this.mfac.getONE()).multiply(this.ap);
        ComplexTest.assertEquals((String)"a*1 = 1*a", this.cp, this.dp);
        if (this.ap.isUnit()) {
            this.cp = this.ap.inverse();
            this.dp = this.cp.multiply(this.ap);
            ComplexTest.assertTrue((String)"a*1/a = 1", (boolean)this.dp.isONE());
        }
    }

    public void testIntDivision() {
        this.a = this.fac.random(this.kl * 2);
        if (this.a.isZERO()) {
            return;
        }
        ComplexTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl);
        if (this.b.isZERO()) {
            return;
        }
        ComplexTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.a.divide(this.b);
        this.d = this.a.remainder(this.b);
        this.e = this.b.multiply(this.c).sum(this.d);
        ComplexTest.assertEquals((String)"a = b (a/b) + a%b ", this.a, this.e);
        this.c = this.a.gcd(this.b);
        this.d = this.a.divide(this.c);
        this.e = this.b.divide(this.c);
        this.d = this.c.multiply(this.d);
        this.e = this.c.multiply(this.e);
        ComplexTest.assertEquals((String)"a/gcd(a,b)*gcd(a,b) = a ", this.a, this.d);
        ComplexTest.assertEquals((String)"b/gcd(a,b)*gcd(a,b) = b ", this.b, this.e);
        Complex<BigInteger>[] complexArray = this.a.egcd(this.b);
        this.c = complexArray[0];
        this.d = complexArray[1];
        this.e = complexArray[2];
        this.d = this.d.multiply(this.a);
        this.e = this.e.multiply(this.b);
        this.d = this.d.sum(this.e);
        ComplexTest.assertEquals((String)"d*a + e*b = c = gcd(a,b)", this.c, this.d);
    }

    public void testPolyDivision() {
        this.ap = this.mfac.random(this.kl);
        if (this.ap.isZERO()) {
            return;
        }
        ComplexTest.assertTrue((String)"not isZERO( ap )", (!this.ap.isZERO() ? 1 : 0) != 0);
        this.bp = this.mfac.random(this.kl / 2);
        if (this.bp.isZERO()) {
            return;
        }
        ComplexTest.assertTrue((String)"not isZERO( bp )", (!this.bp.isZERO() ? 1 : 0) != 0);
        this.cp = this.ap.divide(this.bp);
        this.dp = this.ap.remainder(this.bp);
        this.ep = this.bp.multiply(this.cp).sum(this.dp);
        ComplexTest.assertEquals((String)"ap = bp (ap/bp) + ap%bp ", this.ap, this.ep);
    }
}

