/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ExecutableChannels;
import edu.jas.util.ExecutableServer;
import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ExecutableChannelsTest
extends TestCase {
    private static final String host = "localhost";
    private static final int port = 4711;
    private static final String mfile = "examples/machines.test";
    private ExecutableChannels ec;
    private ExecutableServer es;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ExecutableChannelsTest.suite());
    }

    public ExecutableChannelsTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ExecutableChannelsTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.ec = null;
        this.es = new ExecutableServer(4711);
        this.es.init();
    }

    protected void tearDown() {
        this.es.terminate();
        this.es = null;
        if (this.ec != null) {
            this.ec.close();
            this.ec = null;
        }
    }

    public void testExecutableChannels1() {
        String[] stringArray = null;
        this.ec = new ExecutableChannels(stringArray);
        ExecutableChannelsTest.assertEquals((String)"numServers<0", (int)-1, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        String string = "" + this.ec;
        ExecutableChannelsTest.assertEquals((String)"toString", (String)"ExecutableChannels()", (String)string);
    }

    public void testExecutableChannels2() {
        int n = 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "localhost:4711";
        }
        this.ec = new ExecutableChannels(stringArray);
        ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)1, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        String string = "" + this.ec;
        ExecutableChannelsTest.assertEquals((String)"toString", (String)"ExecutableChannels(localhost:4711)", (String)string);
    }

    public void testExecutableChannels3() {
        int n = 100;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "localhost:4711";
        }
        this.ec = new ExecutableChannels(stringArray);
        ExecutableChannelsTest.assertEquals((String)"numServers==100", (int)100, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        String string = "" + this.ec;
        int n2 = "ExecutableChannels()".length() + n * stringArray[0].length() + n - 1;
        ExecutableChannelsTest.assertEquals((String)"toString.length()", (int)n2, (int)string.length());
    }

    public void testExecutableChannels4() {
        int n = 2;
        int n2 = n - 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "localhost:4711";
        }
        this.ec = new ExecutableChannels(stringArray);
        ExecutableChannelsTest.assertEquals((String)"numServers==2", (int)n, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        String string = "" + this.ec;
        int n3 = "ExecutableChannels()".length() + n * stringArray[0].length() + n - 1;
        ExecutableChannelsTest.assertEquals((String)"toString.length()", (int)n3, (int)string.length());
        try {
            this.ec.open();
            ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)n, (int)this.ec.numServers());
            ExecutableChannelsTest.assertEquals((String)"numServers==numChannels", (int)n2, (int)this.ec.numChannels());
        }
        catch (IOException iOException) {
            ExecutableChannelsTest.fail((String)("open()" + iOException));
        }
        this.ec.close();
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
    }

    public void testExecutableChannels5() {
        int n = 11;
        int n2 = n - 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "localhost:4711";
        }
        this.ec = new ExecutableChannels(stringArray);
        ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)n, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        String string = "" + this.ec;
        int n3 = "ExecutableChannels()".length() + n * stringArray[0].length() + n - 1;
        ExecutableChannelsTest.assertEquals((String)"toString.length()", (int)n3, (int)string.length());
        try {
            this.ec.open();
            ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)n, (int)this.ec.numServers());
            ExecutableChannelsTest.assertEquals((String)"numServers==numChannels", (int)n2, (int)this.ec.numChannels());
        }
        catch (IOException iOException) {
            ExecutableChannelsTest.fail((String)("open()" + iOException));
        }
        this.ec.close();
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
    }

    public void testExecutableChannels6() {
        int n = 2;
        int n2 = 10;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "localhost:4711";
        }
        this.ec = new ExecutableChannels(stringArray);
        ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)n, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        try {
            this.ec.open(n2);
            ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)n, (int)this.ec.numServers());
            ExecutableChannelsTest.assertEquals((String)"numServers==numChannels", (int)n2, (int)this.ec.numChannels());
        }
        catch (IOException iOException) {
            ExecutableChannelsTest.fail((String)("open()" + iOException));
        }
        this.ec.close();
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
    }

    public void testExecutableChannels7() {
        int n = 10;
        int n2 = 5;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "localhost:4711";
        }
        this.ec = new ExecutableChannels(stringArray);
        ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)n, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        try {
            this.ec.open(n2);
            ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)n, (int)this.ec.numServers());
            ExecutableChannelsTest.assertEquals((String)"numServers==numChannels", (int)n2, (int)this.ec.numChannels());
        }
        catch (IOException iOException) {
            ExecutableChannelsTest.fail((String)("open()" + iOException));
        }
        this.ec.close();
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
    }

    public void testExecutableChannels8() {
        try {
            this.ec = new ExecutableChannels(mfile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ExecutableChannelsTest.fail((String)("readfile()" + fileNotFoundException));
        }
        ExecutableChannelsTest.assertEquals((String)"numServers==4", (int)4, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        int n = this.ec.numServers();
        try {
            this.ec.open(n);
            ExecutableChannelsTest.assertEquals((String)"numServers==numChannels", (int)n, (int)this.ec.numChannels());
        }
        catch (IOException iOException) {
            ExecutableChannelsTest.fail((String)("open()" + iOException));
        }
        this.ec.close();
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
    }

    public void testExecutableChannels9() {
        try {
            this.ec = new ExecutableChannels(mfile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ExecutableChannelsTest.fail((String)("readfile()" + fileNotFoundException));
        }
        ExecutableChannelsTest.assertEquals((String)"numServers==4", (int)4, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        int n = 10;
        try {
            this.ec.open(n);
            ExecutableChannelsTest.assertEquals((String)"numServers==numChannels", (int)n, (int)this.ec.numChannels());
        }
        catch (IOException iOException) {
            ExecutableChannelsTest.fail((String)("open()" + iOException));
        }
        this.ec.close();
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
    }
}

