/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.Interval;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.PolyUtilRoot;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.RealRootsSturm;
import edu.jas.root.Rectangle;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;

public class RootFactory {
    public static <C extends GcdRingElem<C> & Rational> boolean isRoot(GenPolynomial<C> genPolynomial, RealAlgebraicNumber<C> realAlgebraicNumber) {
        ElemFactory elemFactory = realAlgebraicNumber.factory();
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(elemFactory, (GenPolynomialRing)genPolynomial.factory());
        GenPolynomial genPolynomial2 = PolyUtilRoot.convertToRealCoefficients(genPolynomialRing, genPolynomial);
        RealAlgebraicNumber<C> realAlgebraicNumber2 = PolyUtil.evaluateMain(elemFactory, genPolynomial2, realAlgebraicNumber);
        return realAlgebraicNumber2.isZERO();
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbers(GenPolynomial<C> genPolynomial) {
        RealRootsSturm realRootsSturm = new RealRootsSturm();
        SquarefreeAbstract<GenPolynomial<C>> squarefreeAbstract = SquarefreeFactory.getImplementation(genPolynomial.ring.coFac);
        SortedMap<GenPolynomial<C>, Long> sortedMap = squarefreeAbstract.squarefreeFactors(genPolynomial);
        Set set = sortedMap.keySet();
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>();
        for (GenPolynomial genPolynomial2 : set) {
            List list = realRootsSturm.realRoots(genPolynomial2);
            for (Interval interval : list) {
                RealAlgebraicRing realAlgebraicRing = new RealAlgebraicRing(genPolynomial2, interval);
                RealAlgebraicNumber realAlgebraicNumber = realAlgebraicRing.getGenerator();
                long l = (Long)sortedMap.get(genPolynomial2);
                int n = 0;
                while ((long)n < l) {
                    arrayList.add(realAlgebraicNumber);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbers(GenPolynomial<C> genPolynomial, BigRational bigRational) {
        RealRootsSturm realRootsSturm = new RealRootsSturm();
        SquarefreeAbstract<GenPolynomial<C>> squarefreeAbstract = SquarefreeFactory.getImplementation(genPolynomial.ring.coFac);
        SortedMap<GenPolynomial<C>, Long> sortedMap = squarefreeAbstract.squarefreeFactors(genPolynomial);
        Set set = sortedMap.keySet();
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>();
        for (GenPolynomial genPolynomial2 : set) {
            List list = realRootsSturm.realRoots(genPolynomial2, bigRational);
            for (Interval interval : list) {
                RealAlgebraicRing realAlgebraicRing = new RealAlgebraicRing(genPolynomial2, interval);
                realAlgebraicRing.setEps(bigRational);
                RealAlgebraicNumber realAlgebraicNumber = realAlgebraicRing.getGenerator();
                long l = (Long)sortedMap.get(genPolynomial2);
                int n = 0;
                while ((long)n < l) {
                    arrayList.add(realAlgebraicNumber);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersField(GenPolynomial<C> genPolynomial) {
        RealRootsSturm realRootsSturm = new RealRootsSturm();
        FactorAbstract<C> factorAbstract = FactorFactory.getImplementation(genPolynomial.ring.coFac);
        SortedMap sortedMap = factorAbstract.baseFactors(genPolynomial);
        Set set = sortedMap.keySet();
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>();
        for (GenPolynomial genPolynomial2 : set) {
            List list = realRootsSturm.realRoots(genPolynomial2);
            for (Interval interval : list) {
                RealAlgebraicRing realAlgebraicRing = new RealAlgebraicRing(genPolynomial2, interval, true);
                RealAlgebraicNumber realAlgebraicNumber = realAlgebraicRing.getGenerator();
                long l = (Long)sortedMap.get(genPolynomial2);
                int n = 0;
                while ((long)n < l) {
                    arrayList.add(realAlgebraicNumber);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersField(GenPolynomial<C> genPolynomial, BigRational bigRational) {
        RealRootsSturm realRootsSturm = new RealRootsSturm();
        FactorAbstract<C> factorAbstract = FactorFactory.getImplementation(genPolynomial.ring.coFac);
        SortedMap sortedMap = factorAbstract.baseFactors(genPolynomial);
        Set set = sortedMap.keySet();
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>();
        for (GenPolynomial genPolynomial2 : set) {
            List list = realRootsSturm.realRoots(genPolynomial2, bigRational);
            for (Interval interval : list) {
                RealAlgebraicRing realAlgebraicRing = new RealAlgebraicRing(genPolynomial2, interval, true);
                realAlgebraicRing.setEps(bigRational);
                RealAlgebraicNumber realAlgebraicNumber = realAlgebraicRing.getGenerator();
                long l = (Long)sortedMap.get(genPolynomial2);
                int n = 0;
                while ((long)n < l) {
                    arrayList.add(realAlgebraicNumber);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersIrred(GenPolynomial<C> genPolynomial) {
        RealRootsSturm<C> realRootsSturm = new RealRootsSturm<C>();
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>();
        List<Interval<C>> list = realRootsSturm.realRoots(genPolynomial);
        for (Interval<C> interval : list) {
            RealAlgebraicRing<C> realAlgebraicRing = new RealAlgebraicRing<C>(genPolynomial, interval, true);
            RealAlgebraicNumber<C> realAlgebraicNumber = realAlgebraicRing.getGenerator();
            arrayList.add(realAlgebraicNumber);
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersIrred(GenPolynomial<C> genPolynomial, BigRational bigRational) {
        RealRootsSturm<C> realRootsSturm = new RealRootsSturm<C>();
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>();
        List<Interval<C>> list = realRootsSturm.realRoots(genPolynomial, bigRational);
        for (Interval<C> interval : list) {
            RealAlgebraicRing<C> realAlgebraicRing = new RealAlgebraicRing<C>(genPolynomial, interval, true);
            realAlgebraicRing.setEps(bigRational);
            RealAlgebraicNumber<C> realAlgebraicNumber = realAlgebraicRing.getGenerator();
            arrayList.add(realAlgebraicNumber);
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRoot(GenPolynomial<C> genPolynomial, ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        ElemFactory elemFactory = complexAlgebraicNumber.factory();
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(elemFactory, (GenPolynomialRing)genPolynomial.factory());
        GenPolynomial genPolynomial2 = PolyUtilRoot.convertToComplexCoefficients(genPolynomialRing, genPolynomial);
        ComplexAlgebraicNumber<C> complexAlgebraicNumber2 = PolyUtil.evaluateMain(elemFactory, genPolynomial2, complexAlgebraicNumber);
        return complexAlgebraicNumber2.isZERO();
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRootComplex(GenPolynomial<Complex<C>> genPolynomial, ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        ElemFactory elemFactory = complexAlgebraicNumber.factory();
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(elemFactory, (GenPolynomialRing)genPolynomial.factory());
        GenPolynomial genPolynomial2 = PolyUtilRoot.convertToComplexCoefficientsFromComplex(genPolynomialRing, genPolynomial);
        ComplexAlgebraicNumber<C> complexAlgebraicNumber2 = PolyUtil.evaluateMain(elemFactory, genPolynomial2, complexAlgebraicNumber);
        return complexAlgebraicNumber2.isZERO();
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbersComplex(GenPolynomial<Complex<C>> genPolynomial) {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(genPolynomial.ring.coFac);
        SquarefreeAbstract<GenPolynomial<Complex<C>>> squarefreeAbstract = SquarefreeFactory.getImplementation(genPolynomial.ring.coFac);
        SortedMap<GenPolynomial<Complex<C>>, Long> sortedMap = squarefreeAbstract.squarefreeFactors(genPolynomial);
        Set set = sortedMap.keySet();
        ArrayList<ComplexAlgebraicNumber<C>> arrayList = new ArrayList<ComplexAlgebraicNumber<C>>();
        for (GenPolynomial genPolynomial2 : set) {
            List list = complexRootsSturm.complexRoots(genPolynomial2);
            for (Rectangle rectangle : list) {
                ComplexAlgebraicRing complexAlgebraicRing = new ComplexAlgebraicRing(genPolynomial2, rectangle);
                ComplexAlgebraicNumber complexAlgebraicNumber = complexAlgebraicRing.getGenerator();
                long l = (Long)sortedMap.get(genPolynomial2);
                int n = 0;
                while ((long)n < l) {
                    arrayList.add(complexAlgebraicNumber);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbersComplex(GenPolynomial<Complex<C>> genPolynomial, BigRational bigRational) {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(genPolynomial.ring.coFac);
        SquarefreeAbstract<GenPolynomial<Complex<C>>> squarefreeAbstract = SquarefreeFactory.getImplementation(genPolynomial.ring.coFac);
        SortedMap<GenPolynomial<Complex<C>>, Long> sortedMap = squarefreeAbstract.squarefreeFactors(genPolynomial);
        Set set = sortedMap.keySet();
        ArrayList<ComplexAlgebraicNumber<C>> arrayList = new ArrayList<ComplexAlgebraicNumber<C>>();
        for (GenPolynomial genPolynomial2 : set) {
            List list = complexRootsSturm.complexRoots(genPolynomial2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Rectangle rectangle;
                Rectangle rectangle2 = rectangle = iterator.next();
                try {
                    rectangle2 = complexRootsSturm.complexRootRefinement(rectangle, genPolynomial2, bigRational);
                }
                catch (InvalidBoundaryException invalidBoundaryException) {
                    invalidBoundaryException.printStackTrace();
                }
                ComplexAlgebraicRing complexAlgebraicRing = new ComplexAlgebraicRing(genPolynomial2, rectangle2);
                complexAlgebraicRing.setEps(bigRational);
                ComplexAlgebraicNumber complexAlgebraicNumber = complexAlgebraicRing.getGenerator();
                long l = (Long)sortedMap.get(genPolynomial2);
                int n = 0;
                while ((long)n < l) {
                    arrayList.add(complexAlgebraicNumber);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbers(GenPolynomial<C> genPolynomial) {
        if (genPolynomial.ring.coFac instanceof Complex) {
            throw new IllegalArgumentException("f already has Complex coefficients " + genPolynomial.ring);
        }
        if (genPolynomial.ring.coFac instanceof ComplexAlgebraicRing) {
            throw new UnsupportedOperationException("unsupported ComplexAlgebraicRing coefficients " + genPolynomial.ring);
        }
        ComplexRing complexRing = new ComplexRing(genPolynomial.ring.coFac);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(complexRing, genPolynomial.ring);
        GenPolynomial genPolynomial2 = PolyUtil.complexFromAny(genPolynomialRing, genPolynomial);
        return RootFactory.complexAlgebraicNumbersComplex(genPolynomial2);
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbers(GenPolynomial<C> genPolynomial, BigRational bigRational) {
        if (genPolynomial.ring.coFac instanceof Complex) {
            throw new IllegalArgumentException("f already has Complex coefficients " + genPolynomial.ring);
        }
        if (genPolynomial.ring.coFac instanceof ComplexAlgebraicRing) {
            throw new UnsupportedOperationException("unsupported ComplexAlgebraicRing coefficients " + genPolynomial.ring);
        }
        ComplexRing complexRing = new ComplexRing(genPolynomial.ring.coFac);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(complexRing, genPolynomial.ring);
        GenPolynomial genPolynomial2 = PolyUtil.complexFromAny(genPolynomialRing, genPolynomial);
        return RootFactory.complexAlgebraicNumbersComplex(genPolynomial2, bigRational);
    }
}

