/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerIterator;
import edu.jas.arith.ModularRingFactory;
import edu.jas.kern.StringUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class ModIntegerRing
implements ModularRingFactory<ModInteger>,
Iterable<ModInteger> {
    public final java.math.BigInteger modul;
    private static final Random random = new Random();
    private int isField = -1;

    public ModIntegerRing(java.math.BigInteger bigInteger) {
        this.modul = bigInteger;
    }

    public ModIntegerRing(java.math.BigInteger bigInteger, boolean bl) {
        this.modul = bigInteger;
        this.isField = bl ? 1 : 0;
    }

    public ModIntegerRing(long l) {
        this(new java.math.BigInteger(String.valueOf(l)));
    }

    public ModIntegerRing(long l, boolean bl) {
        this(new java.math.BigInteger(String.valueOf(l)), bl);
    }

    public ModIntegerRing(String string) {
        this(new java.math.BigInteger(string.trim()));
    }

    public ModIntegerRing(String string, boolean bl) {
        this(new java.math.BigInteger(string.trim()), bl);
    }

    public java.math.BigInteger getModul() {
        return this.modul;
    }

    @Override
    public BigInteger getIntegerModul() {
        return new BigInteger(this.modul);
    }

    public ModInteger create(java.math.BigInteger bigInteger) {
        return new ModInteger(this, bigInteger);
    }

    public ModInteger create(long l) {
        return new ModInteger(this, l);
    }

    public ModInteger create(String string) {
        return this.parse(string);
    }

    @Override
    public ModInteger copy(ModInteger modInteger) {
        return new ModInteger(this, modInteger.val);
    }

    @Override
    public ModInteger getZERO() {
        return new ModInteger(this, java.math.BigInteger.ZERO);
    }

    @Override
    public ModInteger getONE() {
        return new ModInteger(this, java.math.BigInteger.ONE);
    }

    @Override
    public List<ModInteger> generators() {
        ArrayList<ModInteger> arrayList = new ArrayList<ModInteger>(1);
        arrayList.add(this.getONE());
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.modul.isProbablePrime(this.modul.bitLength())) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    @Override
    public java.math.BigInteger characteristic() {
        return this.modul;
    }

    @Override
    public ModInteger fromInteger(java.math.BigInteger bigInteger) {
        return new ModInteger(this, bigInteger);
    }

    @Override
    public ModInteger fromInteger(long l) {
        return new ModInteger(this, l);
    }

    public String toString() {
        return " bigMod(" + this.modul.toString() + ")";
    }

    @Override
    public String toScript() {
        if (this.isField()) {
            return "GF(" + this.modul.toString() + ")";
        }
        return "ZM(" + this.modul.toString() + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof ModIntegerRing)) {
            return false;
        }
        ModIntegerRing modIntegerRing = (ModIntegerRing)object;
        return 0 == this.modul.compareTo(modIntegerRing.modul);
    }

    public int hashCode() {
        return this.modul.hashCode();
    }

    @Override
    public ModInteger random(int n) {
        return this.random(n, random);
    }

    @Override
    public ModInteger random(int n, Random random) {
        java.math.BigInteger bigInteger = new java.math.BigInteger(n, random);
        return new ModInteger(this, bigInteger);
    }

    @Override
    public ModInteger parse(String string) {
        return new ModInteger(this, string);
    }

    @Override
    public ModInteger parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }

    @Override
    public ModInteger chineseRemainder(ModInteger modInteger, ModInteger modInteger2, ModInteger modInteger3) {
        ModInteger modInteger4 = modInteger3.ring.fromInteger(modInteger.val);
        ModInteger modInteger5 = modInteger3.subtract(modInteger4);
        if (modInteger5.isZERO()) {
            return this.fromInteger(modInteger.val);
        }
        modInteger4 = modInteger5.multiply(modInteger2);
        java.math.BigInteger bigInteger = modInteger.ring.modul.multiply(modInteger4.val);
        bigInteger = bigInteger.add(modInteger.val);
        return this.fromInteger(bigInteger);
    }

    @Override
    public Iterator<ModInteger> iterator() {
        return new ModIntegerIterator(this);
    }
}

