/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.RingFactoryTokenizer;
import edu.jas.application.RunGB;
import edu.jas.gb.SolvableGroebnerBaseParallel;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gb.SolvableGroebnerBaseSeqPairParallel;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.util.CatReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.BasicConfigurator;

public class RunSGB {
    static boolean doCheck = false;
    static boolean doLog = true;

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        int n;
        String[] stringArray2 = new String[]{"seq", "seq+", "par", "par+"};
        String[] stringArray3 = new String[]{"irr", "left", "right", "two"};
        String string = "Usage: RunGB [ " + RunSGB.join(stringArray2, " | ") + " ] [" + RunSGB.join(stringArray3, " | ") + "] <file> " + "#threads " + "[check] [nolog]";
        if (stringArray.length < 3) {
            System.out.println("args: " + Arrays.toString(stringArray));
            System.out.println(string);
            return;
        }
        boolean bl = false;
        String string2 = stringArray[0];
        boolean bl2 = false;
        int n2 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            n = RunSGB.indexOf(stringArray2, stringArray[i]);
            if (n < 0) continue;
            bl2 = true;
            n2 = i;
            string2 = stringArray[n2];
            break;
        }
        if (!bl2) {
            System.out.println("args(sup): " + Arrays.toString(stringArray));
            System.out.println(string);
            return;
        }
        if (string2.indexOf("+") >= 0) {
            bl = true;
        }
        System.out.println("kind: " + string2 + ", k = " + n2);
        String string3 = stringArray[n2 + 1];
        bl2 = false;
        n = RunSGB.indexOf(stringArray3, string3);
        if (n < 0) {
            System.out.println(string);
            return;
        }
        String string4 = stringArray[n2 + 2];
        int n3 = 0;
        if (string2.startsWith("par")) {
            if (stringArray.length < 4) {
                System.out.println("args(par): " + Arrays.toString(stringArray));
                System.out.println(string);
                return;
            }
            object = object2 = stringArray[n2 + 3];
            try {
                n3 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                System.out.println("args(threads): " + Arrays.toString(stringArray));
                System.out.println(string);
                return;
            }
            if (n3 < 1) {
                n3 = 1;
            }
        }
        if ((n = RunSGB.indexOf(stringArray, "check")) >= 0) {
            doCheck = true;
        }
        if ((n = RunSGB.indexOf(stringArray, "nolog")) >= 0) {
            doLog = false;
        }
        if ((object2 = RunGB.getReader(string4)) == null) {
            System.out.println("args(file): " + string4);
            System.out.println("args(file): examples.jar(" + string4 + ")");
            System.out.println("args(file): " + Arrays.toString(stringArray));
            System.out.println(string);
            return;
        }
        object = new RingFactoryTokenizer((Reader)object2);
        GenSolvablePolynomialRing genSolvablePolynomialRing = null;
        try {
            genSolvablePolynomialRing = ((RingFactoryTokenizer)object).nextSolvablePolynomialRing();
            object = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        CatReader catReader = new CatReader(new StringReader("("), (Reader)object2);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(genSolvablePolynomialRing, catReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = new PolynomialList(genSolvablePolynomialRing, genPolynomialTokenizer.nextSolvablePolynomialList());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        System.out.println("S =\n" + polynomialList);
        if (doLog) {
            BasicConfigurator.configure();
        }
        if (string2.startsWith("seq")) {
            RunSGB.runSequential(polynomialList, string3, bl);
        } else if (string2.startsWith("par")) {
            RunSGB.runParallel(polynomialList, n3, string3, bl);
        }
        ComputerThreads.terminate();
    }

    static void runSequential(PolynomialList polynomialList, String string, boolean bl) {
        List list = polynomialList.list;
        List list2 = null;
        SolvableReductionSeq solvableReductionSeq = new SolvableReductionSeq();
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = null;
        solvableGroebnerBaseSeq = bl ? new SolvableGroebnerBaseSeq() : new SolvableGroebnerBaseSeq();
        long l = System.currentTimeMillis();
        System.out.println("\nSolvable GB [" + string + "] sequential ...");
        if (string.equals("irr")) {
            list2 = solvableReductionSeq.leftIrreducibleSet(list);
        }
        if (string.equals("left")) {
            list2 = solvableGroebnerBaseSeq.leftGB(list);
        }
        if (string.equals("right")) {
            list2 = solvableGroebnerBaseSeq.rightGB(list);
        }
        if (string.equals("two")) {
            list2 = solvableGroebnerBaseSeq.twosidedGB(list);
        }
        if (list2 == null) {
            System.out.println("unknown action = " + string + "\n");
            return;
        }
        polynomialList = new PolynomialList(polynomialList.ring, list2);
        System.out.println("G =\n" + polynomialList);
        System.out.println("G.size() = " + list2.size());
        l = System.currentTimeMillis() - l;
        if (bl) {
            System.out.print("seq+, ");
        } else {
            System.out.print("seq, ");
        }
        System.out.println("time = " + l + " milliseconds");
        RunSGB.checkGB(polynomialList);
        System.out.println("");
    }

    static void runParallel(PolynomialList polynomialList, int n, String string, boolean bl) {
        List list = polynomialList.list;
        List list2 = null;
        SolvableReductionPar solvableReductionPar = new SolvableReductionPar();
        SolvableGroebnerBaseParallel solvableGroebnerBaseParallel = null;
        SolvableGroebnerBaseSeqPairParallel solvableGroebnerBaseSeqPairParallel = null;
        if (bl) {
            solvableGroebnerBaseSeqPairParallel = new SolvableGroebnerBaseSeqPairParallel(n);
        } else {
            solvableGroebnerBaseParallel = new SolvableGroebnerBaseParallel(n);
        }
        long l = System.currentTimeMillis();
        System.out.println("\nSolvable GB [" + string + "] parallel " + n + " threads ...");
        if (string.equals("irr")) {
            list2 = solvableReductionPar.leftIrreducibleSet(list);
        }
        if (string.equals("left")) {
            list2 = bl ? solvableGroebnerBaseSeqPairParallel.leftGB(list) : solvableGroebnerBaseParallel.leftGB(list);
        }
        if (string.equals("right")) {
            list2 = bl ? solvableGroebnerBaseSeqPairParallel.rightGB(list) : solvableGroebnerBaseParallel.rightGB(list);
        }
        if (string.equals("two")) {
            list2 = bl ? solvableGroebnerBaseSeqPairParallel.twosidedGB(list) : solvableGroebnerBaseParallel.twosidedGB(list);
        }
        if (list2 == null) {
            System.out.println("unknown action = " + string + "\n");
            return;
        }
        polynomialList = list2.size() > 0 ? new PolynomialList(list2.get((int)0).ring, list2) : new PolynomialList(polynomialList.ring, list2);
        System.out.println("G =\n" + polynomialList);
        System.out.println("G.size() = " + list2.size());
        l = System.currentTimeMillis() - l;
        if (bl) {
            System.out.print("p+ ");
        } else {
            System.out.print("p ");
        }
        System.out.println("= " + n + ", time = " + l + " milliseconds");
        RunSGB.checkGB(polynomialList);
        System.out.println("");
        if (bl) {
            solvableGroebnerBaseSeqPairParallel.terminate();
        } else {
            solvableGroebnerBaseParallel.terminate();
        }
    }

    static void checkGB(PolynomialList polynomialList) {
        if (!doCheck) {
            return;
        }
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        long l = System.currentTimeMillis();
        boolean bl = solvableGroebnerBaseSeq.isLeftGB(polynomialList.list, false);
        l = System.currentTimeMillis() - l;
        System.out.println("check isGB = " + bl + " in " + l + " milliseconds");
    }

    static int indexOf(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    static String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }
}

