/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.FactorFactory;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorAlgebraic;
import edu.jas.ufd.FactorInteger;
import edu.jas.ufd.FactorModular;
import edu.jas.ufd.FactorQuotient;
import edu.jas.ufd.FactorRational;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)FactorTest.suite());
    }

    public FactorTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FactorTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testFactory() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        FactorAbstract<ModInteger> factorAbstract = FactorFactory.getImplementation(modIntegerRing);
        FactorTest.assertTrue((String)("ufd != Modular " + factorAbstract), (boolean)(factorAbstract instanceof FactorModular));
        ModLongRing modLongRing = new ModLongRing(19L, true);
        FactorAbstract<ModLong> factorAbstract2 = FactorFactory.getImplementation(modLongRing);
        FactorTest.assertTrue((String)("ufd != Modular " + factorAbstract2), (boolean)(factorAbstract2 instanceof FactorModular));
        BigInteger bigInteger = new BigInteger(1L);
        FactorAbstract<BigInteger> factorAbstract3 = FactorFactory.getImplementation(bigInteger);
        FactorTest.assertTrue((String)("ufd != Integer " + factorAbstract3), (boolean)(factorAbstract3 instanceof FactorInteger));
        BigRational bigRational = new BigRational(1L);
        FactorAbstract<BigRational> factorAbstract4 = FactorFactory.getImplementation(bigRational);
        FactorTest.assertTrue((String)("ufd != Rational " + factorAbstract4), (boolean)(factorAbstract4 instanceof FactorRational));
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.univariate(0);
        AlgebraicNumberRing<ModInteger> algebraicNumberRing = new AlgebraicNumberRing<ModInteger>(genPolynomial, true);
        FactorAbstract<AlgebraicNumber<ModInteger>> factorAbstract5 = FactorFactory.getImplementation(algebraicNumberRing);
        FactorTest.assertTrue((String)("ufd != AlgebraicNumber<ModInteger> " + factorAbstract5), (boolean)(factorAbstract5 instanceof FactorAlgebraic));
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 1);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.univariate(0);
        AlgebraicNumberRing<BigRational> algebraicNumberRing2 = new AlgebraicNumberRing<BigRational>(genPolynomial2, true);
        FactorAbstract<AlgebraicNumber<BigRational>> factorAbstract6 = FactorFactory.getImplementation(algebraicNumberRing2);
        FactorTest.assertTrue((String)("ufd != AlgebraicNumber<BigRational> " + factorAbstract6), (boolean)(factorAbstract6 instanceof FactorAlgebraic));
        genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 2);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing2);
        FactorAbstract<Quotient<BigRational>> factorAbstract7 = FactorFactory.getImplementation(quotientRing);
        FactorTest.assertTrue((String)("ufd != Quotient<BigRational> " + factorAbstract7), (boolean)(factorAbstract7 instanceof FactorQuotient));
    }

    public void testFactoryGeneric() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        FactorAbstract<ModInteger> factorAbstract = FactorFactory.getImplementation(modIntegerRing);
        FactorTest.assertTrue((String)("ufd != Modular " + factorAbstract), (boolean)(factorAbstract instanceof FactorModular));
        BigInteger bigInteger = new BigInteger(1L);
        FactorAbstract<BigInteger> factorAbstract2 = FactorFactory.getImplementation(bigInteger);
        FactorTest.assertTrue((String)("ufd != Integer " + factorAbstract2), (boolean)(factorAbstract2 instanceof FactorInteger));
        BigRational bigRational = new BigRational(1L);
        FactorAbstract<BigRational> factorAbstract3 = FactorFactory.getImplementation(bigRational);
        FactorTest.assertTrue((String)("ufd != Rational " + factorAbstract3), (boolean)(factorAbstract3 instanceof FactorRational));
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.univariate(0);
        AlgebraicNumberRing<ModInteger> algebraicNumberRing = new AlgebraicNumberRing<ModInteger>(genPolynomial, true);
        FactorAbstract<ModInteger> factorAbstract4 = FactorFactory.getImplementation(algebraicNumberRing);
        FactorTest.assertTrue((String)("ufd != AlgebraicNumber<ModInteger> " + factorAbstract4), (boolean)(factorAbstract4 instanceof FactorAlgebraic));
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 1);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.univariate(0);
        AlgebraicNumberRing<BigRational> algebraicNumberRing2 = new AlgebraicNumberRing<BigRational>(genPolynomial2, true);
        FactorAbstract<BigRational> factorAbstract5 = FactorFactory.getImplementation(algebraicNumberRing2);
        FactorTest.assertTrue((String)("ufd != AlgebraicNumber<BigRational> " + factorAbstract5), (boolean)(factorAbstract5 instanceof FactorAlgebraic));
        genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 2);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing2);
        FactorAbstract<BigRational> factorAbstract6 = FactorFactory.getImplementation(quotientRing);
        FactorTest.assertTrue((String)("ufd != Quotient<BigRational> " + factorAbstract6), (boolean)(factorAbstract6 instanceof FactorQuotient));
        genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        QuotientRing<ModInteger> quotientRing2 = new QuotientRing<ModInteger>(genPolynomialRing);
        FactorAbstract<ModInteger> factorAbstract7 = FactorFactory.getImplementation(quotientRing2);
        FactorTest.assertTrue((String)("ufd != Quotient<ModInteger> " + factorAbstract7), (boolean)(factorAbstract7 instanceof FactorQuotient));
        genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 2);
        GenPolynomialRing<BigRational> genPolynomialRing3 = new GenPolynomialRing<BigRational>(genPolynomialRing2, 1);
        FactorAbstract<BigRational> factorAbstract8 = FactorFactory.getImplementation(genPolynomialRing3);
        FactorTest.assertTrue((String)("ufd != GenPolynomial<GenPolynomialBigRational>> " + factorAbstract8), (boolean)(factorAbstract8 instanceof FactorRational));
    }

    public void testFactorySpecific() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        FactorAbstract<ModInteger> factorAbstract = FactorFactory.getImplementation(modIntegerRing);
        FactorTest.assertTrue((String)("ufd != Modular " + factorAbstract), (boolean)(factorAbstract instanceof FactorModular));
        BigInteger bigInteger = new BigInteger(1L);
        FactorAbstract<BigInteger> factorAbstract2 = FactorFactory.getImplementation(bigInteger);
        FactorTest.assertTrue((String)("ufd != Integer " + factorAbstract2), (boolean)(factorAbstract2 instanceof FactorInteger));
        BigRational bigRational = new BigRational(1L);
        FactorAbstract<BigRational> factorAbstract3 = FactorFactory.getImplementation(bigRational);
        FactorTest.assertTrue((String)("ufd != Rational " + factorAbstract3), (boolean)(factorAbstract3 instanceof FactorRational));
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.univariate(0);
        AlgebraicNumberRing<ModInteger> algebraicNumberRing = new AlgebraicNumberRing<ModInteger>(genPolynomial, true);
        FactorAbstract<AlgebraicNumber<ModInteger>> factorAbstract4 = FactorFactory.getImplementation(algebraicNumberRing);
        FactorTest.assertTrue((String)("ufd != AlgebraicNumber<ModInteger> " + factorAbstract4), (boolean)(factorAbstract4 instanceof FactorAlgebraic));
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 1);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.univariate(0);
        AlgebraicNumberRing<BigRational> algebraicNumberRing2 = new AlgebraicNumberRing<BigRational>(genPolynomial2, true);
        FactorAbstract<AlgebraicNumber<BigRational>> factorAbstract5 = FactorFactory.getImplementation(algebraicNumberRing2);
        FactorTest.assertTrue((String)("ufd != AlgebraicNumber<BigRational> " + factorAbstract5), (boolean)(factorAbstract5 instanceof FactorAlgebraic));
        genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 2);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing2);
        FactorAbstract<Quotient<BigRational>> factorAbstract6 = FactorFactory.getImplementation(quotientRing);
        FactorTest.assertTrue((String)("ufd != Quotient<BigRational> " + factorAbstract6), (boolean)(factorAbstract6 instanceof FactorQuotient));
        genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        QuotientRing<ModInteger> quotientRing2 = new QuotientRing<ModInteger>(genPolynomialRing);
        FactorAbstract<Quotient<ModInteger>> factorAbstract7 = FactorFactory.getImplementation(quotientRing2);
        FactorTest.assertTrue((String)("ufd != Quotient<ModInteger> " + factorAbstract7), (boolean)(factorAbstract7 instanceof FactorQuotient));
        genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 2);
        FactorAbstract<BigRational> factorAbstract8 = FactorFactory.getImplementation(genPolynomialRing2);
        FactorTest.assertTrue((String)("ufd != GenPolynomial<GenPolynomialBigRational>> " + factorAbstract8), (boolean)(factorAbstract8 instanceof FactorRational));
    }
}

