/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class CoeffToReAlg<C extends GcdRingElem<C> & Rational>
implements UnaryFunctor<C, RealAlgebraicNumber<C>> {
    protected final RealAlgebraicRing<C> afac;
    protected final GenPolynomial<C> zero;

    public CoeffToReAlg(RealAlgebraicRing<C> realAlgebraicRing) {
        if (realAlgebraicRing == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.afac = realAlgebraicRing;
        GenPolynomialRing genPolynomialRing = this.afac.algebraic.ring;
        this.zero = genPolynomialRing.getZERO();
    }

    @Override
    public RealAlgebraicNumber<C> eval(C c) {
        if (c == null) {
            return this.afac.getZERO();
        }
        return new RealAlgebraicNumber<C>(this.afac, this.zero.sum(c));
    }
}

