/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ps.ExpVectorIterable;
import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.ps.MultiVarPowerSeriesRing;
import edu.jas.ps.Ones;
import edu.jas.ps.PolynomialTaylorFunction;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.ps.UnivPowerSeriesRing;
import edu.jas.ps.Vars;
import edu.jas.ps.Zeros;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MultiVarPowerSeriesTest
extends TestCase {
    MultiVarPowerSeriesRing<BigRational> fac;
    MultiVarPowerSeries<BigRational> a;
    MultiVarPowerSeries<BigRational> b;
    MultiVarPowerSeries<BigRational> c;
    MultiVarPowerSeries<BigRational> d;
    MultiVarPowerSeries<BigRational> e;
    MultiVarPowerSeries<BigRational> f;
    int rl = 2;
    int kl = 10;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)MultiVarPowerSeriesTest.suite());
    }

    public MultiVarPowerSeriesTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(MultiVarPowerSeriesTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        String[] stringArray = new String[]{"x", "y"};
        this.fac = new MultiVarPowerSeriesRing<BigRational>(new BigRational(1L), this.rl, stringArray);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testCoefficients() {
        int n;
        RingElem<BigRational> ringElem;
        AbelianGroupElem<ExpVector> abelianGroupElem2;
        BigRational bigRational = new BigRational(0L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        Zeros zeros = new Zeros(genPolynomialRing);
        Ones ones = new Ones(genPolynomialRing);
        Vars vars = new Vars(genPolynomialRing);
        int n2 = 5;
        ExpVectorIterable expVectorIterable = new ExpVectorIterable(this.rl, true, n2);
        for (AbelianGroupElem<ExpVector> abelianGroupElem2 : expVectorIterable) {
            ringElem = (BigRational)zeros.get((ExpVector)abelianGroupElem2);
            MultiVarPowerSeriesTest.assertTrue((String)"isZERO( c )", (boolean)ringElem.isZERO());
        }
        MultiVarPowerSeriesTest.assertTrue((String)"coeffCache is one element", (zeros.coeffCache.size() == n2 + 1 ? 1 : 0) != 0);
        for (AbelianGroupElem<ExpVector> abelianGroupElem2 : expVectorIterable) {
            ringElem = (BigRational)ones.get((ExpVector)abelianGroupElem2);
            MultiVarPowerSeriesTest.assertTrue((String)"isONE( c )", (boolean)ringElem.isONE());
        }
        MultiVarPowerSeriesTest.assertTrue((String)"zeroCache is empty", (boolean)ones.zeroCache.isEmpty());
        for (n = 0; n <= n2; ++n) {
            abelianGroupElem2 = ones.getHomPart(n);
            ringElem = ones.getHomPart(n);
            MultiVarPowerSeriesTest.assertTrue((String)"c.equals(d) ", (boolean)((GenPolynomial)abelianGroupElem2).equals(ringElem));
        }
        MultiVarPowerSeriesTest.assertTrue((String)"zeroCache is empty", (boolean)ones.zeroCache.isEmpty());
        MultiVarPowerSeriesTest.assertTrue((String)("#coeffCache = " + n2), (ones.coeffCache.size() == n2 + 1 ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)("#homCheck = " + n2), (ones.homCheck.length() == n2 + 1 ? 1 : 0) != 0);
        for (n = 0; n <= n2; ++n) {
            abelianGroupElem2 = vars.getHomPart(n);
            MultiVarPowerSeriesTest.assertTrue((String)"c==0 || deg(c)==1 ", (((GenPolynomial)abelianGroupElem2).isZERO() || ((GenPolynomial)abelianGroupElem2).degree() == 1L ? 1 : 0) != 0);
        }
        MultiVarPowerSeriesTest.assertTrue((String)("#coeffCache = " + n2), (vars.coeffCache.size() == n2 + 1 ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)("#homCheck = " + n2), (vars.homCheck.length() == n2 + 1 ? 1 : 0) != 0);
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        MultiVarPowerSeriesTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        MultiVarPowerSeriesTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        MultiVarPowerSeriesTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        List<MultiVarPowerSeries<BigRational>> list = this.fac.generators();
        MultiVarPowerSeriesTest.assertTrue((String)"#gens == rl+1 ", (this.rl + 1 == list.size() ? 1 : 0) != 0);
        for (MultiVarPowerSeries<BigRational> multiVarPowerSeries : list) {
            MultiVarPowerSeriesTest.assertTrue((String)"red(p) == 0 ", (boolean)multiVarPowerSeries.reductum().isZERO());
        }
        this.a = this.fac.copy(this.c);
        this.b = this.c.copy();
        MultiVarPowerSeriesTest.assertEquals((String)"copy(c) == c.clone() ", this.a, this.b);
        this.a = this.fac.fromInteger(1L);
        MultiVarPowerSeriesTest.assertEquals((String)"1 == fromInteger(1) ", this.a, this.c);
        this.b = this.fac.fromInteger(BigInteger.ONE);
        MultiVarPowerSeriesTest.assertEquals((String)"1 == fromInteger(1) ", this.b, this.c);
    }

    public void testRandom() {
        for (int i = 0; i < 5; ++i) {
            this.a = this.fac.random(i + 2);
            MultiVarPowerSeriesTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            MultiVarPowerSeriesTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testCoefficientsInPS() {
        int n;
        RingElem<BigRational> ringElem;
        AbelianGroupElem<ExpVector> abelianGroupElem2;
        Zeros zeros = new Zeros(this.fac);
        Ones ones = new Ones(this.fac);
        Vars vars = new Vars(this.fac);
        this.a = new MultiVarPowerSeries<BigRational>(this.fac, zeros);
        this.b = new MultiVarPowerSeries<BigRational>(this.fac, ones);
        this.c = new MultiVarPowerSeries<BigRational>(this.fac, vars);
        int n2 = 5;
        ExpVectorIterable expVectorIterable = new ExpVectorIterable(this.rl, true, n2);
        for (AbelianGroupElem<ExpVector> abelianGroupElem2 : expVectorIterable) {
            ringElem = this.a.coefficient((ExpVector)abelianGroupElem2);
            MultiVarPowerSeriesTest.assertTrue((String)"isZERO( r )", (boolean)ringElem.isZERO());
        }
        MultiVarPowerSeriesTest.assertTrue((String)"coeffCache is one element", (this.a.lazyCoeffs.coeffCache.size() == n2 + 1 ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        for (AbelianGroupElem<ExpVector> abelianGroupElem2 : expVectorIterable) {
            ringElem = this.b.coefficient((ExpVector)abelianGroupElem2);
            MultiVarPowerSeriesTest.assertTrue((String)"isONE( r )", (boolean)ringElem.isONE());
        }
        MultiVarPowerSeriesTest.assertTrue((String)"zeroCache is empty", (boolean)this.b.lazyCoeffs.zeroCache.isEmpty());
        for (n = 0; n <= n2; ++n) {
            abelianGroupElem2 = this.b.homogeneousPart(n);
            ringElem = this.b.homogeneousPart(n);
            MultiVarPowerSeriesTest.assertTrue((String)"p.equals(q) ", (boolean)((GenPolynomial)abelianGroupElem2).equals(ringElem));
        }
        MultiVarPowerSeriesTest.assertTrue((String)"zeroCache is empty", (boolean)this.b.lazyCoeffs.zeroCache.isEmpty());
        MultiVarPowerSeriesTest.assertTrue((String)("#coeffCache = " + n2), (this.b.lazyCoeffs.coeffCache.size() == n2 + 1 ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)("#homCheck = " + n2), (this.b.lazyCoeffs.homCheck.length() == n2 + 1 ? 1 : 0) != 0);
        for (n = 0; n <= n2; ++n) {
            abelianGroupElem2 = this.c.homogeneousPart(n);
            MultiVarPowerSeriesTest.assertTrue((String)"p==0 || deg(p)==1 ", (((GenPolynomial)abelianGroupElem2).isZERO() || ((GenPolynomial)abelianGroupElem2).degree() == 1L ? 1 : 0) != 0);
        }
        MultiVarPowerSeriesTest.assertTrue((String)("#coeffCache = " + n2), (this.c.lazyCoeffs.coeffCache.size() == n2 + 1 ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)("#homCheck = " + n2), (this.c.lazyCoeffs.homCheck.length() == n2 + 1 ? 1 : 0) != 0);
    }

    public void testAddition() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        MultiVarPowerSeriesTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.d = this.c.subtract(this.b);
        MultiVarPowerSeriesTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.d = this.c.sum((MultiVarPowerSeries<BigRational>)this.b.negate());
        MultiVarPowerSeriesTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.a.sum(this.b.sum(this.c));
        this.e = this.a.sum(this.b).sum(this.c);
        MultiVarPowerSeriesTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        Map.Entry<ExpVector, BigRational> entry = this.a.orderMonomial();
        this.c = this.a.reductum().sum(entry);
        MultiVarPowerSeriesTest.assertEquals((String)"a = red(a)+om(a)", this.a, this.c);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        MultiVarPowerSeriesTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        MultiVarPowerSeriesTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        MultiVarPowerSeriesTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        MultiVarPowerSeriesTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        MultiVarPowerSeriesTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        MultiVarPowerSeriesTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        MultiVarPowerSeriesTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        ExpVector expVector = ExpVector.random(this.rl, 5L, 0.8f);
        BigRational bigRational = (BigRational)this.fac.coFac.random(5);
        this.b = this.a.shift(expVector).multiply(bigRational);
        this.c = this.a.multiply(bigRational, expVector);
        MultiVarPowerSeriesTest.assertEquals((String)"(a ev) br = a (ev,br)", this.b, this.c);
    }

    public void testDistributive() {
        this.a = this.fac.random(this.kl, this.q);
        this.b = this.fac.random(this.kl, this.q);
        this.c = this.fac.random(this.kl, this.q);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        MultiVarPowerSeriesTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testInverse() {
        this.a = this.fac.getONE();
        MultiVarPowerSeriesTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        MultiVarPowerSeriesTest.assertTrue((String)"isUnit( a )", (boolean)this.a.isUnit());
        this.b = this.a.inverse();
        this.c = this.a.multiply(this.b);
        MultiVarPowerSeriesTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.a = this.fac.random(this.kl);
        if (!this.a.isUnit()) {
            this.a = this.fac.fromInteger(23L);
        }
        this.b = this.a.inverse();
        this.c = this.a.multiply(this.b);
        MultiVarPowerSeriesTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.b = this.fac.random(this.kl);
        this.c = this.b.divide(this.a);
        this.d = this.c.multiply(this.a);
        MultiVarPowerSeriesTest.assertEquals((String)"b/a * a == b ", this.d, this.b);
    }

    public void testFixpoints() {
        int n = 0;
        UnivPowerSeriesRing univPowerSeriesRing = new UnivPowerSeriesRing(this.fac.coFac, this.fac.vars[n]);
        UnivPowerSeries univPowerSeries = univPowerSeriesRing.getEXP();
        this.a = this.fac.fromPowerSeries(univPowerSeries, 0);
        this.b = this.fac.fromPowerSeries(univPowerSeries, 1);
        this.c = this.fac.getEXP(0);
        this.d = this.fac.getEXP(1);
        MultiVarPowerSeriesTest.assertEquals((String)"a == c ", this.a, this.c);
        MultiVarPowerSeriesTest.assertEquals((String)"b == d ", this.b, this.d);
        this.e = this.d.differentiate(0);
        MultiVarPowerSeriesTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.d.differentiate(1);
        MultiVarPowerSeriesTest.assertEquals((String)"e == d ", this.d, this.e);
    }

    public void testReductum() {
        this.a = this.fac.random(this.kl);
        Map.Entry<ExpVector, BigRational> entry = this.a.orderMonomial();
        ExpVector expVector = entry.getKey();
        BigRational bigRational = entry.getValue();
        this.b = ((MultiVarPowerSeries)this.fac.getONE()).multiply(bigRational, expVector);
        this.c = this.a.reductum();
        this.d = this.c.sum(this.b);
        MultiVarPowerSeriesTest.assertEquals((String)"a = red(a)+1*lm(a) ", this.a, this.d);
        this.e = this.c.sum(bigRational, expVector);
        MultiVarPowerSeriesTest.assertEquals((String)"a = red(a)+lm(a) ", this.a, this.e);
        this.e = this.a.subtract(bigRational, expVector);
        MultiVarPowerSeriesTest.assertEquals((String)"a - lm(a) = red(a) ", this.c, this.e);
        this.b = this.fac.random(this.kl);
        String string = this.b.toString();
        MultiVarPowerSeriesTest.assertFalse((String)("s.size > 0 " + string), (string.length() == 0 ? 1 : 0) != 0);
        this.c = this.a.sum(this.b);
        this.d = this.a.sum(this.b.lazyCoeffs);
        bigRational = new BigRational(2L, 3L);
        this.c = this.a.prepend(bigRational, 0);
        this.d = this.c.reductum(0);
        MultiVarPowerSeriesTest.assertEquals((String)"red(a + br_0,0) = a ", this.d, this.a);
        this.c = this.a.shift(3, 0);
        this.d = this.c.shift(-3, 0);
        MultiVarPowerSeriesTest.assertEquals((String)"shift(shift(a,3,),-3,0) = a ", this.d, this.a);
    }

    public void testPolynomial() {
        GenPolynomialRing<BigRational> genPolynomialRing = this.fac.polyRing();
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, 3, 3, this.q + this.q);
        this.a = this.fac.fromPolynomial(genPolynomial);
        GenPolynomial<BigRational> genPolynomial2 = this.a.asPolynomial();
        MultiVarPowerSeriesTest.assertEquals((String)"asPolynomial(fromPolynomial(p)) = p ", genPolynomial, genPolynomial2);
    }

    public void testGcd() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        this.c = this.a.gcd(this.b);
        this.d = this.a.divide(this.c);
        this.e = this.b.divide(this.c);
        this.f = this.d.gcd(this.e);
        MultiVarPowerSeriesTest.assertTrue((String)"gcd(a/gcd(a,b),b/gcd(a,b)) == 1 ", (boolean)this.f.isONE());
    }

    public void testTaylor() {
        BigRational bigRational = new BigRational(5L);
        BigRational bigRational2 = new BigRational(0L);
        BigRational bigRational3 = new BigRational(-5L);
        ArrayList<BigRational> arrayList = new ArrayList<BigRational>(this.rl);
        ArrayList<BigRational> arrayList2 = new ArrayList<BigRational>(this.rl);
        ArrayList<BigRational> arrayList3 = new ArrayList<BigRational>(this.rl);
        for (int i = 0; i < this.rl; ++i) {
            arrayList.add(bigRational);
            arrayList2.add(bigRational2);
            arrayList3.add(bigRational3);
        }
        GenPolynomialRing<BigRational> genPolynomialRing = this.fac.polyRing();
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, 3, 3, this.q + this.q);
        int n = (int)genPolynomial.degree();
        this.fac.setTruncate(n + 1);
        PolynomialTaylorFunction<BigRational> polynomialTaylorFunction = new PolynomialTaylorFunction<BigRational>(genPolynomial);
        MultiVarPowerSeries<BigRational> multiVarPowerSeries = this.fac.fromPolynomial(genPolynomial);
        MultiVarPowerSeries<BigRational> multiVarPowerSeries2 = this.fac.seriesOfTaylor(polynomialTaylorFunction, arrayList2);
        MultiVarPowerSeriesTest.assertEquals((String)"taylor(p) == p", multiVarPowerSeries2, multiVarPowerSeries);
        MultiVarPowerSeries<BigRational> multiVarPowerSeries3 = this.fac.seriesOfTaylor(polynomialTaylorFunction, arrayList);
        polynomialTaylorFunction = new PolynomialTaylorFunction<BigRational>(multiVarPowerSeries3.asPolynomial());
        MultiVarPowerSeries<BigRational> multiVarPowerSeries4 = this.fac.seriesOfTaylor(polynomialTaylorFunction, arrayList3);
        MultiVarPowerSeriesTest.assertEquals((String)"taylor(taylor(p,5),-5) == p", multiVarPowerSeries2, multiVarPowerSeries4);
        for (GenPolynomial<BigRational> genPolynomial2 : genPolynomialRing.generators()) {
            polynomialTaylorFunction = new PolynomialTaylorFunction<BigRational>(genPolynomial2);
            multiVarPowerSeries2 = this.fac.seriesOfTaylor(polynomialTaylorFunction, arrayList2);
            multiVarPowerSeries = this.fac.fromPolynomial(genPolynomial2);
            MultiVarPowerSeriesTest.assertEquals((String)"taylor(p) == p", multiVarPowerSeries2, multiVarPowerSeries);
            multiVarPowerSeries3 = this.fac.seriesOfTaylor(polynomialTaylorFunction, arrayList);
            polynomialTaylorFunction = new PolynomialTaylorFunction<BigRational>(multiVarPowerSeries3.asPolynomial());
            multiVarPowerSeries4 = this.fac.seriesOfTaylor(polynomialTaylorFunction, arrayList3);
            MultiVarPowerSeriesTest.assertEquals((String)"taylor(taylor(p,5),-5) == p", multiVarPowerSeries2, multiVarPowerSeries4);
        }
    }

    public void testEvaluation() {
        this.a = this.fac.random(this.kl, this.q);
        this.b = this.fac.random(this.kl, this.q);
        BigRational bigRational = new BigRational(0L);
        ArrayList<BigRational> arrayList = new ArrayList<BigRational>(this.rl);
        for (int i = 0; i < this.rl; ++i) {
            arrayList.add(bigRational.random(this.kl));
        }
        BigRational bigRational2 = this.a.evaluate(arrayList);
        BigRational bigRational3 = this.b.evaluate(arrayList);
        this.c = this.a.sum(this.b);
        BigRational bigRational4 = this.c.evaluate(arrayList);
        BigRational bigRational5 = bigRational2.sum(bigRational3);
        MultiVarPowerSeriesTest.assertEquals((String)"a(v)+b(v) = (a+b)(v) ", (Object)bigRational4, (Object)bigRational5);
        this.c = this.fac.getZERO();
        bigRational4 = this.c.evaluate(arrayList);
        bigRational5 = bigRational.getZERO();
        MultiVarPowerSeriesTest.assertEquals((String)"0(v) = 0 ", (Object)bigRational4, (Object)bigRational5);
        this.c = this.fac.getONE();
        bigRational4 = this.c.evaluate(arrayList);
        bigRational5 = bigRational.getONE();
        MultiVarPowerSeriesTest.assertEquals((String)"1(v) = 1 ", (Object)bigRational4, (Object)bigRational5);
    }
}

