/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseDistributedHybridEC;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import edu.jas.util.ExecutableServer;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GroebnerBaseDistHybridECTest
extends TestCase {
    int port = 55711;
    String host = "localhost";
    String mfile = "examples/machines.localhost";
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    GroebnerBase<BigRational> bbseq;
    GroebnerBaseAbstract<BigRational> bbdist;
    GroebnerBaseAbstract<BigRational> bbdists;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 4;
    int ll = 7;
    int el = 3;
    float q = 0.2f;
    int threads = 2;
    ExecutableServer es1;
    ExecutableServer es2;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GroebnerBaseDistHybridECTest.suite());
    }

    public GroebnerBaseDistHybridECTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBaseDistHybridECTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.es1 = new ExecutableServer(4712);
        this.es1.init();
        this.es2 = new ExecutableServer(4711);
        this.es2.init();
        BigRational bigRational = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bbseq = new GroebnerBaseSeq<BigRational>();
        this.bbdist = new GroebnerBaseDistributedHybridEC<BigRational>(this.mfile, this.threads, this.port);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bbseq = null;
        this.bbdist.terminate();
        this.bbdist = null;
        this.es1.terminate();
        this.es2.terminate();
        this.es1 = null;
        this.es2 = null;
        ComputerThreads.terminate();
    }

    public void testDistributedGBaseCorner() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.getZERO();
        this.L.add(this.a);
        this.L = this.bbdist.GB(this.L);
        GroebnerBaseDistHybridECTest.assertTrue((String)("isGB( { a } ): " + this.L), (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseDistHybridECTest.assertTrue((String)("L == {}: " + this.L), (boolean)this.L.isEmpty());
        this.b = this.fac.getONE();
        this.L.add(this.b);
        this.L = this.bbdist.GB(this.L);
        GroebnerBaseDistHybridECTest.assertTrue((String)("isGB( { a } ): " + this.L), (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseDistHybridECTest.assertTrue((String)("L == {1}: " + this.L), (this.L.size() == 1 ? 1 : 0) != 0);
    }

    public void testDistributedGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L.add(this.a);
        this.L = this.bbdist.GB(this.L);
        GroebnerBaseDistHybridECTest.assertTrue((String)("isGB( { a } ): " + this.L), (boolean)this.bbseq.isGB(this.L));
        this.L.add(this.b);
        this.L = this.bbdist.GB(this.L);
        GroebnerBaseDistHybridECTest.assertTrue((String)("isGB( { a, b } ): " + this.L), (boolean)this.bbseq.isGB(this.L));
        this.L.add(this.c);
        this.L = this.bbdist.GB(this.L);
        GroebnerBaseDistHybridECTest.assertTrue((String)("isGB( { a, b, c } ): " + this.L), (boolean)this.bbseq.isGB(this.L));
        this.L.add(this.d);
        this.L = this.bbdist.GB(this.L);
        GroebnerBaseDistHybridECTest.assertTrue((String)("isGB( { a, b, c, d } ): " + this.L), (boolean)this.bbseq.isGB(this.L));
        this.L.add(this.e);
        this.L = this.bbdist.GB(this.L);
        GroebnerBaseDistHybridECTest.assertTrue((String)("isGB( { a, b, c, d, e } ): " + this.L), (boolean)this.bbseq.isGB(this.L));
    }

    public void testSequentialDistributedGBase() {
        List<GenPolynomial<BigRational>> list = null;
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L.add(this.a);
        List<GenPolynomial<BigRational>> list2 = this.bbseq.GB(this.L);
        list = this.bbdist.GB(this.L);
        GroebnerBaseDistHybridECTest.assertTrue((String)("Gs.containsAll(Gp)" + list2 + ", " + list + ", " + this.L), (boolean)list2.containsAll(list));
        GroebnerBaseDistHybridECTest.assertTrue((String)("Gp.containsAll(Gs)" + list2 + ", " + list + ", " + this.L), (boolean)list.containsAll(list2));
        this.L = list2;
        this.L.add(this.b);
        list2 = this.bbseq.GB(this.L);
        list = this.bbdist.GB(this.L);
        GroebnerBaseDistHybridECTest.assertTrue((String)("Gs.containsAll(Gp)" + list2 + ", " + list + ", " + this.L), (boolean)list2.containsAll(list));
        GroebnerBaseDistHybridECTest.assertTrue((String)("Gp.containsAll(Gs)" + list2 + ", " + list + ", " + this.L), (boolean)list.containsAll(list2));
        this.L = list2;
        this.L.add(this.c);
        list2 = this.bbseq.GB(this.L);
        list = this.bbdist.GB(this.L);
        GroebnerBaseDistHybridECTest.assertTrue((String)("Gs.containsAll(Gp)" + list2 + ", " + list + ", " + this.L), (boolean)list2.containsAll(list));
        GroebnerBaseDistHybridECTest.assertTrue((String)("Gp.containsAll(Gs)" + list2 + ", " + list + ", " + this.L), (boolean)list.containsAll(list2));
        this.L = list2;
        this.L.add(this.d);
        list2 = this.bbseq.GB(this.L);
        list = this.bbdist.GB(this.L);
        GroebnerBaseDistHybridECTest.assertTrue((String)("Gs.containsAll(Gp)" + list2 + ", " + list + ", " + this.L), (boolean)list2.containsAll(list));
        GroebnerBaseDistHybridECTest.assertTrue((String)("Gp.containsAll(Gs)" + list2 + ", " + list + ", " + this.L), (boolean)list.containsAll(list2));
        this.L = list2;
        this.L.add(this.e);
        list2 = this.bbseq.GB(this.L);
        list = this.bbdist.GB(this.L);
        GroebnerBaseDistHybridECTest.assertTrue((String)("Gs.containsAll(Gp)" + list2 + ", " + list + ", " + this.L), (boolean)list2.containsAll(list));
        GroebnerBaseDistHybridECTest.assertTrue((String)("Gp.containsAll(Gs)" + list2 + ", " + list + ", " + this.L), (boolean)list.containsAll(list2));
    }

    public void testTrinks7GBase() {
        List list = null;
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GroebnerBaseDistHybridECTest.fail((String)("" + iOException));
        }
        List list2 = this.bbseq.GB(this.F.list);
        list = this.bbdist.GB(this.F.list);
        GroebnerBaseDistHybridECTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbseq.isGB(list));
        GroebnerBaseDistHybridECTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbseq.isGB(list2));
        GroebnerBaseDistHybridECTest.assertTrue((String)("Gs.containsAll(Gp)" + list2 + ", " + list + ", " + this.F), (boolean)list2.containsAll(list));
        GroebnerBaseDistHybridECTest.assertTrue((String)("Gp.containsAll(Gs)" + list2 + ", " + list + ", " + this.F), (boolean)list.containsAll(list2));
    }
}

