/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TableRelation;
import edu.jas.poly.WeylRelations;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class RelationTableTest
extends TestCase {
    RelationTable<BigRational> table;
    GenSolvablePolynomialRing<BigRational> ring;
    int rl = 6;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)RelationTableTest.suite());
    }

    public RelationTableTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RelationTableTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(1L);
        this.ring = new GenSolvablePolynomialRing<BigRational>(bigRational, this.rl);
        this.table = this.ring.table;
    }

    protected void tearDown() {
        this.table = null;
        this.ring = null;
    }

    public void testConstructor() {
        this.table = new RelationTable<BigRational>(this.ring);
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        RelationTableTest.assertEquals((String)"ring == table.ring", this.ring, this.table.ring);
        String string = "RelationTable[]";
        String string2 = this.table.toString();
        RelationTableTest.assertEquals((String)"RelationTable[]", (String)string, (String)string2);
    }

    public void testUpdateOneKey() {
        this.table = this.ring.table;
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        ExpVector expVector = ExpVector.create(this.rl, 2, 1L);
        ExpVector expVector2 = ExpVector.create(this.rl, 3, 1L);
        ExpVector expVector3 = expVector.sum(expVector2);
        GenPolynomial genPolynomial = this.ring.getONE();
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 1", (int)1, (int)this.table.size());
        expVector = ExpVector.create(this.rl, 2, 2L);
        expVector2 = ExpVector.create(this.rl, 3, 1L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 2", (int)2, (int)this.table.size());
        expVector = ExpVector.create(this.rl, 2, 2L);
        expVector2 = ExpVector.create(this.rl, 3, 2L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 3", (int)3, (int)this.table.size());
        expVector = ExpVector.create(this.rl, 2, 2L);
        expVector2 = ExpVector.create(this.rl, 3, 4L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 4", (int)4, (int)this.table.size());
        expVector = ExpVector.create(this.rl, 2, 2L);
        expVector2 = ExpVector.create(this.rl, 3, 3L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 5", (int)5, (int)this.table.size());
    }

    public void testUpdateKeys() {
        this.table = this.ring.table;
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        ExpVector expVector = ExpVector.create(this.rl, 2, 1L);
        ExpVector expVector2 = ExpVector.create(this.rl, 3, 1L);
        ExpVector expVector3 = expVector.sum(expVector2);
        GenPolynomial genPolynomial = this.ring.getONE();
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 1", (int)1, (int)this.table.size());
        expVector = ExpVector.create(this.rl, 0, 1L);
        expVector2 = ExpVector.create(this.rl, 2, 1L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 2", (int)2, (int)this.table.size());
        expVector = ExpVector.create(this.rl, 2, 1L);
        expVector2 = ExpVector.create(this.rl, 4, 1L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 3", (int)3, (int)this.table.size());
    }

    public void testLookupOneKey() {
        GenSolvablePolynomial genSolvablePolynomial;
        this.table = this.ring.table;
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        ExpVector expVector = ExpVector.create(this.rl, 2, 1L);
        ExpVector expVector2 = ExpVector.create(this.rl, 3, 1L);
        ExpVector expVector3 = expVector.sum(expVector2);
        GenPolynomial genPolynomial = this.ring.getONE();
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        GenSolvablePolynomial genSolvablePolynomial2 = genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 1", (int)1, (int)this.table.size());
        TableRelation<BigRational> tableRelation = this.table.lookup(expVector, expVector2);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)tableRelation.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)tableRelation.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)genSolvablePolynomial, tableRelation.p);
        expVector = ExpVector.create(this.rl, 2, 2L);
        expVector2 = ExpVector.create(this.rl, 3, 1L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 2", (int)2, (int)this.table.size());
        tableRelation = this.table.lookup(expVector, expVector2);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)tableRelation.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)tableRelation.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)genSolvablePolynomial, tableRelation.p);
        expVector = ExpVector.create(this.rl, 2, 2L);
        expVector2 = ExpVector.create(this.rl, 3, 2L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 3", (int)3, (int)this.table.size());
        tableRelation = this.table.lookup(expVector, expVector2);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)tableRelation.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)tableRelation.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)genSolvablePolynomial, tableRelation.p);
        expVector = ExpVector.create(this.rl, 2, 2L);
        expVector2 = ExpVector.create(this.rl, 3, 4L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 4", (int)4, (int)this.table.size());
        tableRelation = this.table.lookup(expVector, expVector2);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)tableRelation.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)tableRelation.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)genSolvablePolynomial, tableRelation.p);
        expVector = ExpVector.create(this.rl, 2, 2L);
        expVector2 = ExpVector.create(this.rl, 3, 3L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 5", (int)5, (int)this.table.size());
        tableRelation = this.table.lookup(expVector, expVector2);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)tableRelation.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)tableRelation.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)genSolvablePolynomial, tableRelation.p);
        expVector = ExpVector.create(this.rl, 2, 1L);
        expVector2 = ExpVector.create(this.rl, 3, 1L);
        tableRelation = this.table.lookup(expVector, expVector2);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)tableRelation.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)tableRelation.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)genSolvablePolynomial2, tableRelation.p);
    }

    public void testLookupKeys() {
        this.table = this.ring.table;
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        ExpVector expVector = ExpVector.create(this.rl, 2, 1L);
        ExpVector expVector2 = ExpVector.create(this.rl, 3, 1L);
        ExpVector expVector3 = expVector.sum(expVector2);
        GenPolynomial genPolynomial = this.ring.getONE();
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 1", (int)1, (int)this.table.size());
        TableRelation<BigRational> tableRelation = this.table.lookup(expVector, expVector2);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)tableRelation.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)tableRelation.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)genSolvablePolynomial, tableRelation.p);
        expVector = ExpVector.create(this.rl, 0, 1L);
        expVector2 = ExpVector.create(this.rl, 2, 1L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 2", (int)2, (int)this.table.size());
        tableRelation = this.table.lookup(expVector, expVector2);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)tableRelation.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)tableRelation.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)genSolvablePolynomial, tableRelation.p);
        expVector = ExpVector.create(this.rl, 2, 1L);
        expVector2 = ExpVector.create(this.rl, 4, 1L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial2 = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial2);
        this.table.update(expVector, expVector2, (GenSolvablePolynomial<BigRational>)genSolvablePolynomial);
        RelationTableTest.assertEquals((String)"size() = 3", (int)3, (int)this.table.size());
        tableRelation = this.table.lookup(expVector, expVector2);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)tableRelation.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)tableRelation.f);
        RelationTableTest.assertEquals((String)"p = p", (Object)genSolvablePolynomial, tableRelation.p);
    }

    public void testSymmetric() {
        this.table = this.ring.table;
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        ExpVector expVector = ExpVector.create(this.rl, 2, 1L);
        ExpVector expVector2 = ExpVector.create(this.rl, 3, 1L);
        ExpVector expVector3 = expVector.sum(expVector2);
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        TableRelation<BigRational> tableRelation = this.table.lookup(expVector, expVector2);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)tableRelation.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)tableRelation.f);
        RelationTableTest.assertEquals((String)"p = b", (Object)genPolynomial, tableRelation.p);
        expVector = ExpVector.create(this.rl, 0, 1L);
        expVector2 = ExpVector.create(this.rl, 2, 1L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        tableRelation = this.table.lookup(expVector, expVector2);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)tableRelation.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)tableRelation.f);
        RelationTableTest.assertEquals((String)"p = b", (Object)genPolynomial, tableRelation.p);
        expVector = ExpVector.create(this.rl, 2, 1L);
        expVector2 = ExpVector.create(this.rl, 4, 1L);
        expVector3 = expVector.sum(expVector2);
        genPolynomial = ((GenSolvablePolynomial)this.ring.getONE()).multiply(expVector3);
        tableRelation = this.table.lookup(expVector, expVector2);
        RelationTableTest.assertEquals((String)"e = e", null, (Object)tableRelation.e);
        RelationTableTest.assertEquals((String)"f = f", null, (Object)tableRelation.f);
        RelationTableTest.assertEquals((String)"p = b", (Object)genPolynomial, tableRelation.p);
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
    }

    public void testRelationList() {
        List list = this.table.relationList();
        RelationTableTest.assertEquals((String)"list.size() = 0", (int)0, (int)list.size());
        this.table.addSolvRelations(list);
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)this.table.size());
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        list = this.table.relationList();
        RelationTableTest.assertEquals((String)"list.size() = r/2", (int)(this.rl / 2), (int)(list.size() / 3));
        GenSolvablePolynomialRing genSolvablePolynomialRing = new GenSolvablePolynomialRing(this.ring.coFac, this.ring);
        RelationTableTest.assertEquals((String)"size() = 0", (int)0, (int)genSolvablePolynomialRing.table.size());
        genSolvablePolynomialRing.table.addSolvRelations(list);
        RelationTableTest.assertEquals((String)"size() = r/2", (int)(this.rl / 2), (int)genSolvablePolynomialRing.table.size());
        RelationTableTest.assertEquals((String)"rel1 == rel2: ", this.ring.table, genSolvablePolynomialRing.table);
    }
}

