/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.AlgebraElem;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenMatrixTest
extends TestCase {
    int rl = 5;
    int kl = 10;
    int ll = 10;
    float q = 0.5f;
    int rows = 3;
    int cols = 3;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GenMatrixTest.suite());
    }

    public GenMatrixTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GenMatrixTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testPolynomialConstruction() {
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(genPolynomialRing, this.rows, this.cols);
        GenMatrixTest.assertTrue((String)("#rows = " + this.rows), (genMatrixRing.rows == this.rows ? 1 : 0) != 0);
        GenMatrixTest.assertTrue((String)("#columns = " + this.cols), (genMatrixRing.cols == this.cols ? 1 : 0) != 0);
        GenMatrixTest.assertTrue((String)"pfac == coFac ", (genPolynomialRing == genMatrixRing.coFac ? 1 : 0) != 0);
        AbelianGroupElem abelianGroupElem = genMatrixRing.getZERO();
        GenMatrixTest.assertTrue((String)"isZERO( a )", (boolean)((GenMatrix)abelianGroupElem).isZERO());
        GenMatrix<BigRational> genMatrix = new GenMatrix<BigRational>(genMatrixRing);
        GenMatrixTest.assertTrue((String)"isZERO( b )", (boolean)genMatrix.isZERO());
        GenMatrixTest.assertTrue((String)"a == b ", (boolean)((GenMatrix)abelianGroupElem).equals(genMatrix));
        Element element = genMatrix.copy();
        GenMatrixTest.assertTrue((String)"isZERO( c )", (boolean)((GenMatrix)element).isZERO());
        GenMatrixTest.assertTrue((String)"a == c ", (boolean)((GenMatrix)abelianGroupElem).equals(element));
        GenMatrix<BigRational> genMatrix2 = genMatrixRing.copy(genMatrix);
        GenMatrixTest.assertTrue((String)"isZERO( d )", (boolean)genMatrix2.isZERO());
        GenMatrixTest.assertTrue((String)"a == d ", (boolean)((GenMatrix)abelianGroupElem).equals(genMatrix2));
    }

    public void testPolynomialRandom() {
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(genPolynomialRing, this.rows, this.cols);
        for (int i = 0; i < 5; ++i) {
            AlgebraElem algebraElem = genMatrixRing.random(this.kl, this.q);
            if (((GenMatrix)algebraElem).isZERO()) continue;
            GenMatrixTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!((GenMatrix)algebraElem).isZERO() ? 1 : 0) != 0);
        }
    }

    public void testPolynomialAddition() {
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(genPolynomialRing, this.rows, this.cols);
        AlgebraElem algebraElem = genMatrixRing.random(this.kl, this.q);
        AlgebraElem algebraElem2 = genMatrixRing.random(this.kl, this.q);
        AlgebraElem algebraElem3 = ((GenMatrix)algebraElem).sum(algebraElem2);
        GenMatrix genMatrix = algebraElem3.subtract(algebraElem2);
        GenMatrixTest.assertEquals((String)"a+b-b = a", (Object)algebraElem, genMatrix);
        algebraElem3 = ((GenMatrix)algebraElem).sum(algebraElem2);
        genMatrix = algebraElem3.sum(((GenMatrix)algebraElem2).negate());
        GenMatrixTest.assertEquals((String)"a+b+(-b) = a", (Object)algebraElem, genMatrix);
        algebraElem3 = ((GenMatrix)algebraElem).sum(algebraElem2);
        genMatrix = ((GenMatrix)algebraElem2).sum(algebraElem);
        GenMatrixTest.assertEquals((String)"a+b = b+a", algebraElem3, genMatrix);
        algebraElem3 = genMatrixRing.random(this.kl, this.q);
        genMatrix = ((GenMatrix)algebraElem).sum(algebraElem2).sum(algebraElem3);
        GenMatrix genMatrix2 = ((GenMatrix)algebraElem).sum(((GenMatrix)algebraElem2).sum(algebraElem3));
        GenMatrixTest.assertEquals((String)"a+(b+c) = (a+b)+c", genMatrix, genMatrix2);
    }

    public void testPolynomialMultiplication() {
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(genPolynomialRing, this.rows, this.cols);
        Element element = genPolynomialRing.random(this.kl);
        AbelianGroupElem abelianGroupElem = ((GenPolynomial)element).negate();
        AlgebraElem algebraElem = genMatrixRing.random(this.kl, this.q);
        GenMatrix<MonoidElem> genMatrix = ((GenMatrix)algebraElem).scalarMultiply((RingElem)element);
        GenMatrix genMatrix2 = ((GenMatrix)algebraElem).scalarMultiply((RingElem)abelianGroupElem);
        GenMatrix genMatrix3 = genMatrix.sum(genMatrix2);
        GenMatrixTest.assertEquals((String)"a*b + a*(-b) = 0", genMatrix3, (Object)genMatrixRing.getZERO());
        AlgebraElem algebraElem2 = genMatrixRing.random(this.kl, this.q);
        Element element2 = genPolynomialRing.getONE();
        genMatrix = ((GenMatrix)algebraElem).linearCombination(algebraElem2, element2);
        genMatrix2 = ((GenMatrix)algebraElem2).linearCombination(algebraElem, element2);
        GenMatrixTest.assertEquals((String)"a+1*b = b+1*a", genMatrix, genMatrix2);
        genMatrix = ((GenMatrix)algebraElem).linearCombination(algebraElem2, element2);
        genMatrix2 = ((GenMatrix)algebraElem).sum(algebraElem2);
        GenMatrixTest.assertEquals((String)"a+1*b = b+1*a", genMatrix, genMatrix2);
        abelianGroupElem = ((GenPolynomial)element2).negate();
        genMatrix = ((GenMatrix)algebraElem).linearCombination(algebraElem2, element2);
        genMatrix2 = genMatrix.linearCombination((GenMatrix<MonoidElem>)algebraElem2, (MonoidElem)((Object)abelianGroupElem));
        GenMatrixTest.assertEquals((String)"a+1*b+(-1)*b = a", (Object)algebraElem, genMatrix2);
        genMatrix = ((GenMatrix)algebraElem).linearCombination(element2, algebraElem2, element2);
        genMatrix2 = genMatrix.linearCombination((MonoidElem)element2, (GenMatrix<MonoidElem>)algebraElem2, (MonoidElem)((Object)abelianGroupElem));
        GenMatrixTest.assertEquals((String)"a+1*b+(-1)*b = a", (Object)algebraElem, genMatrix2);
        element2 = genPolynomialRing.getZERO();
        genMatrix = ((GenMatrix)algebraElem).linearCombination(algebraElem2, element2);
        GenMatrixTest.assertEquals((String)"a+0*b = a", (Object)algebraElem, genMatrix);
        genMatrix2 = ((GenMatrix)algebraElem).linearCombination(element2, algebraElem2, element2);
        GenMatrixTest.assertEquals((String)"0*a+0*b = 0", (Object)genMatrixRing.getZERO(), genMatrix2);
    }
}

