/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.HybridReducerClient;
import edu.jas.gb.HybridReducerServer;
import edu.jas.gb.MiReducerServer;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.DistHashTableServer;
import edu.jas.util.SocketChannel;
import edu.jas.util.TaggedSocketChannel;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

@Deprecated
public class GroebnerBaseDistributedHybrid<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    public static final Logger logger = Logger.getLogger(GroebnerBaseDistributedHybrid.class);
    public final boolean debug = logger.isDebugEnabled();
    protected final int threads;
    protected static final int DEFAULT_THREADS = 2;
    protected final int threadsPerNode;
    protected static final int DEFAULT_THREADS_PER_NODE = 1;
    protected final transient ThreadPool pool;
    protected static final int DEFAULT_PORT = 4711;
    protected final int port;
    public static final Integer pairTag = 1;
    public static final Integer resultTag = 2;
    public static final Integer ackTag = 3;

    public GroebnerBaseDistributedHybrid() {
        this(2, 4711);
    }

    public GroebnerBaseDistributedHybrid(int n) {
        this(n, new ThreadPool(n), 4711);
    }

    public GroebnerBaseDistributedHybrid(int n, int n2) {
        this(n, new ThreadPool(n), n2);
    }

    public GroebnerBaseDistributedHybrid(int n, int n2, int n3) {
        this(n, n2, new ThreadPool(n), n3);
    }

    public GroebnerBaseDistributedHybrid(int n, ThreadPool threadPool, int n2) {
        this(n, 1, threadPool, n2);
    }

    public GroebnerBaseDistributedHybrid(int n, int n2, PairList<C> pairList, int n3) {
        this(n, n2, new ThreadPool(n), pairList, n3);
    }

    public GroebnerBaseDistributedHybrid(int n, int n2, ThreadPool threadPool, int n3) {
        this(n, n2, threadPool, new OrderedPairlist(), n3);
    }

    public GroebnerBaseDistributedHybrid(int n, int n2, ThreadPool threadPool, PairList<C> pairList, int n3) {
        super(new ReductionPar(), pairList);
        if (n < 1) {
            n = 1;
        }
        this.threads = n;
        this.threadsPerNode = n2;
        this.pool = threadPool;
        this.port = n3;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.terminate();
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        int n2;
        GenPolynomial genPolynomial;
        long l = System.currentTimeMillis();
        int n3 = this.port + 100;
        ChannelFactory channelFactory = new ChannelFactory(this.port);
        channelFactory.init();
        DistHashTableServer distHashTableServer = new DistHashTableServer(n3);
        distHashTableServer.init();
        logger.debug((Object)"dist-list server running");
        List<Object> list2 = new ArrayList<GenPolynomial<C>>();
        PairList<C> pairList = null;
        boolean bl = false;
        ListIterator<GenPolynomial<C>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            int n4;
            GenPolynomial<C> genPolynomial2 = listIterator.next();
            if (genPolynomial2.length() <= 0) continue;
            if ((genPolynomial2 = genPolynomial2.monic()).isONE()) {
                bl = true;
                list2.clear();
                list2.add(genPolynomial2);
            }
            if (!bl) {
                list2.add(genPolynomial2);
            }
            if (pairList == null) {
                pairList = this.strategy.create(n, genPolynomial2.ring);
                if (!genPolynomial2.ring.coFac.isField()) {
                    throw new IllegalArgumentException("coefficients not from a field");
                }
            }
            if (genPolynomial2.isONE()) {
                n4 = pairList.putOne();
                continue;
            }
            n4 = pairList.put(genPolynomial2);
        }
        logger.info((Object)("pairlist " + pairList));
        logger.debug((Object)"looking for clients");
        DistHashTable distHashTable = new DistHashTable("localhost", n3);
        distHashTable.init();
        List list3 = pairList.getList();
        for (int i = 0; i < list3.size(); ++i) {
            genPolynomial = distHashTable.put(i, list3.get(i));
            if (genPolynomial == null) continue;
            logger.info((Object)("double polynomials " + i + ", nn = " + genPolynomial + ", al(i) = " + list3.get(i)));
        }
        Terminator terminator = new Terminator(this.threads * this.threadsPerNode);
        logger.info((Object)("using pool = " + this.pool));
        for (n2 = 0; n2 < this.threads; ++n2) {
            genPolynomial = new HybridReducerServer(this.threadsPerNode, terminator, channelFactory, distHashTable, pairList);
            this.pool.addJob((Runnable)((Object)genPolynomial));
        }
        logger.info((Object)("main loop waiting " + terminator));
        terminator.waitDone();
        n2 = distHashTable.size();
        logger.info((Object)("#distributed list = " + n2));
        list2 = pairList.getList();
        if (n2 != list2.size()) {
            logger.info((Object)("#distributed list = " + distHashTable.size() + " #pairlist list = " + list2.size()));
        }
        for (GenPolynomial genPolynomial3 : distHashTable.getValueList()) {
            if (genPolynomial3 == null || genPolynomial3.isZERO()) continue;
            logger.debug((Object)("final q = " + genPolynomial3.leadingExpVector()));
        }
        logger.debug((Object)"distributed list end");
        long l2 = System.currentTimeMillis();
        List<GenPolynomial<C>> list4 = this.minimalGB(list2);
        l2 = System.currentTimeMillis() - l2;
        logger.info((Object)("parallel gbmi time = " + l2));
        list2 = list4;
        logger.debug((Object)"server cf.terminate()");
        channelFactory.terminate();
        logger.info((Object)("server not pool.terminate() " + this.pool));
        logger.info((Object)("server theList.terminate() " + distHashTable.size()));
        distHashTable.terminate();
        logger.info((Object)("server dls.terminate() " + distHashTableServer));
        distHashTableServer.terminate();
        l = System.currentTimeMillis() - l;
        logger.info((Object)("server GB end, time = " + l + ", " + pairList.toString()));
        return list2;
    }

    public void clientPart(String string) throws IOException {
        ChannelFactory channelFactory = new ChannelFactory(this.port + 10);
        channelFactory.init();
        SocketChannel socketChannel = channelFactory.getChannel(string, this.port);
        TaggedSocketChannel taggedSocketChannel = new TaggedSocketChannel(socketChannel);
        taggedSocketChannel.init();
        if (this.debug) {
            logger.info((Object)("clientPart pairChannel   = " + taggedSocketChannel));
        }
        int n = this.port + 100;
        DistHashTable distHashTable = new DistHashTable(string, n);
        distHashTable.init();
        ThreadPool threadPool = new ThreadPool(this.threadsPerNode);
        logger.info((Object)("client using pool = " + threadPool));
        for (int i = 0; i < this.threadsPerNode; ++i) {
            HybridReducerClient hybridReducerClient = new HybridReducerClient(this.threadsPerNode, taggedSocketChannel, i, distHashTable);
            threadPool.addJob(hybridReducerClient);
        }
        if (this.debug) {
            logger.info((Object)"clients submitted");
        }
        threadPool.terminate();
        logger.info((Object)"client pool.terminate()");
        taggedSocketChannel.close();
        logger.info((Object)"client pairChannel.close()");
        distHashTable.terminate();
        channelFactory.terminate();
        logger.info((Object)"client cf.terminate()");
        socketChannel.close();
        logger.info((Object)"client channel.close()");
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> list) {
        GenPolynomial<C> genPolynomial;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        ListIterator<GenPolynomial<Object>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            genPolynomial = listIterator.next();
            if (genPolynomial.length() == 0) continue;
            arrayList.add(genPolynomial);
        }
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(arrayList.size());
        while (arrayList.size() > 0) {
            ExpVector expVector;
            GenPolynomial<Object> genPolynomial2;
            genPolynomial = arrayList.remove(0);
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            if (bl) continue;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        Collections.reverse(arrayList);
        MiReducerServer[] miReducerServerArray = new MiReducerServer[arrayList.size()];
        int n = 0;
        arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            genPolynomial = arrayList.remove(0);
            ArrayList arrayList3 = new ArrayList(arrayList.size() + arrayList2.size());
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
            miReducerServerArray[n] = new MiReducerServer(arrayList3, genPolynomial);
            this.pool.addJob(miReducerServerArray[n]);
            ++n;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList(arrayList.size());
        for (n = 0; n < miReducerServerArray.length; ++n) {
            genPolynomial = miReducerServerArray[n].getNF();
            arrayList2.add(genPolynomial);
        }
        return arrayList2;
    }
}

