/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.gb.OrderedMinPairlist;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.OrderedSyzPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.SGBProxy;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseParallel;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.SolvableGroebnerBasePseudoRecSeq;
import edu.jas.gbufd.SolvableGroebnerBasePseudoSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import edu.jas.structure.ValueFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import org.apache.log4j.Logger;

public class SGBFactory {
    private static final Logger logger = Logger.getLogger(SGBFactory.class);

    protected SGBFactory() {
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<C> getImplementation() {
        logger.warn((Object)"no coefficent factory given, assuming field coeffcients");
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        return solvableGroebnerBaseSeq;
    }

    public static SolvableGroebnerBaseAbstract<ModLong> getImplementation(ModLongRing modLongRing) {
        return SGBFactory.getImplementation(modLongRing, new OrderedPairlist<ModLong>());
    }

    public static SolvableGroebnerBaseAbstract<ModLong> getImplementation(ModLongRing modLongRing, PairList<ModLong> pairList) {
        SolvableGroebnerBaseAbstract solvableGroebnerBaseAbstract = modLongRing.isField() ? new SolvableGroebnerBaseSeq<ModLong>(pairList) : new SolvableGroebnerBasePseudoSeq<ModLong>(modLongRing, pairList);
        return solvableGroebnerBaseAbstract;
    }

    public static SolvableGroebnerBaseAbstract<ModInteger> getImplementation(ModIntegerRing modIntegerRing) {
        return SGBFactory.getImplementation(modIntegerRing, new OrderedPairlist<ModInteger>());
    }

    public static SolvableGroebnerBaseAbstract<ModInteger> getImplementation(ModIntegerRing modIntegerRing, PairList<ModInteger> pairList) {
        SolvableGroebnerBaseAbstract solvableGroebnerBaseAbstract = modIntegerRing.isField() ? new SolvableGroebnerBaseSeq<ModInteger>(pairList) : new SolvableGroebnerBasePseudoSeq<ModInteger>(modIntegerRing, pairList);
        return solvableGroebnerBaseAbstract;
    }

    public static SolvableGroebnerBaseAbstract<BigInteger> getImplementation(BigInteger bigInteger) {
        return SGBFactory.getImplementation(bigInteger, GBFactory.Algo.igb);
    }

    public static SolvableGroebnerBaseAbstract<BigInteger> getImplementation(BigInteger bigInteger, GBFactory.Algo algo) {
        return SGBFactory.getImplementation(bigInteger, algo, new OrderedPairlist<BigInteger>());
    }

    public static SolvableGroebnerBaseAbstract<BigInteger> getImplementation(BigInteger bigInteger, PairList<BigInteger> pairList) {
        return SGBFactory.getImplementation(bigInteger, GBFactory.Algo.igb, pairList);
    }

    public static SolvableGroebnerBaseAbstract<BigInteger> getImplementation(BigInteger bigInteger, GBFactory.Algo algo, PairList<BigInteger> pairList) {
        SolvableGroebnerBasePseudoSeq<BigInteger> solvableGroebnerBasePseudoSeq;
        switch (algo) {
            case igb: {
                solvableGroebnerBasePseudoSeq = new SolvableGroebnerBasePseudoSeq<BigInteger>(bigInteger, pairList);
                break;
            }
            case egb: {
                throw new UnsupportedOperationException("egb algorithm not available for BigInteger " + (Object)((Object)algo));
            }
            case dgb: {
                throw new UnsupportedOperationException("dgb algorithm not available for BigInteger " + (Object)((Object)algo));
            }
            default: {
                throw new IllegalArgumentException("algorithm not available for BigInteger " + (Object)((Object)algo));
            }
        }
        return solvableGroebnerBasePseudoSeq;
    }

    public static SolvableGroebnerBaseAbstract<BigRational> getImplementation(BigRational bigRational) {
        return SGBFactory.getImplementation(bigRational, GBFactory.Algo.qgb);
    }

    public static SolvableGroebnerBaseAbstract<BigRational> getImplementation(BigRational bigRational, GBFactory.Algo algo) {
        return SGBFactory.getImplementation(bigRational, algo, new OrderedPairlist<BigRational>());
    }

    public static SolvableGroebnerBaseAbstract<BigRational> getImplementation(BigRational bigRational, PairList<BigRational> pairList) {
        return SGBFactory.getImplementation(bigRational, GBFactory.Algo.qgb, pairList);
    }

    public static SolvableGroebnerBaseAbstract<BigRational> getImplementation(BigRational bigRational, GBFactory.Algo algo, PairList<BigRational> pairList) {
        SolvableGroebnerBaseSeq<BigRational> solvableGroebnerBaseSeq;
        switch (algo) {
            case qgb: {
                solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq<BigRational>(pairList);
                break;
            }
            case ffgb: {
                throw new UnsupportedOperationException("ffgb algorithm not available for BigRational " + (Object)((Object)algo));
            }
            default: {
                throw new IllegalArgumentException("algorithm not available for " + bigRational.toScriptFactory() + ", Algo = " + (Object)((Object)algo));
            }
        }
        return solvableGroebnerBaseSeq;
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<Quotient<C>> getImplementation(QuotientRing<C> quotientRing) {
        return SGBFactory.getImplementation(quotientRing, GBFactory.Algo.qgb);
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<Quotient<C>> getImplementation(QuotientRing<C> quotientRing, GBFactory.Algo algo) {
        return SGBFactory.getImplementation(quotientRing, algo, new OrderedPairlist<Quotient<C>>());
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<Quotient<C>> getImplementation(QuotientRing<C> quotientRing, PairList<Quotient<C>> pairList) {
        return SGBFactory.getImplementation(quotientRing, GBFactory.Algo.qgb, pairList);
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<Quotient<C>> getImplementation(QuotientRing<C> quotientRing, GBFactory.Algo algo, PairList<Quotient<C>> pairList) {
        SolvableGroebnerBaseSeq<Quotient<C>> solvableGroebnerBaseSeq;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("QuotientRing, fac = " + quotientRing));
        }
        switch (algo) {
            case qgb: {
                solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq<Quotient<C>>(new SolvableReductionSeq(), pairList);
                break;
            }
            case ffgb: {
                throw new UnsupportedOperationException("ffgb algorithm not available for " + (Object)((Object)algo));
            }
            default: {
                throw new IllegalArgumentException("algorithm not available for Quotient " + (Object)((Object)algo));
            }
        }
        return solvableGroebnerBaseSeq;
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> genPolynomialRing) {
        return SGBFactory.getImplementation(genPolynomialRing, GBFactory.Algo.igb);
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> genPolynomialRing, GBFactory.Algo algo) {
        return SGBFactory.getImplementation(genPolynomialRing, algo, new OrderedPairlist<GenPolynomial<C>>());
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> genPolynomialRing, PairList<GenPolynomial<C>> pairList) {
        return SGBFactory.getImplementation(genPolynomialRing, GBFactory.Algo.igb, pairList);
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> genPolynomialRing, GBFactory.Algo algo, PairList<GenPolynomial<C>> pairList) {
        SolvableGroebnerBasePseudoRecSeq<C> solvableGroebnerBasePseudoRecSeq;
        switch (algo) {
            case igb: {
                solvableGroebnerBasePseudoRecSeq = new SolvableGroebnerBasePseudoRecSeq<C>(genPolynomialRing, pairList);
                break;
            }
            case egb: {
                throw new UnsupportedOperationException("egb algorithm not available for " + (Object)((Object)algo));
            }
            case dgb: {
                throw new UnsupportedOperationException("dgb algorithm not available for " + (Object)((Object)algo));
            }
            default: {
                throw new IllegalArgumentException("algorithm not available for GenPolynomial<C> " + (Object)((Object)algo));
            }
        }
        return solvableGroebnerBasePseudoRecSeq;
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<C> getImplementation(RingFactory<C> ringFactory) {
        return SGBFactory.getImplementation(ringFactory, new OrderedPairlist());
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<C> getImplementation(RingFactory<C> ringFactory, PairList<C> pairList) {
        logger.info((Object)("fac = " + ringFactory.getClass().getName()));
        if (ringFactory.isField()) {
            return new SolvableGroebnerBaseSeq<C>(pairList);
        }
        if (ringFactory instanceof ValueFactory) {
            return new SolvableGroebnerBasePseudoSeq<C>(ringFactory, pairList);
        }
        if (ringFactory instanceof QuotPairFactory) {
            return new SolvableGroebnerBaseSeq<C>(pairList);
        }
        SolvableGroebnerBaseAbstract solvableGroebnerBaseAbstract = null;
        RingFactory<C> ringFactory2 = ringFactory;
        if (ringFactory2 instanceof GenPolynomialRing) {
            OrderedPairlist orderedPairlist = pairList instanceof OrderedMinPairlist ? new OrderedMinPairlist() : (pairList instanceof OrderedSyzPairlist ? new OrderedSyzPairlist() : new OrderedPairlist());
            GenPolynomialRing genPolynomialRing = (GenPolynomialRing)ringFactory2;
            SolvableGroebnerBasePseudoRecSeq solvableGroebnerBasePseudoRecSeq = new SolvableGroebnerBasePseudoRecSeq(genPolynomialRing, orderedPairlist);
            solvableGroebnerBaseAbstract = solvableGroebnerBasePseudoRecSeq;
        } else {
            solvableGroebnerBaseAbstract = new SolvableGroebnerBasePseudoSeq<C>(ringFactory, pairList);
        }
        logger.info((Object)("bba = " + solvableGroebnerBaseAbstract.getClass().getName()));
        return solvableGroebnerBaseAbstract;
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<C> getProxy(RingFactory<C> ringFactory) {
        return SGBFactory.getProxy(ringFactory, new OrderedPairlist());
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<C> getProxy(RingFactory<C> ringFactory, PairList<C> pairList) {
        int n;
        if (ComputerThreads.NO_THREADS) {
            return SGBFactory.getImplementation(ringFactory, pairList);
        }
        logger.info((Object)("proxy fac = " + ringFactory.getClass().getName()));
        int n2 = n = ComputerThreads.N_CPUS > 2 ? ComputerThreads.N_CPUS - 1 : 2;
        if (ringFactory.isField()) {
            SolvableGroebnerBaseSeq<C> solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq<C>(pairList);
            SolvableGroebnerBaseParallel<C> solvableGroebnerBaseParallel = new SolvableGroebnerBaseParallel<C>(n, pairList);
            return new SGBProxy<C>(solvableGroebnerBaseSeq, solvableGroebnerBaseParallel);
        }
        if (ringFactory.characteristic().signum() == 0) {
            if (ringFactory instanceof GenPolynomialRing) {
                GenPolynomialRing genPolynomialRing = (GenPolynomialRing)ringFactory;
                OrderedPairlist orderedPairlist = new OrderedPairlist();
                SolvableGroebnerBasePseudoRecSeq solvableGroebnerBasePseudoRecSeq = new SolvableGroebnerBasePseudoRecSeq(genPolynomialRing, orderedPairlist);
                logger.warn((Object)"no parallel version available, returning sequential version");
                return solvableGroebnerBasePseudoRecSeq;
            }
            SolvableGroebnerBasePseudoSeq<C> solvableGroebnerBasePseudoSeq = new SolvableGroebnerBasePseudoSeq<C>(ringFactory, pairList);
            logger.warn((Object)"no parallel version available, returning sequential version");
            return solvableGroebnerBasePseudoSeq;
        }
        return SGBFactory.getImplementation(ringFactory, pairList);
    }

    public static <C extends GcdRingElem<C>> SolvableGroebnerBaseAbstract<GenPolynomial<C>> getProxy(GenPolynomialRing<C> genPolynomialRing) {
        if (ComputerThreads.NO_THREADS) {
            return SGBFactory.getImplementation(genPolynomialRing);
        }
        logger.info((Object)("fac = " + genPolynomialRing.getClass().getName()));
        OrderedPairlist orderedPairlist = new OrderedPairlist();
        SolvableGroebnerBasePseudoRecSeq solvableGroebnerBasePseudoRecSeq = new SolvableGroebnerBasePseudoRecSeq(genPolynomialRing, orderedPairlist);
        logger.warn((Object)"no parallel version available, returning sequential version");
        return solvableGroebnerBasePseudoRecSeq;
    }
}

