/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.CartesianOneProductInfiniteIterator;
import edu.jas.util.CartesianTwoProductInfiniteIteratorList;
import java.util.Iterator;
import java.util.List;

public class CartesianProductInfinite<E>
implements Iterable<List<E>> {
    public final List<Iterable<E>> comps;

    public CartesianProductInfinite(List<Iterable<E>> list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("null components not allowed");
        }
        this.comps = list;
    }

    @Override
    public Iterator<List<E>> iterator() {
        if (this.comps.size() == 1) {
            return new CartesianOneProductInfiniteIterator<E>(this.comps.get(0));
        }
        int n = this.comps.size();
        int n2 = n / 2 + n % 2;
        CartesianProductInfinite<E> cartesianProductInfinite = new CartesianProductInfinite<E>(this.comps.subList(0, n2));
        CartesianProductInfinite<E> cartesianProductInfinite2 = new CartesianProductInfinite<E>(this.comps.subList(n2, n));
        return new CartesianTwoProductInfiniteIteratorList(cartesianProductInfinite, cartesianProductInfinite2);
    }
}

