/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.arith.BigRational;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.ModulElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenVectorTest
extends TestCase {
    int rl = 5;
    int kl = 10;
    int ll = 10;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GenVectorTest.suite());
    }

    public GenVectorTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GenVectorTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testConstruction() {
        BigRational bigRational = new BigRational(1L);
        GenVectorModul<BigRational> genVectorModul = new GenVectorModul<BigRational>(bigRational, this.ll);
        GenVectorTest.assertTrue((String)("#columns = " + this.ll), (genVectorModul.cols == this.ll ? 1 : 0) != 0);
        GenVectorTest.assertTrue((String)"cfac == coFac ", (bigRational == genVectorModul.coFac ? 1 : 0) != 0);
        AbelianGroupElem abelianGroupElem = genVectorModul.getZERO();
        GenVectorTest.assertTrue((String)"isZERO( a )", (boolean)((GenVector)abelianGroupElem).isZERO());
        GenVector<BigRational> genVector = new GenVector<BigRational>(genVectorModul);
        GenVectorTest.assertTrue((String)"isZERO( b )", (boolean)genVector.isZERO());
        GenVectorTest.assertTrue((String)"a == b ", (boolean)((GenVector)abelianGroupElem).equals(genVector));
        Element element = genVector.copy();
        GenVectorTest.assertTrue((String)"isZERO( c )", (boolean)((GenVector)element).isZERO());
        GenVectorTest.assertTrue((String)"a == c ", (boolean)((GenVector)abelianGroupElem).equals(element));
        GenVector<BigRational> genVector2 = genVectorModul.copy(genVector);
        GenVectorTest.assertTrue((String)"isZERO( d )", (boolean)genVector2.isZERO());
        GenVectorTest.assertTrue((String)"a == d ", (boolean)((GenVector)abelianGroupElem).equals(genVector2));
    }

    public void testRandom() {
        BigRational bigRational = new BigRational(1L);
        GenVectorModul<BigRational> genVectorModul = new GenVectorModul<BigRational>(bigRational, this.ll);
        for (int i = 0; i < 7; ++i) {
            ModulElem modulElem = genVectorModul.random(this.kl, this.q);
            if (((GenVector)modulElem).isZERO()) continue;
            GenVectorTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!((GenVector)modulElem).isZERO() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        BigRational bigRational = new BigRational(1L);
        GenVectorModul<BigRational> genVectorModul = new GenVectorModul<BigRational>(bigRational, this.ll);
        ModulElem modulElem = genVectorModul.random(this.kl, this.q);
        ModulElem modulElem2 = genVectorModul.random(this.kl, this.q);
        ModulElem modulElem3 = ((GenVector)modulElem).sum(modulElem2);
        GenVector genVector = modulElem3.subtract(modulElem2);
        GenVectorTest.assertEquals((String)"a+b-b = a", (Object)modulElem, genVector);
        modulElem3 = ((GenVector)modulElem).sum(modulElem2);
        genVector = modulElem3.sum(((GenVector)modulElem2).negate());
        GenVectorTest.assertEquals((String)"a+b+(-b) = a", (Object)modulElem, genVector);
        modulElem3 = ((GenVector)modulElem).sum(modulElem2);
        genVector = ((GenVector)modulElem2).sum(modulElem);
        GenVectorTest.assertEquals((String)"a+b = b+a", modulElem3, genVector);
        modulElem3 = genVectorModul.random(this.kl, this.q);
        genVector = ((GenVector)modulElem).sum(modulElem2).sum(modulElem3);
        GenVector genVector2 = ((GenVector)modulElem).sum(((GenVector)modulElem2).sum(modulElem3));
        GenVectorTest.assertEquals((String)"a+(b+c) = (a+b)+c", genVector, genVector2);
    }

    public void testMultiplication() {
        BigRational bigRational = new BigRational(1L);
        GenVectorModul<BigRational> genVectorModul = new GenVectorModul<BigRational>(bigRational, this.ll);
        BigRational bigRational2 = bigRational.random(this.kl);
        if (bigRational2.isZERO()) {
            bigRational2 = bigRational.getONE();
        }
        BigRational bigRational3 = bigRational2.inverse();
        ModulElem modulElem = genVectorModul.random(this.kl, this.q);
        GenVector<BigRational> genVector = ((GenVector)modulElem).scalarMultiply(bigRational2);
        GenVector<BigRational> genVector2 = genVector.scalarMultiply((RingElem)bigRational3);
        GenVectorTest.assertEquals((String)("a*b*(1/b) = a " + bigRational2), (Object)modulElem, (Object)genVector2);
        ModulElem modulElem2 = genVectorModul.random(this.kl, this.q);
        BigRational bigRational4 = bigRational.getONE();
        genVector = ((GenVector)modulElem).linearCombination(modulElem2, bigRational4);
        genVector2 = ((GenVector)modulElem2).linearCombination(modulElem, bigRational4);
        GenVectorTest.assertEquals((String)"a+1*b = b+1*a", genVector, genVector2);
        genVector = ((GenVector)modulElem).linearCombination(modulElem2, bigRational4);
        genVector2 = ((GenVector)modulElem).sum(modulElem2);
        GenVectorTest.assertEquals((String)"a+1*b = b+1*a", genVector, genVector2);
        bigRational3 = bigRational4.negate();
        genVector = ((GenVector)modulElem).linearCombination(modulElem2, bigRational4);
        genVector2 = genVector.linearCombination((GenVector<BigRational>)modulElem2, bigRational3);
        GenVectorTest.assertEquals((String)"a+1*b+(-1)*b = a", (Object)modulElem, genVector2);
        genVector = ((GenVector)modulElem).linearCombination(bigRational4, modulElem2, bigRational4);
        genVector2 = genVector.linearCombination(bigRational4, (GenVector<BigRational>)modulElem2, bigRational3);
        GenVectorTest.assertEquals((String)"a*1+b*1+b*(-1) = a", (Object)modulElem, genVector2);
        bigRational4 = bigRational.getZERO();
        genVector = ((GenVector)modulElem).linearCombination(modulElem2, bigRational4);
        GenVectorTest.assertEquals((String)"a+0*b = a", (Object)modulElem, genVector);
        genVector2 = ((GenVector)modulElem).linearCombination(bigRational4, modulElem2, bigRational4);
        GenVectorTest.assertEquals((String)"0*a+0*b = 0", (Object)genVectorModul.getZERO(), genVector2);
        bigRational2 = (BigRational)((GenVector)modulElem).scalarProduct(modulElem2);
        bigRational3 = (BigRational)((GenVector)modulElem2).scalarProduct(modulElem);
        GenVectorTest.assertEquals((String)"a.b = b.a", (Object)bigRational2, (Object)bigRational3);
    }

    public void testParse() {
        BigRational bigRational = new BigRational(1L);
        GenVectorModul<BigRational> genVectorModul = new GenVectorModul<BigRational>(bigRational, this.ll);
        ModulElem modulElem = genVectorModul.random(this.kl, this.q);
        if (!((GenVector)modulElem).isZERO()) {
            GenVectorTest.assertTrue((String)" not isZERO( a )", (!((GenVector)modulElem).isZERO() ? 1 : 0) != 0);
        }
        String string = ((GenVector)modulElem).toString();
        Element element = genVectorModul.parse(string);
        GenVectorTest.assertEquals((String)"parse(toStirng(a) == a ", (Object)modulElem, (Object)element);
    }
}

