/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.NGClientListener;
import com.martiansoftware.nailgun.NGHeartbeatListener;
import com.martiansoftware.nailgun.NGInputStream;
import com.martiansoftware.nailgun.NGServer;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Properties;

public class NGContext {
    private Properties remoteEnvironment = null;
    private InetAddress remoteHost = null;
    private int remotePort = 0;
    private String[] args = null;
    private PrintStream exitStream = null;
    private NGServer server = null;
    private String command = null;
    private String workingDirectory = null;
    public InputStream in = null;
    public PrintStream out = null;
    public PrintStream err = null;

    public void setExitStream(PrintStream exitStream) {
        this.exitStream = exitStream;
    }

    public void setPort(int remotePort) {
        this.remotePort = remotePort;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    void setEnv(Properties remoteEnvironment) {
        this.remoteEnvironment = remoteEnvironment;
    }

    void setInetAddress(InetAddress remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    void setNGServer(NGServer server) {
        this.server = server;
    }

    public Properties getEnv() {
        return this.remoteEnvironment;
    }

    public String getFileSeparator() {
        return this.remoteEnvironment.getProperty("NAILGUN_FILESEPARATOR");
    }

    public String getPathSeparator() {
        return this.remoteEnvironment.getProperty("NAILGUN_PATHSEPARATOR");
    }

    public InetAddress getInetAddress() {
        return this.remoteHost;
    }

    public String[] getArgs() {
        return this.args;
    }

    public NGServer getNGServer() {
        return this.server;
    }

    public void exit(int exitCode) {
        this.exitStream.println(exitCode);
    }

    public int getPort() {
        return this.remotePort;
    }

    public void assertLoopbackClient() {
        if (!this.getInetAddress().isLoopbackAddress()) {
            throw new SecurityException("Client is not at loopback address.");
        }
    }

    public void assertLocalClient() {
        NetworkInterface iface = null;
        try {
            iface = NetworkInterface.getByInetAddress(this.getInetAddress());
        }
        catch (SocketException se) {
            throw new SecurityException("Unable to determine if client is local.  Assuming he isn't.");
        }
        if (iface == null && !this.getInetAddress().isLoopbackAddress()) {
            throw new SecurityException("Client is not local.");
        }
    }

    private NGInputStream getInputStream() {
        return (NGInputStream)this.in;
    }

    public boolean isClientConnected() {
        return this.getInputStream().isClientConnected();
    }

    public void addClientListener(NGClientListener listener) {
        this.getInputStream().addClientListener(listener);
    }

    public void removeClientListener(NGClientListener listener) {
        this.getInputStream().removeClientListener(listener);
    }

    public void addHeartbeatListener(NGHeartbeatListener listener) {
        this.getInputStream().addHeartbeatListener(listener);
    }

    public void removeHeartbeatListener(NGHeartbeatListener listener) {
        this.getInputStream().removeHeartbeatListener(listener);
    }
}

