/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBClientSP;
import edu.jas.gb.GroebnerBaseSeqPairDistributed;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistThreadPool;
import java.util.List;

public class GBDistSP<C extends RingElem<C>> {
    private final String mfile;
    protected final int threads;
    protected final int port;
    private final GroebnerBaseSeqPairDistributed<C> bbd;
    private final DistThreadPool dtp;

    public GBDistSP(int n, String string, int n2) {
        this.threads = n;
        this.mfile = string == null || string.length() == 0 ? "../util/machines" : string;
        this.port = n2;
        this.bbd = new GroebnerBaseSeqPairDistributed(n, this.port);
        this.dtp = new DistThreadPool(n, this.mfile);
    }

    public List<GenPolynomial<C>> execute(List<GenPolynomial<C>> list) {
        String string = this.dtp.getEC().getMasterHost();
        int n = this.dtp.getEC().getMasterPort();
        GBClientSP gBClientSP = new GBClientSP(string, n);
        for (int i = 0; i < this.threads; ++i) {
            this.dtp.addJob(gBClientSP);
        }
        List<GenPolynomial<C>> list2 = this.bbd.GB(list);
        return list2;
    }

    public void terminate(boolean bl) {
        this.bbd.terminate();
        this.dtp.terminate(bl);
    }
}

