/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RelationGenerator;
import edu.jas.poly.RelationTable;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class WeylRelationsIterated<C extends RingElem<C>>
implements RelationGenerator<C> {
    private final GenSolvablePolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(WeylRelationsIterated.class);

    public WeylRelationsIterated() {
        this.ring = null;
    }

    public WeylRelationsIterated(GenSolvablePolynomialRing<C> genSolvablePolynomialRing) {
        if (genSolvablePolynomialRing == null) {
            throw new IllegalArgumentException("WeylRelations, ring == null");
        }
        this.ring = genSolvablePolynomialRing;
        if (this.ring.nvar <= 1 || this.ring.nvar % 2 != 0) {
            throw new IllegalArgumentException("WeylRelations, wrong nvar = " + this.ring.nvar);
        }
    }

    public void generate() {
        if (this.ring == null) {
            throw new IllegalArgumentException("WeylRelations, ring == null");
        }
        this.generate(this.ring);
    }

    @Override
    public void generate(GenSolvablePolynomialRing<C> genSolvablePolynomialRing) {
        if (genSolvablePolynomialRing == null) {
            throw new IllegalArgumentException("WeylRelations, ring == null");
        }
        if (genSolvablePolynomialRing.nvar <= 1 || genSolvablePolynomialRing.nvar % 2 != 0) {
            throw new IllegalArgumentException("WeylRelations, wrong nvar = " + genSolvablePolynomialRing.nvar);
        }
        RelationTable relationTable = genSolvablePolynomialRing.table;
        int n = genSolvablePolynomialRing.nvar;
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)genSolvablePolynomialRing.getONE()).copy();
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)genSolvablePolynomialRing.getZERO()).copy();
        for (int i = 1; i <= n; i += 2) {
            ExpVector expVector = ExpVector.create(n, i, 1L);
            int n2 = i - 1;
            ExpVector expVector2 = ExpVector.create(n, n2, 1L);
            ExpVector expVector3 = expVector2.sum(expVector);
            GenPolynomial genPolynomial3 = ((GenSolvablePolynomial)genPolynomial).multiply(expVector3);
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial3.sum(genPolynomial);
            if (genSolvablePolynomial.isZERO()) {
                logger.info((Object)("ring = " + genSolvablePolynomialRing));
                logger.info((Object)("one  = " + genPolynomial));
                logger.info((Object)("zero = " + genPolynomial2));
                logger.info((Object)("b    = " + genPolynomial3));
                logger.info((Object)("rel  = " + genSolvablePolynomial));
                throw new RuntimeException("rel.isZERO()");
            }
            relationTable.update(expVector2, expVector, genSolvablePolynomial);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\nWeyl relations = " + relationTable));
        }
    }
}

