/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongIterator;
import edu.jas.arith.ModularRingFactory;
import edu.jas.kern.StringUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class ModLongRing
implements ModularRingFactory<ModLong>,
Iterable<ModLong> {
    public final long modul;
    private static final Random random = new Random();
    private int isField = -1;
    public static final java.math.BigInteger MAX_LONG = new java.math.BigInteger(String.valueOf(Integer.MAX_VALUE));

    public ModLongRing(long l) {
        this.modul = l;
    }

    public ModLongRing(long l, boolean bl) {
        this.modul = l;
        this.isField = bl ? 1 : 0;
    }

    public ModLongRing(Long l) {
        this((long)l);
    }

    public ModLongRing(Long l, boolean bl) {
        this((long)l, bl);
    }

    public ModLongRing(java.math.BigInteger bigInteger) {
        this(bigInteger.longValue());
        if (MAX_LONG.compareTo(bigInteger) < 0) {
            System.out.println("modul to large for long " + bigInteger + ",max=" + MAX_LONG);
            throw new IllegalArgumentException("modul to large for long " + bigInteger);
        }
    }

    public ModLongRing(java.math.BigInteger bigInteger, boolean bl) {
        this(bigInteger.longValue(), bl);
        if (MAX_LONG.compareTo(bigInteger) < 0) {
            System.out.println("modul to large for long " + bigInteger + ",max=" + MAX_LONG);
            throw new IllegalArgumentException("modul to large for long " + bigInteger);
        }
    }

    public ModLongRing(String string) {
        this(new Long(string.trim()));
    }

    public ModLongRing(String string, boolean bl) {
        this(new Long(string.trim()), bl);
    }

    public java.math.BigInteger getModul() {
        return new java.math.BigInteger(Long.toString(this.modul));
    }

    public long getLongModul() {
        return this.modul;
    }

    @Override
    public BigInteger getIntegerModul() {
        return new BigInteger(this.modul);
    }

    public ModLong create(java.math.BigInteger bigInteger) {
        return new ModLong(this, bigInteger);
    }

    public ModLong create(long l) {
        return new ModLong(this, l);
    }

    public ModLong create(String string) {
        return this.parse(string);
    }

    @Override
    public ModLong copy(ModLong modLong) {
        return new ModLong(this, modLong.val);
    }

    @Override
    public ModLong getZERO() {
        return new ModLong(this, 0L);
    }

    @Override
    public ModLong getONE() {
        return new ModLong(this, 1L);
    }

    @Override
    public List<ModLong> generators() {
        ArrayList<ModLong> arrayList = new ArrayList<ModLong>(1);
        arrayList.add(this.getONE());
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        java.math.BigInteger bigInteger = new java.math.BigInteger(Long.toString(this.modul));
        if (bigInteger.isProbablePrime(bigInteger.bitLength())) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    @Override
    public java.math.BigInteger characteristic() {
        return new java.math.BigInteger(Long.toString(this.modul));
    }

    @Override
    public ModLong fromInteger(java.math.BigInteger bigInteger) {
        return new ModLong(this, bigInteger);
    }

    @Override
    public ModLong fromInteger(long l) {
        return new ModLong(this, l);
    }

    public String toString() {
        return " mod(" + this.modul + ")";
    }

    @Override
    public String toScript() {
        if (this.isField()) {
            return "GFL(" + this.modul + ")";
        }
        return "ZL(" + this.modul + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof ModLongRing)) {
            return false;
        }
        ModLongRing modLongRing = (ModLongRing)object;
        return this.modul == modLongRing.modul;
    }

    public int hashCode() {
        return (int)this.modul;
    }

    @Override
    public ModLong random(int n) {
        return this.random(n, random);
    }

    @Override
    public ModLong random(int n, Random random) {
        java.math.BigInteger bigInteger = new java.math.BigInteger(n, random);
        return new ModLong(this, bigInteger);
    }

    @Override
    public ModLong parse(String string) {
        return new ModLong(this, string);
    }

    @Override
    public ModLong parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }

    @Override
    public ModLong chineseRemainder(ModLong modLong, ModLong modLong2, ModLong modLong3) {
        ModLong modLong4;
        ModLong modLong5;
        if (modLong.ring.modul < modLong3.ring.modul) {
            System.out.println("ModLong error " + modLong.ring + ", " + modLong3.ring);
        }
        if ((modLong5 = modLong3.subtract(modLong4 = modLong3.ring.fromInteger(modLong.val))).isZERO()) {
            return new ModLong(this, modLong.val);
        }
        modLong4 = modLong5.multiply(modLong2);
        long l = modLong.ring.modul * modLong4.val;
        return new ModLong(this, l += modLong.val);
    }

    @Override
    public Iterator<ModLong> iterator() {
        return new ModLongIterator(this);
    }
}

