/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorHensel;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GCDHenselTest
extends TestCase {
    GreatestCommonDivisorAbstract<BigInteger> ufd;
    GreatestCommonDivisorAbstract<BigInteger> ufd1;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    BigInteger cofac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<BigInteger> ac;
    GenPolynomial<BigInteger> bc;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    GenPolynomial<GenPolynomial<BigInteger>> arc;
    GenPolynomial<GenPolynomial<BigInteger>> brc;
    int rl = 3;
    String[] vars = new String[]{"x", "y", "z"};
    int kl = 4;
    int ll = 5;
    int el = 4;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GCDHenselTest.suite());
    }

    public GCDHenselTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDHenselTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.cofac = new BigInteger();
        this.ufd = new GreatestCommonDivisorHensel();
        this.dfac = new GenPolynomialRing<BigInteger>(this.cofac, this.rl, this.to, this.vars);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = null;
        this.dfac = null;
    }

    public void testHenselGcd() {
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.b = this.dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.c = this.dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.c = this.c.multiply((BigInteger)((Object)this.dfac.univariate(0)));
            ExpVector expVector = this.c.leadingExpVector();
            if (expVector != null) {
                this.c.doPutToMap(expVector, (BigInteger)((RingElem)this.dfac.coFac.getONE()));
            }
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDHenselTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigInteger)((Object)this.c));
            this.b = this.b.multiply((BigInteger)((Object)this.c));
            this.d = this.ufd.gcd(this.a, this.b);
            this.c = this.ufd.basePrimitivePart(this.c).abs();
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDHenselTest.assertTrue((String)("c | gcd(ac,bc): " + this.d + ", c = " + this.c), (boolean)this.e.isZERO());
            this.e = PolyUtil.basePseudoRemainder(this.a, this.d);
            GCDHenselTest.assertTrue((String)("gcd(a,b) | a: " + this.e + ", d = " + this.d), (boolean)this.e.isZERO());
            this.e = PolyUtil.basePseudoRemainder(this.b, this.d);
            GCDHenselTest.assertTrue((String)("gcd(a,b) | b: " + this.e + ", d = " + this.d), (boolean)this.e.isZERO());
        }
    }

    public void ytestHenselLinearSubresGcd() {
        this.ufd1 = new GreatestCommonDivisorHensel(false);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.b = this.dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.c = this.dfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.c = this.c.multiply((BigInteger)((Object)this.dfac.univariate(0)));
            ExpVector expVector = this.c.leadingExpVector();
            if (expVector != null) {
                this.c.doPutToMap(expVector, (BigInteger)((RingElem)this.dfac.coFac.getONE()));
            }
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDHenselTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigInteger)((Object)this.c));
            this.b = this.b.multiply((BigInteger)((Object)this.c));
            long l = System.currentTimeMillis();
            this.d = this.ufd1.gcd(this.a, this.b);
            l = System.currentTimeMillis() - l;
            long l2 = System.currentTimeMillis();
            this.e = this.ufd.gcd(this.a, this.b);
            l2 = System.currentTimeMillis() - l2;
            this.c = this.ufd.basePrimitivePart(this.c).abs();
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDHenselTest.assertTrue((String)("c | gcd(ac,bc): " + this.d + ", c = " + this.c), (boolean)this.e.isZERO());
            this.e = PolyUtil.basePseudoRemainder(this.a, this.d);
            GCDHenselTest.assertTrue((String)("gcd(a,b) | a: " + this.e + ", d = " + this.d), (boolean)this.e.isZERO());
            this.e = PolyUtil.basePseudoRemainder(this.b, this.d);
            GCDHenselTest.assertTrue((String)("gcd(a,b) | b: " + this.e + ", d = " + this.d), (boolean)this.e.isZERO());
        }
    }

    public void testHenselGCD3() {
        BigInteger bigInteger = new BigInteger(1L);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger, 3, this.to, new String[]{"x", "y", "z"});
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + i, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
            ExpVector expVector = this.a.leadingExpVector();
            if (expVector != null) {
                this.a.doPutToMap(expVector, bigInteger.getONE());
            }
            if ((expVector = this.b.leadingExpVector()) != null) {
                this.b.doPutToMap(expVector, bigInteger.getONE());
            }
            if ((expVector = this.c.leadingExpVector()) != null) {
                // empty if block
            }
            GCDHenselTest.assertFalse((String)"ev == null ", (expVector == null ? 1 : 0) != 0);
            if (expVector.dependencyOnVariables().length > 1) {
                this.c = this.dfac.univariate(1);
            }
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            this.a = this.a.multiply((BigInteger)((Object)this.c));
            this.b = this.b.multiply((BigInteger)((Object)this.c));
            this.d = this.ufd.gcd(this.a, this.b);
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDHenselTest.assertTrue((String)("c | gcd(ac,bc) " + this.e + ", d = " + this.d), (boolean)this.e.isZERO());
        }
    }
}

