/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ResidueRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;

public class Residue<C extends GcdRingElem<C>>
implements GcdRingElem<Residue<C>> {
    public final ResidueRing<C> ring;
    public final GenPolynomial<C> val;
    protected int isunit = -1;

    public Residue(ResidueRing<C> residueRing) {
        this(residueRing, (GenPolynomial<C>)residueRing.ring.getZERO(), 0);
    }

    public Residue(ResidueRing<C> residueRing, GenPolynomial<C> genPolynomial) {
        this(residueRing, genPolynomial, -1);
    }

    public Residue(ResidueRing<C> residueRing, GenPolynomial<C> genPolynomial, int n) {
        this.ring = residueRing;
        this.val = this.ring.ideal.normalform(genPolynomial);
        if (n == 0 || n == 1) {
            this.isunit = n;
            return;
        }
        if (this.val.isZERO()) {
            this.isunit = 0;
            return;
        }
        if (this.ring.isField()) {
            this.isunit = 1;
            return;
        }
        if (this.val.isUnit()) {
            this.isunit = 1;
        }
        this.isunit = -1;
    }

    @Override
    public ResidueRing<C> factory() {
        return this.ring;
    }

    @Override
    public Residue<C> copy() {
        return new Residue<C>(this.ring, this.val, this.isunit);
    }

    @Override
    public boolean isZERO() {
        return this.val.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.val.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        boolean bl = this.ring.ideal.isUnit(this.val);
        this.isunit = bl ? 1 : 0;
        return bl;
    }

    public boolean isConstant() {
        return this.val.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            return this.val.toString(this.ring.ring.getVars());
        }
        return "Residue[ " + this.val.toString() + " mod " + this.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return this.val.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((ResidueRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Residue<C> residue) {
        GenPolynomial<C> genPolynomial = residue.val;
        if (!this.ring.equals(residue.ring)) {
            genPolynomial = this.ring.ideal.normalform(genPolynomial);
        }
        return this.val.compareTo(genPolynomial);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Residue)) {
            return false;
        }
        Residue residue = null;
        try {
            residue = (Residue)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (residue == null) {
            return false;
        }
        return this.compareTo(residue) == 0;
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.val.hashCode();
        return n;
    }

    @Override
    public Residue<C> abs() {
        return new Residue<C>(this.ring, this.val.abs(), this.isunit);
    }

    @Override
    public Residue<C> sum(Residue<C> residue) {
        return new Residue<GenPolynomial<C>>(this.ring, this.val.sum(residue.val));
    }

    @Override
    public Residue<C> negate() {
        return new Residue<C>(this.ring, this.val.negate(), this.isunit);
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public Residue<C> subtract(Residue<C> residue) {
        return new Residue<GenPolynomial<C>>(this.ring, this.val.subtract(residue.val));
    }

    @Override
    public Residue<C> divide(Residue<C> residue) {
        if (this.ring.isField()) {
            return this.multiply((Residue<C>)residue.inverse());
        }
        GenPolynomial<C> genPolynomial = PolyUtil.basePseudoDivide(this.val, residue.val);
        return new Residue<C>(this.ring, genPolynomial);
    }

    @Override
    public Residue<C> inverse() {
        GenPolynomial genPolynomial = this.ring.ideal.inverse(this.val);
        return new Residue<C>(this.ring, genPolynomial, 1);
    }

    @Override
    public Residue<C> remainder(Residue<C> residue) {
        GenPolynomial<C> genPolynomial = PolyUtil.baseSparsePseudoRemainder(this.val, residue.val);
        return new Residue<C>(this.ring, genPolynomial);
    }

    @Override
    public Residue<C> multiply(Residue<C> residue) {
        GenPolynomial<GenPolynomial<C>> genPolynomial = this.val.multiply(residue.val);
        int n = -1;
        if (this.isunit == 1 && residue.isunit == 1) {
            n = 1;
        } else if (this.isunit == 0 || residue.isunit == 0) {
            n = 0;
        }
        return new Residue<GenPolynomial<C>>(this.ring, genPolynomial, n);
    }

    public Residue<C> monic() {
        return new Residue<C>(this.ring, this.val.monic(), this.isunit);
    }

    @Override
    public Residue<C> gcd(Residue<C> residue) {
        GenPolynomial genPolynomial = this.ring.engine.gcd(this.val, residue.val);
        int n = -1;
        if (genPolynomial.isONE()) {
            n = 1;
        } else {
            System.out.println("Residue gcd = " + genPolynomial);
        }
        if (this.isunit == 1 && residue.isunit == 1) {
            n = 1;
        }
        return new Residue<C>(this.ring, genPolynomial, n);
    }

    public Residue<C>[] egcd(Residue<C> residue) {
        throw new UnsupportedOperationException("egcd not implemented");
    }
}

