/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import java.util.ArrayList;
import java.util.List;

public final class ExpVectorShort
extends ExpVector {
    final short[] val;
    public static final long maxShort = 16383L;
    public static final long minShort = -16384L;

    public ExpVectorShort(int n) {
        this(new short[n]);
    }

    public ExpVectorShort(int n, int n2, short s) {
        this(n);
        this.val[n2] = s;
    }

    public ExpVectorShort(int n, int n2, long l) {
        this(n);
        if (l >= 16383L || l <= -16384L) {
            throw new IllegalArgumentException("exponent to large: " + l);
        }
        this.val[n2] = (short)l;
    }

    protected ExpVectorShort(short[] sArray) {
        this.val = sArray;
    }

    public ExpVectorShort(long[] lArray) {
        this(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] >= 16383L || lArray[i] <= -16384L) {
                throw new IllegalArgumentException("exponent to large: " + lArray[i]);
            }
            this.val[i] = (short)lArray[i];
        }
    }

    public ExpVectorShort(String string) throws NumberFormatException {
        ArrayList<Short> arrayList = new ArrayList<Short>();
        string = string.trim();
        int n = string.indexOf(40);
        int n2 = string.indexOf(41, n + 1);
        if (n >= 0 && n2 >= 0) {
            short s;
            String string2;
            int n3;
            ++n;
            while ((n3 = string.indexOf(44, n)) >= 0) {
                string2 = string.substring(n, n3);
                s = Short.parseShort(string2);
                arrayList.add(s);
                n = n3 + 1;
            }
            if (n <= n2) {
                string2 = string.substring(n, n2);
                s = Short.parseShort(string2);
                arrayList.add(s);
            }
            int n4 = arrayList.size();
            this.val = new short[n4];
            for (int i = 0; i < n4; ++i) {
                this.val[i] = (Short)arrayList.get(i);
            }
        } else {
            this.val = null;
        }
    }

    @Override
    public ExpVectorShort copy() {
        short[] sArray = new short[this.val.length];
        System.arraycopy(this.val, 0, sArray, 0, this.val.length);
        return new ExpVectorShort(sArray);
    }

    @Override
    long[] getVal() {
        long[] lArray = new long[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            lArray[i] = this.val[i];
        }
        return lArray;
    }

    @Override
    public long getVal(int n) {
        return this.val[n];
    }

    @Override
    protected long setVal(int n, long l) {
        short s = this.val[n];
        if (l >= 16383L || l <= -16384L) {
            throw new IllegalArgumentException("exponent to large: " + l);
        }
        this.val[n] = (short)l;
        this.hash = 0;
        return s;
    }

    protected short setVal(int n, short s) {
        short s2 = this.val[n];
        this.val[n] = s;
        this.hash = 0;
        return s2;
    }

    @Override
    public int length() {
        return this.val.length;
    }

    @Override
    public ExpVectorShort extend(int n, int n2, long l) {
        short[] sArray = new short[this.val.length + n];
        System.arraycopy(this.val, 0, sArray, n, this.val.length);
        if (n2 >= n) {
            throw new IllegalArgumentException("i " + n + " <= j " + n2 + " invalid");
        }
        if (l >= 16383L || l <= -16384L) {
            throw new IllegalArgumentException("exponent to large: " + l);
        }
        sArray[n2] = (short)l;
        return new ExpVectorShort(sArray);
    }

    @Override
    public ExpVectorShort extendLower(int n, int n2, long l) {
        short[] sArray = new short[this.val.length + n];
        System.arraycopy(this.val, 0, sArray, 0, this.val.length);
        if (n2 >= n) {
            throw new IllegalArgumentException("i " + n + " <= j " + n2 + " invalid");
        }
        sArray[this.val.length + n2] = (short)l;
        return new ExpVectorShort(sArray);
    }

    @Override
    public ExpVectorShort contract(int n, int n2) {
        if (n + n2 > this.val.length) {
            throw new IllegalArgumentException("len " + n2 + " > val.len " + this.val.length);
        }
        short[] sArray = new short[n2];
        System.arraycopy(this.val, n, sArray, 0, n2);
        return new ExpVectorShort(sArray);
    }

    @Override
    public ExpVectorShort reverse() {
        short[] sArray = new short[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            sArray[i] = this.val[this.val.length - 1 - i];
        }
        return new ExpVectorShort(sArray);
    }

    @Override
    public ExpVectorShort reverse(int n) {
        int n2;
        if (n <= 0 || n > this.val.length) {
            return this;
        }
        short[] sArray = new short[this.val.length];
        for (n2 = 0; n2 < n; ++n2) {
            sArray[n2] = this.val[n2];
        }
        for (n2 = n; n2 < this.val.length; ++n2) {
            sArray[n2] = this.val[this.val.length + n - 1 - n2];
        }
        return new ExpVectorShort(sArray);
    }

    @Override
    public ExpVectorShort combine(ExpVector expVector) {
        if (expVector == null || expVector.length() == 0) {
            return this;
        }
        ExpVectorShort expVectorShort = (ExpVectorShort)expVector;
        if (this.val.length == 0) {
            return expVectorShort;
        }
        short[] sArray = new short[this.val.length + expVectorShort.val.length];
        System.arraycopy(this.val, 0, sArray, 0, this.val.length);
        System.arraycopy(expVectorShort.val, 0, sArray, this.val.length, expVectorShort.val.length);
        return new ExpVectorShort(sArray);
    }

    @Override
    public ExpVectorShort permutation(List<Integer> list) {
        short[] sArray = new short[this.val.length];
        int n = 0;
        for (Integer n2 : list) {
            sArray[n++] = this.val[n2];
        }
        return new ExpVectorShort(sArray);
    }

    @Override
    public String toString() {
        return super.toString() + ":short";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ExpVectorShort)) {
            return false;
        }
        ExpVectorShort expVectorShort = (ExpVectorShort)object;
        int n = this.invLexCompareTo(expVectorShort);
        return 0 == n;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public ExpVectorShort abs() {
        short[] sArray = this.val;
        short[] sArray2 = new short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray2[i] = (long)sArray[i] >= 0L ? sArray[i] : (short)(-sArray[i]);
        }
        return new ExpVectorShort(sArray2);
    }

    @Override
    public ExpVectorShort negate() {
        short[] sArray = this.val;
        short[] sArray2 = new short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray2[i] = -sArray[i];
        }
        return new ExpVectorShort(sArray2);
    }

    @Override
    public ExpVectorShort sum(ExpVector expVector) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        short[] sArray3 = new short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray3[i] = (short)(sArray[i] + sArray2[i]);
        }
        return new ExpVectorShort(sArray3);
    }

    @Override
    public ExpVectorShort subtract(ExpVector expVector) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        short[] sArray3 = new short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray3[i] = (short)(sArray[i] - sArray2[i]);
        }
        return new ExpVectorShort(sArray3);
    }

    public ExpVectorShort subst(int n, short s) {
        ExpVectorShort expVectorShort = this.copy();
        expVectorShort.setVal(n, s);
        return expVectorShort;
    }

    @Override
    public ExpVectorShort subst(int n, long l) {
        ExpVectorShort expVectorShort = this.copy();
        expVectorShort.setVal(n, l);
        return expVectorShort;
    }

    @Override
    public int signum() {
        int n = 0;
        short[] sArray = this.val;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] < 0) {
                return -1;
            }
            if (sArray[i] <= 0) continue;
            n = 1;
        }
        return n;
    }

    @Override
    public long totalDeg() {
        long l = 0L;
        short[] sArray = this.val;
        for (int i = 0; i < sArray.length; ++i) {
            l += (long)sArray[i];
        }
        return l;
    }

    @Override
    public long maxDeg() {
        long l = 0L;
        short[] sArray = this.val;
        for (int i = 0; i < sArray.length; ++i) {
            if ((long)sArray[i] <= l) continue;
            l = sArray[i];
        }
        return l;
    }

    @Override
    public long weightDeg(long[][] lArray) {
        if (lArray == null || lArray.length == 0) {
            return this.totalDeg();
        }
        long l = 0L;
        short[] sArray = this.val;
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray2 = lArray[i];
            for (int j = 0; j < sArray.length; ++j) {
                l += lArray2[j] * (long)sArray[j];
            }
        }
        return l;
    }

    @Override
    public ExpVectorShort lcm(ExpVector expVector) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        short[] sArray3 = new short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray3[i] = sArray[i] >= sArray2[i] ? sArray[i] : sArray2[i];
        }
        return new ExpVectorShort(sArray3);
    }

    @Override
    public ExpVectorShort gcd(ExpVector expVector) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        short[] sArray3 = new short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray3[i] = sArray[i] <= sArray2[i] ? sArray[i] : sArray2[i];
        }
        return new ExpVectorShort(sArray3);
    }

    @Override
    public int[] dependencyOnVariables() {
        short[] sArray = this.val;
        int n = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] <= 0) continue;
            ++n;
        }
        int[] nArray = new int[n];
        if (n == 0) {
            return nArray;
        }
        int n2 = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] <= 0) continue;
            nArray[n2] = i;
            ++n2;
        }
        return nArray;
    }

    @Override
    public boolean multipleOf(ExpVector expVector) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        boolean bl = true;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] >= sArray2[i]) continue;
            return false;
        }
        return bl;
    }

    @Override
    public int compareTo(ExpVector expVector) {
        return this.invLexCompareTo(expVector);
    }

    @Override
    public int invLexCompareTo(ExpVector expVector) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        int n = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] > sArray2[i]) {
                return 1;
            }
            if (sArray[i] >= sArray2[i]) continue;
            return -1;
        }
        return n;
    }

    @Override
    public int invLexCompareTo(ExpVector expVector, int n, int n2) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (sArray[i] > sArray2[i]) {
                return 1;
            }
            if (sArray[i] >= sArray2[i]) continue;
            return -1;
        }
        return n3;
    }

    @Override
    public int invGradCompareTo(ExpVector expVector) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        int n = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] > sArray2[i]) {
                n = 1;
                break;
            }
            if (sArray[i] >= sArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i < sArray.length; ++i) {
            l += (long)sArray[i];
            l2 += (long)sArray2[i];
        }
        if (l > l2) {
            n = 1;
        } else if (l < l2) {
            n = -1;
        }
        return n;
    }

    @Override
    public int invGradCompareTo(ExpVector expVector, int n, int n2) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (sArray[i] > sArray2[i]) {
                n3 = 1;
                break;
            }
            if (sArray[i] >= sArray2[i]) continue;
            n3 = -1;
            break;
        }
        if (n3 == 0) {
            return n3;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i < n2; ++i) {
            l += (long)sArray[i];
            l2 += (long)sArray2[i];
        }
        if (l > l2) {
            n3 = 1;
        } else if (l < l2) {
            n3 = -1;
        }
        return n3;
    }

    @Override
    public int revInvLexCompareTo(ExpVector expVector) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        int n = 0;
        for (int i = sArray.length - 1; i >= 0; --i) {
            if (sArray[i] > sArray2[i]) {
                return 1;
            }
            if (sArray[i] >= sArray2[i]) continue;
            return -1;
        }
        return n;
    }

    @Override
    public int revInvLexCompareTo(ExpVector expVector, int n, int n2) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        int n3 = 0;
        for (int i = n2 - 1; i >= n; --i) {
            if (sArray[i] > sArray2[i]) {
                return 1;
            }
            if (sArray[i] >= sArray2[i]) continue;
            return -1;
        }
        return n3;
    }

    @Override
    public int revInvGradCompareTo(ExpVector expVector) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        int n = 0;
        for (int i = sArray.length - 1; i >= 0; --i) {
            if (sArray[i] > sArray2[i]) {
                n = 1;
                break;
            }
            if (sArray[i] >= sArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i >= 0; --i) {
            l += (long)sArray[i];
            l2 += (long)sArray2[i];
        }
        if (l > l2) {
            n = 1;
        } else if (l < l2) {
            n = -1;
        }
        return n;
    }

    @Override
    public int revInvGradCompareTo(ExpVector expVector, int n, int n2) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        int n3 = 0;
        for (int i = n2 - 1; i >= n; --i) {
            if (sArray[i] > sArray2[i]) {
                n3 = 1;
                break;
            }
            if (sArray[i] >= sArray2[i]) continue;
            n3 = -1;
            break;
        }
        if (n3 == 0) {
            return n3;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i >= n; --i) {
            l += (long)sArray[i];
            l2 += (long)sArray2[i];
        }
        if (l > l2) {
            n3 = 1;
        } else if (l < l2) {
            n3 = -1;
        }
        return n3;
    }

    @Override
    public int invWeightCompareTo(long[][] lArray, ExpVector expVector) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        int n = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] > sArray2[i]) {
                n = 1;
                break;
            }
            if (sArray[i] >= sArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray2 = lArray[i];
            long l = 0L;
            long l2 = 0L;
            for (int j = i; j < sArray.length; ++j) {
                l += lArray2[j] * (long)sArray[j];
                l2 += lArray2[j] * (long)sArray2[j];
            }
            if (l > l2) {
                return 1;
            }
            if (l >= l2) continue;
            return -1;
        }
        return n;
    }

    @Override
    public int invWeightCompareTo(long[][] lArray, ExpVector expVector, int n, int n2) {
        short[] sArray = this.val;
        short[] sArray2 = ((ExpVectorShort)expVector).val;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (sArray[i] > sArray2[i]) {
                n3 = 1;
                break;
            }
            if (sArray[i] >= sArray2[i]) continue;
            n3 = -1;
            break;
        }
        if (n3 == 0) {
            return n3;
        }
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray2 = lArray[i];
            long l = 0L;
            long l2 = 0L;
            for (int j = i; j < n2; ++j) {
                l += lArray2[j] * (long)sArray[j];
                l2 += lArray2[j] * (long)sArray2[j];
            }
            if (l > l2) {
                return 1;
            }
            if (l >= l2) continue;
            return -1;
        }
        return n3;
    }
}

