/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;

public class Examples {
    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        Examples.example7();
        Examples.example7();
    }

    public static void example0() {
        BigInteger bigInteger = new BigInteger();
        TermOrder termOrder = new TermOrder();
        String[] stringArray = new String[]{"x1", "x2", "x3"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 3, termOrder, stringArray);
        System.out.println("ring = " + genPolynomialRing);
        Element element = genPolynomialRing.parse("3 x1^2 x3^4 + 7 x2^5 - 61");
        System.out.println("pol = " + element);
        System.out.println("pol = " + ((GenPolynomial)element).toString(genPolynomialRing.getVars()));
        Element element2 = genPolynomialRing.parse("1");
        System.out.println("one = " + element2);
        System.out.println("one = " + ((GenPolynomial)element2).toString(genPolynomialRing.getVars()));
        GenPolynomial<Element> genPolynomial = ((GenPolynomial)element).subtract(element);
        System.out.println("p = " + genPolynomial);
        System.out.println("p = " + genPolynomial.toString(genPolynomialRing.getVars()));
        genPolynomial = ((GenPolynomial)element).multiply(element);
        System.out.println("p = " + genPolynomial);
        System.out.println("p = " + genPolynomial.toString(genPolynomialRing.getVars()));
    }

    public static void example1() {
        System.out.println("\n\n example 1");
        BigRational bigRational = new BigRational();
        System.out.println("cfac = " + bigRational);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 7);
        System.out.println("fac = " + genPolynomialRing);
        Element element = genPolynomialRing.random(10);
        System.out.println("a = " + element);
    }

    public static void example2() {
        System.out.println("\n\n example 2");
        BigRational bigRational = new BigRational();
        System.out.println("cfac = " + bigRational);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 7);
        System.out.println("fac = " + genPolynomialRing);
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(genPolynomialRing, 3);
        System.out.println("gfac = " + genPolynomialRing2);
        Element element = genPolynomialRing2.random(10);
        System.out.println("a = " + element);
    }

    public static void example3() {
        System.out.println("\n\n example 3");
        BigRational bigRational = new BigRational();
        System.out.println("cfac = " + bigRational);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1);
        System.out.println("mfac = " + genPolynomialRing);
        GenPolynomial genPolynomial = ((GenPolynomial)genPolynomialRing.random(8)).monic();
        System.out.println("modul = " + genPolynomial);
        AlgebraicNumberRing algebraicNumberRing = new AlgebraicNumberRing(genPolynomial);
        System.out.println("fac = " + algebraicNumberRing);
        Element element = algebraicNumberRing.random(15);
        System.out.println("a = " + element);
    }

    protected static long getPrime() {
        long l = 2L;
        for (int i = 1; i < 60; ++i) {
            l *= 2L;
        }
        return l -= 93L;
    }

    public static void example4() {
        System.out.println("\n\n example 4");
        long l = Examples.getPrime();
        ModIntegerRing modIntegerRing = new ModIntegerRing(l);
        System.out.println("cfac = " + modIntegerRing);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        System.out.println("mfac = " + genPolynomialRing);
        GenPolynomial genPolynomial = ((GenPolynomial)genPolynomialRing.random(8)).monic();
        System.out.println("modul = " + genPolynomial);
        AlgebraicNumberRing algebraicNumberRing = new AlgebraicNumberRing(genPolynomial);
        System.out.println("fac = " + algebraicNumberRing);
        Element element = algebraicNumberRing.random(12);
        System.out.println("a = " + element);
    }

    public static void example5() {
        System.out.println("\n\n example 5");
        BigRational bigRational = new BigRational();
        System.out.println("cfac = " + bigRational);
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(bigRational, 6);
        WeylRelations weylRelations = new WeylRelations();
        genSolvablePolynomialRing.addRelations(weylRelations);
        System.out.println("sfac = " + genSolvablePolynomialRing);
        GenPolynomial genPolynomial = genSolvablePolynomialRing.random(5);
        System.out.println("a = " + genPolynomial);
        System.out.println("a = " + genPolynomial.toString(genSolvablePolynomialRing.vars));
        GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial = ((GenSolvablePolynomial)genPolynomial).multiply(genPolynomial);
        System.out.println("b = " + genSolvablePolynomial);
        System.out.println("b = " + genSolvablePolynomial.toString(genSolvablePolynomialRing.vars));
        System.out.println("sfac = " + genSolvablePolynomialRing);
    }

    public static void example6() {
        System.out.println("\n\n example 6");
        BigInteger bigInteger = new BigInteger();
        System.out.println("cfac = " + bigInteger);
        TermOrder termOrder = new TermOrder(2);
        System.out.println("to   = " + termOrder);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 3, termOrder);
        System.out.println("fac = " + genPolynomialRing);
        genPolynomialRing.setVars(new String[]{"z", "y", "x"});
        System.out.println("fac = " + genPolynomialRing);
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.univariate(0);
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.univariate(1);
        GenPolynomial<BigInteger> genPolynomial3 = genPolynomialRing.univariate(2);
        System.out.println("x = " + genPolynomial);
        System.out.println("x = " + genPolynomial.toString(genPolynomialRing.vars));
        System.out.println("y = " + genPolynomial2);
        System.out.println("y = " + genPolynomial2.toString(genPolynomialRing.vars));
        System.out.println("z = " + genPolynomial3);
        System.out.println("z = " + genPolynomial3.toString(genPolynomialRing.vars));
        GenPolynomial<GenPolynomial<BigInteger>> genPolynomial4 = genPolynomial.sum((BigInteger)((Object)genPolynomial2)).sum(genPolynomial3).sum((GenPolynomial<BigInteger>)genPolynomialRing.getONE());
        System.out.println("p = " + genPolynomial4);
        System.out.println("p = " + genPolynomial4.toString(genPolynomialRing.vars));
        GenPolynomial<GenPolynomial<RingElem<BigInteger>>> genPolynomial5 = genPolynomial4;
        for (int i = 1; i < 20; ++i) {
            genPolynomial5 = genPolynomial5.multiply((GenPolynomial<RingElem<BigInteger>>)genPolynomial4);
        }
        System.out.println("q = " + genPolynomial5.length());
        GenPolynomial<GenPolynomial<RingElem<BigInteger>>> genPolynomial6 = genPolynomial5.sum((GenPolynomial<RingElem<BigInteger>>)genPolynomialRing.getONE());
        long l = System.currentTimeMillis();
        GenPolynomial<GenPolynomial<GenPolynomial<RingElem<BigInteger>>>> genPolynomial7 = genPolynomial5.multiply((GenPolynomial<RingElem<BigInteger>>)genPolynomial6);
        l = System.currentTimeMillis() - l;
        System.out.println("q2 = " + genPolynomial7.length());
        System.out.println("time = " + l + " ms");
    }

    public static void example7() {
        System.out.println("\n\n example 7");
        BigRational bigRational = new BigRational();
        System.out.println("cfac = " + bigRational);
        TermOrder termOrder = new TermOrder(2);
        System.out.println("to   = " + termOrder);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 3, termOrder);
        System.out.println("fac = " + genPolynomialRing);
        genPolynomialRing.setVars(new String[]{"z", "y", "x"});
        System.out.println("fac = " + genPolynomialRing);
        long l = 1L;
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.univariate(0, l);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.univariate(1, l);
        GenPolynomial<BigRational> genPolynomial3 = genPolynomialRing.univariate(2, l);
        System.out.println("x = " + genPolynomial.toString(genPolynomialRing.vars));
        System.out.println("y = " + genPolynomial2.toString(genPolynomialRing.vars));
        System.out.println("z = " + genPolynomial3.toString(genPolynomialRing.vars));
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial4 = genPolynomial.sum((BigRational)((Object)genPolynomial2)).sum(genPolynomial3).sum((GenPolynomial<BigRational>)genPolynomialRing.getONE());
        System.out.println("p = " + genPolynomial4.toString(genPolynomialRing.vars));
        int n = 20;
        System.out.println("mpow = " + n);
        GenPolynomial<GenPolynomial<RingElem<BigRational>>> genPolynomial5 = genPolynomial4;
        for (int i = 1; i < n; ++i) {
            genPolynomial5 = genPolynomial5.multiply((GenPolynomial<RingElem<BigRational>>)genPolynomial4);
        }
        System.out.println("len(q) = " + genPolynomial5.length());
        System.out.println("deg(q) = " + genPolynomial5.degree());
        GenPolynomial<GenPolynomial<RingElem<BigRational>>> genPolynomial6 = genPolynomial5.sum((GenPolynomial<RingElem<BigRational>>)genPolynomialRing.getONE());
        long l2 = System.currentTimeMillis();
        GenPolynomial<GenPolynomial<GenPolynomial<RingElem<BigRational>>>> genPolynomial7 = genPolynomial5.multiply((GenPolynomial<RingElem<BigRational>>)genPolynomial6);
        l2 = System.currentTimeMillis() - l2;
        System.out.println("len(q2)    = " + genPolynomial7.length());
        System.out.println("deg(q2)    = " + genPolynomial7.degree());
        System.out.println("LeadEV(q2) = " + genPolynomial7.leadingExpVector());
        System.out.println("time       = " + l2 + " ms");
    }

    public static void example8() {
        int n;
        GenPolynomial<BigInteger> genPolynomial;
        int n2 = 10;
        BigInteger bigInteger = new BigInteger();
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 1, stringArray);
        ArrayList<MonoidElem> arrayList = new ArrayList<MonoidElem>(n2);
        MonoidElem monoidElem = genPolynomialRing.getONE();
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.univariate(0);
        GenPolynomial<BigInteger> genPolynomial3 = genPolynomial = genPolynomial2.multiply(new BigInteger(2L));
        arrayList.add(monoidElem);
        arrayList.add(genPolynomial2);
        for (n = 2; n < n2; ++n) {
            GenPolynomial<BigInteger> genPolynomial4 = genPolynomial3.multiply((BigInteger)((Object)((GenPolynomial)arrayList.get(n - 1)))).subtract((BigInteger)((Object)((GenPolynomial)arrayList.get(n - 2))));
            arrayList.add(genPolynomial4);
        }
        for (n = 0; n < n2; ++n) {
            System.out.println("T[" + n + "] = " + arrayList.get(n));
        }
    }

    public static void example9() {
        int n;
        int n2 = 10;
        BigRational bigRational = new BigRational();
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, stringArray);
        ArrayList<MonoidElem> arrayList = new ArrayList<MonoidElem>(n2);
        MonoidElem monoidElem = genPolynomialRing.getONE();
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.univariate(0);
        arrayList.add(monoidElem);
        arrayList.add(genPolynomial);
        for (n = 2; n < n2; ++n) {
            BigRational bigRational2 = new BigRational(2 * n - 1);
            GenPolynomial<BigRational> genPolynomial2 = genPolynomial.multiply(bigRational2);
            GenPolynomial<RingElem<BigRational>> genPolynomial3 = genPolynomial2.multiply((BigRational)((Object)((GenPolynomial)arrayList.get(n - 1))));
            BigRational bigRational3 = new BigRational(n - 1);
            genPolynomial2 = ((GenPolynomial)arrayList.get(n - 2)).multiply(bigRational3);
            genPolynomial3 = genPolynomial3.subtract((RingElem<BigRational>)genPolynomial2);
            bigRational3 = new BigRational(1L, n);
            genPolynomial3 = genPolynomial3.multiply(bigRational3);
            arrayList.add(genPolynomial3);
        }
        for (n = 0; n < n2; ++n) {
            System.out.println("P[" + n + "] = " + ((GenPolynomial)arrayList.get(n)).toString(stringArray));
            System.out.println();
        }
    }

    public static void example10() {
        int n;
        int n2 = 100;
        BigInteger bigInteger = new BigInteger();
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 1, stringArray);
        ArrayList<MonoidElem> arrayList = new ArrayList<MonoidElem>(n2);
        MonoidElem monoidElem = genPolynomialRing.getONE();
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.univariate(0);
        BigInteger bigInteger2 = new BigInteger(2L);
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomial.multiply(bigInteger2);
        arrayList.add(monoidElem);
        arrayList.add(genPolynomial2);
        for (n = 2; n < n2; ++n) {
            GenPolynomial<RingElem<BigInteger>> genPolynomial3 = genPolynomial2.multiply((BigInteger)((Object)((GenPolynomial)arrayList.get(n - 1))));
            BigInteger bigInteger3 = new BigInteger(2 * (n - 1));
            GenPolynomial<BigInteger> genPolynomial4 = ((GenPolynomial)arrayList.get(n - 2)).multiply(bigInteger3);
            genPolynomial3 = genPolynomial3.subtract((BigInteger)((Object)genPolynomial4));
            arrayList.add(genPolynomial3);
        }
        for (n = n2 - 1; n < n2; ++n) {
            System.out.println("H[" + n + "] = " + ((GenPolynomial)arrayList.get(n)).toString(stringArray));
            System.out.println();
        }
    }

    public static void example11() {
        int n = 50;
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, n);
        System.out.println("ring = " + genPolynomialRing + "\n");
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(5, 3, 6, 0.5f);
        System.out.println("p = " + genPolynomial + "\n");
        List<GenPolynomial<BigInteger>> list = TermOrderOptimization.degreeMatrix(genPolynomial);
        System.out.println("dem = " + list + "\n");
        ArrayList arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        for (int i = 0; i < 5; ++i) {
            arrayList.add(genPolynomialRing.random(5, 3, 6, 0.1f));
        }
        System.out.println("polys = " + arrayList + "\n");
        list = TermOrderOptimization.degreeMatrix(arrayList);
        System.out.println("dem = " + list + "\n");
        List<Integer> list2 = TermOrderOptimization.optimalPermutation(list);
        System.out.println("perm = " + list2 + "\n");
        List<GenPolynomial<BigInteger>> list3 = TermOrderOptimization.listPermutation(list2, list);
        System.out.println("pdem = " + list3 + "\n");
        GenPolynomialRing<BigRational> genPolynomialRing2 = TermOrderOptimization.permutation(list2, genPolynomialRing);
        System.out.println("ring  = " + genPolynomialRing);
        System.out.println("pring = " + genPolynomialRing2 + "\n");
        List list4 = TermOrderOptimization.permutation(list2, genPolynomialRing2, arrayList);
        System.out.println("ppolys = " + list4 + "\n");
        list = TermOrderOptimization.degreeMatrix(list4);
        list2 = TermOrderOptimization.optimalPermutation(list);
        int n2 = 0;
        for (Integer n3 : list2) {
            if (n2 != n3) {
                System.out.println("error = " + n2 + " != " + n3 + "\n");
            }
            ++n2;
        }
        OptimizedPolynomialList<BigRational> optimizedPolynomialList = TermOrderOptimization.optimizeTermOrder(genPolynomialRing, arrayList);
        System.out.println("op:\n" + optimizedPolynomialList);
        if (!optimizedPolynomialList.equals(new PolynomialList<BigRational>(genPolynomialRing2, list4))) {
            System.out.println("error = \n" + optimizedPolynomialList);
        }
    }

    public static void example12() {
        System.out.println("\n\n example 12");
        BigRational bigRational = new BigRational();
        System.out.println("t1 = " + bigRational);
        BigInteger bigInteger = new BigInteger();
        System.out.println("t2 = " + bigInteger);
        System.out.println("t1.isAssignableFrom(t2) = " + bigRational.getClass().isAssignableFrom(bigInteger.getClass()));
        System.out.println("t2.isAssignableFrom(t1) = " + bigInteger.getClass().isAssignableFrom(bigRational.getClass()));
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 3);
        System.out.println("t3 = " + genPolynomialRing);
        GenSolvablePolynomialRing<BigInteger> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigInteger>(bigInteger, 3);
        System.out.println("t4 = " + genSolvablePolynomialRing);
        System.out.println("t3.isAssignableFrom(t4) = " + genPolynomialRing.getClass().isAssignableFrom(genSolvablePolynomialRing.getClass()));
        System.out.println("t4.isAssignableFrom(t3) = " + genSolvablePolynomialRing.getClass().isAssignableFrom(genPolynomialRing.getClass()));
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 3);
        System.out.println("t5 = " + genPolynomialRing2);
        System.out.println("t3.isAssignableFrom(t5) = " + genPolynomialRing.getClass().isAssignableFrom(genPolynomialRing2.getClass()));
        System.out.println("t5.isAssignableFrom(t3) = " + genPolynomialRing2.getClass().isAssignableFrom(genPolynomialRing.getClass()));
    }

    public static void example13() {
        System.out.println("\n\n example 13");
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, termOrder, stringArray);
        Element element = genPolynomialRing.parse("19(6)/10");
        System.out.println("FF0 = " + element);
        element = genPolynomialRing.parse("19(6)1/10");
        System.out.println("FF0 = " + element);
        element = genPolynomialRing.parse("19 6/10");
        System.out.println("FF0 = " + element);
        element = genPolynomialRing.parse("19*6/10");
        System.out.println("FF0 = " + element);
        element = genPolynomialRing.parse("19+6/10");
        System.out.println("FF0 = " + element);
        element = genPolynomialRing.parse("(x).2");
        System.out.println("FF0 = " + element);
    }
}

