/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import java.util.ArrayList;
import java.util.List;

public class IdealWithComplexAlgebraicRoots<D extends GcdRingElem<D> & Rational>
extends IdealWithUniv<D> {
    public final List<List<Complex<RealAlgebraicNumber<D>>>> can;
    protected List<List<Complex<BigDecimal>>> droots = null;

    protected IdealWithComplexAlgebraicRoots() {
        throw new IllegalArgumentException("do not use this constructor");
    }

    public IdealWithComplexAlgebraicRoots(Ideal<D> ideal, List<GenPolynomial<D>> list, List<List<Complex<RealAlgebraicNumber<D>>>> list2) {
        super(ideal, list);
        this.can = list2;
    }

    public IdealWithComplexAlgebraicRoots(IdealWithUniv<D> idealWithUniv, List<List<Complex<RealAlgebraicNumber<D>>>> list) {
        super(idealWithUniv.ideal, idealWithUniv.upolys);
        this.can = list;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString() + "\ncomplex roots:\n");
        stringBuffer.append("[");
        boolean bl = true;
        for (List<Complex<RealAlgebraicNumber<D>>> list : this.can) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append("[");
            boolean bl2 = true;
            for (Complex<RealAlgebraicNumber<D>> complex : list) {
                if (!bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = false;
                }
                stringBuffer.append(complex.ring.toScript());
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        if (this.droots != null) {
            stringBuffer.append("\ndecimal complex root approximation:\n");
            for (List<Complex<GcdRingElem<RealAlgebraicNumber<Object>>>> list : this.droots) {
                stringBuffer.append(list.toString());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        return super.toScript() + ",  " + this.can.toString();
    }

    public synchronized List<List<Complex<BigDecimal>>> decimalApproximation() {
        if (this.droots != null) {
            return this.droots;
        }
        ArrayList<List<Complex<BigDecimal>>> arrayList = new ArrayList<List<Complex<BigDecimal>>>();
        ComplexRing<BigDecimal> complexRing = new ComplexRing<BigDecimal>(new BigDecimal());
        for (List<Complex<RealAlgebraicNumber<D>>> list : this.can) {
            ArrayList<Complex<BigDecimal>> arrayList2 = new ArrayList<Complex<BigDecimal>>();
            for (Complex<RealAlgebraicNumber<D>> complex : list) {
                BigDecimal bigDecimal = new BigDecimal(complex.getRe().magnitude());
                BigDecimal bigDecimal2 = new BigDecimal(complex.getIm().magnitude());
                Complex<BigDecimal> complex2 = new Complex<BigDecimal>(complexRing, bigDecimal, bigDecimal2);
                arrayList2.add(complex2);
            }
            arrayList.add(arrayList2);
        }
        this.droots = arrayList;
        return arrayList;
    }

    public void doDecimalApproximation() {
        List<List<Complex<BigDecimal>>> list = this.decimalApproximation();
        if (list.isEmpty()) {
            System.out.println("unused is empty");
        }
    }
}

