/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import lpsolve.AbortListener;
import lpsolve.LogListener;
import lpsolve.LpSolve;
import lpsolve.LpSolveException;
import lpsolve.MsgListener;
import lpsolve.VersionInfo;

public class Demo {
    public void execute() throws LpSolveException {
        VersionInfo versionInfo = LpSolve.lpSolveVersion();
        System.out.println("This demo (Java version) will show most of the features of lp_solve " + versionInfo.getMajorversion() + "." + versionInfo.getMinorversion() + "." + versionInfo.getRelease() + "." + versionInfo.getBuild());
        this.pressRet();
        System.out.println("We start by creating a new problem with 4 variables and 0 constraints");
        System.out.println("We use: LpSolve problem = LpSolve.makeLp(0, 4);");
        LpSolve lpSolve = LpSolve.makeLp((int)0, (int)4);
        this.pressRet();
        1 var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        lpSolve.putLogfunc((LogListener)var3_3, null);
        lpSolve.solve();
        lpSolve.putLogfunc(null, null);
        2 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        lpSolve.putAbortfunc((AbortListener)var4_4, null);
        3 var5_5 = new /* Unavailable Anonymous Inner Class!! */;
        lpSolve.putMsgfunc((MsgListener)var5_5, null, 921);
        System.out.println("We can show the current problem with problem.printLp()");
        lpSolve.printLp();
        this.pressRet();
        System.out.println("Now we add some constraints:");
        System.out.println("problem.strAddConstraint(\"3 2 2 1\", LpSolve.LE, 4);");
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.printLp();
        this.pressRet();
        System.out.println("problem.strAddConstraint(\"0 4 3 1\", LpSolve.GE, 3);");
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.printLp();
        this.pressRet();
        System.out.println("Set the objective function:");
        System.out.println("problem.strSetObjFn(\"2 3 -2 3\");");
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.printLp();
        this.pressRet();
        System.out.println("Now solve the problem with System.out.println(problem.solve());");
        System.out.println(lpSolve.solve());
        this.pressRet();
        System.out.println("The value is 0, this means we found an optimal solution.");
        System.out.println("We can display the solution with problem.printObjective(), problem.printSolution(1), and problem.printConstraints(1)");
        lpSolve.printObjective();
        lpSolve.printSolution(1);
        lpSolve.printConstraints(1);
        this.pressRet();
        System.out.println("The dual variables of the solution are printed with problem.printDuals()");
        lpSolve.printDuals();
        this.pressRet();
        System.out.println("We can change a single element in the matix with problem.setMat(2, 1, 0.5)");
        lpSolve.setMat(2, 1, 0.5);
        lpSolve.printLp();
        this.pressRet();
        System.out.println("If we want to maximize the objective function use problem.setMaxim()");
        lpSolve.setMaxim();
        lpSolve.printLp();
        this.pressRet();
        System.out.println("After solving this gives us:");
        lpSolve.solve();
        lpSolve.printObjective();
        lpSolve.printSolution(1);
        lpSolve.printConstraints(1);
        lpSolve.printDuals();
        this.pressRet();
        System.out.println("Change the value of a rhs element with problem.setRh(1, 7.45)");
        lpSolve.setRh(1, 7.45);
        lpSolve.printLp();
        lpSolve.solve();
        lpSolve.printObjective();
        lpSolve.printSolution(1);
        lpSolve.printConstraints(1);
        this.pressRet();
        System.out.println("We change " + lpSolve.getColName(4) + " to the integer type with problem.setInt(4, true)");
        lpSolve.setInt(4, true);
        lpSolve.printLp();
        System.out.println("We set branch & bound debugging on with problem.setDebug(true)");
        lpSolve.setDebug(true);
        System.out.println("and solve...");
        this.pressRet();
        lpSolve.solve();
        lpSolve.printObjective();
        lpSolve.printSolution(1);
        lpSolve.printConstraints(1);
        this.pressRet();
        System.out.println("We can set bounds on the variables with problem.setLowbo(2, 2) & problem.setUpbo(4, 5.3)");
        lpSolve.setLowbo(2, 2.0);
        lpSolve.setUpbo(4, 5.3);
        lpSolve.printLp();
        this.pressRet();
        lpSolve.solve();
        lpSolve.printObjective();
        lpSolve.printSolution(1);
        lpSolve.printConstraints(1);
        this.pressRet();
        System.out.println("Now remove a constraint with problem.delConstraint(1)");
        lpSolve.delConstraint(1);
        lpSolve.printLp();
        this.pressRet();
        System.out.println("Add an equality constraint:\nproblem.strAddConstraint(\"1 2 1 4\", LpSolve.EQ, 8)");
        lpSolve.strAddConstraint("1 2 1 4", 3, 8.0);
        lpSolve.printLp();
        this.pressRet();
        System.out.println("A column can be added with problem.strAddColumn(\"3 2 2\")");
        lpSolve.strAddColumn("3 2 2");
        lpSolve.printLp();
        this.pressRet();
        System.out.println("A column can be removed with problem.delColumn(3)");
        lpSolve.delColumn(3);
        lpSolve.printLp();
        this.pressRet();
        System.out.println("We can use automatic scaling with problem.setScaling(LpSolve.SCALE_MEAN)");
        lpSolve.setScaling(3);
        lpSolve.printLp();
        this.pressRet();
        System.out.println("The function matElm returns a single matrix element.");
        System.out.println("problem.getMat(2, 3) returns " + lpSolve.getMat(2, 3));
        System.out.println("problem.getMat(1, 1) returns " + lpSolve.getMat(1, 1));
        System.out.println("Notice that getMat returns the value of the original unscaled problem");
        this.pressRet();
        System.out.println("If there are any integer type variables, then only  the rows are scaled.");
        System.out.println("problem.setScaling(LpSolve.SCALE_MEAN);");
        lpSolve.setScaling(3);
        System.out.println("problem.setInt(3, false);");
        lpSolve.setInt(3, false);
        lpSolve.printLp();
        this.pressRet();
        System.out.println("printObjective, printSolution gives the solution to the original problem");
        lpSolve.solve();
        lpSolve.printObjective();
        lpSolve.printSolution(1);
        lpSolve.printConstraints(1);
        this.pressRet();
        System.out.println("Scaling is turned off with problem.unscale()");
        lpSolve.unscale();
        lpSolve.printLp();
        this.pressRet();
        System.out.println("Now turn B&B debugging off and simplex tracing on with");
        System.out.println("problem.setDebug(false), problem.setTrace(true) and solve.");
        lpSolve.setDebug(false);
        lpSolve.setTrace(true);
        this.pressRet();
        lpSolve.solve();
        System.out.println("Where possible, lp_solve will start at the last found basis.");
        System.out.println("We can reset the problem to the initial basis with");
        System.out.println("problem.resetBasis(). Now solve it again ...");
        this.pressRet();
        lpSolve.resetBasis();
        lpSolve.solve();
        System.out.println("It is possible to give variables and constraints names.");
        System.out.println("problem.setRowName(1, \"speed\") & problem.setColName(2, \"money\")");
        lpSolve.setRowName(1, "speed");
        lpSolve.setColName(2, "money");
        lpSolve.printLp();
        System.out.println("As you can see, all column and rows are assigned default names");
        System.out.println("If a column or constraint is deleted, the names shift place also:");
        this.pressRet();
        System.out.println("problem.delColumn(1)");
        lpSolve.delColumn(1);
        lpSolve.printLp();
        this.pressRet();
        lpSolve.deleteLp();
    }

    private void pressRet() {
        System.out.print("\n[Press return to continue or type 'q' to quit] ");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string = bufferedReader.readLine();
            if (string == null || "q".equals(string.trim())) {
                System.out.println("Demo terminated.");
                System.exit(0);
            }
        }
        catch (IOException iOException) {
            System.exit(0);
        }
        System.out.println("");
    }

    public static void main(String[] stringArray) {
        try {
            new Demo().execute();
        }
        catch (LpSolveException lpSolveException) {
            lpSolveException.printStackTrace();
        }
    }
}

