/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public final class TermOrder
implements Serializable {
    public static final int LEX = 1;
    public static final int INVLEX = 2;
    public static final int GRLEX = 3;
    public static final int IGRLEX = 4;
    public static final int REVLEX = 5;
    public static final int REVILEX = 6;
    public static final int REVTDEG = 7;
    public static final int REVITDG = 8;
    public static final int DEFAULT_EVORD = 4;
    private final int evord;
    private final int evord2;
    private final int evbeg1;
    private final int evend1;
    private final int evbeg2;
    private final int evend2;
    private static final Logger logger = Logger.getLogger(TermOrder.class);
    private final boolean debug = logger.isDebugEnabled();
    private final long[][] weight;
    private final EVComparator horder;
    private final EVComparator lorder;
    private final EVComparator sugar;

    public TermOrder() {
        this(4);
    }

    public TermOrder(int n) {
        if (n < 1 || 8 < n) {
            throw new IllegalArgumentException("invalid term order: " + n);
        }
        this.evord = n;
        this.evord2 = 0;
        this.weight = null;
        this.evbeg1 = 0;
        this.evbeg2 = this.evend1 = Integer.MAX_VALUE;
        this.evend2 = this.evend1;
        switch (n) {
            case 1: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return ExpVector.EVILCP(expVector, expVector2);
                    }
                };
                break;
            }
            case 2: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return -ExpVector.EVILCP(expVector, expVector2);
                    }
                };
                break;
            }
            case 3: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return ExpVector.EVIGLC(expVector, expVector2);
                    }
                };
                break;
            }
            case 4: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return -ExpVector.EVIGLC(expVector, expVector2);
                    }
                };
                break;
            }
            case 5: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return ExpVector.EVRILCP(expVector, expVector2);
                    }
                };
                break;
            }
            case 6: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return -ExpVector.EVRILCP(expVector, expVector2);
                    }
                };
                break;
            }
            case 7: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return ExpVector.EVRIGLC(expVector, expVector2);
                    }
                };
                break;
            }
            case 8: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return -ExpVector.EVRIGLC(expVector, expVector2);
                    }
                };
                break;
            }
            default: {
                this.horder = null;
            }
        }
        if (this.horder == null) {
            throw new IllegalArgumentException("invalid term order: " + n);
        }
        this.lorder = new EVComparator(){

            @Override
            public int compare(ExpVector expVector, ExpVector expVector2) {
                return -TermOrder.this.horder.compare(expVector, expVector2);
            }
        };
        this.sugar = new EVComparator(){

            @Override
            public int compare(ExpVector expVector, ExpVector expVector2) {
                return ExpVector.EVIGLC(expVector, expVector2);
            }
        };
    }

    public TermOrder(long[] lArray) {
        this(new long[][]{lArray});
    }

    public TermOrder(long[][] lArray) {
        if (lArray == null || lArray.length == 0) {
            throw new IllegalArgumentException("invalid term order weight");
        }
        this.weight = (long[][])Arrays.copyOf(lArray, lArray.length);
        this.evord = 0;
        this.evord2 = 0;
        this.evbeg1 = 0;
        this.evbeg2 = this.evend1 = this.weight[0].length;
        this.evend2 = this.evend1;
        this.horder = new EVComparator(){

            @Override
            public int compare(ExpVector expVector, ExpVector expVector2) {
                return -ExpVector.EVIWLC(TermOrder.this.weight, expVector, expVector2);
            }
        };
        this.lorder = new EVComparator(){

            @Override
            public int compare(ExpVector expVector, ExpVector expVector2) {
                return ExpVector.EVIWLC(TermOrder.this.weight, expVector, expVector2);
            }
        };
        this.sugar = this.horder;
    }

    public TermOrder(int n, int n2) {
        this(4, 4, n, n2);
    }

    public TermOrder(int n, int n2, int n3, int n4) {
        if (n < 1 || 8 < n) {
            throw new IllegalArgumentException("invalid term order: " + n);
        }
        if (n2 < 1 || 8 < n2) {
            throw new IllegalArgumentException("invalid term order: " + n2);
        }
        this.evord = n;
        this.evord2 = n2;
        this.weight = null;
        this.evbeg1 = 0;
        this.evend1 = n4;
        this.evbeg2 = n4;
        this.evend2 = n3;
        if (this.evbeg2 > this.evend2) {
            throw new IllegalArgumentException("invalid term order split, r = " + n3 + ", split = " + n4);
        }
        block0 : switch (this.evord) {
            case 1: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 2: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 3: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 4: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 5: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 6: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 7: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 8: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVRILCP(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -ExpVector.EVRIGLC(expVector, expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            default: {
                this.horder = null;
            }
        }
        if (this.horder == null) {
            throw new IllegalArgumentException("invalid term order: " + this.evord + " 2 " + this.evord2);
        }
        this.lorder = new EVComparator(){

            @Override
            public int compare(ExpVector expVector, ExpVector expVector2) {
                return -TermOrder.this.horder.compare(expVector, expVector2);
            }
        };
        this.sugar = new EVComparator(){

            @Override
            public int compare(ExpVector expVector, ExpVector expVector2) {
                return ExpVector.EVIGLC(expVector, expVector2);
            }
        };
    }

    public int getEvord() {
        return this.evord;
    }

    public int getEvord2() {
        return this.evord2;
    }

    public int getSplit() {
        return this.evend1;
    }

    public long[][] getWeight() {
        if (this.weight == null) {
            return null;
        }
        return (long[][])Arrays.copyOf(this.weight, this.weight.length);
    }

    public EVComparator getDescendComparator() {
        return this.horder;
    }

    public EVComparator getAscendComparator() {
        return this.lorder;
    }

    public EVComparator getSugarComparator() {
        return this.sugar;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof TermOrder)) {
            return false;
        }
        TermOrder termOrder = (TermOrder)object;
        boolean bl2 = bl = this.evord == termOrder.getEvord() && this.evord2 == termOrder.evord2 && this.evbeg1 == termOrder.evbeg1 && this.evend1 == termOrder.evend1 && this.evbeg2 == termOrder.evbeg2 && this.evend2 == termOrder.evend2;
        if (!bl) {
            return bl;
        }
        return Arrays.equals((Object[])this.weight, (Object[])termOrder.weight);
    }

    public int hashCode() {
        int n = this.evord;
        n = (n << 3) + this.evord2;
        n = (n << 4) + this.evbeg1;
        n = (n << 4) + this.evend1;
        n = (n << 4) + this.evbeg2;
        n = (n << 4) + this.evend2;
        if (this.weight == null) {
            return n;
        }
        n = n * 7 + Arrays.deepHashCode((Object[])this.weight);
        return n;
    }

    public String weightToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.weight != null) {
            stringBuffer.append("weight(");
            for (int i = 0; i < this.weight.length; ++i) {
                long[] lArray = this.weight[i];
                stringBuffer.append("(");
                for (int j = 0; j < lArray.length; ++j) {
                    stringBuffer.append("" + lArray[lArray.length - j - 1]);
                    if (j >= lArray.length - 1) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append(")");
                if (i >= this.weight.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.weight != null) {
            stringBuffer.append("W(");
            for (int i = 0; i < this.weight.length; ++i) {
                long[] lArray = this.weight[i];
                stringBuffer.append("(");
                for (int j = 0; j < lArray.length; ++j) {
                    stringBuffer.append("" + lArray[lArray.length - j - 1]);
                    if (j >= lArray.length - 1) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append(")");
                if (i >= this.weight.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            if (this.evend1 == this.evend2) {
                return stringBuffer.toString();
            }
            stringBuffer.append("[" + this.evbeg1 + "," + this.evend1 + "]");
            stringBuffer.append("[" + this.evbeg2 + "," + this.evend2 + "]");
            return stringBuffer.toString();
        }
        switch (this.evord) {
            case 1: {
                stringBuffer.append("LEX");
                break;
            }
            case 2: {
                stringBuffer.append("INVLEX");
                break;
            }
            case 3: {
                stringBuffer.append("GRLEX");
                break;
            }
            case 4: {
                stringBuffer.append("IGRLEX");
                break;
            }
            case 5: {
                stringBuffer.append("REVLEX");
                break;
            }
            case 6: {
                stringBuffer.append("REVILEX");
                break;
            }
            case 7: {
                stringBuffer.append("REVTDEG");
                break;
            }
            case 8: {
                stringBuffer.append("REVITDG");
                break;
            }
            default: {
                stringBuffer.append("invalid(" + this.evord + ")");
            }
        }
        if (this.evord2 <= 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append("[" + this.evbeg1 + "," + this.evend1 + "]");
        switch (this.evord2) {
            case 1: {
                stringBuffer.append("LEX");
                break;
            }
            case 2: {
                stringBuffer.append("INVLEX");
                break;
            }
            case 3: {
                stringBuffer.append("GRLEX");
                break;
            }
            case 4: {
                stringBuffer.append("IGRLEX");
                break;
            }
            case 5: {
                stringBuffer.append("REVLEX");
                break;
            }
            case 6: {
                stringBuffer.append("REVILEX");
                break;
            }
            case 7: {
                stringBuffer.append("REVTDEG");
                break;
            }
            case 8: {
                stringBuffer.append("REVITDG");
                break;
            }
            default: {
                stringBuffer.append("invalid(" + this.evord2 + ")");
            }
        }
        stringBuffer.append("[" + this.evbeg2 + "," + this.evend2 + "]");
        return stringBuffer.toString();
    }

    public TermOrder extend(int n, int n2) {
        if (this.weight != null) {
            long[][] lArrayArray = new long[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                long[] lArray = this.weight[i];
                long l = 0L;
                for (int j = 0; j < lArray.length; ++j) {
                    if (lArray[j] <= l) continue;
                    l = lArray[j];
                }
                ++l;
                long[] lArray2 = new long[lArray.length + n2];
                for (int j = 0; j < i; ++j) {
                    lArray2[j] = l;
                }
                System.arraycopy(lArray, 0, lArray2, i, lArray.length);
                lArrayArray[i] = lArray2;
            }
            return new TermOrder(lArrayArray);
        }
        if (this.evord2 != 0) {
            logger.debug((Object)"warn: TermOrder is already extended");
            if (this.debug) {
                throw new IllegalArgumentException("TermOrder is already extended: " + this);
            }
            return new TermOrder(this.evord, this.evord2, n + n2, this.evend1 + n2);
        }
        return new TermOrder(4, this.evord, n + n2, n2);
    }

    public TermOrder extendLower(int n, int n2) {
        if (this.weight != null) {
            long[][] lArrayArray = new long[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                long[] lArray = this.weight[i];
                long l = Long.MAX_VALUE;
                for (int j = 0; j < lArray.length; ++j) {
                    if (lArray[j] >= l) continue;
                    l = lArray[j];
                }
                long[] lArray2 = new long[lArray.length + n2];
                for (int j = 0; j < i; ++j) {
                    lArray2[lArray.length + j] = l;
                }
                System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
                lArrayArray[i] = lArray2;
            }
            return new TermOrder(lArrayArray);
        }
        if (this.evord2 != 0) {
            if (this.debug) {
                logger.warn((Object)"TermOrder is already extended");
            }
            return new TermOrder(this.evord, this.evord2, n + n2, this.evend1 + n2);
        }
        return new TermOrder(this.evord);
    }

    public TermOrder contract(int n, int n2) {
        if (this.weight != null) {
            long[][] lArrayArray = new long[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                long[] lArray = this.weight[i];
                long[] lArray2 = new long[n2];
                System.arraycopy(lArray, n, lArray2, 0, n2);
                lArrayArray[i] = lArray2;
            }
            return new TermOrder(lArrayArray);
        }
        if (this.evord2 == 0) {
            if (this.debug) {
                logger.warn((Object)"TermOrder is already contracted");
            }
            return new TermOrder(this.evord);
        }
        if (this.evend1 > n) {
            int n3;
            for (n3 = this.evend1 - n; n3 > n2; n3 -= n2) {
            }
            if ((long)n3 == 0L) {
                return new TermOrder(this.evord);
            }
            if (n3 == n2) {
                return new TermOrder(this.evord);
            }
            return new TermOrder(this.evord, this.evord2, n2, n3);
        }
        return new TermOrder(this.evord2);
    }

    public TermOrder reverse() {
        return this.reverse(false);
    }

    public TermOrder reverse(boolean bl) {
        if (this.weight != null) {
            if (bl) {
                logger.error((Object)"partial reversed weight order not implemented");
            }
            long[][] lArrayArray = new long[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                long[] lArray = this.weight[i];
                long[] lArray2 = new long[lArray.length];
                for (int j = 0; j < lArray2.length; ++j) {
                    lArray2[j] = lArray[lArray2.length - 1 - j];
                }
                lArrayArray[i] = lArray2;
            }
            TermOrder termOrder = new TermOrder(lArrayArray);
            logger.info((Object)("reverse = " + termOrder + ", from = " + this));
            return termOrder;
        }
        if (this.evord2 == 0) {
            TermOrder termOrder = new TermOrder(TermOrder.revert(this.evord));
            return termOrder;
        }
        TermOrder termOrder = bl ? new TermOrder(TermOrder.revert(this.evord), TermOrder.revert(this.evord2), this.evend2, this.evend1) : new TermOrder(TermOrder.revert(this.evord2), TermOrder.revert(this.evord), this.evend2, this.evend2 - this.evbeg2);
        logger.info((Object)("reverse = " + termOrder + ", from = " + this));
        return termOrder;
    }

    public static int revert(int n) {
        int n2 = n;
        switch (n) {
            case 1: {
                n2 = 5;
                break;
            }
            case 2: {
                n2 = 6;
                break;
            }
            case 3: {
                n2 = 7;
                break;
            }
            case 4: {
                n2 = 8;
                break;
            }
            case 5: {
                n2 = 1;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 4;
                break;
            }
            default: {
                logger.error((Object)("can not revert " + n));
            }
        }
        return n2;
    }

    public static long[] longArrayPermutation(List<Integer> list, long[] lArray) {
        if (lArray == null || lArray.length <= 1) {
            return lArray;
        }
        long[] lArray2 = new long[lArray.length];
        int n = 0;
        for (Integer n2 : list) {
            lArray2[n] = lArray[n2];
            ++n;
        }
        return lArray2;
    }

    public TermOrder permutation(List<Integer> list) {
        long[][] lArray;
        TermOrder termOrder = this;
        if (this.getEvord2() != 0) {
            termOrder = new TermOrder(this.getEvord2());
            logger.warn((Object)("split term order '" + this + "' not permutable, resetting to most base term order " + termOrder));
        }
        if ((lArray = this.getWeight()) != null) {
            long[][] lArrayArray = new long[lArray.length][];
            for (int i = 0; i < lArray.length; ++i) {
                lArrayArray[i] = TermOrder.longArrayPermutation(list, lArray[i]);
            }
            termOrder = new TermOrder(lArrayArray);
        }
        return termOrder;
    }

    public static abstract class EVComparator
    implements Comparator<ExpVector>,
    Serializable {
        @Override
        public abstract int compare(ExpVector var1, ExpVector var2);
    }
}

