/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.WordResidueRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.Word;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.QuotPair;
import edu.jas.structure.Value;
import java.util.ArrayList;

public class WordResidue<C extends GcdRingElem<C>>
implements GcdRingElem<WordResidue<C>>,
QuotPair<GenWordPolynomial<C>>,
Value<GenWordPolynomial<C>> {
    public final WordResidueRing<C> ring;
    public final GenWordPolynomial<C> val;
    protected int isunit = -1;

    public WordResidue(WordResidueRing<C> wordResidueRing) {
        this(wordResidueRing, (GenWordPolynomial<C>)wordResidueRing.ring.getZERO(), 0);
    }

    public WordResidue(WordResidueRing<C> wordResidueRing, GenWordPolynomial<C> genWordPolynomial) {
        this(wordResidueRing, genWordPolynomial, -1);
    }

    public WordResidue(WordResidueRing<C> wordResidueRing, GenWordPolynomial<C> genWordPolynomial, int n) {
        this.ring = wordResidueRing;
        this.val = this.ring.ideal.normalform(genWordPolynomial);
        if (n == 0 || n == 1) {
            this.isunit = n;
            return;
        }
        if (this.val.isZERO()) {
            this.isunit = 0;
            return;
        }
        if (this.ring.isField()) {
            this.isunit = 1;
            return;
        }
        if (this.val.isUnit()) {
            this.isunit = 1;
        }
        this.isunit = -1;
    }

    @Override
    public WordResidueRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenWordPolynomial<C> value() {
        return this.val;
    }

    @Override
    public GenWordPolynomial<C> numerator() {
        return this.val;
    }

    @Override
    public GenWordPolynomial<C> denominator() {
        return this.ring.ring.getONE();
    }

    @Override
    public WordResidue<C> copy() {
        return new WordResidue<C>(this.ring, this.val, this.isunit);
    }

    @Override
    public boolean isZERO() {
        return this.val.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.val.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        boolean bl = this.ring.ideal.isUnit(this.val);
        this.isunit = bl ? 1 : 0;
        return this.isunit > 0;
    }

    @Override
    public boolean isConstant() {
        return this.val.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            return this.val.toString();
        }
        return "WordResidue[ " + this.val.toString() + " mod " + this.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return this.val.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((WordResidueRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(WordResidue<C> wordResidue) {
        GenWordPolynomial<C> genWordPolynomial = wordResidue.val;
        if (!this.ring.equals(wordResidue.ring)) {
            genWordPolynomial = this.ring.ideal.normalform(genWordPolynomial);
        }
        return this.val.compareTo(genWordPolynomial);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof WordResidue)) {
            return false;
        }
        WordResidue wordResidue = null;
        try {
            wordResidue = (WordResidue)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (wordResidue == null) {
            return false;
        }
        return this.compareTo(wordResidue) == 0;
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.val.hashCode();
        return n;
    }

    @Override
    public WordResidue<C> abs() {
        return new WordResidue<C>(this.ring, this.val.abs(), this.isunit);
    }

    @Override
    public WordResidue<C> sum(WordResidue<C> wordResidue) {
        return new WordResidue<GenWordPolynomial<C>>(this.ring, this.val.sum(wordResidue.val));
    }

    @Override
    public WordResidue<C> negate() {
        return new WordResidue<C>(this.ring, this.val.negate(), this.isunit);
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public WordResidue<C> subtract(WordResidue<C> wordResidue) {
        return new WordResidue<GenWordPolynomial<C>>(this.ring, this.val.subtract(wordResidue.val));
    }

    @Override
    public WordResidue<C> divide(WordResidue<C> wordResidue) {
        if (this.ring.isField()) {
            return this.multiply((C)wordResidue.inverse());
        }
        try {
            return this.multiply((C)wordResidue.inverse());
        }
        catch (NotInvertibleException notInvertibleException) {
            System.out.println("catch: " + notInvertibleException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(this.ring.ring.getZERO());
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(this.ring.ring.getZERO());
        ArrayList arrayList3 = new ArrayList(1);
        arrayList3.add(wordResidue.val);
        GenWordPolynomial genWordPolynomial = this.ring.bb.red.normalform(arrayList, arrayList2, arrayList3, this.val);
        GenWordPolynomial genWordPolynomial2 = (GenWordPolynomial)arrayList.get(0);
        return new WordResidue<C>(this.ring, genWordPolynomial2);
    }

    public WordResidue<C>[] twosidedDivide(WordResidue<C> wordResidue) {
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(this.ring.ring.getZERO());
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(this.ring.ring.getZERO());
        ArrayList arrayList3 = new ArrayList(1);
        arrayList3.add(wordResidue.val);
        GenWordPolynomial genWordPolynomial = this.ring.bb.red.normalform(arrayList, arrayList2, arrayList3, this.val);
        GenWordPolynomial genWordPolynomial2 = (GenWordPolynomial)arrayList.get(0);
        GenWordPolynomial genWordPolynomial3 = (GenWordPolynomial)arrayList2.get(0);
        System.out.println("WordResidue val = " + this.val + ", div = " + wordResidue.val + ", leftquotient = " + genWordPolynomial2 + ", rightquotient = " + genWordPolynomial3 + ", remainder = " + genWordPolynomial);
        WordResidue[] wordResidueArray = new WordResidue[]{new WordResidue<C>(this.ring, genWordPolynomial2), new WordResidue<C>(this.ring, genWordPolynomial3)};
        return wordResidueArray;
    }

    @Override
    public WordResidue<C> inverse() {
        GenWordPolynomial<GenWordPolynomial<C>> genWordPolynomial = this.ring.ideal.inverse(this.val);
        WordResidue<WordResidue> wordResidue = new WordResidue<WordResidue>(this.ring, genWordPolynomial, 1);
        if (wordResidue.isZERO()) {
            throw new NotInvertibleException("(" + genWordPolynomial + ") * (" + this.val + ") = " + genWordPolynomial.multiply(this.val) + " = 0 mod " + this.ring.ideal);
        }
        if (!wordResidue.multiply(this).isONE()) {
            throw new NotInvertibleException("(" + genWordPolynomial + ") * (" + this.val + ") = " + genWordPolynomial.multiply(this.val) + " != 1 mod " + this.ring.ideal);
        }
        return wordResidue;
    }

    @Override
    public WordResidue<C> remainder(WordResidue<C> wordResidue) {
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(wordResidue.val);
        GenWordPolynomial genWordPolynomial = this.ring.bb.red.normalform(arrayList, this.val);
        return new WordResidue<C>(this.ring, genWordPolynomial);
    }

    @Override
    public WordResidue<C> multiply(WordResidue<C> wordResidue) {
        GenWordPolynomial<GenWordPolynomial<C>> genWordPolynomial = this.val.multiply(wordResidue.val);
        int n = -1;
        if (this.isunit == 1 && wordResidue.isunit == 1) {
            n = 1;
        } else if (this.isunit == 0 || wordResidue.isunit == 0) {
            n = 0;
        }
        return new WordResidue<GenWordPolynomial<C>>(this.ring, genWordPolynomial, n);
    }

    @Override
    public WordResidue<C> multiply(GenWordPolynomial<C> genWordPolynomial) {
        GenWordPolynomial<GenWordPolynomial<C>> genWordPolynomial2 = this.val.multiply(genWordPolynomial);
        int n = -1;
        if (this.isunit == 1 && genWordPolynomial.isUnit()) {
            n = 1;
        } else if (this.isunit == 0 || !genWordPolynomial.isUnit()) {
            n = 0;
        }
        return new WordResidue<GenWordPolynomial<C>>(this.ring, genWordPolynomial2, n);
    }

    @Override
    public WordResidue<C> multiply(C c) {
        GenWordPolynomial<C> genWordPolynomial = this.val.multiply(c);
        int n = -1;
        if (this.isunit == 1 && c.isUnit()) {
            n = 1;
        } else if (this.isunit == 0 || !c.isUnit()) {
            n = 0;
        }
        return new WordResidue<C>(this.ring, genWordPolynomial, n);
    }

    @Override
    public WordResidue<C> multiply(Word word) {
        GenWordPolynomial<C> genWordPolynomial = this.val.multiply(word);
        int n = -1;
        if (this.isunit == 1 && word.isONE()) {
            n = 1;
        } else if (this.isunit == 0 || !word.isONE()) {
            n = 0;
        }
        return new WordResidue<C>(this.ring, genWordPolynomial, n);
    }

    public WordResidue<C> monic() {
        return new WordResidue<C>(this.ring, this.val.monic(), this.isunit);
    }

    @Override
    public WordResidue<C> gcd(WordResidue<C> wordResidue) {
        throw new UnsupportedOperationException("gcd not implemented");
    }

    public WordResidue<C>[] egcd(WordResidue<C> wordResidue) {
        throw new UnsupportedOperationException("egcd not implemented");
    }
}

