/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import java.util.ArrayList;
import java.util.List;

class CoeffToRecReAlg<C extends GcdRingElem<C> & Rational>
implements UnaryFunctor<C, RealAlgebraicNumber<C>> {
    protected final List<RealAlgebraicRing<C>> lfac;
    final int depth;

    public CoeffToRecReAlg(int n, RealAlgebraicRing<C> realAlgebraicRing) {
        if (realAlgebraicRing == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        RealAlgebraicRing realAlgebraicRing2 = realAlgebraicRing;
        this.depth = n;
        this.lfac = new ArrayList<RealAlgebraicRing<C>>(this.depth);
        this.lfac.add(realAlgebraicRing);
        for (int i = 1; i < this.depth; ++i) {
            RingFactory ringFactory = realAlgebraicRing2.algebraic.ring.coFac;
            if (!(ringFactory instanceof RealAlgebraicRing)) {
                throw new IllegalArgumentException("fac depth to low");
            }
            realAlgebraicRing2 = (RealAlgebraicRing)ringFactory;
            this.lfac.add(realAlgebraicRing2);
        }
    }

    @Override
    public RealAlgebraicNumber<C> eval(C c) {
        if (c == null) {
            return this.lfac.get(0).getZERO();
        }
        Object object = c;
        RealAlgebraicRing<C> realAlgebraicRing = this.lfac.get(this.lfac.size() - 1);
        AbelianGroupElem abelianGroupElem = realAlgebraicRing.algebraic.ring.getZERO();
        RealAlgebraicNumber<C> realAlgebraicNumber = new RealAlgebraicNumber<C>(realAlgebraicRing, ((GenPolynomial)abelianGroupElem).sum(object));
        for (int i = this.lfac.size() - 2; i >= 0; --i) {
            realAlgebraicRing = this.lfac.get(i);
            abelianGroupElem = realAlgebraicRing.algebraic.ring.getZERO();
            object = realAlgebraicNumber;
            realAlgebraicNumber = new RealAlgebraicNumber<C>(realAlgebraicRing, ((GenPolynomial)abelianGroupElem).sum(object));
        }
        return realAlgebraicNumber;
    }
}

