/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class ChannelFactory
extends Thread {
    private static final Logger logger = Logger.getLogger(ChannelFactory.class);
    private final boolean debug;
    public static final int DEFAULT_PORT = 4711;
    private final int port;
    private final BlockingQueue<SocketChannel> buf;
    private volatile ServerSocket srv;
    private volatile boolean srvrun;
    private volatile boolean srvstart;

    public ChannelFactory() {
        this(4711);
    }

    public ChannelFactory(int n) {
        block4: {
            this.debug = logger.isDebugEnabled();
            this.srvrun = false;
            this.srvstart = false;
            this.buf = new LinkedBlockingQueue<SocketChannel>();
            this.port = n <= 0 ? 4711 : n;
            try {
                this.srv = new ServerSocket(this.port);
                logger.info((Object)("server bound to port " + this.port));
            }
            catch (BindException bindException) {
                this.srv = null;
                logger.warn((Object)("server not started, port used " + this.port));
                if (this.debug) {
                    bindException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                logger.debug((Object)("IOException " + iOException));
                if (!logger.isDebugEnabled()) break block4;
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.srv + ", buf = " + this.buf.size() + ")";
    }

    public void init() {
        if (this.srv != null && !this.srvstart) {
            this.start();
            this.srvstart = true;
            logger.info((Object)("ChannelFactory at " + this.srv));
        }
    }

    public SocketChannel getChannel() throws InterruptedException {
        if (this.srv == null) {
            if (this.srvrun) {
                throw new IllegalArgumentException("dont call when no server listens");
            }
        } else if (!this.srvstart) {
            this.init();
        }
        return this.buf.take();
    }

    public SocketChannel getChannel(String string) throws IOException {
        return this.getChannel(string, 4711);
    }

    public SocketChannel getChannel(String string, int n) throws IOException {
        if (n <= 0) {
            n = this.port;
        }
        SocketChannel socketChannel = null;
        int n2 = 0;
        int n3 = 5;
        logger.debug((Object)("connecting to " + string));
        while (socketChannel == null) {
            try {
                socketChannel = new SocketChannel(new Socket(string, n));
            }
            catch (IOException iOException) {
                if (++n2 % 50 == 0) {
                    n3 += n3;
                    logger.info((Object)("Server on " + string + ":" + n + " not ready in " + n3 + "ms"));
                }
                try {
                    Thread.sleep(n3);
                    if (n2 % 50 != 0 || !this.debug) continue;
                    throw new Exception("time wait, host = " + string + ", port = " + this.port);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted during IO wait " + interruptedException);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        logger.debug((Object)("connected, iter = " + n2));
        return socketChannel;
    }

    @Override
    public void run() {
        if (this.srv == null) {
            return;
        }
        this.srvrun = true;
        try {
            while (true) {
                logger.info((Object)("waiting for connection on " + this.srv));
                Socket socket = this.srv.accept();
                if (this.isInterrupted()) {
                    this.srvrun = false;
                    if (socket != null) {
                        socket.close();
                    }
                    return;
                }
                logger.debug((Object)"connection accepted");
                SocketChannel socketChannel = new SocketChannel(socket);
                this.buf.put(socketChannel);
            }
        }
        catch (IOException iOException) {
            this.srvrun = false;
            return;
        }
        catch (InterruptedException interruptedException) {
            this.srvrun = false;
            return;
        }
    }

    public void terminate() {
        if (!this.srvstart) {
            logger.debug((Object)"server not started");
            return;
        }
        this.interrupt();
        try {
            if (this.srv != null) {
                this.srv.close();
                this.srvrun = false;
            }
            this.interrupt();
            while (!this.buf.isEmpty()) {
                logger.debug((Object)"closing unused SocketChannel");
                SocketChannel socketChannel = (SocketChannel)this.buf.poll();
                if (socketChannel == null) continue;
                socketChannel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.debug((Object)"ChannelFactory terminated");
    }
}

