/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.ps.MultiVarCoefficients;
import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.ps.MultiVarPowerSeriesMap;
import edu.jas.ps.TaylorFunction;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import edu.jas.util.ListUtil;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class MultiVarPowerSeriesRing<C extends RingElem<C>>
implements RingFactory<MultiVarPowerSeries<C>> {
    protected static final Random random = new Random();
    public static final int DEFAULT_TRUNCATE = 7;
    int truncate;
    public final ExpVector EVZERO;
    public final RingFactory<C> coFac;
    public final int nvar;
    protected String[] vars;
    public final MultiVarPowerSeries<C> ONE;
    public final MultiVarPowerSeries<C> ZERO;

    private MultiVarPowerSeriesRing() {
        throw new IllegalArgumentException("do not use no-argument constructor");
    }

    public MultiVarPowerSeriesRing(GenPolynomialRing<C> genPolynomialRing) {
        this(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.getVars());
    }

    public MultiVarPowerSeriesRing(RingFactory<C> ringFactory, int n) {
        this(ringFactory, n, 7);
    }

    public MultiVarPowerSeriesRing(RingFactory<C> ringFactory, int n, int n2) {
        this(ringFactory, n, n2, null);
    }

    public MultiVarPowerSeriesRing(RingFactory<C> ringFactory, String[] stringArray) {
        this(ringFactory, stringArray.length, 7, stringArray);
    }

    public MultiVarPowerSeriesRing(RingFactory<C> ringFactory, int n, String[] stringArray) {
        this(ringFactory, n, 7, stringArray);
    }

    public MultiVarPowerSeriesRing(RingFactory<C> ringFactory, int n, int n2, String[] stringArray) {
        this.coFac = ringFactory;
        this.nvar = n;
        this.truncate = n2;
        this.vars = stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length);
        if (this.vars == null) {
            if (PrettyPrint.isTrue()) {
                this.vars = GenPolynomialRing.newVars("x", this.nvar);
            }
        } else {
            if (this.vars.length != this.nvar) {
                throw new IllegalArgumentException("incompatible variable size " + this.vars.length + ", " + this.nvar);
            }
            GenPolynomialRing.addVars(this.vars);
        }
        this.EVZERO = ExpVector.create(this.nvar);
        this.ONE = new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

            @Override
            public C generate(ExpVector expVector) {
                if (expVector.isZERO()) {
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.getONE();
                }
                return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
            }
        });
        this.ZERO = new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

            @Override
            public C generate(ExpVector expVector) {
                return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public MultiVarPowerSeries<C> fixPoint(MultiVarPowerSeriesMap<C> multiVarPowerSeriesMap) {
        MultiVarPowerSeries multiVarPowerSeries = new MultiVarPowerSeries(this);
        MultiVarPowerSeries<C> multiVarPowerSeries2 = multiVarPowerSeriesMap.map(multiVarPowerSeries);
        multiVarPowerSeries.lazyCoeffs = multiVarPowerSeries2.lazyCoeffs;
        return multiVarPowerSeries2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.coFac.getClass().getSimpleName();
        stringBuffer.append(string + "((" + this.varsToString() + "))");
        return stringBuffer.toString();
    }

    public String varsToString() {
        if (this.vars == null) {
            return "#" + this.nvar;
        }
        return ExpVector.varsToString(this.vars);
    }

    public String[] getVars() {
        return Arrays.copyOf(this.vars, this.vars.length);
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer("MPS(");
        String string = null;
        try {
            string = ((RingElem)((Object)this.coFac)).toScriptFactory();
        }
        catch (Exception exception) {
            string = this.coFac.toScript();
        }
        stringBuffer.append(string + ",\"" + this.varsToString() + "\"," + this.truncate + ")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        MultiVarPowerSeriesRing multiVarPowerSeriesRing = null;
        try {
            multiVarPowerSeriesRing = (MultiVarPowerSeriesRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (multiVarPowerSeriesRing == null) {
            return false;
        }
        if (!this.coFac.equals(multiVarPowerSeriesRing.coFac)) {
            return false;
        }
        return Arrays.equals(this.vars, multiVarPowerSeriesRing.vars);
    }

    public int hashCode() {
        int n = this.coFac.hashCode();
        n <<= 7;
        n += Arrays.hashCode(this.vars) << 17;
        return n += this.truncate;
    }

    @Override
    public MultiVarPowerSeries<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public MultiVarPowerSeries<C> getONE() {
        return this.ONE;
    }

    @Override
    public List<MultiVarPowerSeries<C>> generators() {
        List list = this.coFac.generators();
        ArrayList<MultiVarPowerSeries<C>> arrayList = new ArrayList<MultiVarPowerSeries<C>>(list.size());
        for (final RingElem ringElem : list) {
            MultiVarPowerSeries multiVarPowerSeries = new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

                @Override
                public C generate(ExpVector expVector) {
                    if (expVector.isZERO()) {
                        return ringElem;
                    }
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
                }
            });
            arrayList.add(multiVarPowerSeries);
        }
        for (int i = 0; i < this.nvar; ++i) {
            arrayList.add(this.ONE.shift(1, this.nvar - 1 - i));
        }
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    public int truncate() {
        return this.truncate;
    }

    public int setTruncate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative truncate not allowed");
        }
        int n2 = this.truncate;
        this.truncate = n;
        this.ONE.setTruncate(n);
        this.ZERO.setTruncate(n);
        return n2;
    }

    public MultiVarPowerSeries<C> getEXP(final int n) {
        return this.fixPoint(new MultiVarPowerSeriesMap<C>(){

            @Override
            public MultiVarPowerSeries<C> map(MultiVarPowerSeries<C> multiVarPowerSeries) {
                return multiVarPowerSeries.integrate((RingElem)MultiVarPowerSeriesRing.this.coFac.getONE(), n);
            }
        });
    }

    public MultiVarPowerSeries<C> getSIN(final int n) {
        return this.fixPoint(new MultiVarPowerSeriesMap<C>(){

            @Override
            public MultiVarPowerSeries<C> map(MultiVarPowerSeries<C> multiVarPowerSeries) {
                return ((MultiVarPowerSeries)multiVarPowerSeries.negate()).integrate((RingElem)MultiVarPowerSeriesRing.this.coFac.getONE(), n).integrate((RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO(), n);
            }
        });
    }

    public MultiVarPowerSeries<C> getCOS(final int n) {
        return this.fixPoint(new MultiVarPowerSeriesMap<C>(){

            @Override
            public MultiVarPowerSeries<C> map(MultiVarPowerSeries<C> multiVarPowerSeries) {
                return ((MultiVarPowerSeries)multiVarPowerSeries.negate()).integrate((RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO(), n).integrate((RingElem)MultiVarPowerSeriesRing.this.coFac.getONE(), n);
            }
        });
    }

    public MultiVarPowerSeries<C> getTAN(final int n) {
        return this.fixPoint(new MultiVarPowerSeriesMap<C>(){

            @Override
            public MultiVarPowerSeries<C> map(MultiVarPowerSeries<C> multiVarPowerSeries) {
                return multiVarPowerSeries.multiply(multiVarPowerSeries).sum((MultiVarPowerSeries)MultiVarPowerSeriesRing.this.getONE()).integrate((RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO(), n);
            }
        });
    }

    public MultiVarPowerSeries<C> solvePDE(MultiVarPowerSeries<C> multiVarPowerSeries, C c, int n) {
        return multiVarPowerSeries.integrate(c, n);
    }

    @Override
    public boolean isCommutative() {
        return this.coFac.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    @Override
    public MultiVarPowerSeries<C> fromInteger(final long l) {
        return new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

            @Override
            public C generate(ExpVector expVector) {
                if (expVector.isZERO()) {
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.fromInteger(l);
                }
                return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    @Override
    public MultiVarPowerSeries<C> fromInteger(final BigInteger bigInteger) {
        return new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

            @Override
            public C generate(ExpVector expVector) {
                if (expVector.isZERO()) {
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.fromInteger(bigInteger);
                }
                return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public GenPolynomialRing<C> polyRing() {
        return new GenPolynomialRing<C>(this.coFac, this.nvar, this.vars);
    }

    public MultiVarPowerSeries<C> fromPolynomial(GenPolynomial<C> genPolynomial) {
        Element<ExpVector> element;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this.ZERO;
        }
        if (genPolynomial.isONE()) {
            return this.ONE;
        }
        GenPolynomialRing<C> genPolynomialRing = this.polyRing();
        HashMap hashMap = new HashMap();
        int n = 0;
        for (Monomial<C> monomial : genPolynomial) {
            element = monomial.exponent();
            long l = element.totalDeg();
            n = Math.max(n, (int)l);
            Element element2 = (GenPolynomial)hashMap.get(l);
            if (element2 == null) {
                element2 = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
                hashMap.put(l, element2);
            }
            element2.doPutToMap((ExpVector)element, monomial.coefficient());
        }
        if (++n > this.truncate()) {
            this.setTruncate(n);
        }
        BitSet bitSet = new BitSet();
        for (int i = 0; i <= this.truncate(); ++i) {
            bitSet.set(i);
            if (hashMap.get(i) != null) continue;
            element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
            hashMap.put(Long.valueOf(i), element);
        }
        return new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(genPolynomialRing, hashMap, bitSet){

            @Override
            public C generate(ExpVector expVector) {
                return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public List<MultiVarPowerSeries<C>> fromPolynomial(List<GenPolynomial<C>> list) {
        return ListUtil.map(list, new UnaryFunctor<GenPolynomial<C>, MultiVarPowerSeries<C>>(){

            @Override
            public MultiVarPowerSeries<C> eval(GenPolynomial<C> genPolynomial) {
                return MultiVarPowerSeriesRing.this.fromPolynomial(genPolynomial);
            }
        });
    }

    public MultiVarPowerSeries<C> fromPowerSeries(final UnivPowerSeries<C> univPowerSeries, final int n) {
        if (univPowerSeries == null) {
            return this.ZERO;
        }
        return new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

            @Override
            public C generate(ExpVector expVector) {
                if (expVector.isZERO()) {
                    return univPowerSeries.coefficient(0);
                }
                int[] nArray = expVector.dependencyOnVariables();
                if (nArray.length != 1) {
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
                }
                if (nArray[0] != n) {
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
                }
                int n2 = (int)expVector.getVal(n);
                if (n2 > 0) {
                    return univPowerSeries.coefficient(n2);
                }
                return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public MultiVarPowerSeries<C> random() {
        return this.random(5, 0.7f, random);
    }

    @Override
    public MultiVarPowerSeries<C> random(int n) {
        return this.random(n, 0.7f, random);
    }

    @Override
    public MultiVarPowerSeries<C> random(int n, Random random) {
        return this.random(n, 0.7f, random);
    }

    public MultiVarPowerSeries<C> random(int n, float f) {
        return this.random(n, f, random);
    }

    public MultiVarPowerSeries<C> random(final int n, final float f, final Random random) {
        return new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){

            @Override
            public C generate(ExpVector expVector) {
                float f2 = random.nextFloat();
                RingElem ringElem = f2 < f ? (RingElem)MultiVarPowerSeriesRing.this.coFac.random(n, random) : (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
                return ringElem;
            }
        });
    }

    @Override
    public MultiVarPowerSeries<C> copy(MultiVarPowerSeries<C> multiVarPowerSeries) {
        return new MultiVarPowerSeries(this, multiVarPowerSeries.lazyCoeffs);
    }

    @Override
    public MultiVarPowerSeries<C> parse(String string) {
        throw new UnsupportedOperationException("parse for power series not implemented");
    }

    @Override
    public MultiVarPowerSeries<C> parse(Reader reader) {
        throw new UnsupportedOperationException("parse for power series not implemented");
    }

    public MultiVarPowerSeries<C> seriesOfTaylor(final TaylorFunction<C> taylorFunction, final List<C> list) {
        return new MultiVarPowerSeries(this, new MultiVarCoefficients<C>(this){
            TaylorFunction<C> der;
            final List<C> v;
            {
                super(multiVarPowerSeriesRing2);
                this.der = taylorFunction;
                this.v = list;
            }

            @Override
            public C generate(ExpVector expVector) {
                int n = expVector.signum();
                if (n == 0) {
                    Object c = this.der.evaluate(this.v);
                    return c;
                }
                TaylorFunction taylorFunction2 = this.der.deriviative(expVector);
                if (taylorFunction2.isZERO()) {
                    return (RingElem)MultiVarPowerSeriesRing.this.coFac.getZERO();
                }
                MonoidElem monoidElem = taylorFunction2.evaluate(this.v);
                if (monoidElem.isZERO()) {
                    return monoidElem;
                }
                long l = taylorFunction2.getFacul();
                monoidElem = (RingElem)monoidElem.divide((MonoidElem)((MonoidElem)MultiVarPowerSeriesRing.this.coFac.fromInteger(l)));
                return monoidElem;
            }
        });
    }
}

