/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.QuotientRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class Quotient<C extends RingElem<C>>
implements RingElem<Quotient<C>>,
QuotPair<C> {
    private static final Logger logger = Logger.getLogger(Quotient.class);
    private final boolean debug = logger.isDebugEnabled();
    public final QuotientRing<C> ring;
    public final C num;
    public final C den;

    public Quotient(QuotientRing<C> quotientRing) {
        this(quotientRing, (RingElem)quotientRing.ring.getZERO());
    }

    public Quotient(QuotientRing<C> quotientRing, C c) {
        this((QuotientRing<RingElem>)quotientRing, (RingElem)c, (RingElem)quotientRing.ring.getONE(), true);
    }

    public Quotient(QuotientRing<C> quotientRing, C c, C c2) {
        this(quotientRing, c, c2, false);
    }

    protected Quotient(QuotientRing<C> quotientRing, C object, C object2, boolean bl) {
        if (object2 == null || object2.isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = quotientRing;
        if (object2.signum() < 0) {
            object = (RingElem)object.negate();
            object2 = (RingElem)object2.negate();
        }
        if (bl) {
            this.num = object;
            this.den = object2;
            return;
        }
        if (object instanceof GcdRingElem && object2 instanceof GcdRingElem) {
            GcdRingElem gcdRingElem = (GcdRingElem)object;
            GcdRingElem gcdRingElem2 = (GcdRingElem)object2;
            GcdRingElem gcdRingElem3 = gcdRingElem.gcd(gcdRingElem2);
            if (this.debug) {
                logger.info((Object)("gcd = " + gcdRingElem3));
            }
            if (gcdRingElem3.isONE()) {
                this.num = object;
                this.den = object2;
            } else {
                this.num = object.divide((GcdRingElem)gcdRingElem3);
                this.den = object2.divide((GcdRingElem)gcdRingElem3);
            }
        } else {
            logger.warn((Object)"gcd = ????");
            this.num = object;
            this.den = object2;
        }
    }

    @Override
    public QuotientRing<C> factory() {
        return this.ring;
    }

    @Override
    public C numerator() {
        return this.num;
    }

    @Override
    public C denominator() {
        return this.den;
    }

    @Override
    public boolean isConstant() {
        throw new UnsupportedOperationException("isConstant not implemented");
    }

    @Override
    public Quotient<C> copy() {
        return new Quotient<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.equals(this.den);
    }

    @Override
    public boolean isUnit() {
        return !this.num.isZERO();
    }

    public String toString() {
        return "Quotient[ " + this.num.toString() + " / " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "Quotient( " + this.num.toScript() + " , " + this.den.toScript() + " )";
    }

    @Override
    public String toScriptFactory() {
        return ((QuotientRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Quotient<C> quotient) {
        if (quotient == null || quotient.isZERO()) {
            return this.signum();
        }
        RingElem ringElem = (RingElem)this.num.multiply(quotient.den);
        RingElem ringElem2 = (RingElem)this.den.multiply(quotient.num);
        RingElem ringElem3 = ringElem.subtract(ringElem2);
        return ringElem3.signum();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Quotient)) {
            return false;
        }
        Quotient quotient = (Quotient)object;
        return 0 == this.compareTo(quotient);
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.num.hashCode();
        n = 37 * n + this.den.hashCode();
        return n;
    }

    @Override
    public Quotient<C> abs() {
        return new Quotient<RingElem>((QuotientRing<RingElem>)this.ring, (RingElem)this.num.abs(), (RingElem)this.den, true);
    }

    @Override
    public Quotient<C> sum(Quotient<C> quotient) {
        if (quotient == null || quotient.isZERO()) {
            return this;
        }
        RingElem ringElem = (RingElem)this.num.multiply(quotient.den);
        ringElem = (RingElem)ringElem.sum((AbelianGroupElem)this.den.multiply(quotient.num));
        RingElem ringElem2 = (RingElem)this.den.multiply(quotient.den);
        return new Quotient<RingElem>(this.ring, ringElem, ringElem2, false);
    }

    @Override
    public Quotient<C> negate() {
        return new Quotient<RingElem>((QuotientRing<RingElem>)this.ring, (RingElem)this.num.negate(), (RingElem)this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public Quotient<C> subtract(Quotient<C> quotient) {
        if (quotient == null || quotient.isZERO()) {
            return this;
        }
        RingElem ringElem = (RingElem)this.num.multiply(quotient.den);
        ringElem = (RingElem)ringElem.subtract((AbelianGroupElem)this.den.multiply(quotient.num));
        RingElem ringElem2 = (RingElem)this.den.multiply(quotient.den);
        return new Quotient<RingElem>(this.ring, ringElem, ringElem2, false);
    }

    @Override
    public Quotient<C> divide(Quotient<C> quotient) {
        return this.multiply((Quotient<C>)quotient.inverse());
    }

    @Override
    public Quotient<C> inverse() {
        return new Quotient<C>(this.ring, this.den, this.num, true);
    }

    @Override
    public Quotient<C> remainder(Quotient<C> quotient) {
        if (this.num.isZERO()) {
            throw new ArithmeticException("element not invertible " + this);
        }
        return this.ring.getZERO();
    }

    public Quotient<C>[] quotientRemainder(Quotient<C> quotient) {
        return new Quotient[]{this.divide(quotient), this.remainder(quotient)};
    }

    @Override
    public Quotient<C> multiply(Quotient<C> quotient) {
        if (quotient == null || quotient.isZERO()) {
            return quotient;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (quotient.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return quotient;
        }
        RingElem ringElem = (RingElem)this.num.multiply(quotient.num);
        RingElem ringElem2 = (RingElem)this.den.multiply(quotient.den);
        return new Quotient<RingElem>(this.ring, ringElem, ringElem2, false);
    }

    public Quotient<C> monic() {
        logger.info((Object)"monic not implemented");
        return this;
    }

    @Override
    public Quotient<C> gcd(Quotient<C> quotient) {
        if (quotient == null || quotient.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return quotient;
        }
        if (this.num instanceof GcdRingElem && this.den instanceof GcdRingElem && quotient.num instanceof GcdRingElem && quotient.den instanceof GcdRingElem) {
            return this.ring.getONE();
        }
        throw new UnsupportedOperationException("gcd not implemented " + this.num.getClass().getName());
    }

    public Quotient<C>[] egcd(Quotient<C> quotient) {
        Quotient[] quotientArray = new Quotient[]{null, null, null};
        if (quotient == null || quotient.isZERO()) {
            quotientArray[0] = this;
            return quotientArray;
        }
        if (this.isZERO()) {
            quotientArray[0] = quotient;
            return quotientArray;
        }
        if (this.num instanceof GcdRingElem && this.den instanceof GcdRingElem && quotient.num instanceof GcdRingElem && quotient.den instanceof GcdRingElem) {
            Element element = this.ring.fromInteger(2L);
            quotientArray[0] = this.ring.getONE();
            quotientArray[1] = this.multiply((Quotient<C>)element).inverse();
            quotientArray[2] = quotient.multiply((Quotient<C>)element).inverse();
            return quotientArray;
        }
        throw new UnsupportedOperationException("egcd not implemented " + this.num.getClass().getName());
    }
}

