/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.OrderedWordPairlist;
import edu.jas.gb.WordGroebnerBaseAbstract;
import edu.jas.gb.WordPair;
import edu.jas.gb.WordPairList;
import edu.jas.gbufd.WordPseudoReduction;
import edu.jas.gbufd.WordPseudoReductionSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class WordGroebnerBasePseudoRecSeq<C extends GcdRingElem<C>>
extends WordGroebnerBaseAbstract<GenPolynomial<C>> {
    private static final Logger logger = Logger.getLogger(WordGroebnerBasePseudoRecSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final WordPseudoReduction<C> redRec;
    protected final WordPseudoReduction<GenPolynomial<C>> red;
    protected final GenPolynomialRing<C> cofac;

    public WordGroebnerBasePseudoRecSeq(RingFactory<GenPolynomial<C>> ringFactory) {
        this(ringFactory, new WordPseudoReductionSeq<GenPolynomial<C>>());
    }

    public WordGroebnerBasePseudoRecSeq(RingFactory<GenPolynomial<C>> ringFactory, WordPseudoReductionSeq<GenPolynomial<C>> wordPseudoReductionSeq) {
        this(ringFactory, wordPseudoReductionSeq, new OrderedWordPairlist<GenPolynomial<C>>());
    }

    public WordGroebnerBasePseudoRecSeq(RingFactory<GenPolynomial<C>> ringFactory, WordPseudoReductionSeq<GenPolynomial<C>> wordPseudoReductionSeq, WordPairList<GenPolynomial<C>> wordPairList) {
        super(wordPseudoReductionSeq, wordPairList);
        this.red = wordPseudoReductionSeq;
        this.redRec = wordPseudoReductionSeq;
        this.cofac = (GenPolynomialRing)ringFactory;
        if (!this.cofac.isCommutative()) {
            logger.warn((Object)("reduction not correct for " + this.cofac.toScript()));
        }
        this.engine = GCDFactory.getImplementation(this.cofac.coFac);
    }

    @Override
    public List<GenWordPolynomial<GenPolynomial<C>>> GB(List<GenWordPolynomial<GenPolynomial<C>>> list) {
        List<GenWordPolynomial<GenPolynomial<C>>> list2 = this.normalizeZerosOnes(list);
        list2 = this.recursivePrimitivePart(list2);
        if ((list2 = this.normalizeZerosOnes(list2)).size() <= 1) {
            return list2;
        }
        GenWordPolynomialRing genWordPolynomialRing = list2.get((int)0).ring;
        if (!genWordPolynomialRing.coFac.isCommutative()) {
            throw new IllegalArgumentException("coefficient ring not commutative");
        }
        OrderedWordPairlist orderedWordPairlist = (OrderedWordPairlist)this.strategy.create(genWordPolynomialRing);
        orderedWordPairlist.put(list2);
        logger.info((Object)("start " + orderedWordPairlist));
        while (orderedWordPairlist.hasNext()) {
            List list3;
            WordPair wordPair = orderedWordPairlist.removeNext();
            if (wordPair == null) continue;
            GenWordPolynomial genWordPolynomial = wordPair.pi;
            GenWordPolynomial genWordPolynomial2 = wordPair.pj;
            if (this.debug) {
                logger.info((Object)("pi   = " + genWordPolynomial + ", pj = " + genWordPolynomial2));
            }
            if ((list3 = this.red.SPolynomials(genWordPolynomial, genWordPolynomial2)).isEmpty()) continue;
            for (GenWordPolynomial genWordPolynomial3 : list3) {
                if (genWordPolynomial3.isZERO()) continue;
                if (this.debug) {
                    logger.info((Object)("ht(S) = " + genWordPolynomial3.leadingWord()));
                }
                boolean bl = orderedWordPairlist.criterion3(wordPair.i, wordPair.j, genWordPolynomial3.leadingWord());
                AbelianGroupElem<GenWordPolynomial<C>> abelianGroupElem = this.redRec.normalformRecursive(list2, genWordPolynomial3);
                if (this.debug) {
                    logger.info((Object)("ht(H) = " + ((GenWordPolynomial)abelianGroupElem).monic()));
                }
                if (((GenWordPolynomial)abelianGroupElem).isZERO()) continue;
                if (!bl) {
                    logger.info((Object)("criterion3(" + wordPair.i + "," + wordPair.j + ") wrong: " + genWordPolynomial3.leadingWord() + " --> '" + ((GenWordPolynomial)abelianGroupElem).leadingWord() + "'"));
                }
                abelianGroupElem = this.recursivePrimitivePart((GenWordPolynomial<GenPolynomial<C>>)abelianGroupElem);
                abelianGroupElem = ((GenWordPolynomial)abelianGroupElem).abs();
                if (this.debug) {
                    logger.info((Object)("ht(H) = " + ((GenWordPolynomial)abelianGroupElem).leadingWord()));
                }
                if (((GenWordPolynomial)abelianGroupElem).isONE()) {
                    list2.clear();
                    list2.add((GenWordPolynomial<GenPolynomial<C>>)abelianGroupElem);
                    return list2;
                }
                if (this.debug) {
                    logger.info((Object)("H = " + abelianGroupElem));
                }
                if (((GenWordPolynomial)abelianGroupElem).length() <= 0) continue;
                list2.add((GenWordPolynomial<GenPolynomial<C>>)abelianGroupElem);
                orderedWordPairlist.put(abelianGroupElem);
            }
        }
        list2 = this.minimalGB(list2);
        logger.info((Object)("" + orderedWordPairlist));
        return list2;
    }

    @Override
    public List<GenWordPolynomial<GenPolynomial<C>>> minimalGB(List<GenWordPolynomial<GenPolynomial<C>>> list) {
        GenWordPolynomial genWordPolynomial;
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<GenWordPolynomial<GenPolynomial<C>>> iterable2 = new ArrayList<GenWordPolynomial<GenPolynomial<C>>>(list.size());
        for (GenWordPolynomial<GenPolynomial<C>> iterable3 : list) {
            if (iterable3 == null || iterable3.isZERO()) continue;
            iterable2.add(iterable3);
        }
        if (iterable2.size() <= 1) {
            return iterable2;
        }
        ArrayList arrayList = new ArrayList(iterable2.size());
        while (iterable2.size() > 0) {
            genWordPolynomial = (GenWordPolynomial)iterable2.remove(0);
            if (this.red.isTopReducible(iterable2, genWordPolynomial) || this.red.isTopReducible(arrayList, genWordPolynomial)) {
                if (!this.debug) continue;
                System.out.println("dropped " + genWordPolynomial);
                ArrayList<GenWordPolynomial<GenPolynomial<C>>> n = new ArrayList<GenWordPolynomial<GenPolynomial<C>>>(iterable2);
                n.addAll(arrayList);
                if ((genWordPolynomial = this.redRec.normalformRecursive(n, genWordPolynomial)).isZERO()) continue;
                System.out.println("error, nf(a) " + genWordPolynomial);
                continue;
            }
            arrayList.add(genWordPolynomial);
        }
        iterable2 = arrayList;
        if (iterable2.size() <= 1) {
            return iterable2;
        }
        Collections.reverse(iterable2);
        int n = iterable2.size();
        if (this.debug) {
            System.out.println("#G " + n);
            for (GenWordPolynomial genWordPolynomial2 : iterable2) {
                System.out.println("aa = " + genWordPolynomial2.length() + ", lt = " + genWordPolynomial2.getMap().keySet());
            }
        }
        for (int i = 0; i < n; ++i) {
            genWordPolynomial = (GenWordPolynomial)iterable2.remove(0);
            if (this.debug) {
                System.out.println("doing " + genWordPolynomial.length() + ", lt = " + genWordPolynomial.leadingWord());
            }
            genWordPolynomial = this.redRec.normalformRecursive(iterable2, genWordPolynomial);
            iterable2.add(genWordPolynomial);
        }
        return iterable2;
    }

    @Override
    public boolean isGB(List<GenWordPolynomial<GenPolynomial<C>>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            GenWordPolynomial<GenPolynomial<C>> genWordPolynomial = list.get(i);
            for (int j = 0; j < list.size(); ++j) {
                GenWordPolynomial<GenPolynomial<C>> genWordPolynomial2;
                List<GenWordPolynomial<GenPolynomial<C>>> list2;
                if (i == j || (list2 = this.red.SPolynomials(genWordPolynomial, genWordPolynomial2 = list.get(j))).isEmpty()) continue;
                for (GenWordPolynomial<GenPolynomial<C>> genWordPolynomial3 : list2) {
                    GenWordPolynomial<GenPolynomial<C>> genWordPolynomial4 = this.redRec.normalformRecursive(list, genWordPolynomial3);
                    if (genWordPolynomial4.isZERO()) continue;
                    logger.info((Object)("no GB: pi = " + genWordPolynomial + ", pj = " + genWordPolynomial2));
                    logger.info((Object)("s  = " + genWordPolynomial3 + ", h = " + genWordPolynomial4));
                    return false;
                }
            }
        }
        return true;
    }

    public GenPolynomial<C> recursiveContent(GenWordPolynomial<GenPolynomial<C>> genWordPolynomial) {
        if (genWordPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genWordPolynomial.isZERO()) {
            return (GenPolynomial)genWordPolynomial.ring.getZEROCoefficient();
        }
        GenPolynomial<C> genPolynomial = null;
        for (GenPolynomial<C> genPolynomial2 : genWordPolynomial.getMap().values()) {
            if (!(genPolynomial = genPolynomial == null ? genPolynomial2 : this.engine.gcd(genPolynomial, genPolynomial2)).isONE()) continue;
            return genPolynomial;
        }
        if (genPolynomial.signum() < 0) {
            genPolynomial = genPolynomial.negate();
        }
        return genPolynomial;
    }

    public GenWordPolynomial<GenPolynomial<C>> recursivePrimitivePart(GenWordPolynomial<GenPolynomial<C>> genWordPolynomial) {
        GenWordPolynomial<GenPolynomial<C>> genWordPolynomial2;
        if (genWordPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genWordPolynomial.isZERO()) {
            return genWordPolynomial;
        }
        GenPolynomial<C> genPolynomial = this.recursiveContent(genWordPolynomial);
        if (genPolynomial.isONE()) {
            return genWordPolynomial;
        }
        GenWordPolynomial<GenPolynomial<GenPolynomial<C>>> genWordPolynomial3 = PolyUtil.recursiveDivide(genWordPolynomial, genPolynomial);
        if (this.debug && !(genWordPolynomial2 = genWordPolynomial3.multiply(genPolynomial)).equals(genWordPolynomial)) {
            throw new ArithmeticException("pp(p)*cont(p) != p: ");
        }
        return genWordPolynomial3;
    }

    public List<GenWordPolynomial<GenPolynomial<C>>> recursivePrimitivePart(List<GenWordPolynomial<GenPolynomial<C>>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<GenWordPolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenWordPolynomial<GenPolynomial<C>>>(list.size());
        for (GenWordPolynomial<GenPolynomial<C>> genWordPolynomial : list) {
            GenWordPolynomial<GenPolynomial<C>> genWordPolynomial2 = this.recursivePrimitivePart(genWordPolynomial);
            arrayList.add(genWordPolynomial2);
        }
        return arrayList;
    }
}

