/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.BackSubstKronecker;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SubstKronecker;
import edu.jas.util.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PolyUfdUtil {
    private static final Logger logger = Logger.getLogger(PolyUfdUtil.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> integralFromQuotientCoefficients(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, GenPolynomial<Quotient<C>> genPolynomial) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return element;
        }
        GenPolynomial<Object> genPolynomial2 = null;
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        int n = 0;
        for (Quotient<C> object : genPolynomial.getMap().values()) {
            GenPolynomial genPolynomial3 = object.den;
            if (genPolynomial2 == null) {
                genPolynomial2 = genPolynomial3;
                n = genPolynomial3.signum();
                continue;
            }
            GenPolynomial genPolynomial4 = greatestCommonDivisorSubres.gcd(genPolynomial2, genPolynomial3);
            genPolynomial2 = genPolynomial2.multiply((Object)genPolynomial3.divide(genPolynomial4));
        }
        if (n < 0) {
            genPolynomial2 = genPolynomial2.negate();
        }
        for (Map.Entry entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            Quotient quotient = (Quotient)entry.getValue();
            GenPolynomial<Object> genPolynomial3 = genPolynomial2.divide(quotient.den);
            GenPolynomial<GenPolynomial<Object>> genPolynomial4 = quotient.num.multiply(genPolynomial3);
            ((GenPolynomial)element).doPutToMap(expVector, genPolynomial4);
        }
        return element;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<GenPolynomial<C>>> integralFromQuotientCoefficients(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, Collection<GenPolynomial<Quotient<C>>> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenPolynomial<GenPolynomial<C>>>(collection.size());
        for (GenPolynomial<Quotient<C>> genPolynomial : collection) {
            arrayList.add(PolyUfdUtil.integralFromQuotientCoefficients(genPolynomialRing, genPolynomial));
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Quotient<C>> quotientFromIntegralCoefficients(GenPolynomialRing<Quotient<C>> genPolynomialRing, GenPolynomial<GenPolynomial<C>> genPolynomial) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return element;
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        QuotientRing quotientRing = (QuotientRing)ringFactory;
        for (Map.Entry<ExpVector, GenPolynomial<C>> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenPolynomial<C> genPolynomial2 = entry.getValue();
            Quotient<C> quotient = new Quotient<C>(quotientRing, genPolynomial2);
            if (quotient.isZERO()) continue;
            ((GenPolynomial)element).doPutToMap(expVector, quotient);
        }
        return element;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Quotient<C>>> quotientFromIntegralCoefficients(GenPolynomialRing<Quotient<C>> genPolynomialRing, Collection<GenPolynomial<GenPolynomial<C>>> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<GenPolynomial<Quotient<C>>> arrayList = new ArrayList<GenPolynomial<Quotient<C>>>(collection.size());
        for (GenPolynomial<GenPolynomial<C>> genPolynomial : collection) {
            arrayList.add(PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, genPolynomial));
        }
        return arrayList;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> fromIntegerCoefficients(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, GenPolynomial<GenPolynomial<BigInteger>> genPolynomial) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return element;
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)ringFactory;
        for (Map.Entry<ExpVector, GenPolynomial<BigInteger>> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenPolynomial<BigInteger> genPolynomial2 = entry.getValue();
            GenPolynomial genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, genPolynomial2);
            if (genPolynomial3.isZERO()) continue;
            ((GenPolynomial)element).doPutToMap(expVector, genPolynomial3);
        }
        return element;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<GenPolynomial<C>>> fromIntegerCoefficients(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, List<GenPolynomial<GenPolynomial<BigInteger>>> list) {
        ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList = null;
        if (list == null) {
            return arrayList;
        }
        arrayList = new ArrayList<GenPolynomial<GenPolynomial<C>>>(list.size());
        if (list.size() == 0) {
            return arrayList;
        }
        for (GenPolynomial<GenPolynomial<BigInteger>> genPolynomial : list) {
            GenPolynomial<GenPolynomial<C>> genPolynomial2 = PolyUfdUtil.fromIntegerCoefficients(genPolynomialRing, genPolynomial);
            arrayList.add(genPolynomial2);
        }
        return arrayList;
    }

    public static GenPolynomial<GenPolynomial<BigInteger>> integerFromRationalCoefficients(GenPolynomialRing<GenPolynomial<BigInteger>> genPolynomialRing, GenPolynomial<GenPolynomial<BigRational>> genPolynomial) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return element;
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)ringFactory;
        for (Map.Entry<ExpVector, GenPolynomial<BigRational>> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenPolynomial<BigRational> genPolynomial2 = entry.getValue();
            GenPolynomial<BigInteger> genPolynomial3 = PolyUtil.integerFromRationalCoefficients((GenPolynomialRing<BigInteger>)genPolynomialRing2, genPolynomial2);
            if (genPolynomial3.isZERO()) continue;
            ((GenPolynomial)element).doPutToMap(expVector, genPolynomial3);
        }
        return element;
    }

    public static List<GenPolynomial<GenPolynomial<BigInteger>>> integerFromRationalCoefficients(GenPolynomialRing<GenPolynomial<BigInteger>> genPolynomialRing, List<GenPolynomial<GenPolynomial<BigRational>>> list) {
        ArrayList<GenPolynomial<GenPolynomial<BigInteger>>> arrayList = new ArrayList<GenPolynomial<GenPolynomial<BigInteger>>>(list.size());
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        for (GenPolynomial<GenPolynomial<BigRational>> genPolynomial : list) {
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial2 = PolyUfdUtil.integerFromRationalCoefficients(genPolynomialRing, genPolynomial);
            arrayList.add(genPolynomial2);
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> introduceLowerVariable(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomialRing == null) {
            return null;
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = ((GenPolynomial)genPolynomialRing.getONE()).multiply(genPolynomial);
        if (genPolynomial2.isZERO()) {
            return genPolynomial2;
        }
        genPolynomial2 = PolyUtil.switchVariables(genPolynomial2);
        return genPolynomial2;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> substituteFromAlgebraicCoefficients(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, GenPolynomial<AlgebraicNumber<C>> genPolynomial, long l) {
        if (genPolynomial == null || genPolynomialRing == null) {
            return null;
        }
        if (genPolynomial.isZERO()) {
            return genPolynomialRing.getZERO();
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomial.ring;
        GenPolynomial genPolynomial2 = genPolynomialRing2.univariate(0);
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomial.ring.coFac;
        AlgebraicNumber algebraicNumber = algebraicNumberRing.getGenerator();
        Element element = algebraicNumberRing.fromInteger(l);
        GenPolynomial genPolynomial3 = genPolynomial2.subtract(((AlgebraicNumber)element).multiply(algebraicNumber));
        if (debug) {
            logger.info((Object)("x - k alpha: " + genPolynomial3));
        }
        GenPolynomial genPolynomial4 = PolyUtil.substituteMain(genPolynomial, genPolynomial3);
        GenPolynomial<GenPolynomial<C>> genPolynomial5 = PolyUtil.fromAlgebraicCoefficients(genPolynomialRing, genPolynomial4);
        genPolynomial5 = PolyUtil.switchVariables(genPolynomial5);
        return genPolynomial5;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> substituteConvertToAlgebraicCoefficients(GenPolynomialRing<AlgebraicNumber<C>> genPolynomialRing, GenPolynomial<C> genPolynomial, long l) {
        if (genPolynomial == null || genPolynomialRing == null) {
            return null;
        }
        if (genPolynomial.isZERO()) {
            return genPolynomialRing.getZERO();
        }
        GenPolynomial<AlgebraicNumber<C>> genPolynomial2 = PolyUtil.convertToAlgebraicCoefficients(genPolynomialRing, genPolynomial);
        GenPolynomial genPolynomial3 = genPolynomialRing.univariate(0);
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.coFac;
        AlgebraicNumber algebraicNumber = algebraicNumberRing.getGenerator();
        Element element = algebraicNumberRing.fromInteger(l);
        GenPolynomial genPolynomial4 = genPolynomial3.sum(((AlgebraicNumber)element).multiply(algebraicNumber));
        GenPolynomial<AlgebraicNumber<C>> genPolynomial5 = PolyUtil.substituteMain(genPolynomial2, genPolynomial4);
        return genPolynomial5;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> norm(GenPolynomial<AlgebraicNumber<C>> genPolynomial, long l) {
        if (genPolynomial == null) {
            return null;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.coFac;
        GenPolynomial genPolynomial2 = algebraicNumberRing.modul;
        GenPolynomialRing genPolynomialRing2 = algebraicNumberRing.ring;
        if (genPolynomial.isZERO()) {
            return genPolynomialRing2.getZERO();
        }
        AlgebraicNumber<C> algebraicNumber = genPolynomial.leadingBaseCoefficient();
        if (!algebraicNumber.isONE()) {
            genPolynomial = genPolynomial.monic();
        }
        GenPolynomialRing<GenPolynomial<C>> genPolynomialRing3 = new GenPolynomialRing<GenPolynomial<C>>(genPolynomialRing2, genPolynomialRing);
        GenPolynomial<GenPolynomial<C>> genPolynomial3 = PolyUfdUtil.introduceLowerVariable(genPolynomialRing3, genPolynomial2);
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = PolyUfdUtil.substituteFromAlgebraicCoefficients(genPolynomialRing3, genPolynomial, l);
        genPolynomial4 = PolyUtil.monic(genPolynomial4);
        GreatestCommonDivisorSubres<C> greatestCommonDivisorSubres = new GreatestCommonDivisorSubres<C>();
        GenPolynomial genPolynomial5 = greatestCommonDivisorSubres.recursiveUnivariateResultant(genPolynomial4, genPolynomial3);
        GenPolynomial genPolynomial6 = genPolynomial5.leadingBaseCoefficient();
        genPolynomial6 = genPolynomial6.monic();
        return genPolynomial6;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> norm(GenPolynomial<AlgebraicNumber<C>> genPolynomial) {
        return PolyUfdUtil.norm(genPolynomial, 0L);
    }

    public static <C extends GcdRingElem<C>> void ensureFieldProperty(AlgebraicNumberRing<C> algebraicNumberRing) {
        if (algebraicNumberRing.getField() != -1) {
            return;
        }
        if (!algebraicNumberRing.ring.coFac.isField()) {
            algebraicNumberRing.setField(false);
            return;
        }
        FactorAbstract factorAbstract = FactorFactory.getImplementation(algebraicNumberRing.ring);
        if (factorAbstract.isIrreducible(algebraicNumberRing.modul)) {
            algebraicNumberRing.setField(true);
        } else {
            algebraicNumberRing.setField(false);
        }
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> substituteKronecker(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return genPolynomial;
        }
        long l = genPolynomial.degree() + 1L;
        return PolyUfdUtil.substituteKronecker(genPolynomial, l);
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> substituteKronecker(GenPolynomial<C> genPolynomial, long l) {
        if (genPolynomial == null) {
            return genPolynomial;
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(ringFactory, 1);
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial.isZERO()) {
            return element;
        }
        for (Map.Entry<ExpVector, C> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GcdRingElem gcdRingElem = (GcdRingElem)entry.getValue();
            long l2 = 0L;
            long l3 = 1L;
            for (int i = 0; i < expVector.length(); ++i) {
                long l4 = expVector.getVal(i) * l3;
                l2 += l4;
                l3 *= l;
            }
            ExpVector expVector2 = ExpVector.create(1, 0, l2);
            ((GenPolynomial)element).doPutToMap(expVector2, gcdRingElem);
        }
        return element;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<C>> substituteKronecker(List<GenPolynomial<C>> list, int n) {
        if (list == null || list.get(0) == null) {
            return null;
        }
        return ListUtil.map(list, new SubstKronecker(n));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> backSubstituteKronecker(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<C> genPolynomial, long l) {
        if (genPolynomial == null) {
            return genPolynomial;
        }
        if (genPolynomialRing == null) {
            throw new IllegalArgumentException("null factory not allowed ");
        }
        int n = genPolynomialRing.nvar;
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial.isZERO()) {
            return element;
        }
        for (Map.Entry<ExpVector, C> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GcdRingElem gcdRingElem = (GcdRingElem)entry.getValue();
            long l2 = expVector.getVal(0);
            ExpVector expVector2 = ExpVector.create(n);
            for (int i = 0; i < n; ++i) {
                long l3 = l2 % l;
                l2 /= l;
                expVector2 = expVector2.subst(i, l3);
            }
            ((GenPolynomial)element).doPutToMap(expVector2, gcdRingElem);
        }
        return element;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<C>> backSubstituteKronecker(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list, long l) {
        return ListUtil.map(list, new BackSubstKronecker<C>(genPolynomialRing, l));
    }
}

