/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.fd.FDUtil;
import edu.jas.gbmod.QuotSolvablePolynomialRing;
import edu.jas.gbmod.SolvableQuotientRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelationsIterated;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class FDUtilTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenSolvablePolynomialRing<BigInteger> dfac;
    GenSolvablePolynomialRing<BigRational> rdfac;
    GenSolvablePolynomialRing<GenPolynomial<BigInteger>> rfac;
    GenSolvablePolynomialRing<GenPolynomial<BigRational>> rrfac;
    RecSolvablePolynomialRing<BigRational> rrfacTemp;
    GenSolvablePolynomial<BigInteger> a;
    GenSolvablePolynomial<BigInteger> b;
    GenSolvablePolynomial<BigInteger> c;
    GenSolvablePolynomial<BigInteger> d;
    GenSolvablePolynomial<BigInteger> e;
    GenSolvablePolynomial<BigInteger> f;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> ar;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> br;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> cr;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> dr;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> er;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> fr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> arr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> brr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> crr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> drr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> err;
    GenSolvablePolynomial<GenPolynomial<BigRational>> frr;
    int rl = 4;
    int kl = 3;
    int ll = 4;
    int el = 3;
    float q = 0.35f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)FDUtilTest.suite());
    }

    public FDUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FDUtilTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        this.dfac = new GenSolvablePolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = this.dfac.recursive(1);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.rfac = null;
    }

    public void testBasePseudoDivision() {
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenSolvablePolynomialRing<BigInteger>(new BigInteger(1L), this.to, stringArray);
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.dfac);
        this.a = this.dfac.random(this.kl, 2 * this.ll, this.el + 17, this.q);
        this.b = this.dfac.random(this.kl, 2 * this.ll, this.el + 3, this.q);
        if (this.b.isZERO()) {
            this.b = this.dfac.parse(" 2 x^2 + 40 ");
        }
        GenPolynomial<BigInteger>[] genPolynomialArray = PolyUtil.basePseudoQuotientRemainder(this.a, this.b);
        this.c = (GenSolvablePolynomial)genPolynomialArray[0];
        this.d = (GenSolvablePolynomial)genPolynomialArray[1];
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this.c.multiply((BigInteger)((Object)this.b)).sum(this.d);
        FDUtilTest.assertTrue((String)"nonsense", (!genSolvablePolynomial.isZERO() ? 1 : 0) != 0);
        boolean bl = PolyUtil.isBasePseudoQuotientRemainder(this.a, this.b, this.c, this.d);
        FDUtilTest.assertTrue((String)("lc^n a = q b + r: " + this.d), (boolean)bl);
        GenSolvablePolynomial<BigInteger>[] genSolvablePolynomialArray = FDUtil.leftBasePseudoQuotientRemainder(this.a, this.b);
        this.e = genSolvablePolynomialArray[0];
        this.f = genSolvablePolynomialArray[1];
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)this.e.multiply((BigInteger)((Object)this.b)).sum(this.f);
        FDUtilTest.assertTrue((String)"nonsense", (!genSolvablePolynomial2.isZERO() ? 1 : 0) != 0);
        bl = PolyUtil.isBasePseudoQuotientRemainder(this.a, this.b, this.e, this.f);
        FDUtilTest.assertTrue((String)("ore(lc^n) a = q b + r: " + this.f), (boolean)bl);
        GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)PolyUtil.fromIntegerCoefficients(genSolvablePolynomialRing, this.a);
        GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)PolyUtil.fromIntegerCoefficients(genSolvablePolynomialRing, this.b);
        GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)PolyUtil.fromIntegerCoefficients(genSolvablePolynomialRing, this.c);
        GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)PolyUtil.fromIntegerCoefficients(genSolvablePolynomialRing, this.d);
        GenSolvablePolynomial genSolvablePolynomial7 = (GenSolvablePolynomial)PolyUtil.fromIntegerCoefficients(genSolvablePolynomialRing, this.e);
        GenSolvablePolynomial genSolvablePolynomial8 = (GenSolvablePolynomial)PolyUtil.fromIntegerCoefficients(genSolvablePolynomialRing, this.f);
        GenSolvablePolynomial genSolvablePolynomial9 = (GenSolvablePolynomial)genSolvablePolynomial3.divide(genSolvablePolynomial4);
        GenSolvablePolynomial genSolvablePolynomial10 = (GenSolvablePolynomial)genSolvablePolynomial3.remainder(genSolvablePolynomial4);
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray2 = genSolvablePolynomial3.quotientRemainder(genSolvablePolynomial4);
        FDUtilTest.assertEquals((String)"qp == QRr[0]: ", (Object)genSolvablePolynomial9, genSolvablePolynomialArray2[0]);
        FDUtilTest.assertEquals((String)"rp == QRr[1]: ", (Object)genSolvablePolynomial10, genSolvablePolynomialArray2[1]);
        GenSolvablePolynomial genSolvablePolynomial11 = (GenSolvablePolynomial)genSolvablePolynomial9.multiply(genSolvablePolynomial4).sum(genSolvablePolynomial10);
        FDUtilTest.assertEquals((String)"ap == qp bp + rp: ", (Object)genSolvablePolynomial3, (Object)genSolvablePolynomial11);
        FDUtilTest.assertEquals((String)"cp == qp: ", (Object)genSolvablePolynomial9.monic(), (Object)genSolvablePolynomial5.monic());
        FDUtilTest.assertEquals((String)"dp == rp: ", (Object)genSolvablePolynomial10.monic(), (Object)genSolvablePolynomial6.monic());
        FDUtilTest.assertEquals((String)"ep == qp: ", (Object)genSolvablePolynomial7.monic(), (Object)genSolvablePolynomial5.monic());
        FDUtilTest.assertEquals((String)"fp == rp: ", (Object)genSolvablePolynomial8.monic(), (Object)genSolvablePolynomial6.monic());
    }

    public void testRecursivePseudoDivision() {
        String[] stringArray = new String[]{"t", "x", "y", "z"};
        this.rdfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated);
        this.rrfacTemp = (RecSolvablePolynomialRing)this.rdfac.recursive(1);
        this.rrfac = this.rrfacTemp;
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)this.rrfac.coFac;
        SolvableQuotientRing solvableQuotientRing = new SolvableQuotientRing(genSolvablePolynomialRing);
        QuotSolvablePolynomialRing quotSolvablePolynomialRing = new QuotSolvablePolynomialRing(solvableQuotientRing, this.rrfac);
        List list = this.rrfacTemp.coeffTable.relationList();
        List list2 = PolynomialList.castToList(list);
        quotSolvablePolynomialRing.polCoeff.coeffTable.addRelations(list2);
        this.kl = 1;
        this.ll = 3;
        this.arr = this.rrfac.random(this.kl, this.ll, this.el, this.q);
        this.brr = this.rrfac.random(this.kl, this.ll, this.el, this.q);
        if (this.brr.isZERO()) {
            this.brr = this.rrfac.parse(" ( x - 2 ) z - ( t - y^2 + y ) ");
        }
        this.drr = FDUtil.recursivePseudoQuotient(this.arr, this.brr);
        this.crr = FDUtil.recursiveSparsePseudoRemainder(this.arr, this.brr);
        GenSolvablePolynomial<GenPolynomial<C>>[] genSolvablePolynomialArray = FDUtil.recursivePseudoQuotientRemainder(this.arr, this.brr);
        FDUtilTest.assertEquals((String)"drr == QR[0]: ", this.drr, genSolvablePolynomialArray[0]);
        FDUtilTest.assertEquals((String)"crr == QR[1]: ", this.crr, genSolvablePolynomialArray[1]);
        boolean bl = FDUtil.isRecursivePseudoQuotientRemainder(this.arr, this.brr, this.drr, this.crr);
        FDUtilTest.assertTrue((String)("ore(lc^n) a = q b + r: " + this.crr), (boolean)bl);
        GenSolvablePolynomial genSolvablePolynomial = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.arr);
        GenSolvablePolynomial genSolvablePolynomial2 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.brr);
        GenSolvablePolynomial genSolvablePolynomial3 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.crr);
        GenSolvablePolynomial genSolvablePolynomial4 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.drr);
        GenPolynomial genPolynomial = genSolvablePolynomial.monic();
        GenPolynomial genPolynomial2 = genSolvablePolynomial2.monic();
        GenPolynomial genPolynomial3 = genSolvablePolynomial3.monic();
        GenPolynomial genPolynomial4 = genSolvablePolynomial4.monic();
        GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)genSolvablePolynomial.divide(genSolvablePolynomial2);
        GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)genSolvablePolynomial.remainder(genSolvablePolynomial2);
        GenPolynomial genPolynomial5 = genSolvablePolynomial5.monic();
        GenPolynomial genPolynomial6 = genSolvablePolynomial6.monic();
        GenSolvablePolynomial genSolvablePolynomial7 = (GenSolvablePolynomial)genSolvablePolynomial5.multiply(genSolvablePolynomial2).sum(genSolvablePolynomial6);
        GenPolynomial genPolynomial7 = genSolvablePolynomial7.monic();
        FDUtilTest.assertEquals((String)"ap == qp bp + rp: ", genSolvablePolynomial, (Object)genSolvablePolynomial7);
        FDUtilTest.assertEquals((String)"cpm == rpm: ", (Object)genPolynomial6, (Object)genPolynomial3);
        FDUtilTest.assertEquals((String)"dpm == qpm: ", (Object)genPolynomial5, (Object)genPolynomial4);
        FDUtilTest.assertEquals((String)"nonsense", (Object)genPolynomial, (Object)genSolvablePolynomial.monic());
        FDUtilTest.assertEquals((String)"nonsense", (Object)genPolynomial2, (Object)genSolvablePolynomial2.monic());
        FDUtilTest.assertEquals((String)"nonsense", (Object)genPolynomial7, (Object)((GenSolvablePolynomial)genPolynomial7).monic());
    }

    public void testLeftAndRightRecursiveDivision() {
        String[] stringArray = new String[]{"y", "z"};
        this.rdfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated);
        this.rrfac = this.rdfac.recursive(1);
        this.kl = 3;
        this.ll = 5;
        this.el = 6;
        this.arr = this.rrfac.random(this.kl, this.ll, this.el + 1, this.q);
        this.brr = this.rrfac.random(this.kl, this.ll, this.el, this.q);
        this.drr = FDUtil.recursivePseudoQuotient(this.arr, this.brr);
        this.crr = FDUtil.recursiveSparsePseudoRemainder(this.arr, this.brr);
        GenSolvablePolynomial<GenPolynomial<C>>[] genSolvablePolynomialArray = FDUtil.recursivePseudoQuotientRemainder(this.arr, this.brr);
        FDUtilTest.assertEquals((String)"drr == QR[0]: ", this.drr, genSolvablePolynomialArray[0]);
        FDUtilTest.assertEquals((String)"crr == QR[1]: ", this.crr, genSolvablePolynomialArray[1]);
        boolean bl = FDUtil.isRecursivePseudoQuotientRemainder(this.arr, this.brr, this.drr, this.crr);
        FDUtilTest.assertTrue((String)("ore(lc^n) a = q b + r: " + this.crr), (boolean)bl);
        genSolvablePolynomialArray = FDUtil.recursiveRightPseudoQuotientRemainder(this.arr, this.brr);
        this.drr = genSolvablePolynomialArray[0];
        this.crr = genSolvablePolynomialArray[1];
        bl = FDUtil.isRecursiveRightPseudoQuotientRemainder(this.arr, this.brr, this.drr, this.crr);
        FDUtilTest.assertTrue((String)("a ore(lc^n) = b q + r: " + this.crr), (boolean)bl);
    }

    public void testRightRecursivePolynomial() {
        String[] stringArray = new String[]{"y", "z"};
        this.rdfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated);
        this.rrfac = this.rdfac.recursive(1);
        this.kl = 5;
        this.ll = 5;
        this.el = 7;
        this.arr = this.rrfac.random(this.kl, this.ll, this.el, this.q);
        this.brr = this.arr.rightRecursivePolynomial();
        boolean bl = this.arr.isRightRecursivePolynomial(this.brr);
        FDUtilTest.assertTrue((String)"arr == eval(brr): ", (boolean)bl);
    }
}

