/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigRational;
import edu.jas.fd.FDUtil;
import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.fd.GreatestCommonDivisorSimple;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gbmod.QuotSolvablePolynomialRing;
import edu.jas.gbmod.SolvableQuotientRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelationsIterated;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GCDSimpleTest
extends TestCase {
    GreatestCommonDivisorAbstract<BigRational> fd;
    TermOrder to = new TermOrder(2);
    GenSolvablePolynomialRing<BigRational> dfac;
    RecSolvablePolynomialRing<BigRational> rfac;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    GenSolvablePolynomial<GenPolynomial<BigRational>> ar;
    GenSolvablePolynomial<GenPolynomial<BigRational>> br;
    GenSolvablePolynomial<GenPolynomial<BigRational>> cr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> dr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> er;
    int rl = 4;
    int kl = 2;
    int ll = 2;
    int el = 3;
    float q = 0.25f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GCDSimpleTest.suite());
    }

    public GCDSimpleTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDSimpleTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        BigRational bigRational = new BigRational(1L);
        this.fd = new GreatestCommonDivisorSimple<BigRational>(bigRational);
        this.dfac = new GenSolvablePolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(1);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.fd = null;
        this.dfac = null;
        this.rfac = null;
    }

    public void xtestBaseGcdSimple() {
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), 1, this.to, stringArray);
        for (int i = 0; i < 3; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2, this.q);
            this.b = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + 2, this.q);
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 1, this.el + 1, this.q);
            this.c = this.c.multiply((BigRational)((Object)this.dfac.univariate(0)));
            if (this.c.isZERO()) continue;
            this.a = this.a.multiply((BigRational)((Object)this.c));
            this.b = this.b.multiply((BigRational)((Object)this.c));
            this.d = this.fd.leftBaseGcd(this.a, this.b);
            this.e = (GenSolvablePolynomial)PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            this.e = (GenSolvablePolynomial)PolyUtil.basePseudoRemainder(this.a, this.d);
            GCDSimpleTest.assertTrue((String)("gcd(a,b) | a " + this.e), (boolean)this.e.isZERO());
            this.e = (GenSolvablePolynomial)PolyUtil.basePseudoRemainder(this.b, this.d);
            GCDSimpleTest.assertTrue((String)("gcd(a,b) | b " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void xtestRecursiveLeftGCDSimple() {
        String[] stringArray = new String[]{"a", "b"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        System.out.println("dfac = " + this.dfac.toScript());
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(1);
        System.out.println("rfac = " + this.rfac.toScript());
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing = this.rfac;
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing2 = this.rfac;
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)this.rfac.coFac;
        SolvableQuotientRing solvableQuotientRing = new SolvableQuotientRing(genSolvablePolynomialRing);
        QuotSolvablePolynomialRing quotSolvablePolynomialRing = new QuotSolvablePolynomialRing(solvableQuotientRing, recSolvablePolynomialRing2);
        List list = recSolvablePolynomialRing.coeffTable.relationList();
        List list2 = PolynomialList.castToList(list);
        quotSolvablePolynomialRing.polCoeff.coeffTable.addRelations(list2);
        this.ll = 3;
        this.el = 3;
        this.ar = this.rfac.random(this.kl, this.ll, this.el + 1, this.q);
        this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = (RecSolvablePolynomial)PolyUtil.monic(this.cr);
        if (this.cr.isZERO()) {
            this.cr = this.rfac.getONE();
        }
        this.ar = this.ar.multiply((GenPolynomial<BigRational>)this.cr);
        this.br = this.br.multiply((GenPolynomial<BigRational>)this.cr);
        this.dr = this.fd.leftRecursiveUnivariateGcd(this.ar, this.br);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.dr, this.cr);
        GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.ar, this.dr);
        GCDSimpleTest.assertTrue((String)("gcd(a,b) | a " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.br, this.dr);
        GCDSimpleTest.assertTrue((String)("gcd(a,b) | b " + this.er), (boolean)this.er.isZERO());
        GenSolvablePolynomial genSolvablePolynomial = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.ar);
        GenSolvablePolynomial genSolvablePolynomial2 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.br);
        GenSolvablePolynomial genSolvablePolynomial3 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.cr);
        GenSolvablePolynomial genSolvablePolynomial4 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.dr);
        GenPolynomial genPolynomial = genSolvablePolynomial.monic();
        GenPolynomial genPolynomial2 = genSolvablePolynomial2.monic();
        GenPolynomial genPolynomial3 = genSolvablePolynomial3.monic();
        GenPolynomial genPolynomial4 = genSolvablePolynomial4.monic();
        System.out.println("ap  = " + genSolvablePolynomial);
        System.out.println("apm = " + genPolynomial);
        System.out.println("bp  = " + genSolvablePolynomial2);
        System.out.println("bpm = " + genPolynomial2);
        System.out.println("cp  = " + genSolvablePolynomial3);
        System.out.println("cpm = " + genPolynomial3);
        System.out.println("dp  = " + genSolvablePolynomial4);
        System.out.println("dpm = " + genPolynomial4);
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple(solvableQuotientRing);
        GenSolvablePolynomial genSolvablePolynomial5 = ((GreatestCommonDivisorAbstract)greatestCommonDivisorSimple).leftBaseGcd(genSolvablePolynomial, genSolvablePolynomial2);
        GenPolynomial genPolynomial5 = genSolvablePolynomial5.monic();
        System.out.println("gp  = " + genSolvablePolynomial5);
        System.out.println("gpm = " + genPolynomial5);
        GenSolvablePolynomial genSolvablePolynomial6 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial5, genSolvablePolynomial4);
        GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc): " + genSolvablePolynomial6), (boolean)genSolvablePolynomial6.isZERO());
        genSolvablePolynomial6 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial, genSolvablePolynomial5);
        GCDSimpleTest.assertTrue((String)("gcd(ac,bc)| ac): " + genSolvablePolynomial6), (boolean)genSolvablePolynomial6.isZERO());
        genSolvablePolynomial6 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial2, genSolvablePolynomial5);
        GCDSimpleTest.assertTrue((String)("gcd(ac,bc)| bc): " + genSolvablePolynomial6), (boolean)genSolvablePolynomial6.isZERO());
    }

    public void xtestRecursiveRightGCDSimple() {
        String[] stringArray = new String[]{"a", "b"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        System.out.println("dfac = " + this.dfac.toScript());
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(1);
        System.out.println("rfac = " + this.rfac.toScript());
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing = this.rfac;
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing2 = this.rfac;
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)this.rfac.coFac;
        SolvableQuotientRing solvableQuotientRing = new SolvableQuotientRing(genSolvablePolynomialRing);
        QuotSolvablePolynomialRing quotSolvablePolynomialRing = new QuotSolvablePolynomialRing(solvableQuotientRing, recSolvablePolynomialRing2);
        List list = recSolvablePolynomialRing.coeffTable.relationList();
        List list2 = PolynomialList.castToList(list);
        quotSolvablePolynomialRing.polCoeff.coeffTable.addRelations(list2);
        this.ll = 3;
        this.el = 3;
        this.ar = this.rfac.random(this.kl, this.ll, this.el + 1, this.q);
        this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = (RecSolvablePolynomial)PolyUtil.monic(this.cr);
        System.out.println("ar = " + this.ar);
        System.out.println("br = " + this.br);
        System.out.println("cr = " + this.cr);
        if (this.cr.isZERO()) {
            this.cr = this.rfac.getONE();
        }
        this.ar = this.cr.multiply((GenPolynomial<BigRational>)this.ar);
        this.br = this.cr.multiply((GenPolynomial<BigRational>)this.br);
        System.out.println("ar = " + this.ar);
        System.out.println("br = " + this.br);
        this.dr = this.fd.rightRecursiveUnivariateGcd(this.ar, this.br);
        System.out.println("cr = " + this.cr);
        System.out.println("dr = " + this.dr);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.dr, this.cr);
        GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.ar, this.dr);
        GCDSimpleTest.assertTrue((String)("gcd(a,b) | a " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.br, this.dr);
        GCDSimpleTest.assertTrue((String)("gcd(a,b) | b " + this.er), (boolean)this.er.isZERO());
    }

    public void testArbitraryRecursiveGCDSimple() {
        String[] stringArray = new String[]{"a", "b"};
        String[] stringArray2 = new String[]{"c"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = new RecSolvablePolynomialRing(this.dfac, this.to, stringArray2);
        this.el = 2;
        this.ar = this.rfac.parse("( a * b^2 + 1/2 b - 1/6 a^2 )");
        this.br = this.rfac.parse("( b^2 - 1/5 )");
        this.cr = this.rfac.parse("c + 3/13 a");
        this.cr = (RecSolvablePolynomial)this.cr.monic();
        if (this.cr.isZERO()) {
            this.cr = this.rfac.getONE();
        }
        this.ar = this.ar.multiply((GenPolynomial<BigRational>)this.cr);
        this.br = this.br.multiply((GenPolynomial<BigRational>)this.cr);
        this.dr = this.fd.leftRecursiveGcd(this.ar, this.br);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.dr, this.cr);
        GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.ar, this.dr);
        GCDSimpleTest.assertTrue((String)("gcd(a,b) | a " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.br, this.dr);
        GCDSimpleTest.assertTrue((String)("gcd(a,b) | b " + this.er), (boolean)this.er.isZERO());
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing = this.rfac;
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing2 = this.rfac;
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)this.rfac.coFac;
        SolvableQuotientRing solvableQuotientRing = new SolvableQuotientRing(genSolvablePolynomialRing);
        QuotSolvablePolynomialRing quotSolvablePolynomialRing = new QuotSolvablePolynomialRing(solvableQuotientRing, recSolvablePolynomialRing2);
        List list = recSolvablePolynomialRing.coeffTable.relationList();
        List list2 = PolynomialList.castToList(list);
        quotSolvablePolynomialRing.polCoeff.coeffTable.addRelations(list2);
        GenSolvablePolynomial genSolvablePolynomial = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.ar);
        GenSolvablePolynomial genSolvablePolynomial2 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.br);
        GenSolvablePolynomial genSolvablePolynomial3 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.cr);
        GenSolvablePolynomial genSolvablePolynomial4 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.dr);
        GenPolynomial genPolynomial = genSolvablePolynomial.monic();
        GenPolynomial genPolynomial2 = genSolvablePolynomial2.monic();
        GenPolynomial genPolynomial3 = genSolvablePolynomial3.monic();
        GenPolynomial genPolynomial4 = genSolvablePolynomial4.monic();
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple(solvableQuotientRing);
        GenSolvablePolynomial genSolvablePolynomial5 = ((GreatestCommonDivisorAbstract)greatestCommonDivisorSimple).leftBaseGcd(genSolvablePolynomial, genSolvablePolynomial2);
        GenPolynomial genPolynomial5 = genSolvablePolynomial5.monic();
        GenSolvablePolynomial genSolvablePolynomial6 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial5, genSolvablePolynomial4);
        GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc): " + genSolvablePolynomial6), (boolean)genSolvablePolynomial6.isZERO());
        genSolvablePolynomial6 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial, genSolvablePolynomial5);
        GCDSimpleTest.assertTrue((String)("gcd(ac,bc)| ac): " + genSolvablePolynomial6), (boolean)genSolvablePolynomial6.isZERO());
        genSolvablePolynomial6 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial2, genSolvablePolynomial5);
        GCDSimpleTest.assertTrue((String)("gcd(ac,bc)| bc): " + genSolvablePolynomial6), (boolean)genSolvablePolynomial6.isZERO());
        GCDSimpleTest.assertEquals((String)"nonsense", (Object)genPolynomial, (Object)genSolvablePolynomial.monic());
        GCDSimpleTest.assertEquals((String)"nonsense", (Object)genPolynomial2, (Object)genSolvablePolynomial2.monic());
        GCDSimpleTest.assertEquals((String)"nonsense", (Object)genPolynomial3, (Object)genSolvablePolynomial3.monic());
        GCDSimpleTest.assertEquals((String)"nonsense", (Object)genPolynomial4, (Object)genSolvablePolynomial4.monic());
        GCDSimpleTest.assertEquals((String)"nonsense", (Object)genPolynomial5, (Object)genSolvablePolynomial5.monic());
    }

    public void xtestGCDSimple() {
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        System.out.println("dfac = " + this.dfac.toScript());
        this.ll = 4;
        this.el = 4;
        this.a = this.dfac.parse("b^3 - 1/6 + d");
        this.b = this.dfac.parse("b + 3 a^2 + d");
        this.c = this.dfac.parse("c - a - b");
        this.c = this.c.monic();
        if (this.c.isZERO()) {
            this.c = this.dfac.getONE();
        }
        System.out.println("a = " + this.a);
        System.out.println("b = " + this.b);
        System.out.println("c = " + this.c);
        this.a = this.a.multiply((BigRational)((Object)this.c));
        this.b = this.b.multiply((BigRational)((Object)this.c));
        System.out.println("a = " + this.a);
        System.out.println("b = " + this.b);
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.a);
        arrayList.add(this.b);
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        List list = solvableGroebnerBaseSeq.leftGB(arrayList);
        System.out.println("leftGB = " + list);
        this.d = this.fd.leftGcd(this.a, this.b);
        System.out.println("gb = " + list);
        System.out.println("c  = " + this.c);
        System.out.println("d  = " + this.d);
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.d, this.c);
        System.out.println("e = " + this.e);
        GCDSimpleTest.assertTrue((String)("c | gcd(ac,bc): " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.a, this.c);
        System.out.println("e = " + this.e);
        GCDSimpleTest.assertTrue((String)("c | ac: " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.b, this.c);
        System.out.println("e = " + this.e);
        GCDSimpleTest.assertTrue((String)("c | bc: " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.a, this.d);
        System.out.println("e = " + this.e);
        GCDSimpleTest.assertTrue((String)("gcd(a,b) | a: " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.b, this.d);
        System.out.println("e = " + this.e);
        GCDSimpleTest.assertTrue((String)("gcd(a,b) | b: " + this.e), (boolean)this.e.isZERO());
    }
}

