/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import java.util.ArrayList;
import java.util.List;

public final class ExpVectorInteger
extends ExpVector {
    final int[] val;
    public static final long maxInt = 0x3FFFFFFFL;
    public static final long minInt = -1073741824L;

    public ExpVectorInteger(int n) {
        this(new int[n]);
    }

    public ExpVectorInteger(int n, int n2, int n3) {
        this(n);
        this.val[n2] = n3;
    }

    public ExpVectorInteger(int n, int n2, long l) {
        this(n);
        if (l >= 0x3FFFFFFFL || l <= -1073741824L) {
            throw new IllegalArgumentException("exponent to large: " + l);
        }
        this.val[n2] = (int)l;
    }

    protected ExpVectorInteger(int[] nArray) {
        this.val = nArray;
    }

    public ExpVectorInteger(long[] lArray) {
        this(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] >= 0x3FFFFFFFL || lArray[i] <= -1073741824L) {
                throw new IllegalArgumentException("exponent to large: " + lArray[i]);
            }
            this.val[i] = (int)lArray[i];
        }
    }

    public ExpVectorInteger(String string) throws NumberFormatException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        string = string.trim();
        int n = string.indexOf(40);
        int n2 = string.indexOf(41, n + 1);
        if (n >= 0 && n2 >= 0) {
            int n3;
            String string2;
            int n4;
            ++n;
            while ((n4 = string.indexOf(44, n)) >= 0) {
                string2 = string.substring(n, n4);
                n3 = Integer.parseInt(string2);
                arrayList.add(n3);
                n = n4 + 1;
            }
            if (n <= n2) {
                string2 = string.substring(n, n2);
                n3 = Integer.parseInt(string2);
                arrayList.add(n3);
            }
            int n5 = arrayList.size();
            this.val = new int[n5];
            for (int i = 0; i < n5; ++i) {
                this.val[i] = (Integer)arrayList.get(i);
            }
        } else {
            this.val = null;
        }
    }

    @Override
    public ExpVectorInteger copy() {
        int[] nArray = new int[this.val.length];
        System.arraycopy(this.val, 0, nArray, 0, this.val.length);
        return new ExpVectorInteger(nArray);
    }

    @Override
    long[] getVal() {
        long[] lArray = new long[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            lArray[i] = this.val[i];
        }
        return lArray;
    }

    @Override
    public long getVal(int n) {
        return this.val[n];
    }

    @Override
    protected long setVal(int n, long l) {
        int n2 = this.val[n];
        if (l >= 0x3FFFFFFFL || l <= -1073741824L) {
            throw new IllegalArgumentException("exponent to large: " + l);
        }
        this.val[n] = (int)l;
        this.hash = 0;
        return n2;
    }

    protected int setVal(int n, int n2) {
        int n3 = this.val[n];
        this.val[n] = n2;
        this.hash = 0;
        return n3;
    }

    @Override
    public int length() {
        return this.val.length;
    }

    @Override
    public ExpVectorInteger extend(int n, int n2, long l) {
        int[] nArray = new int[this.val.length + n];
        System.arraycopy(this.val, 0, nArray, n, this.val.length);
        if (n2 >= n) {
            throw new IllegalArgumentException("i " + n + " <= j " + n2 + " invalid");
        }
        if (l >= 0x3FFFFFFFL || l <= -1073741824L) {
            throw new IllegalArgumentException("exponent to large: " + l);
        }
        nArray[n2] = (int)l;
        return new ExpVectorInteger(nArray);
    }

    @Override
    public ExpVectorInteger extendLower(int n, int n2, long l) {
        int[] nArray = new int[this.val.length + n];
        System.arraycopy(this.val, 0, nArray, 0, this.val.length);
        if (n2 >= n) {
            throw new IllegalArgumentException("i " + n + " <= j " + n2 + " invalid");
        }
        nArray[this.val.length + n2] = (int)l;
        return new ExpVectorInteger(nArray);
    }

    @Override
    public ExpVectorInteger contract(int n, int n2) {
        if (n + n2 > this.val.length) {
            throw new IllegalArgumentException("len " + n2 + " > val.len " + this.val.length);
        }
        int[] nArray = new int[n2];
        System.arraycopy(this.val, n, nArray, 0, n2);
        return new ExpVectorInteger(nArray);
    }

    @Override
    public ExpVectorInteger reverse() {
        int[] nArray = new int[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            nArray[i] = this.val[this.val.length - 1 - i];
        }
        return new ExpVectorInteger(nArray);
    }

    @Override
    public ExpVectorInteger reverse(int n) {
        int n2;
        if (n <= 0 || n > this.val.length) {
            return this;
        }
        int[] nArray = new int[this.val.length];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = this.val[n2];
        }
        for (n2 = n; n2 < this.val.length; ++n2) {
            nArray[n2] = this.val[this.val.length + n - 1 - n2];
        }
        return new ExpVectorInteger(nArray);
    }

    @Override
    public ExpVectorInteger combine(ExpVector expVector) {
        if (expVector == null || expVector.length() == 0) {
            return this;
        }
        ExpVectorInteger expVectorInteger = (ExpVectorInteger)expVector;
        if (this.val.length == 0) {
            return expVectorInteger;
        }
        int[] nArray = new int[this.val.length + expVectorInteger.val.length];
        System.arraycopy(this.val, 0, nArray, 0, this.val.length);
        System.arraycopy(expVectorInteger.val, 0, nArray, this.val.length, expVectorInteger.val.length);
        return new ExpVectorInteger(nArray);
    }

    @Override
    public ExpVectorInteger permutation(List<Integer> list) {
        int[] nArray = new int[this.val.length];
        int n = 0;
        for (Integer n2 : list) {
            nArray[n++] = this.val[n2];
        }
        return new ExpVectorInteger(nArray);
    }

    @Override
    public String toString() {
        return super.toString() + ":int";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ExpVectorInteger)) {
            return false;
        }
        ExpVectorInteger expVectorInteger = (ExpVectorInteger)object;
        int n = this.invLexCompareTo(expVectorInteger);
        return 0 == n;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public ExpVectorInteger abs() {
        int[] nArray = this.val;
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = (long)nArray[i] >= 0L ? nArray[i] : -nArray[i];
        }
        return new ExpVectorInteger(nArray2);
    }

    @Override
    public ExpVectorInteger negate() {
        int[] nArray = this.val;
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = -nArray[i];
        }
        return new ExpVectorInteger(nArray2);
    }

    @Override
    public ExpVectorInteger sum(ExpVector expVector) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray[i] + nArray2[i];
        }
        return new ExpVectorInteger(nArray3);
    }

    @Override
    public ExpVectorInteger subtract(ExpVector expVector) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray[i] - nArray2[i];
        }
        return new ExpVectorInteger(nArray3);
    }

    @Override
    public ExpVectorInteger subst(int n, long l) {
        ExpVectorInteger expVectorInteger = this.copy();
        expVectorInteger.setVal(n, l);
        return expVectorInteger;
    }

    public ExpVectorInteger subst(int n, int n2) {
        ExpVectorInteger expVectorInteger = this.copy();
        expVectorInteger.setVal(n, n2);
        return expVectorInteger;
    }

    @Override
    public int signum() {
        int n = 0;
        int[] nArray = this.val;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                return -1;
            }
            if (nArray[i] <= 0) continue;
            n = 1;
        }
        return n;
    }

    @Override
    public long totalDeg() {
        long l = 0L;
        int[] nArray = this.val;
        for (int i = 0; i < nArray.length; ++i) {
            l += (long)nArray[i];
        }
        return l;
    }

    @Override
    public long maxDeg() {
        long l = 0L;
        int[] nArray = this.val;
        for (int i = 0; i < nArray.length; ++i) {
            if ((long)nArray[i] <= l) continue;
            l = nArray[i];
        }
        return l;
    }

    @Override
    public long weightDeg(long[][] lArray) {
        if (lArray == null || lArray.length == 0) {
            return this.totalDeg();
        }
        long l = 0L;
        int[] nArray = this.val;
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray2 = lArray[i];
            for (int j = 0; j < nArray.length; ++j) {
                l += lArray2[j] * (long)nArray[j];
            }
        }
        return l;
    }

    @Override
    public ExpVectorInteger lcm(ExpVector expVector) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray[i] >= nArray2[i] ? nArray[i] : nArray2[i];
        }
        return new ExpVectorInteger(nArray3);
    }

    @Override
    public ExpVectorInteger gcd(ExpVector expVector) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray[i] <= nArray2[i] ? nArray[i] : nArray2[i];
        }
        return new ExpVectorInteger(nArray3);
    }

    @Override
    public int[] dependencyOnVariables() {
        int[] nArray = this.val;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            ++n;
        }
        int[] nArray2 = new int[n];
        if (n == 0) {
            return nArray2;
        }
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            nArray2[n2] = i;
            ++n2;
        }
        return nArray2;
    }

    @Override
    public boolean multipleOf(ExpVector expVector) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= nArray2[i]) continue;
            return false;
        }
        return bl;
    }

    @Override
    public int compareTo(ExpVector expVector) {
        return this.invLexCompareTo(expVector);
    }

    @Override
    public int invLexCompareTo(ExpVector expVector) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > nArray2[i]) {
                return 1;
            }
            if (nArray[i] >= nArray2[i]) continue;
            return -1;
        }
        return n;
    }

    @Override
    public int invLexCompareTo(ExpVector expVector, int n, int n2) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (nArray[i] > nArray2[i]) {
                return 1;
            }
            if (nArray[i] >= nArray2[i]) continue;
            return -1;
        }
        return n3;
    }

    @Override
    public int invGradCompareTo(ExpVector expVector) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > nArray2[i]) {
                n = 1;
                break;
            }
            if (nArray[i] >= nArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i < nArray.length; ++i) {
            l += (long)nArray[i];
            l2 += (long)nArray2[i];
        }
        if (l > l2) {
            n = 1;
        } else if (l < l2) {
            n = -1;
        }
        return n;
    }

    @Override
    public int invGradCompareTo(ExpVector expVector, int n, int n2) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (nArray[i] > nArray2[i]) {
                n3 = 1;
                break;
            }
            if (nArray[i] >= nArray2[i]) continue;
            n3 = -1;
            break;
        }
        if (n3 == 0) {
            return n3;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i < n2; ++i) {
            l += (long)nArray[i];
            l2 += (long)nArray2[i];
        }
        if (l > l2) {
            n3 = 1;
        } else if (l < l2) {
            n3 = -1;
        }
        return n3;
    }

    @Override
    public int revInvLexCompareTo(ExpVector expVector) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int n = 0;
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] > nArray2[i]) {
                return 1;
            }
            if (nArray[i] >= nArray2[i]) continue;
            return -1;
        }
        return n;
    }

    @Override
    public int revInvLexCompareTo(ExpVector expVector, int n, int n2) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int n3 = 0;
        for (int i = n2 - 1; i >= n; --i) {
            if (nArray[i] > nArray2[i]) {
                return 1;
            }
            if (nArray[i] >= nArray2[i]) continue;
            return -1;
        }
        return n3;
    }

    @Override
    public int revInvGradCompareTo(ExpVector expVector) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int n = 0;
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] > nArray2[i]) {
                n = 1;
                break;
            }
            if (nArray[i] >= nArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i >= 0; --i) {
            l += (long)nArray[i];
            l2 += (long)nArray2[i];
        }
        if (l > l2) {
            n = 1;
        } else if (l < l2) {
            n = -1;
        }
        return n;
    }

    @Override
    public int revInvGradCompareTo(ExpVector expVector, int n, int n2) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int n3 = 0;
        for (int i = n2 - 1; i >= n; --i) {
            if (nArray[i] > nArray2[i]) {
                n3 = 1;
                break;
            }
            if (nArray[i] >= nArray2[i]) continue;
            n3 = -1;
            break;
        }
        if (n3 == 0) {
            return n3;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i >= n; --i) {
            l += (long)nArray[i];
            l2 += (long)nArray2[i];
        }
        if (l > l2) {
            n3 = 1;
        } else if (l < l2) {
            n3 = -1;
        }
        return n3;
    }

    @Override
    public int invWeightCompareTo(long[][] lArray, ExpVector expVector) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > nArray2[i]) {
                n = 1;
                break;
            }
            if (nArray[i] >= nArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray2 = lArray[i];
            long l = 0L;
            long l2 = 0L;
            for (int j = i; j < nArray.length; ++j) {
                l += lArray2[j] * (long)nArray[j];
                l2 += lArray2[j] * (long)nArray2[j];
            }
            if (l > l2) {
                return 1;
            }
            if (l >= l2) continue;
            return -1;
        }
        return n;
    }

    @Override
    public int invWeightCompareTo(long[][] lArray, ExpVector expVector, int n, int n2) {
        int[] nArray = this.val;
        int[] nArray2 = ((ExpVectorInteger)expVector).val;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (nArray[i] > nArray2[i]) {
                n3 = 1;
                break;
            }
            if (nArray[i] >= nArray2[i]) continue;
            n3 = -1;
            break;
        }
        if (n3 == 0) {
            return n3;
        }
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray2 = lArray[i];
            long l = 0L;
            long l2 = 0L;
            for (int j = i; j < n2; ++j) {
                l += lArray2[j] * (long)nArray[j];
                l2 += lArray2[j] * (long)nArray2[j];
            }
            if (l > l2) {
                return 1;
            }
            if (l >= l2) continue;
            return -1;
        }
        return n3;
    }
}

