/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.ufd.FactorAbsolute;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorRational
extends FactorAbsolute<BigRational> {
    private static final Logger logger = Logger.getLogger(FactorRational.class);
    private final boolean debug = logger.isInfoEnabled();
    protected final FactorAbstract<BigInteger> iengine = FactorFactory.getImplementation(BigInteger.ONE);

    protected FactorRational() {
        super(BigRational.ONE);
    }

    @Override
    public List<GenPolynomial<BigRational>> baseFactorsSquarefree(GenPolynomial<BigRational> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<BigRational>> arrayList = new ArrayList<GenPolynomial<BigRational>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.isONE()) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<BigRational> genPolynomial2 = genPolynomial;
        BigRational bigRational = genPolynomial.leadingBaseCoefficient();
        if (!bigRational.isONE()) {
            genPolynomial2 = genPolynomial2.monic();
        }
        BigInteger bigInteger = BigInteger.ONE;
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(bigInteger, genPolynomialRing);
        GenPolynomial<BigInteger> genPolynomial3 = PolyUtil.integerFromRationalCoefficients(genPolynomialRing2, genPolynomial2);
        if (this.debug) {
            logger.info((Object)("Pi = " + genPolynomial3));
        }
        List<GenPolynomial<BigInteger>> list = this.iengine.baseFactorsSquarefree(genPolynomial3);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("ifacts = " + list));
        }
        if (list.size() <= 1) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        List list2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, list);
        list2 = PolyUtil.monic(list2);
        if (!bigRational.isONE()) {
            GenPolynomial<BigRational> genPolynomial4 = list2.get(0);
            list2.remove(genPolynomial4);
            genPolynomial4 = genPolynomial4.multiply(bigRational);
            list2.set(0, genPolynomial4);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("rfacts = " + list2));
        }
        arrayList.addAll(list2);
        return arrayList;
    }

    @Override
    public List<GenPolynomial<BigRational>> factorsSquarefree(GenPolynomial<BigRational> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<BigRational>> arrayList = new ArrayList<GenPolynomial<BigRational>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.isONE()) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar == 1) {
            return this.baseFactorsSquarefree(genPolynomial);
        }
        GenPolynomial<BigRational> genPolynomial2 = genPolynomial;
        BigRational bigRational = genPolynomial.leadingBaseCoefficient();
        if (!bigRational.isONE()) {
            genPolynomial2 = genPolynomial2.monic();
        }
        BigInteger bigInteger = BigInteger.ONE;
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(bigInteger, genPolynomialRing);
        GenPolynomial<BigInteger> genPolynomial3 = PolyUtil.integerFromRationalCoefficients(genPolynomialRing2, genPolynomial2);
        if (this.debug) {
            logger.info((Object)("Pi = " + genPolynomial3));
        }
        List<GenPolynomial<BigInteger>> list = this.iengine.factorsSquarefree(genPolynomial3);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("ifacts = " + list));
        }
        if (list.size() <= 1) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        List list2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, list);
        list2 = PolyUtil.monic(list2);
        if (!bigRational.isONE()) {
            GenPolynomial<BigRational> genPolynomial4 = list2.get(0);
            list2.remove(genPolynomial4);
            genPolynomial4 = genPolynomial4.multiply(bigRational);
            list2.set(0, genPolynomial4);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("rfacts = " + list2));
        }
        arrayList.addAll(list2);
        return arrayList;
    }
}

