/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class QuotientRatTest
extends TestCase {
    QuotientRing<BigRational> zFac;
    QuotientRing<BigRational> efac;
    GenPolynomialRing<BigRational> mfac;
    Quotient<BigRational> a;
    Quotient<BigRational> b;
    Quotient<BigRational> c;
    Quotient<BigRational> d;
    Quotient<BigRational> e;
    Quotient<BigRational> az;
    Quotient<BigRational> bz;
    Quotient<BigRational> cz;
    Quotient<BigRational> dz;
    Quotient<BigRational> ez;
    int rl = 3;
    int kl = 5;
    int ll = 3;
    int el = 2;
    float q = 0.4f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)QuotientRatTest.suite());
    }

    public QuotientRatTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(QuotientRatTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        TermOrder termOrder = new TermOrder(2);
        this.mfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, termOrder);
        this.efac = new QuotientRing<BigRational>(this.mfac);
        this.zFac = new QuotientRing<BigRational>(this.mfac, false);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.efac = null;
        this.zFac = null;
        ComputerThreads.terminate();
    }

    public void testConstruction() {
        this.c = this.efac.getONE();
        QuotientRatTest.assertTrue((String)"length( c ) = 1", (this.c.num.length() == 1 ? 1 : 0) != 0);
        QuotientRatTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuotientRatTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.efac.getZERO();
        QuotientRatTest.assertTrue((String)"length( d ) = 0", (this.d.num.length() == 0 ? 1 : 0) != 0);
        QuotientRatTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        QuotientRatTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.efac.random(this.kl * (i + 1), this.ll + 2 + 2 * i, this.el, this.q);
            if (this.a.isZERO() || this.a.isONE()) continue;
            QuotientRatTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.num.length() >= 0 ? 1 : 0) != 0);
            QuotientRatTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            QuotientRatTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        this.d = this.d.monic();
        QuotientRatTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        QuotientRatTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        QuotientRatTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((Quotient<BigRational>)this.efac.getZERO());
        this.d = this.a.subtract((Quotient<BigRational>)this.efac.getZERO());
        QuotientRatTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((Quotient)this.efac.getZERO()).sum(this.a);
        this.d = ((Quotient)this.efac.getZERO()).subtract(this.a.negate());
        QuotientRatTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        this.e = this.d.subtract(this.c);
        QuotientRatTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        QuotientRatTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        QuotientRatTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        QuotientRatTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        QuotientRatTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((BigRational)this.efac.getONE());
        this.d = ((Quotient)this.efac.getONE()).multiply(this.a);
        QuotientRatTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply((BigRational)((Object)this.a));
            QuotientRatTest.assertTrue((String)"a*1/a = 1", (boolean)this.d.isONE());
        }
    }

    public void xtestAdditionGcd() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.az = new Quotient<BigRational>(this.zFac, this.a.num, this.a.den, true);
        this.bz = new Quotient<BigRational>(this.zFac, this.b.num, this.b.den, true);
        long l = System.currentTimeMillis();
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        this.d = this.d.monic();
        l = System.currentTimeMillis() - l;
        QuotientRatTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        long l2 = System.currentTimeMillis();
        this.cz = this.az.sum(this.bz);
        this.dz = this.cz.subtract(this.bz);
        this.dz = this.dz.monic();
        l2 = System.currentTimeMillis() - l2;
        QuotientRatTest.assertEquals((String)"a+b-b = a", this.az, this.dz);
        System.out.println("te = " + l);
        System.out.println("tz = " + l2);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        QuotientRatTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.cz = new Quotient<BigRational>(this.zFac, this.c.num, this.c.den, true);
        l = System.currentTimeMillis();
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        l = System.currentTimeMillis() - l;
        QuotientRatTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        l2 = System.currentTimeMillis();
        this.dz = this.cz.sum(this.az.sum(this.bz));
        this.ez = this.cz.sum(this.az).sum(this.bz);
        l2 = System.currentTimeMillis() - l2;
        QuotientRatTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.dz, this.ez);
        System.out.println("te = " + l);
        System.out.println("tz = " + l2);
        this.c = this.a.sum((Quotient<BigRational>)this.efac.getZERO());
        this.d = this.a.subtract((Quotient<BigRational>)this.efac.getZERO());
        QuotientRatTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((Quotient)this.efac.getZERO()).sum(this.a);
        this.d = ((Quotient)this.efac.getZERO()).subtract(this.a.negate());
        QuotientRatTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testParse() {
        this.a = this.efac.random(this.kl * 2, this.ll * 2, this.el * 2, this.q * 2.0f);
        PrettyPrint.setPretty();
        String string = this.a.toString();
        this.b = this.efac.parse(string);
        QuotientRatTest.assertEquals((String)"parse(a.toSting()) = a", this.a, this.b);
    }
}

