/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.root.Interval;
import edu.jas.root.RealRootsAbstract;
import edu.jas.root.RootUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RealRootsSturm<C extends RingElem<C> & Rational>
extends RealRootsAbstract<C> {
    private static final Logger logger = Logger.getLogger(RealRootsSturm.class);
    private static boolean debug = logger.isDebugEnabled();

    public List<GenPolynomial<C>> sturmSequence(GenPolynomial<C> genPolynomial) {
        Iterable<Monomial<Object>> iterable;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.isConstant()) {
            arrayList.add(genPolynomial.monic());
            return arrayList;
        }
        GenPolynomial<C> genPolynomial2 = genPolynomial;
        arrayList.add(genPolynomial2);
        AbelianGroupElem<GenPolynomial<C>> abelianGroupElem = PolyUtil.baseDeriviative(genPolynomial);
        while (!abelianGroupElem.isZERO()) {
            iterable = genPolynomial2.remainder((GenPolynomial<C>)abelianGroupElem);
            genPolynomial2 = abelianGroupElem;
            abelianGroupElem = ((GenPolynomial)iterable).negate();
            arrayList.add(genPolynomial2);
        }
        if (genPolynomial2.isConstant()) {
            return arrayList;
        }
        iterable = new ArrayList(arrayList.size());
        for (GenPolynomial<C> genPolynomial3 : arrayList) {
            genPolynomial3 = genPolynomial3.divide(genPolynomial2);
            iterable.add(genPolynomial3);
        }
        return iterable;
    }

    @Override
    public List<Interval<C>> realRoots(GenPolynomial<C> genPolynomial) {
        ArrayList<Interval<C>> arrayList = new ArrayList<Interval<C>>();
        if (genPolynomial == null || genPolynomial.isConstant()) {
            return arrayList;
        }
        if (genPolynomial.isZERO()) {
            RingElem ringElem = (RingElem)genPolynomial.ring.coFac.getZERO();
            arrayList.add(new Interval<RingElem>(ringElem));
            return arrayList;
        }
        if (genPolynomial.degree(0) == 1L) {
            RingElem ringElem = (RingElem)genPolynomial.monic().trailingBaseCoefficient().negate();
            arrayList.add(new Interval<RingElem>(ringElem));
            return arrayList;
        }
        GenPolynomial<C> genPolynomial2 = genPolynomial;
        C c = this.realRootBound(genPolynomial2);
        Interval<RingElem> interval = new Interval<RingElem>((RingElem)c.negate(), (RingElem)c);
        List<GenPolynomial<C>> list = this.sturmSequence(genPolynomial2);
        List<Interval<RingElem>> list2 = this.realRoots(interval, list);
        if (logger.isInfoEnabled() && !(genPolynomial.ring.coFac instanceof BigRational)) {
            logger.info((Object)("realRoots: " + list2));
        }
        arrayList.addAll(list2);
        return arrayList;
    }

    @Override
    public List<Interval<C>> realRoots(Interval<C> interval, List<GenPolynomial<C>> list) {
        ArrayList<Interval<C>> arrayList = new ArrayList<Interval<C>>();
        GenPolynomial<C> genPolynomial = list.get(0);
        if (genPolynomial.isZERO()) {
            C c = genPolynomial.leadingBaseCoefficient();
            if (!interval.contains((RingElem)c)) {
                throw new IllegalArgumentException("root not in interval: f = " + genPolynomial + ", iv = " + interval + ", z = " + c);
            }
            Interval<C> interval2 = new Interval<C>(c);
            arrayList.add(interval2);
            return arrayList;
        }
        if (genPolynomial.isConstant()) {
            return arrayList;
        }
        if (genPolynomial.degree(0) == 1L) {
            RingElem ringElem = (RingElem)genPolynomial.monic().trailingBaseCoefficient().negate();
            if (!interval.contains(ringElem)) {
                return arrayList;
            }
            Interval<RingElem> interval3 = new Interval<RingElem>(ringElem);
            arrayList.add(interval3);
            return arrayList;
        }
        long l = this.realRootCount(interval, list);
        if (l == 0L) {
            return arrayList;
        }
        if (l == 1L) {
            arrayList.add(interval);
            return arrayList;
        }
        C c = this.bisectionPoint(interval, genPolynomial);
        Interval interval4 = new Interval(interval.left, c);
        Interval<C> interval5 = new Interval<C>(c, interval.right);
        List list2 = this.realRoots(interval4, list);
        if (debug) {
            logger.info((Object)("R1 = " + list2));
        }
        List<Interval<C>> list3 = this.realRoots(interval5, list);
        if (debug) {
            logger.info((Object)("R2 = " + list3));
        }
        if (list2.isEmpty()) {
            arrayList.addAll(list3);
            return arrayList;
        }
        if (list3.isEmpty()) {
            arrayList.addAll(list2);
            return arrayList;
        }
        interval4 = list2.get(list2.size() - 1);
        interval5 = list3.get(0);
        if (interval4.right.compareTo(interval5.left) < 0) {
            arrayList.addAll(list2);
            arrayList.addAll(list3);
            return arrayList;
        }
        list2.remove(interval4);
        list3.remove(interval5);
        while (interval4.right.equals(interval5.left)) {
            Object c2 = this.bisectionPoint(interval4, genPolynomial);
            C c3 = this.bisectionPoint(interval5, genPolynomial);
            Interval interval6 = new Interval(interval4.left, c2);
            Interval interval7 = new Interval(c2, interval4.right);
            Interval interval8 = new Interval(interval5.left, c3);
            Interval<C> interval9 = new Interval<C>(c3, interval5.right);
            boolean bl = this.signChange(interval6, genPolynomial);
            boolean bl2 = this.signChange(interval7, genPolynomial);
            boolean bl3 = this.signChange(interval9, genPolynomial);
            if (bl) {
                interval4 = interval6;
                if (bl3) {
                    interval5 = interval9;
                    break;
                }
                interval5 = interval8;
                break;
            }
            if (bl3) {
                interval5 = interval9;
                if (bl2) {
                    interval4 = interval7;
                    break;
                }
                interval4 = interval6;
                break;
            }
            interval4 = interval7;
            interval5 = interval8;
        }
        arrayList.addAll(list2);
        arrayList.add(interval4);
        arrayList.add(interval5);
        arrayList.addAll(list3);
        return arrayList;
    }

    @Override
    public long realRootCount(Interval<C> interval, List<GenPolynomial<C>> list) {
        GenPolynomial<C> genPolynomial = list.get(0);
        RingFactory ringFactory = genPolynomial.ring.coFac;
        List list2 = PolyUtil.evaluateMain(ringFactory, list, interval.left);
        List list3 = PolyUtil.evaluateMain(ringFactory, list, interval.right);
        long l = RootUtil.signVar(list2) - RootUtil.signVar(list3);
        if (l < 0L) {
            l = -l;
        }
        return l;
    }

    @Override
    public long realRootCount(Interval<C> interval, GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isConstant()) {
            return 0L;
        }
        if (genPolynomial.isZERO()) {
            C c = genPolynomial.leadingBaseCoefficient();
            if (!interval.contains(c)) {
                return 0L;
            }
            return 1L;
        }
        List<GenPolynomial<C>> list = this.sturmSequence(genPolynomial);
        return this.realRootCount(interval, list);
    }

    @Override
    public Interval<C> invariantSignInterval(Interval<C> interval, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        Interval<C> interval2 = interval;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return interval2;
        }
        if (genPolynomial2.isConstant()) {
            return interval2;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new IllegalArgumentException("f == 0");
        }
        List<GenPolynomial<C>> list = this.sturmSequence(genPolynomial2.monic());
        Interval<C> interval3 = this.invariantSignInterval(interval, genPolynomial, list);
        return interval3;
    }

    @Override
    public Interval<C> invariantSignInterval(Interval<C> interval, GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list) {
        Interval<Object> interval2 = interval;
        GenPolynomial<C> genPolynomial2 = list.get(0);
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return interval2;
        }
        if (genPolynomial2.isConstant()) {
            return interval2;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return interval2;
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        RingElem ringElem = (RingElem)ringFactory.fromInteger(2L);
        while (true) {
            long l = this.realRootCount(interval2, list);
            logger.debug((Object)("n = " + l));
            if (l == 0L) {
                return interval2;
            }
            RingElem ringElem2 = (RingElem)interval2.left.sum(interval2.right);
            Interval<RingElem> interval3 = new Interval<RingElem>(ringElem2 = ringElem2.divide(ringElem), (RingElem)interval2.right);
            if (this.signChange(interval3, genPolynomial)) {
                interval2 = interval3;
                continue;
            }
            interval2 = new Interval<RingElem>((RingElem)interval2.left, ringElem2);
        }
    }
}

