/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.root.ComplexRootsAbstract;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.NoConvergenceException;
import edu.jas.root.Rectangle;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ComplexRootTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<Complex<BigRational>> dfac;
    ComplexRing<BigRational> cfac;
    BigRational eps;
    Complex<BigRational> ceps;
    GenPolynomial<Complex<BigRational>> a;
    GenPolynomial<Complex<BigRational>> b;
    GenPolynomial<Complex<BigRational>> c;
    GenPolynomial<Complex<BigRational>> d;
    GenPolynomial<Complex<BigRational>> e;
    int rl = 1;
    int kl = 3;
    int ll = 3;
    int el = 5;
    float q = 0.7f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ComplexRootTest.suite());
        ComputerThreads.terminate();
    }

    public ComplexRootTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ComplexRootTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cfac = new ComplexRing<BigRational>(new BigRational(1L));
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenPolynomialRing<BigRational>(this.cfac, this.rl, this.to, stringArray);
        this.eps = Power.positivePower(new BigRational(1L, 10L), BigDecimal.DEFAULT_PRECISION);
        this.ceps = new Complex<BigRational>(this.cfac, this.eps);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.dfac = null;
        this.cfac = null;
        this.eps = null;
    }

    public void testRootBound() {
        this.a = this.dfac.univariate(0, 2L).sum((Complex<BigRational>)this.dfac.getONE());
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(this.cfac);
        Complex complex = complexRootsSturm.rootBound(this.a);
        BigRational bigRational = (BigRational)complex.getRe();
        ComplexRootTest.assertTrue((String)"M >= 1 ", (bigRational.compareTo(BigRational.ONE) >= 0 ? 1 : 0) != 0);
        this.a = this.a.multiply((Complex<BigRational>)this.dfac.fromInteger(5L));
        bigRational = (BigRational)complexRootsSturm.rootBound(this.a).getRe();
        ComplexRootTest.assertTrue((String)"M >= 1 ", (bigRational.compareTo(BigRational.ONE) >= 0 ? 1 : 0) != 0);
    }

    public void testCauchyIndex() {
        this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
        BigRational bigRational = new BigRational(0L);
        BigRational bigRational2 = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.dfac);
        ComplexRootsSturm<BigRational> complexRootsSturm = new ComplexRootsSturm<BigRational>(this.cfac);
        GenPolynomial<BigRational> genPolynomial = PolyUtil.realPartFromComplex(genPolynomialRing, this.a);
        GenPolynomial<BigRational> genPolynomial2 = PolyUtil.imaginaryPartFromComplex(genPolynomialRing, this.b);
        long l = complexRootsSturm.indexOfCauchy(bigRational, bigRational2, genPolynomial2, genPolynomial);
        ComplexRootTest.assertTrue((String)"ci >= 0 ", (l >= -this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testRouth() {
        GenPolynomial<BigRational> genPolynomial;
        GenPolynomialRing<BigRational> genPolynomialRing;
        GenPolynomial<BigRational> genPolynomial2;
        BigRational bigRational;
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(this.cfac);
        Complex<BigRational> complex = this.cfac.getIMAG();
        GenPolynomial<Complex<BigRational>> genPolynomial3 = this.dfac.univariate(0);
        this.b = genPolynomial3.subtract((Complex<BigRational>)((Object)((GenPolynomial)this.dfac.getONE()).multiply(complex.negate())));
        this.c = genPolynomial3.subtract((Complex<BigRational>)((Object)((GenPolynomial)this.dfac.getONE()).multiply(complex.multiply((Complex<BigRational>)this.cfac.fromInteger(3L)))));
        this.d = genPolynomial3.subtract((Complex<BigRational>)((Object)((GenPolynomial)this.dfac.getONE()).multiply(complex.multiply((Complex<BigRational>)this.cfac.fromInteger(4L)))));
        this.e = genPolynomial3.subtract((Complex<BigRational>)((Object)((GenPolynomial)this.dfac.getONE()).multiply(complex.multiply((Complex<BigRational>)this.cfac.fromInteger(5L)))));
        this.a = this.b.multiply((Complex<BigRational>)((Object)this.c)).multiply(this.d).multiply(this.e);
        Complex complex2 = complexRootsSturm.rootBound(this.a);
        BigRational bigRational2 = (BigRational)complex2.getRe();
        BigRational bigRational3 = bigRational2.negate();
        long[] lArray = complexRootsSturm.indexOfRouth(bigRational3, bigRational = bigRational2, genPolynomial2 = PolyUtil.realPartFromComplex(genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.dfac), this.a), genPolynomial = PolyUtil.imaginaryPartFromComplex(genPolynomialRing, this.a));
        long l = lArray[0] + lArray[1];
        ComplexRootTest.assertTrue((String)"sum(ri) == deg(a) ", (l >= this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testWindingNumber() {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.univariate(0, 2L).sum((Complex<BigRational>)this.cfac.fromInteger(1L));
        Complex complex = complexRootsSturm.rootBound(this.a);
        BigRational bigRational = (BigRational)complex.getRe();
        BigRational bigRational2 = new BigRational(1L, 1000L);
        Complex[] complexArray = new Complex[]{new Complex<BigRational>(this.cfac, bigRational.negate(), bigRational), new Complex<BigRational>(this.cfac, bigRational.negate(), bigRational.negate()), new Complex<BigRational>(this.cfac, bigRational, bigRational.negate()), new Complex<BigRational>(this.cfac, bigRational, bigRational)};
        long l = 0L;
        try {
            l = complexRootsSturm.windingNumber(new Rectangle(complexArray), this.a);
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            ComplexRootTest.fail((String)("" + invalidBoundaryException));
        }
        ComplexRootTest.assertTrue((String)"wind(rect,a) == 2 ", (l == 2L ? 1 : 0) != 0);
        complexArray[0] = new Complex<BigRational>(this.cfac, bigRational.negate(), bigRational);
        complexArray[1] = new Complex<BigRational>(this.cfac, bigRational.negate(), bigRational2);
        complexArray[2] = new Complex<BigRational>(this.cfac, bigRational, bigRational2);
        complexArray[3] = new Complex<BigRational>(this.cfac, bigRational, bigRational);
        try {
            l = complexRootsSturm.windingNumber(new Rectangle(complexArray), this.a);
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            ComplexRootTest.fail((String)("" + invalidBoundaryException));
        }
        ComplexRootTest.assertTrue((String)"wind(rect,a) == 1 ", (l == 1L ? 1 : 0) != 0);
        complexArray[0] = new Complex<BigRational>(this.cfac, bigRational2.negate(), bigRational2);
        complexArray[1] = new Complex<BigRational>(this.cfac, bigRational2.negate(), bigRational2.negate());
        complexArray[2] = new Complex<BigRational>(this.cfac, bigRational2, bigRational2.negate());
        complexArray[3] = new Complex<BigRational>(this.cfac, bigRational2, bigRational2);
        try {
            l = complexRootsSturm.windingNumber(new Rectangle(complexArray), this.a);
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            ComplexRootTest.fail((String)("" + invalidBoundaryException));
        }
        ComplexRootTest.assertTrue((String)"wind(rect,a) == 0 ", (l == 0L ? 1 : 0) != 0);
    }

    public void testComplexRootsImag() {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.univariate(0, 2L).sum((Complex<BigRational>)this.cfac.fromInteger(1L));
        Complex complex = complexRootsSturm.rootBound(this.a);
        BigRational bigRational = (BigRational)complex.getRe();
        Complex[] complexArray = new Complex[]{new Complex<BigRational>(this.cfac, bigRational.negate(), bigRational), new Complex<BigRational>(this.cfac, bigRational.negate(), bigRational.negate()), new Complex<BigRational>(this.cfac, bigRational, bigRational.negate()), new Complex<BigRational>(this.cfac, bigRational, bigRational)};
        Rectangle rectangle = new Rectangle(complexArray);
        List list = null;
        try {
            list = ((ComplexRootsAbstract)complexRootsSturm).complexRoots(rectangle, this.a);
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            ComplexRootTest.fail((String)("" + invalidBoundaryException));
        }
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testComplexRootsRand() {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
        SquarefreeAbstract<BigRational> squarefreeAbstract = SquarefreeFactory.getImplementation(this.cfac);
        this.a = squarefreeAbstract.squarefreePart(this.a);
        Complex complex = complexRootsSturm.rootBound(this.a);
        BigRational bigRational = (BigRational)complex.getRe();
        Complex[] complexArray = new Complex[]{new Complex<BigRational>(this.cfac, bigRational.negate(), bigRational), new Complex<BigRational>(this.cfac, bigRational.negate(), bigRational.negate()), new Complex<BigRational>(this.cfac, bigRational, bigRational.negate()), new Complex<BigRational>(this.cfac, bigRational, bigRational)};
        Rectangle rectangle = new Rectangle(complexArray);
        List list = null;
        try {
            list = ((ComplexRootsAbstract)complexRootsSturm).complexRoots(rectangle, this.a);
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            ComplexRootTest.fail((String)("" + invalidBoundaryException));
        }
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testComplexRoots() {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.random(this.kl, this.ll, this.el + 1, this.q);
        List list = complexRootsSturm.complexRoots(this.a);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testComplexRootRefinement() {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.random(this.kl, this.ll, this.el - 1, this.q);
        SquarefreeAbstract<BigRational> squarefreeAbstract = SquarefreeFactory.getImplementation(this.cfac);
        this.a = squarefreeAbstract.squarefreePart(this.a);
        List list = complexRootsSturm.complexRoots(this.a);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
        BigRational bigRational = new BigRational(1L, 1000L);
        for (Rectangle rectangle : list) {
            try {
                Rectangle rectangle2 = complexRootsSturm.complexRootRefinement(rectangle, this.a, bigRational);
                ComplexRootTest.assertFalse((String)"refine != null", (rectangle2 == null ? 1 : 0) != 0);
            }
            catch (InvalidBoundaryException invalidBoundaryException) {
                ComplexRootTest.fail((String)("" + invalidBoundaryException));
            }
        }
    }

    public void testComplexRootRefinementFull() {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.random(this.kl, this.ll, this.el - 1, this.q);
        BigRational bigRational = new BigRational(1L, 1000L);
        List list = complexRootsSturm.complexRoots(this.a, bigRational);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testWindingNumberWrong() {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.univariate(0, 2L).sum((Complex<BigRational>)this.cfac.fromInteger(1L));
        Element element = this.cfac.fromInteger(1L);
        BigRational bigRational = (BigRational)((Complex)element).getRe();
        BigRational bigRational2 = new BigRational();
        Complex[] complexArray = new Complex[]{new Complex<BigRational>(this.cfac, bigRational.negate(), bigRational), new Complex<BigRational>(this.cfac, bigRational.negate(), bigRational2), new Complex<BigRational>(this.cfac, bigRational, bigRational2), new Complex<BigRational>(this.cfac, bigRational, bigRational)};
        Rectangle rectangle = new Rectangle(complexArray);
        try {
            long l = complexRootsSturm.windingNumber(rectangle, this.a);
            System.out.println("winding number = " + l);
            ComplexRootTest.fail((String)"wind(rect,a) must throw an exception");
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            // empty catch block
        }
    }

    public void testComplexRootApproximation() {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.parse("( ( x^4-2 ) )");
        this.b = this.dfac.parse("( (x-1)*(x-2)*(x-3) )");
        this.c = this.dfac.parse("( x^4-2 )");
        this.d = this.dfac.parse("( (x - { 0i1 })*(x-5) )");
        SquarefreeAbstract<BigRational> squarefreeAbstract = SquarefreeFactory.getImplementation(this.cfac);
        this.a = squarefreeAbstract.squarefreePart(this.a);
        this.eps = this.eps.multiply(new BigRational(1000000L));
        List list = complexRootsSturm.complexRoots(this.a);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
        for (Rectangle rectangle : list) {
            try {
                Complex<BigDecimal> complex = complexRootsSturm.approximateRoot(rectangle, this.a, this.eps);
                ComplexRootTest.assertFalse((String)"cd != 0", (boolean)complex.isZERO());
            }
            catch (NoConvergenceException noConvergenceException) {}
        }
    }

    public void testComplexRootApproximationFull() {
        ComplexRootsSturm<BigRational> complexRootsSturm = new ComplexRootsSturm<BigRational>(this.cfac);
        this.a = this.dfac.parse("( (x-2)*( x^4-2 ) )");
        this.b = this.dfac.parse("( (x-1)*(x-2)*(x-3) )");
        this.c = this.dfac.parse("( x^4-2 )");
        this.d = this.dfac.parse("( (x - { 0i1 })*(x-5) )");
        this.eps = this.eps.multiply(new BigRational(1000000L));
        List<Complex<BigDecimal>> list = complexRootsSturm.approximateRoots(this.a, this.eps);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
    }

    public void testComplexRootApproximationWilkinsonFull() {
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        BigDecimal bigDecimal = new BigDecimal();
        ComplexRing<BigDecimal> complexRing = new ComplexRing<BigDecimal>(bigDecimal);
        Complex<BigDecimal> complex = complexRing.getIMAG();
        Complex<BigDecimal> complex2 = null;
        Complex<BigRational> complex3 = this.cfac.getIMAG();
        ArrayList<Complex<BigDecimal>> arrayList = new ArrayList<Complex<BigDecimal>>(4);
        this.a = this.d;
        for (int i = 0; i < 4; ++i) {
            complex2 = ((Complex)complexRing.fromInteger(i)).multiply(complex);
            arrayList.add(complex2);
            this.c = ((GenPolynomial)this.dfac.fromInteger(i)).multiply(complex3);
            this.b = this.e.subtract((Complex<BigRational>)((Object)this.c));
            this.a = this.a.multiply((Complex<BigRational>)((Object)this.b));
        }
        Collections.reverse(arrayList);
        ComplexRootsSturm<BigRational> complexRootsSturm = new ComplexRootsSturm<BigRational>(this.cfac);
        this.eps = this.eps.multiply(new BigRational(100000L));
        BigDecimal bigDecimal2 = new BigDecimal(this.eps);
        BigDecimal bigDecimal3 = bigDecimal2.multiply(new BigDecimal("10"));
        List<Complex<BigDecimal>> list = complexRootsSturm.approximateRoots(this.a, this.eps);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
        int n = 0;
        for (Complex<BigDecimal> complex4 : list) {
            Complex complex5;
            ComplexRootTest.assertTrue((String)"|dd - di| < eps ", (((BigDecimal)((Complex)complex4.subtract(complex5 = (Complex)arrayList.get(n++)).norm()).getRe()).compareTo(bigDecimal3) <= 0 ? 1 : 0) != 0);
        }
    }

    public void testComplexRootApproximationWilkinsonInverseFull() {
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        BigDecimal bigDecimal = new BigDecimal();
        ComplexRing<BigDecimal> complexRing = new ComplexRing<BigDecimal>(bigDecimal);
        Complex<BigDecimal> complex = complexRing.getIMAG();
        MonoidElem monoidElem = null;
        Complex<BigRational> complex2 = this.cfac.getIMAG();
        ArrayList<Complex<BigDecimal>> arrayList = new ArrayList<Complex<BigDecimal>>(5);
        this.a = this.d;
        for (int i = 1; i < 5; ++i) {
            monoidElem = ((Complex)complexRing.fromInteger(i)).multiply(complex);
            monoidElem = monoidElem.inverse();
            arrayList.add((Complex<BigDecimal>)monoidElem);
            this.c = ((GenPolynomial)this.dfac.fromInteger(i)).multiply(complex2);
            this.c = this.d.divide(this.c);
            this.b = this.e.subtract((Complex<BigRational>)((Object)this.c));
            this.a = this.a.multiply((Complex<BigRational>)((Object)this.b));
        }
        ComplexRootsSturm<BigRational> complexRootsSturm = new ComplexRootsSturm<BigRational>(this.cfac);
        this.eps = this.eps.multiply(new BigRational(100000L));
        BigDecimal bigDecimal2 = new BigDecimal(this.eps);
        BigDecimal bigDecimal3 = bigDecimal2.multiply(new BigDecimal("10"));
        List<Complex<BigDecimal>> list = complexRootsSturm.approximateRoots(this.a, this.eps);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
        for (Complex<BigDecimal> complex3 : list) {
            Complex complex4;
            boolean bl = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && !(bl = ((BigDecimal)((Complex)complex3.subtract(complex4 = (Complex)iterator.next()).norm()).getRe()).compareTo(bigDecimal3) <= 0)) {
            }
            if (bl) continue;
            ComplexRootTest.fail((String)"|dd - di| < eps ");
        }
    }

    public void testComplexRootInvariant() {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.random(this.kl, this.ll, this.el - 1, this.q);
        this.b = this.dfac.random(this.kl, this.ll, 2, this.q);
        if (this.a.degree() == 0L) {
            return;
        }
        SquarefreeAbstract<BigRational> squarefreeAbstract = SquarefreeFactory.getImplementation(this.cfac);
        this.a = squarefreeAbstract.squarefreePart(this.a);
        this.b = squarefreeAbstract.squarefreePart(this.b);
        List list = complexRootsSturm.complexRoots(this.a);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
        Rectangle rectangle = list.get(0);
        try {
            Rectangle rectangle2 = ((ComplexRootsAbstract)complexRootsSturm).invariantRectangle(rectangle, this.a, this.b);
            ComplexRootTest.assertTrue((String)"rect subseteq ref ", (boolean)rectangle.contains(rectangle2));
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            invalidBoundaryException.printStackTrace();
            ComplexRootTest.fail((String)"bad boundary");
        }
    }

    public void testComplexRootInvariantMagnitude() {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(this.cfac);
        this.a = this.dfac.random(this.kl, this.ll, this.el - 1, this.q);
        this.b = this.dfac.random(this.kl, this.ll, 3, this.q);
        if (this.a.degree() == 0L) {
            return;
        }
        SquarefreeAbstract<BigRational> squarefreeAbstract = SquarefreeFactory.getImplementation(this.cfac);
        this.a = squarefreeAbstract.squarefreePart(this.a);
        this.b = squarefreeAbstract.squarefreePart(this.b);
        List list = complexRootsSturm.complexRoots(this.a);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
        Rectangle<BigRational> rectangle = list.get(0);
        try {
            Rectangle<BigRational> rectangle2 = complexRootsSturm.invariantMagnitudeRectangle(rectangle, this.a, this.b, this.eps);
            ComplexRootTest.assertTrue((String)"rect subseteq ref ", (boolean)rectangle.contains(rectangle2));
            Complex<BigRational> complex = complexRootsSturm.complexRectangleMagnitude(rectangle2, this.a, this.b);
            Complex<BigRational> complex2 = complexRootsSturm.complexMagnitude(rectangle2, this.a, this.b, this.eps);
            ComplexRootTest.assertEquals((String)("mag == cmag: " + complex2), complex, complex2);
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            invalidBoundaryException.printStackTrace();
            ComplexRootTest.fail((String)"bad boundary");
        }
    }
}

