/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.root.Interval;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.RealRootsSturm;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class RealAlgebraicTest
extends TestCase {
    RealAlgebraicRing<BigRational> fac;
    GenPolynomialRing<BigRational> mfac;
    RealAlgebraicNumber<BigRational> a;
    RealAlgebraicNumber<BigRational> b;
    RealAlgebraicNumber<BigRational> c;
    RealAlgebraicNumber<BigRational> d;
    RealAlgebraicNumber<BigRational> e;
    RealAlgebraicNumber<BigRational> alpha;
    int rl = 1;
    int kl = 10;
    int ll;
    int el = this.ll = 10;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)RealAlgebraicTest.suite());
    }

    public RealAlgebraicTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RealAlgebraicTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        BigRational bigRational = new BigRational(1L);
        BigRational bigRational2 = new BigRational(2L);
        Interval<BigRational> interval = new Interval<BigRational>(bigRational, bigRational2);
        String[] stringArray = new String[]{"alpha"};
        this.mfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, stringArray);
        GenPolynomial<BigRational> genPolynomial = this.mfac.univariate(0, 2L);
        genPolynomial = genPolynomial.subtract((BigRational)this.mfac.fromInteger(2L));
        this.fac = new RealAlgebraicRing<BigRational>(genPolynomial, interval);
        this.alpha = this.fac.getGenerator();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.alpha = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        RealAlgebraicTest.assertTrue((String)"length( c ) = 1", (this.c.number.getVal().length() == 1 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        RealAlgebraicTest.assertTrue((String)"length( d ) = 0", (this.d.number.getVal().length() == 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        RealAlgebraicTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.el);
            if (this.a.isZERO() || this.a.isONE()) continue;
            RealAlgebraicTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.number.getVal().length() >= 0 ? 1 : 0) != 0);
            RealAlgebraicTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            RealAlgebraicTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((BigRational)((Object)this.b));
        this.d = this.c.subtract(this.b);
        RealAlgebraicTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum((BigRational)((Object)this.b));
        this.d = this.b.sum((BigRational)((Object)this.a));
        RealAlgebraicTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.c.sum((BigRational)((Object)this.a.sum((BigRational)((Object)this.b))));
        this.e = this.c.sum((BigRational)((Object)this.a)).sum(this.b);
        RealAlgebraicTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((BigRational)this.fac.getZERO());
        this.d = this.a.subtract((RealAlgebraicNumber<BigRational>)this.fac.getZERO());
        RealAlgebraicTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((RealAlgebraicNumber)this.fac.getZERO()).sum(this.a);
        this.d = ((RealAlgebraicNumber)this.fac.getZERO()).subtract(this.a.negate());
        RealAlgebraicTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        RealAlgebraicTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        RealAlgebraicTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        RealAlgebraicTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        RealAlgebraicTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        RealAlgebraicTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        RealAlgebraicTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        RealAlgebraicTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        RealAlgebraicTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((BigRational)this.fac.getONE());
        this.d = ((RealAlgebraicNumber)this.fac.getONE()).multiply(this.a);
        RealAlgebraicTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        this.c = this.a.inverse();
        this.d = this.c.multiply((BigRational)((Object)this.a));
        RealAlgebraicTest.assertEquals((String)"a*1/a = 1", (Object)this.fac.getONE(), this.d);
        try {
            this.a = ((RealAlgebraicNumber)this.fac.getZERO()).inverse();
        }
        catch (NotInvertibleException notInvertibleException) {
            return;
        }
        RealAlgebraicTest.fail((String)"0 invertible");
    }

    public void testDistributive() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigRational)((Object)this.b.sum((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).sum((RealAlgebraicNumber<BigRational>)this.a.multiply((BigRational)((Object)this.c)));
        RealAlgebraicTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testSignum() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        int n = this.a.signum();
        int n2 = this.b.signum();
        int n3 = this.c.signum();
        this.d = this.a.multiply((BigRational)((Object)this.b));
        this.e = this.a.multiply((BigRational)((Object)this.c));
        int n4 = this.d.signum();
        int n5 = this.e.signum();
        RealAlgebraicTest.assertEquals((String)"sign(a*b) = sign(a)*sign(b) ", (int)(n * n2), (int)n4);
        RealAlgebraicTest.assertEquals((String)"sign(a*c) = sign(a)*sign(c) ", (int)(n * n3), (int)n5);
        this.b = this.a.negate();
        n2 = this.b.signum();
        RealAlgebraicTest.assertEquals((String)"sign(-a) = -sign(a) ", (int)(-n), (int)n2);
    }

    public void testCompare() {
        this.a = ((RealAlgebraicNumber)this.fac.random(this.ll)).abs();
        this.b = this.a.sum((BigRational)this.fac.getONE());
        this.c = this.b.sum((BigRational)this.fac.getONE());
        int n = this.a.compareTo(this.b);
        int n2 = this.b.compareTo(this.c);
        int n3 = this.a.compareTo(this.c);
        RealAlgebraicTest.assertTrue((String)"a < a+1 ", (n < 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"a+1 < a+2 ", (n2 < 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"a < a+2 ", (n3 < 0 ? 1 : 0) != 0);
        this.a = this.a.negate();
        this.b = this.a.sum((BigRational)this.fac.getONE());
        this.c = this.b.sum((BigRational)this.fac.getONE());
        n = this.a.compareTo(this.b);
        n2 = this.b.compareTo(this.c);
        n3 = this.a.compareTo(this.c);
        RealAlgebraicTest.assertTrue((String)"a < a+1 ", (n < 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"a+1 < a+2 ", (n2 < 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"a < a+2 ", (n3 < 0 ? 1 : 0) != 0);
    }

    public void testMagnitude() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigRational)((Object)this.b));
        this.e = this.a.sum((BigRational)((Object)this.b));
        BigDecimal bigDecimal = new BigDecimal(this.d.magnitude());
        BigDecimal bigDecimal2 = new BigDecimal(this.e.magnitude());
        BigDecimal bigDecimal3 = new BigDecimal(this.a.magnitude().multiply(this.b.magnitude()));
        BigDecimal bigDecimal4 = new BigDecimal(this.a.magnitude().sum(this.b.magnitude()));
        BigRational bigRational = Power.positivePower(new BigRational(1L, 10L), 8L);
        BigDecimal bigDecimal5 = new BigDecimal(bigRational);
        RealAlgebraicTest.assertTrue((String)("mag(a*b) = mag(a)*mag(b): " + bigDecimal + ", " + bigDecimal3), (bigDecimal.subtract(bigDecimal3).abs().compareTo(bigDecimal5) <= 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)("mag(a+b) = mag(a)+mag(b): " + bigDecimal2 + ", " + bigDecimal4), (bigDecimal2.subtract(bigDecimal4).abs().compareTo(bigDecimal5) <= 0 ? 1 : 0) != 0);
        this.d = this.a.divide(this.b);
        this.e = this.a.subtract(this.b);
        bigDecimal = new BigDecimal(this.d.magnitude());
        bigDecimal2 = new BigDecimal(this.e.magnitude());
        bigDecimal3 = new BigDecimal(this.a.magnitude().divide(this.b.magnitude()));
        bigDecimal4 = new BigDecimal(this.a.magnitude().subtract(this.b.magnitude()));
        RealAlgebraicTest.assertTrue((String)"mag(a/b) = mag(a)/mag(b)", (bigDecimal.subtract(bigDecimal3).abs().compareTo(bigDecimal5) <= 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"mag(a-b) = mag(a)-mag(b)", (bigDecimal2.subtract(bigDecimal4).abs().compareTo(bigDecimal5) <= 0 ? 1 : 0) != 0);
    }

    public void notestRealRootIsolation() {
        System.out.println();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(this.fac, 1);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(3, 5, 7, this.q);
        System.out.println("ar = " + genPolynomial);
        RealRootsSturm<Rational> realRootsSturm = new RealRootsSturm<Rational>();
        List<Interval<Object>> list = realRootsSturm.realRoots(genPolynomial);
        System.out.println("R = " + list);
        RealAlgebraicTest.assertTrue((String)"#roots >= 0 ", (list.size() >= 0 ? 1 : 0) != 0);
        BigRational bigRational = Power.positivePower(new BigRational(1L, 10L), BigDecimal.DEFAULT_PRECISION);
        RealAlgebraicNumber<BigRational> realAlgebraicNumber = ((RealAlgebraicNumber)genPolynomialRing.coFac.getONE()).multiply(bigRational);
        list = realRootsSturm.refineIntervals(list, genPolynomial, realAlgebraicNumber);
        for (Interval<Object> interval : list) {
            BigDecimal bigDecimal = interval.toDecimal();
            System.out.println("v = " + bigDecimal);
        }
    }

    public void testRealRootIsolationWilkinson() {
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(this.fac, 1);
        RealRootsSturm<RingElem<GenPolynomial<RealAlgebraicNumber<BigRational>>>> realRootsSturm = new RealRootsSturm<RingElem<GenPolynomial<RealAlgebraicNumber<BigRational>>>>();
        GenPolynomial<GenPolynomial<GenPolynomial<RealAlgebraicNumber<BigRational>>>> genPolynomial = genPolynomialRing.getONE();
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.univariate(0);
        ArrayList<Interval<RealAlgebraicNumber<BigRational>>> arrayList = new ArrayList<Interval<RealAlgebraicNumber<BigRational>>>(3);
        GenPolynomial<GenPolynomial<GenPolynomial<RealAlgebraicNumber<BigRational>>>> genPolynomial3 = genPolynomial;
        for (int i = 0; i < 3; ++i) {
            GenPolynomial<RealAlgebraicNumber<BigRational>> genPolynomial4 = ((GenPolynomial)genPolynomialRing.fromInteger(i)).multiply(this.alpha);
            arrayList.add(new Interval<RealAlgebraicNumber<BigRational>>(genPolynomial4.leadingBaseCoefficient()));
            GenPolynomial<GenPolynomial<RealAlgebraicNumber<BigRational>>> genPolynomial5 = genPolynomial2.subtract((BigRational)((Object)genPolynomial4));
            genPolynomial3 = genPolynomial3.multiply(genPolynomial5);
        }
        List<Interval<Object>> list = realRootsSturm.realRoots(genPolynomial3);
        RealAlgebraicTest.assertTrue((String)"#roots = 3 ", (list.size() == 3 ? 1 : 0) != 0);
        BigRational bigRational = Power.positivePower(new BigRational(1L, 10L), BigDecimal.DEFAULT_PRECISION);
        RealAlgebraicNumber<BigRational> realAlgebraicNumber = ((RealAlgebraicNumber)genPolynomialRing.coFac.getONE()).multiply(bigRational);
        list = realRootsSturm.refineIntervals(list, genPolynomial3, realAlgebraicNumber);
        int n = 0;
        for (Interval<Object> interval : list) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2 = interval.toDecimal();
            RealAlgebraicTest.assertTrue((String)"|dd - di| < eps ", (bigDecimal2.compareTo(bigDecimal = ((Interval)arrayList.get(n++)).toDecimal()) == 0 ? 1 : 0) != 0);
        }
    }
}

