/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DistPoolThread;
import edu.jas.util.ExecutableChannels;
import edu.jas.util.ShutdownRequest;
import edu.jas.util.StrategyEnumeration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class DistThreadPool {
    private final String mfile;
    private static final String DEFAULT_MFILE = "examples/machines.test";
    protected final int threads;
    static final int DEFAULT_SIZE = 3;
    final ExecutableChannels ec;
    protected DistPoolThread[] workers;
    protected int idleworkers = 0;
    protected LinkedList<Runnable> jobstack;
    protected StrategyEnumeration strategy = StrategyEnumeration.LIFO;
    private static final Logger logger = Logger.getLogger(DistThreadPool.class);
    private final boolean debug = true;

    public DistThreadPool() {
        this(StrategyEnumeration.FIFO, 3, null);
    }

    public DistThreadPool(StrategyEnumeration strategyEnumeration) {
        this(strategyEnumeration, 3, null);
    }

    public DistThreadPool(int n) {
        this(StrategyEnumeration.FIFO, n, null);
    }

    public DistThreadPool(int n, String string) {
        this(StrategyEnumeration.FIFO, n, string);
    }

    public DistThreadPool(StrategyEnumeration strategyEnumeration, int n, String string) {
        this.strategy = strategyEnumeration;
        this.threads = n < 0 ? 0 : n;
        this.mfile = string == null || string.length() == 0 ? DEFAULT_MFILE : string;
        this.jobstack = new LinkedList();
        try {
            this.ec = new ExecutableChannels(this.mfile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new IllegalArgumentException("DistThreadPool " + fileNotFoundException);
        }
        logger.info((Object)("ec = " + this.ec));
        try {
            this.ec.open(this.threads);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IllegalArgumentException("DistThreadPool " + iOException);
        }
        logger.info((Object)("ec = " + this.ec));
        this.workers = new DistPoolThread[0];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("DistThreadPool(");
        stringBuffer.append("threads=" + this.threads);
        stringBuffer.append(", strategy=" + this.strategy);
        stringBuffer.append(", exchan=" + this.ec);
        stringBuffer.append(", workers=" + this.workers.length);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void init() {
        if (this.workers == null || this.workers.length == 0) {
            this.workers = new DistPoolThread[this.threads];
            for (int i = 0; i < this.workers.length; ++i) {
                this.workers[i] = new DistPoolThread(this, this.ec, i);
                this.workers[i].start();
            }
            logger.info((Object)("init: " + this.toString()));
        }
    }

    public int getNumber() {
        if (this.workers == null || this.workers.length < this.threads) {
            this.init();
        }
        return this.workers.length;
    }

    public StrategyEnumeration getStrategy() {
        return this.strategy;
    }

    public ExecutableChannels getEC() {
        return this.ec;
    }

    public void terminate(boolean bl) {
        if (bl) {
            ShutdownRequest shutdownRequest = new ShutdownRequest();
            for (int i = 0; i < this.workers.length; ++i) {
                this.addJob(shutdownRequest);
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.info((Object)("remaining jobs = " + this.jobstack.size()));
            try {
                for (int i = 0; i < this.workers.length; ++i) {
                    while (this.workers[i].isAlive()) {
                        this.workers[i].interrupt();
                        this.workers[i].join(100L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.terminate();
        }
    }

    public void terminate() {
        while (this.hasJobs()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        for (int i = 0; i < this.workers.length; ++i) {
            try {
                while (this.workers[i].isAlive()) {
                    this.workers[i].interrupt();
                    this.workers[i].join(100L);
                }
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        this.ec.close();
    }

    public synchronized void addJob(Runnable runnable) {
        if (this.workers == null || this.workers.length < this.threads) {
            this.init();
        }
        this.jobstack.addLast(runnable);
        logger.debug((Object)"adding job");
        if (this.idleworkers > 0) {
            logger.debug((Object)"notifying a jobless worker");
            this.notifyAll();
        }
    }

    protected synchronized Runnable getJob() throws InterruptedException {
        while (this.jobstack.isEmpty()) {
            ++this.idleworkers;
            logger.debug((Object)"waiting");
            this.wait();
            --this.idleworkers;
        }
        if (this.strategy == StrategyEnumeration.LIFO) {
            return this.jobstack.removeLast();
        }
        return this.jobstack.removeFirst();
    }

    public boolean hasJobs() {
        if (this.jobstack.size() > 0) {
            return true;
        }
        for (int i = 0; i < this.workers.length; ++i) {
            if (!this.workers[i].working) continue;
            return true;
        }
        return false;
    }

    public boolean hasJobs(int n) {
        int n2 = this.jobstack.size();
        if (n2 > 0 && n2 + this.workers.length > n) {
            return true;
        }
        int n3 = 0;
        for (int i = 0; i < this.workers.length; ++i) {
            if (!this.workers[i].working) continue;
            ++n3;
        }
        return n2 + n3 > n;
    }
}

