/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.arith.PrimeList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.HenselApprox;
import edu.jas.ufd.HenselMultUtil;
import edu.jas.ufd.HenselUtil;
import edu.jas.ufd.NoLiftingException;
import edu.jas.ufd.TrialParts;
import edu.jas.util.KsubSet;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class FactorInteger<MOD extends GcdRingElem<MOD> & Modular>
extends FactorAbstract<edu.jas.arith.BigInteger> {
    private static final Logger logger = Logger.getLogger(FactorInteger.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final FactorAbstract<MOD> mfactor;
    protected final GreatestCommonDivisorAbstract<MOD> mengine;

    public FactorInteger() {
        this(edu.jas.arith.BigInteger.ONE);
    }

    public FactorInteger(RingFactory<edu.jas.arith.BigInteger> ringFactory) {
        super(ringFactory);
        ModularRingFactory modularRingFactory = new ModLongRing(13L, true);
        this.mfactor = FactorFactory.getImplementation(modularRingFactory);
        this.mengine = GCDFactory.getImplementation(modularRingFactory);
    }

    @Override
    public List<GenPolynomial<edu.jas.arith.BigInteger>> baseFactorsSquarefree(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        ArrayList arrayList;
        block30: {
            Iterable<Element<ExpVector>> iterable;
            Serializable serializable;
            int n;
            if (genPolynomial == null) {
                throw new IllegalArgumentException(this.getClass().getName() + " P == null");
            }
            arrayList = new ArrayList<GenPolynomial<edu.jas.arith.BigInteger>>();
            if (genPolynomial.isZERO()) {
                return arrayList;
            }
            if (genPolynomial.isONE()) {
                arrayList.add(genPolynomial);
                return arrayList;
            }
            GenPolynomialRing genPolynomialRing = genPolynomial.ring;
            if (genPolynomialRing.nvar > 1) {
                throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
            }
            if (!this.engine.baseContent(genPolynomial).isONE()) {
                throw new IllegalArgumentException(this.getClass().getName() + " P not primitive");
            }
            if (genPolynomial.degree(0) <= 1L) {
                arrayList.add(genPolynomial);
                return arrayList;
            }
            edu.jas.arith.BigInteger bigInteger = genPolynomial.maxNorm();
            edu.jas.arith.BigInteger bigInteger2 = genPolynomial.leadingBaseCoefficient();
            ExpVector expVector = genPolynomial.degreeVector();
            int n2 = (int)genPolynomial.degree(0);
            edu.jas.arith.BigInteger bigInteger3 = bigInteger.multiply(PolyUtil.factorBound(expVector));
            bigInteger3 = bigInteger3.multiply(bigInteger2.abs().multiply(bigInteger2.fromInteger(8L)));
            PrimeList primeList = new PrimeList(PrimeList.Range.small);
            int n3 = 30;
            Iterable<ModLong> iterable2 = null;
            GenPolynomial<MonoidElem> genPolynomial2 = null;
            GenPolynomialRing<ModLong> genPolynomialRing2 = null;
            List[] listArray = new List[5];
            List[] listArray2 = new List[5];
            edu.jas.arith.BigInteger[] bigIntegerArray = new edu.jas.arith.BigInteger[5];
            List list = null;
            Object var19_18 = null;
            int n4 = 0;
            if (this.debug) {
                logger.debug((Object)("an  = " + bigInteger));
                logger.debug((Object)("ac  = " + bigInteger2));
                logger.debug((Object)("M   = " + bigInteger3));
                logger.info((Object)("degv = " + expVector));
            }
            Iterator<BigInteger> iterator = primeList.iterator();
            iterator.next();
            iterator.next();
            MonoidElem monoidElem = null;
            for (n = 0; n < 5; ++n) {
                if (n == 4) {
                    primeList = new PrimeList(PrimeList.Range.medium);
                    iterator = primeList.iterator();
                }
                if (n == 6) {
                    primeList = new PrimeList(PrimeList.Range.large);
                    iterator = primeList.iterator();
                }
                while (iterator.hasNext()) {
                    serializable = iterator.next();
                    if (++n4 >= n3) {
                        logger.error((Object)("prime list exhausted, pn = " + n3));
                        throw new ArithmeticException("prime list exhausted");
                    }
                    iterable2 = ModLongRing.MAX_LONG.compareTo((BigInteger)serializable) > 0 ? new ModLongRing((BigInteger)serializable, true) : new ModIntegerRing((BigInteger)serializable, true);
                    logger.info((Object)("prime = " + iterable2));
                    monoidElem = (GcdRingElem)iterable2.fromInteger(bigInteger2.getVal());
                    if (monoidElem.isZERO()) {
                        logger.info((Object)("unlucky prime (nf) = " + serializable));
                        continue;
                    }
                    genPolynomialRing2 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable2), genPolynomialRing);
                    genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, genPolynomial);
                    if (!genPolynomial2.degreeVector().equals(expVector)) {
                        logger.info((Object)("unlucky prime (deg) = " + serializable));
                        continue;
                    }
                    GenPolynomial<MonoidElem> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
                    if (genPolynomial3.isZERO()) {
                        logger.info((Object)("unlucky prime (a')= " + serializable));
                        continue;
                    }
                    iterable = this.mengine.baseGcd(genPolynomial2, genPolynomial3);
                    if (!((GenPolynomial)iterable).isONE()) continue;
                    logger.info((Object)("**lucky prime = " + serializable));
                    break;
                }
                if (!monoidElem.isONE()) {
                    genPolynomial2 = genPolynomial2.divide(monoidElem);
                }
                list = this.mfactor.baseFactorsSquarefree(genPolynomial2);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("modlist  = " + list));
                }
                if (list.size() <= 1) {
                    arrayList.add(genPolynomial);
                    return arrayList;
                }
                if (!monoidElem.isONE()) {
                    serializable = genPolynomialRing2.getONE();
                    serializable = ((GenPolynomial)serializable).multiply(monoidElem);
                    list.add(0, (GenPolynomial<MonoidElem>)serializable);
                }
                listArray[n] = list;
                bigIntegerArray[n] = iterable2.getIntegerModul();
            }
            n = Integer.MAX_VALUE;
            serializable = null;
            for (int i = 0; i < 5; ++i) {
                iterable = PolyUtil.leadingExpVector(listArray[i]);
                BitSet bitSet = this.factorDegrees((List<ExpVector>)iterable, n2);
                if (serializable == null) {
                    serializable = bitSet;
                } else {
                    ((BitSet)serializable).and(bitSet);
                }
                int n5 = listArray[i].size();
                logger.info((Object)("mod(" + bigIntegerArray[i] + ") #s = " + n5 + ", D = " + bitSet));
                if (n5 >= n) continue;
                n = n5;
                list = listArray[i];
            }
            logger.info((Object)("min = " + n + ", AD = " + serializable));
            if (list.size() <= 1) {
                logger.info((Object)"mlist.size() = 1");
                arrayList.add(genPolynomial);
                return arrayList;
            }
            if (((BitSet)serializable).cardinality() <= 2) {
                logger.info((Object)("degree set cardinality = " + ((BitSet)serializable).cardinality()));
                arrayList.add(genPolynomial);
                return arrayList;
            }
            if (this.debug) {
                logger.info((Object)("lifting shortest from " + list));
            }
            if (genPolynomial.leadingBaseCoefficient().isONE()) {
                long l = System.currentTimeMillis();
                try {
                    list = PolyUtil.monic(list);
                    arrayList = this.searchFactorsMonic(genPolynomial, bigInteger3, list, (BitSet)serializable);
                    l = System.currentTimeMillis() - l;
                    if (!this.debug) break block30;
                    l = System.currentTimeMillis();
                    List<GenPolynomial<edu.jas.arith.BigInteger>> list2 = this.searchFactorsNonMonic(genPolynomial, bigInteger3, list, (BitSet)serializable);
                    l = System.currentTimeMillis() - l;
                    System.out.println("non monic time = " + l);
                    if (!arrayList.equals(list2)) {
                        System.out.println("monic factors     = " + arrayList);
                        System.out.println("non monic factors = " + list2);
                    }
                }
                catch (RuntimeException runtimeException) {
                    l = System.currentTimeMillis();
                    arrayList = this.searchFactorsNonMonic(genPolynomial, bigInteger3, list, (BitSet)serializable);
                    l = System.currentTimeMillis() - l;
                }
            } else {
                long l = System.currentTimeMillis();
                arrayList = this.searchFactorsNonMonic(genPolynomial, bigInteger3, list, (BitSet)serializable);
                l = System.currentTimeMillis() - l;
            }
        }
        return this.normalizeFactorization(arrayList);
    }

    public BitSet factorDegrees(List<ExpVector> list, int n) {
        BitSet bitSet = new BitSet(n + 1);
        bitSet.set(0);
        for (ExpVector expVector : list) {
            int n2 = (int)expVector.getVal(0);
            BitSet bitSet2 = new BitSet(n + 1);
            for (int i = 0; i < n + 1 - n2; ++i) {
                bitSet2.set(n2 + i, bitSet.get(i));
            }
            bitSet.or(bitSet2);
        }
        return bitSet;
    }

    public static <C extends RingElem<C>> long degreeSum(List<GenPolynomial<C>> list) {
        long l = 0L;
        for (GenPolynomial<C> genPolynomial : list) {
            ExpVector expVector = genPolynomial.leadingExpVector();
            long l2 = expVector.getVal(0);
            l += l2;
        }
        return l;
    }

    List<GenPolynomial<edu.jas.arith.BigInteger>> searchFactorsMonic(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial, edu.jas.arith.BigInteger bigInteger, List<GenPolynomial<MOD>> list, BitSet bitSet) {
        List<GenPolynomial<Object>> list2;
        if (genPolynomial == null || genPolynomial.isZERO() || list == null || list.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing<edu.jas.arith.BigInteger> genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        ArrayList arrayList = new ArrayList(list.size());
        List<GenPolynomial<MOD>> list3 = list;
        GenPolynomial<MOD> genPolynomial2 = list3.get(0);
        if (genPolynomial2.isConstant()) {
            list3.remove(genPolynomial2);
            if (list3.size() <= 1) {
                arrayList.add(genPolynomial);
                return arrayList;
            }
        }
        ModularRingFactory modularRingFactory = (ModularRingFactory)genPolynomial2.ring.coFac;
        edu.jas.arith.BigInteger bigInteger2 = modularRingFactory.getIntegerModul();
        long l = 1L;
        edu.jas.arith.BigInteger bigInteger3 = bigInteger2;
        while (bigInteger3.compareTo(bigInteger) < 0) {
            ++l;
            bigInteger3 = bigInteger3.multiply(bigInteger2);
        }
        logger.info((Object)("p^k = " + bigInteger2 + "^" + l));
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial3 = genPolynomial;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial4 = genPolynomial;
        try {
            list2 = HenselUtil.liftHenselMonic(genPolynomial3, list3, l);
        }
        catch (NoLiftingException noLiftingException) {
            throw new RuntimeException(noLiftingException);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("lifted modlist = " + list2));
        }
        GenPolynomialRing genPolynomialRing2 = list2.get((int)0).ring;
        int n = (list2.size() + 1) / 2;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial5 = genPolynomial3;
        long l2 = (genPolynomial5.degree(0) + 1L) / 2L;
        block3: for (int i = 1; i <= n; ++i) {
            KsubSet<GenPolynomial<MOD>> ksubSet = new KsubSet<GenPolynomial<MOD>>(list2, i);
            for (List list4 : ksubSet) {
                if (!bitSet.get((int)FactorInteger.degreeSum(list4))) {
                    logger.info((Object)("skipped by degree set " + bitSet + ", deg = " + FactorInteger.degreeSum(list4)));
                    continue;
                }
                GenPolynomial genPolynomial6 = Power.multiply(genPolynomialRing2, list4);
                if (genPolynomial6.degree(0) > l2) {
                    logger.info((Object)("degree " + genPolynomial6.degree(0) + " > deg " + l2));
                }
                GenPolynomial<edu.jas.arith.BigInteger> genPolynomial7 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial6);
                if (!PolyUtil.baseSparsePseudoRemainder(genPolynomial5, genPolynomial7 = this.engine.basePrimitivePart(genPolynomial7)).isZERO()) continue;
                logger.info((Object)("successful trial = " + genPolynomial7));
                arrayList.add(genPolynomial7);
                genPolynomial5 = PolyUtil.basePseudoDivide(genPolynomial5, genPolynomial7);
                list2 = FactorInteger.removeOnce(list2, list4);
                logger.info((Object)("new lift= " + list2));
                n = (list2.size() + 1) / 2;
                i = 0;
                continue block3;
            }
        }
        if (!genPolynomial5.isONE() && !genPolynomial5.equals(genPolynomial4)) {
            logger.info((Object)("rest u = " + genPolynomial5));
            arrayList.add(genPolynomial5);
        }
        if (arrayList.size() == 0) {
            logger.info((Object)("irred u = " + genPolynomial5));
            arrayList.add(genPolynomial3);
        }
        return this.normalizeFactorization(arrayList);
    }

    List<GenPolynomial<edu.jas.arith.BigInteger>> searchFactorsNonMonic(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial, edu.jas.arith.BigInteger bigInteger, List<GenPolynomial<MOD>> list, BitSet bitSet) {
        if (genPolynomial == null || genPolynomial.isZERO() || list == null || list.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        ArrayList arrayList = new ArrayList(list.size());
        List<GenPolynomial<Object>> list2 = list;
        GcdRingElem gcdRingElem = null;
        GenPolynomial<MOD> genPolynomial2 = list2.get(0);
        if (genPolynomial2.isConstant()) {
            gcdRingElem = (GcdRingElem)genPolynomial2.leadingBaseCoefficient();
            list2.remove(genPolynomial2);
            if (list2.size() <= 1) {
                arrayList.add(genPolynomial);
                return arrayList;
            }
        } else {
            gcdRingElem = (GcdRingElem)genPolynomial2.ring.coFac.getONE();
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomial2.ring;
        GenPolynomial<GcdRingElem> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, genPolynomial);
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial4 = genPolynomial;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial5 = genPolynomial;
        int n = (list2.size() + 1) / 2;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial6 = genPolynomial4;
        long l = (genPolynomial6.degree(0) + 1L) / 2L;
        GenPolynomial<GcdRingElem> genPolynomial7 = genPolynomial3;
        HenselApprox<GcdRingElem> henselApprox = null;
        block2: for (int i = 1; i <= n; ++i) {
            KsubSet<GenPolynomial<MOD>> ksubSet = new KsubSet<GenPolynomial<MOD>>(list2, i);
            for (List list3 : ksubSet) {
                GenPolynomial<Object> genPolynomial8;
                if (!bitSet.get((int)FactorInteger.degreeSum(list3))) {
                    logger.info((Object)("skipped by degree set " + bitSet + ", deg = " + FactorInteger.degreeSum(list3)));
                    continue;
                }
                GenPolynomial genPolynomial9 = ((GenPolynomial)genPolynomialRing2.getONE()).multiply(gcdRingElem);
                for (int j = 0; j < list3.size(); ++j) {
                    genPolynomial8 = list3.get(j);
                    genPolynomial9 = genPolynomial9.multiply(genPolynomial8);
                }
                if (genPolynomial9.degree(0) > l) {
                    logger.info((Object)("degree > deg " + l + ", degree = " + genPolynomial9.degree(0)));
                }
                GenPolynomial<GcdRingElem> genPolynomial10 = genPolynomial7.divide(genPolynomial9);
                try {
                    henselApprox = HenselUtil.liftHenselQuadratic(genPolynomial4, bigInteger, genPolynomial9, genPolynomial10);
                }
                catch (NoLiftingException noLiftingException) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.info((Object)("no liftable factors " + noLiftingException));
                    continue;
                }
                genPolynomial8 = henselApprox.A;
                GenPolynomial<edu.jas.arith.BigInteger> genPolynomial11 = henselApprox.B;
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("       modlist = " + genPolynomial9 + ", cofactor " + genPolynomial10));
                    logger.info((Object)("lifted intlist = " + genPolynomial8 + ", cofactor " + genPolynomial11));
                }
                if (!PolyUtil.baseSparsePseudoRemainder(genPolynomial6, genPolynomial8 = this.engine.basePrimitivePart(genPolynomial8)).isZERO()) continue;
                logger.info((Object)("successful trial = " + genPolynomial8));
                arrayList.add(genPolynomial8);
                genPolynomial4 = genPolynomial6 = genPolynomial11;
                genPolynomial7 = genPolynomial10;
                list2 = FactorInteger.removeOnce(list2, list3);
                logger.info((Object)("new mlist= " + list2));
                n = (list2.size() + 1) / 2;
                i = 0;
                continue block2;
            }
        }
        if (!genPolynomial6.isONE() && !genPolynomial6.equals(genPolynomial5)) {
            logger.info((Object)("rest u = " + genPolynomial6));
            arrayList.add(genPolynomial6);
        }
        if (arrayList.size() == 0) {
            logger.info((Object)("irred u = " + genPolynomial4));
            arrayList.add(genPolynomial4);
        }
        return this.normalizeFactorization(arrayList);
    }

    @Override
    public List<GenPolynomial<edu.jas.arith.BigInteger>> factorsSquarefree(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        Iterable iterable;
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseFactorsSquarefree(genPolynomial);
        }
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(genPolynomial);
        OptimizedPolynomialList optimizedPolynomialList = TermOrderOptimization.optimizeTermOrder(genPolynomialRing, arrayList);
        genPolynomial = (GenPolynomial)optimizedPolynomialList.list.get(0);
        logger.info((Object)("optimized polynomial: " + genPolynomial));
        List<Integer> list = TermOrderOptimization.inversePermutation(optimizedPolynomialList.perm);
        logger.info((Object)("optimize perm: " + optimizedPolynomialList.perm + ", de-optimize perm: " + list));
        ExpVector expVector = genPolynomial.degreeVector();
        int[] nArray = expVector.dependencyOnVariables();
        List<GenPolynomial<edu.jas.arith.BigInteger>> list2 = null;
        if (expVector.length() == nArray.length) {
            try {
                logger.info((Object)("try factorsSquarefreeHensel: " + genPolynomial));
                list2 = this.factorsSquarefreeHensel(genPolynomial);
            }
            catch (Exception exception) {
                logger.warn((Object)("exception " + exception));
            }
        } else {
            iterable = PolyUtil.removeUnusedUpperVariables(genPolynomial);
            GenPolynomial genPolynomial2 = PolyUtil.removeUnusedLowerVariables(iterable);
            try {
                logger.info((Object)("try factorsSquarefreeHensel: " + genPolynomial2));
                list2 = this.factorsSquarefreeHensel((GenPolynomial<edu.jas.arith.BigInteger>)iterable);
                ArrayList<GenPolynomial<Object>> arrayList2 = new ArrayList<GenPolynomial<Object>>(list2.size());
                GenPolynomialRing genPolynomialRing2 = genPolynomial.ring;
                GenPolynomialRing genPolynomialRing3 = iterable.ring;
                for (GenPolynomial<Object> genPolynomial3 : list2) {
                    GenPolynomial<Object> genPolynomial4 = genPolynomial3.extendLower(genPolynomialRing3, 0, 0L);
                    GenPolynomial<Object> genPolynomial5 = genPolynomial4.extend(genPolynomialRing2, 0, 0L);
                    arrayList2.add(genPolynomial5);
                }
                list2 = arrayList2;
            }
            catch (Exception exception) {
                logger.warn((Object)("exception " + exception));
            }
        }
        if (list2 == null) {
            logger.info((Object)("factorsSquarefreeHensel not applicable or failed, reverting to Kronecker for: " + genPolynomial));
            list2 = super.factorsSquarefree(genPolynomial);
        }
        iterable = TermOrderOptimization.permutation(list, genPolynomialRing, list2);
        logger.info((Object)("de-optimized polynomials: " + iterable));
        list2 = this.normalizeFactorization(iterable);
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public List<GenPolynomial<edu.jas.arith.BigInteger>> factorsSquarefreeHensel(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        List<GenPolynomial<ModLong>> list;
        void var52_91;
        GcdRingElem<edu.jas.arith.BigInteger> gcdRingElem;
        Iterable<ModLong> iterable;
        Comparable<BigInteger> comparable;
        Iterable iterable2;
        Iterable iterable3;
        GenPolynomial genPolynomial2;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing<edu.jas.arith.BigInteger> genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar == 1) {
            return this.baseFactorsSquarefree(genPolynomial);
        }
        List<GenPolynomial<edu.jas.arith.BigInteger>> list2 = new ArrayList<GenPolynomial<edu.jas.arith.BigInteger>>();
        if (genPolynomial.isZERO()) {
            return list2;
        }
        if (genPolynomial.degreeVector().totalDeg() <= 1L) {
            list2.add(genPolynomial);
            return list2;
        }
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial3 = genPolynomial;
        edu.jas.arith.BigInteger bigInteger = genPolynomial3.leadingBaseCoefficient();
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(genPolynomialRing.nvar - 1);
        GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing2, genPolynomial3);
        GenPolynomial genPolynomial5 = PolyUtil.switchVariables(genPolynomial4);
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial6 = this.engine.recursiveContent(genPolynomial5);
        List<GenPolynomial<edu.jas.arith.BigInteger>> list3 = null;
        if (!genPolynomial6.isONE()) {
            genPolynomial5 = PolyUtil.recursiveDivide(genPolynomial5, genPolynomial6);
            genPolynomial2 = genPolynomial6.extendLower(genPolynomialRing, 0, 0L);
            genPolynomial3 = PolyUtil.basePseudoDivide(genPolynomial3, genPolynomial2);
            logger.info((Object)("recursive content = " + genPolynomial6 + ", new P = " + genPolynomial3));
            list3 = this.factorsSquarefree(genPolynomial6);
            ArrayList<GenPolynomial<edu.jas.arith.BigInteger>> arrayList = new ArrayList<GenPolynomial<edu.jas.arith.BigInteger>>(list3.size());
            for (GenPolynomial iterable42 : list3) {
                iterable3 = iterable42.extendLower(genPolynomialRing, 0, 0L);
                arrayList.add((GenPolynomial<edu.jas.arith.BigInteger>)iterable3);
            }
            list3 = arrayList;
            logger.info((Object)("cfactors = " + list3));
        }
        genPolynomial2 = genPolynomial5.leadingBaseCoefficient();
        logger.info((Object)("leading coeffcient = " + genPolynomial2));
        boolean bl = false;
        if (genPolynomial2.isConstant()) {
            bl = true;
        }
        SortedMap sortedMap = this.factors(genPolynomial2);
        ArrayList arrayList = new ArrayList(sortedMap.keySet());
        logger.info((Object)("leading coefficient factors = " + arrayList));
        iterable3 = genPolynomialRing;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial7 = genPolynomial3;
        GenPolynomialRing genPolynomialRing3 = genPolynomial2.ring;
        List<GenPolynomial<Object>> list4 = arrayList;
        List<GenPolynomial<Object>> list5 = null;
        List<edu.jas.arith.BigInteger> list6 = null;
        ArrayList<edu.jas.arith.BigInteger> arrayList2 = new ArrayList<edu.jas.arith.BigInteger>();
        GcdRingElem<edu.jas.arith.BigInteger> gcdRingElem2 = null;
        edu.jas.arith.BigInteger bigInteger2 = null;
        edu.jas.arith.BigInteger bigInteger3 = null;
        List<GenPolynomial<edu.jas.arith.BigInteger>> list7 = null;
        ArrayList<TrialParts> arrayList3 = new ArrayList<TrialParts>();
        List list8 = null;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial8 = null;
        ArrayList<Comparable<Serializable>> arrayList4 = null;
        ArrayList<Object> arrayList5 = null;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial9 = null;
        List<Object> list9 = null;
        long l = 0L;
        ArrayList<Long> arrayList6 = new ArrayList<Long>(genPolynomialRing.nvar + 1);
        for (int i = 0; i <= genPolynomialRing.nvar; ++i) {
            arrayList6.add(l);
        }
        int n = 0;
        double d = 1.001;
        boolean bl2 = true;
        boolean bl3 = true;
        while (bl3) {
            RingElem<edu.jas.arith.BigInteger> ringElem;
            int n2;
            int genPolynomial12;
            if (Math.abs(l) > 371L) {
                logger.warn((Object)("no lucky evaluation point for: P = " + genPolynomial + ", lprr = " + genPolynomial2 + ", lfacs = " + arrayList));
                throw new RuntimeException("no lucky evaluation point found after " + Math.abs(l) + " iterations");
            }
            if (Math.abs(l) % 100L <= 3L) {
                d *= 1.001592653589793;
            }
            bl3 = false;
            list9 = new ArrayList();
            iterable3 = genPolynomialRing;
            genPolynomial7 = genPolynomial3;
            genPolynomialRing3 = genPolynomial2.ring;
            list4 = arrayList;
            list5 = null;
            list6 = null;
            gcdRingElem2 = null;
            bigInteger3 = null;
            long n6 = 0L;
            for (genPolynomial12 = genPolynomialRing.nvar; genPolynomial12 > 1; --genPolynomial12) {
                long l2 = genPolynomial7.degree(((GenPolynomialRing)iterable3).nvar - 2);
                iterable3 = ((GenPolynomialRing)iterable3).contract(1);
                genPolynomialRing3 = genPolynomialRing3.contract(1);
                n6 = (Long)arrayList6.get(genPolynomial12);
                n2 = 1;
                ringElem = null;
                GenPolynomial<edu.jas.arith.BigInteger> genPolynomial10 = null;
                while (n2 != 0) {
                    logger.info((Object)("vi(" + genPolynomial12 + ") = " + n6));
                    ringElem = new edu.jas.arith.BigInteger(n6);
                    genPolynomial10 = PolyUtil.evaluateMain(iterable3, genPolynomial7, ringElem);
                    if (l2 == genPolynomial10.degree(((GenPolynomialRing)iterable3).nvar - 1)) {
                        logger.info((Object)("pep = " + genPolynomial10));
                        if (this.sengine.isSquarefree(genPolynomial10)) {
                            n2 = 0;
                        }
                    }
                    if (n6 > 0L) {
                        n6 = -n6;
                        continue;
                    }
                    n6 = 1L - n6;
                }
                if (genPolynomialRing3.nvar >= 1) {
                    list5 = PolyUtil.evaluateMain(genPolynomialRing3, list4, ringElem);
                } else {
                    list6 = PolyUtil.evaluateMain(genPolynomialRing3.coFac, list4, ringElem);
                }
                int n3 = (int)Math.round(d + 0.52 * Math.random());
                if (n6 > 0L) {
                    arrayList6.set(genPolynomial12, n6 + (long)n3);
                    l = n6 + (long)n3;
                } else {
                    arrayList6.set(genPolynomial12, n6 - (long)n3);
                    l = n6 - (long)n3;
                }
                list9.add(ringElem);
                genPolynomial7 = genPolynomial10;
                list4 = list5;
            }
            bigInteger2 = this.engine.baseContent(genPolynomial7);
            bl2 = bigInteger2.isONE();
            bigInteger3 = (edu.jas.arith.BigInteger)genPolynomialRing3.coFac.getONE();
            gcdRingElem2 = (edu.jas.arith.BigInteger)genPolynomial7.ring.coFac.getONE();
            if (!bl) {
                gcdRingElem2 = n > 50 ? (edu.jas.arith.BigInteger)genPolynomial7.ring.coFac.getONE() : bigInteger2;
                if (((GenPolynomial)arrayList.get(0)).isConstant()) {
                    bigInteger3 = list6.remove(0);
                }
                arrayList2 = new ArrayList();
                arrayList2.add(gcdRingElem2.multiply(bigInteger3).abs());
                genPolynomial12 = 1;
                for (edu.jas.arith.BigInteger bigInteger4 : list6) {
                    if (bigInteger4.isZERO()) {
                        logger.info((Object)("condition (0) not met for cei = " + list6));
                        bl3 = true;
                        break;
                    }
                    ringElem = bigInteger4.abs();
                    for (n2 = genPolynomial12 - 1; n2 >= 0; --n2) {
                        edu.jas.arith.BigInteger bigInteger5 = (edu.jas.arith.BigInteger)arrayList2.get(n2);
                        while (!bigInteger5.isONE()) {
                            bigInteger5 = bigInteger5.gcd((edu.jas.arith.BigInteger)ringElem);
                            ringElem = ((edu.jas.arith.BigInteger)ringElem).divide(bigInteger5);
                        }
                    }
                    arrayList2.add((edu.jas.arith.BigInteger)ringElem);
                    if (((edu.jas.arith.BigInteger)ringElem).isONE()) {
                        logger.info((Object)("condition (1) not met for dei = " + arrayList2 + ", cei = " + list6));
                        if (!this.testSeparate(list6, bigInteger2) && ++n > 50) {
                            logger.info((Object)("too many inseparable evaluation points: " + n + ", removing " + bigInteger2));
                        }
                        bl3 = true;
                        break;
                    }
                    ++genPolynomial12;
                }
            }
            if (bl3) continue;
            logger.info((Object)("evaluation points  = " + list9 + ", dei = " + arrayList2));
            logger.info((Object)("univariate polynomial = " + genPolynomial7 + ", pecw = " + bigInteger2));
            list7 = this.baseFactorsSquarefree(genPolynomial7.divide(bigInteger2));
            if (!bigInteger2.isONE()) {
                list7.add(0, ((GenPolynomial)((GenPolynomialRing)iterable3).getONE()).multiply(bigInteger2));
            }
            if (list7.size() <= 1) {
                logger.info((Object)"irreducible univariate polynomial");
                list2.add(genPolynomial3);
                if (list3 != null) {
                    list3.addAll(list2);
                    list2 = list3;
                }
                return list2;
            }
            logger.info((Object)("univariate factors = " + list7));
            list8 = new ArrayList<GenPolynomial<edu.jas.arith.BigInteger>>();
            genPolynomial8 = genPolynomial2.ring.getONE();
            for (GenPolynomial<edu.jas.arith.BigInteger> genPolynomial13 : list7) {
                list8.add((GenPolynomial<edu.jas.arith.BigInteger>)genPolynomial2.ring.getONE());
            }
            if (!bl || !bigInteger2.isONE()) {
                if (arrayList.size() > 0 && ((GenPolynomial)arrayList.get(0)).isConstant()) {
                    GenPolynomial i = (GenPolynomial)arrayList.remove(0);
                }
                for (int list92 = list7.size() - 1; list92 >= 0; --list92) {
                    void var48_63;
                    GenPolynomial<edu.jas.arith.BigInteger> list10 = list7.get(list92);
                    edu.jas.arith.BigInteger bigInteger7 = list10.leadingBaseCoefficient();
                    bigInteger7 = bigInteger7.multiply((edu.jas.arith.BigInteger)gcdRingElem2);
                    ringElem = list8.get(list92);
                    n2 = 0;
                    for (edu.jas.arith.BigInteger bigInteger8 : list6) {
                        if (bigInteger8.abs().isONE()) {
                            System.out.println("ppl = " + var48_63 + ", ci = " + bigInteger8 + ", lfp = " + ringElem + ", lfacs.get(ii) = " + arrayList.get(n2));
                            throw new RuntimeException("something is wrong, ci is a unit");
                        }
                        while (var48_63.remainder(bigInteger8).isZERO() && arrayList.size() > n2) {
                            edu.jas.arith.BigInteger bigInteger9 = var48_63.divide(bigInteger8);
                            ringElem = ((GenPolynomial)ringElem).multiply((edu.jas.arith.BigInteger)((Object)((GenPolynomial)arrayList.get(n2))));
                        }
                        ++n2;
                    }
                    ringElem = ((GenPolynomial)ringElem).multiply((edu.jas.arith.BigInteger)var48_63);
                    list8.set(list92, ringElem);
                }
                gcdRingElem2 = bigInteger2;
                genPolynomial8 = Power.multiply(genPolynomial2.ring, list8);
                if (!genPolynomial2.degreeVector().equals(genPolynomial8.degreeVector())) {
                    logger.info((Object)("deg(lprr) != deg(lpx): lprr = " + genPolynomial2 + ", lpx = " + genPolynomial8));
                    bl3 = true;
                    continue;
                }
                if (!gcdRingElem2.isONE()) {
                    void var48_68;
                    void var48_66;
                    List<GenPolynomial<Object>> trialParts = list8;
                    List<RingElem<edu.jas.arith.BigInteger>> trialParts2 = null;
                    genPolynomialRing3 = genPolynomial2.ring;
                    int n4 = genPolynomial2.ring.nvar;
                    while (var48_66 > 0) {
                        genPolynomialRing3 = genPolynomialRing3.contract(1);
                        ringElem = (edu.jas.arith.BigInteger)list9.get(genPolynomial2.ring.nvar - var48_66);
                        if (genPolynomialRing3.nvar >= 1) {
                            trialParts = PolyUtil.evaluateMain(genPolynomialRing3, trialParts, ringElem);
                        } else {
                            trialParts2 = PolyUtil.evaluateMain(genPolynomialRing3.coFac, trialParts, ringElem);
                        }
                        --var48_66;
                    }
                    arrayList4 = new ArrayList<Comparable<Serializable>>(list8.size());
                    arrayList5 = new ArrayList<Object>(list8.size());
                    boolean bl4 = false;
                    while (var48_68 < list8.size()) {
                        ringElem = list7.get((int)var48_68);
                        edu.jas.arith.BigInteger bigInteger10 = (edu.jas.arith.BigInteger)((GenPolynomial)ringElem).leadingBaseCoefficient();
                        edu.jas.arith.BigInteger bigInteger11 = (edu.jas.arith.BigInteger)trialParts2.get((int)var48_68);
                        edu.jas.arith.BigInteger bigInteger12 = bigInteger10.gcd(bigInteger11).abs();
                        iterable2 = bigInteger10.divide(bigInteger12);
                        edu.jas.arith.BigInteger bigInteger13 = bigInteger11.divide(bigInteger12);
                        comparable = list8.get((int)var48_68);
                        GenPolynomial<GenPolynomialRing<ModLong>> genPolynomial11 = ((GenPolynomial)comparable).multiply(iterable2);
                        iterable = ((GenPolynomial)ringElem).multiply(bigInteger13);
                        if (gcdRingElem2.isONE()) {
                            arrayList4.add(comparable);
                            arrayList5.add(ringElem);
                        } else {
                            arrayList4.add(genPolynomial11);
                            arrayList5.add(iterable);
                            gcdRingElem = gcdRingElem2.divide(bigInteger13);
                            gcdRingElem2 = gcdRingElem;
                        }
                        ++var48_68;
                    }
                    if (!list8.equals(arrayList4) || !arrayList5.equals(list7)) {
                        logger.debug((Object)"!lf.equals(ln) || !un.equals(ufactors)");
                    }
                    if (!gcdRingElem2.isONE()) {
                        void var48_70;
                        arrayList4 = new ArrayList(list8.size());
                        arrayList5 = new ArrayList(list8.size());
                        genPolynomial9 = genPolynomial7;
                        boolean bl5 = false;
                        while (var48_70 < list8.size()) {
                            ringElem = list7.get((int)var48_70);
                            GenPolynomial<edu.jas.arith.BigInteger> genPolynomial13 = list8.get((int)var48_70);
                            if (!((GenPolynomial)ringElem).isConstant()) {
                                ringElem = ((GenPolynomial)ringElem).multiply(gcdRingElem2);
                            }
                            genPolynomial13 = genPolynomial13.multiply((edu.jas.arith.BigInteger)gcdRingElem2);
                            if (var48_70 != false) {
                                genPolynomial9 = genPolynomial9.multiply((edu.jas.arith.BigInteger)gcdRingElem2);
                            }
                            arrayList5.add(ringElem);
                            arrayList4.add(genPolynomial13);
                            ++var48_70;
                        }
                        if (genPolynomial9.equals(Power.multiply(genPolynomial7.ring, arrayList5))) {
                            bl2 = false;
                        }
                    }
                }
                if (bl3) continue;
                logger.info((Object)("distributed factors of leading coefficient = " + list8));
                genPolynomial8 = Power.multiply(genPolynomial2.ring, list8);
                if (!((GenPolynomial)genPolynomial2.abs()).equals(genPolynomial8.abs()) && !genPolynomial2.degreeVector().equals(genPolynomial8.degreeVector())) {
                    logger.info((Object)("lprr != lpx: lprr = " + genPolynomial2 + ", lpx = " + genPolynomial8));
                    bl3 = true;
                }
            }
            if (bl3) continue;
            TrialParts genPolynomialRing4 = null;
            genPolynomialRing4 = bl2 ? new TrialParts(list9, genPolynomial7, list7, list6, list8) : new TrialParts(list9, genPolynomial9, arrayList5, list6, arrayList4);
            if (genPolynomialRing4.univPoly != null && genPolynomialRing4.ldcfEval.size() != 0) {
                arrayList3.add(genPolynomialRing4);
            }
            if (arrayList3.size() >= 4) continue;
            bl3 = true;
        }
        int n5 = Integer.MAX_VALUE;
        TrialParts trialParts = null;
        for (TrialParts trialParts3 : arrayList3) {
            logger.info((Object)("tp.univFactors.size() = " + trialParts3.univFactors.size()));
            if (trialParts3.univFactors.size() >= n5) continue;
            n5 = trialParts3.univFactors.size();
            trialParts = trialParts3;
        }
        for (TrialParts primeList : arrayList3) {
            if (primeList.univFactors.size() != n5 || primeList.univFactors.get(0).isConstant()) continue;
            trialParts = primeList;
            break;
        }
        list9 = trialParts.evalPoints;
        genPolynomial7 = trialParts.univPoly;
        list7 = trialParts.univFactors;
        list6 = trialParts.ldcfEval;
        list8 = trialParts.ldcfFactors;
        logger.info((Object)("iterations    = " + Math.abs(l)));
        logger.info((Object)("minimal trial = " + trialParts));
        GenPolynomialRing genPolynomialRing4 = genPolynomial7.ring;
        PrimeList primeList = new PrimeList(PrimeList.Range.medium);
        Iterator<BigInteger> iterator = primeList.iterator();
        int n6 = 50;
        edu.jas.arith.BigInteger bigInteger14 = genPolynomial7.leadingBaseCoefficient();
        GenPolynomial<ModLong> genPolynomial14 = null;
        Object var52_90 = null;
        iterable2 = null;
        for (int i = 0; i < 11; ++i) {
            void var48_72;
            comparable = null;
            if (i == 0) {
                primeList = new PrimeList(PrimeList.Range.medium);
                Iterator<BigInteger> iterator2 = primeList.iterator();
            }
            if (i == 5) {
                primeList = new PrimeList(PrimeList.Range.small);
                Iterator<BigInteger> iterator3 = primeList.iterator();
                comparable = iterator3.next();
                comparable = iterator3.next();
                comparable = iterator3.next();
                comparable = iterator3.next();
            }
            if (i == 7) {
                primeList = new PrimeList(PrimeList.Range.large);
                Iterator<BigInteger> iterator4 = primeList.iterator();
            }
            int n7 = 0;
            while (n7 < n6 && var48_72.hasNext()) {
                comparable = (BigInteger)var48_72.next();
                logger.info((Object)("prime = " + comparable));
                iterable = null;
                iterable = ModLongRing.MAX_LONG.compareTo((BigInteger)comparable) > 0 ? new ModLongRing((BigInteger)comparable, true) : new ModIntegerRing((BigInteger)comparable, true);
                gcdRingElem = (GcdRingElem)iterable.fromInteger(bigInteger14.getVal());
                if (gcdRingElem.isZERO() || !this.mfactor.isSquarefree(genPolynomial14 = PolyUtil.fromIntegerCoefficients(iterable2 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable), genPolynomialRing4), genPolynomial7))) continue;
                Iterable<ModLong> iterable4 = iterable;
                break;
            }
            if (var52_91 != null) break;
        }
        if (var52_91 == null) {
            throw new RuntimeException("giving up on Hensel preparation, no lucky prime found");
        }
        logger.info((Object)("lucky prime = " + var52_91.getIntegerModul()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("univariate modulo p: = " + genPolynomial14));
        }
        edu.jas.arith.BigInteger bigInteger15 = genPolynomial3.maxNorm();
        comparable = bigInteger15.multiply(bigInteger.abs()).multiply(new edu.jas.arith.BigInteger(2L));
        long l3 = Power.logarithm(var52_91.getIntegerModul(), comparable) + 1L;
        gcdRingElem = Power.positivePower(var52_91.getIntegerModul(), l3);
        Iterable<ModLong> iterable5 = ModLongRing.MAX_LONG.compareTo(((edu.jas.arith.BigInteger)gcdRingElem).getVal()) > 0 ? new ModLongRing(((edu.jas.arith.BigInteger)gcdRingElem).getVal()) : new ModIntegerRing(((edu.jas.arith.BigInteger)gcdRingElem).getVal());
        GenPolynomialRing<ModLong> genPolynomialRing5 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable5), genPolynomialRing4);
        List list10 = PolyUtil.fromIntegerCoefficients(genPolynomialRing5, list7);
        GenPolynomial<ModLong> genPolynomial15 = PolyUtil.fromIntegerCoefficients(genPolynomialRing5, genPolynomial7);
        if (this.debug && !this.mfactor.isFactorization(genPolynomial15, list10)) {
            System.out.println("muqfactors = " + list10);
            System.out.println("peqq       = " + genPolynomial15);
            throw new RuntimeException("something is wrong, no modular p^k factorization");
        }
        logger.info((Object)("univariate modulo p^k: " + genPolynomial15 + " = " + list10));
        GenPolynomialRing<ModLong> genPolynomialRing6 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable5), genPolynomial3.ring);
        GenPolynomial<ModLong> genPolynomial16 = PolyUtil.fromIntegerCoefficients(genPolynomialRing6, genPolynomial3);
        logger.info((Object)("multivariate modulo p^k: " + genPolynomial16));
        try {
            list = HenselMultUtil.liftHensel(genPolynomial3, genPolynomial16, list10, list9, l3, list8);
            logger.info((Object)("mlift = " + list));
        }
        catch (NoLiftingException noLiftingException) {
            ArrayList arrayList7 = new ArrayList();
            throw new RuntimeException(noLiftingException);
        }
        catch (ArithmeticException arithmeticException) {
            ArrayList arrayList8 = new ArrayList();
            throw arithmeticException;
        }
        if (list.size() <= 1) {
            logger.info((Object)("modular lift size == 1: " + list));
            list2.add(genPolynomial3);
            if (list3 != null) {
                list3.addAll(list2);
                list2 = list3;
            }
            return list2;
        }
        GenPolynomialRing genPolynomialRing7 = list.get((int)0).ring;
        int n8 = (list.size() + 1) / 2;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial17 = genPolynomial;
        long l4 = (genPolynomial17.degree() + 1L) / 2L;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial18 = genPolynomial3;
        block22: for (int i = 1; i <= n8; ++i) {
            KsubSet<GenPolynomial<ModLong>> ksubSet = new KsubSet<GenPolynomial<ModLong>>(list, i);
            for (List<GenPolynomial<ModLong>> list11 : ksubSet) {
                GenPolynomial<ModLong> genPolynomial19 = Power.multiply(genPolynomialRing7, list11);
                if (genPolynomial19.degree() > l4) {
                    logger.info((Object)("degree > deg " + l4 + ", degree = " + genPolynomial19.degree()));
                }
                GenPolynomial<edu.jas.arith.BigInteger> genPolynomial20 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial19);
                genPolynomial20 = this.engine.basePrimitivePart(genPolynomial20);
                if (this.debug) {
                    logger.info((Object)("trial    = " + genPolynomial20));
                }
                if (!PolyUtil.baseSparsePseudoRemainder(genPolynomial18, genPolynomial20).isZERO()) continue;
                logger.info((Object)("successful trial = " + genPolynomial20));
                list2.add(genPolynomial20);
                genPolynomial18 = PolyUtil.basePseudoDivide(genPolynomial18, genPolynomial20);
                list = FactorInteger.removeOnce(list, list11);
                logger.info((Object)("new mlift= " + list));
                if (list.size() > 1) {
                    n8 = (list.size() + 1) / 2;
                    i = 0;
                    continue block22;
                }
                logger.info((Object)("last factor = " + genPolynomial18));
                list2.add(genPolynomial18);
                if (list3 != null) {
                    list3.addAll(list2);
                    list2 = list3;
                }
                return this.normalizeFactorization(list2);
            }
        }
        if (!genPolynomial18.isONE() && !genPolynomial18.equals(genPolynomial3)) {
            logger.info((Object)("rest factor = " + genPolynomial18));
            list2.add(genPolynomial18);
        }
        if (list2.size() == 0) {
            logger.info((Object)("irreducible P = " + genPolynomial));
            list2.add(genPolynomial3);
        }
        if (list3 != null) {
            list3.addAll(list2);
            list2 = list3;
        }
        return this.normalizeFactorization(list2);
    }

    boolean testSeparate(List<edu.jas.arith.BigInteger> list, edu.jas.arith.BigInteger bigInteger) {
        int n = 0;
        ArrayList<edu.jas.arith.BigInteger> arrayList = new ArrayList<edu.jas.arith.BigInteger>(list.size());
        for (edu.jas.arith.BigInteger bigInteger2 : list) {
            edu.jas.arith.BigInteger bigInteger3 = bigInteger2.gcd(bigInteger).abs();
            arrayList.add(bigInteger3);
            if (bigInteger3.isONE()) continue;
            ++n;
        }
        return n <= 1;
    }

    boolean isNearlySquarefree(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar >= 0) {
            return this.sengine.isSquarefree(genPolynomial);
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial<GenPolynomial<Object>> genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        GenPolynomial genPolynomial3 = PolyUtil.recursiveDeriviative(genPolynomial2);
        System.out.println("Pr = " + genPolynomial2);
        System.out.println("Ps = " + genPolynomial3);
        GenPolynomial genPolynomial4 = this.engine.recursiveUnivariateGcd(genPolynomial2, genPolynomial3);
        System.out.println("g_m = " + genPolynomial4);
        if (!genPolynomial4.isONE()) {
            return false;
        }
        genPolynomialRing2 = genPolynomialRing.recursive(genPolynomialRing.nvar - 1);
        genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        genPolynomial2 = PolyUtil.switchVariables(genPolynomial2);
        genPolynomial3 = PolyUtil.recursiveDeriviative(genPolynomial2);
        System.out.println("Pr = " + genPolynomial2);
        System.out.println("Ps = " + genPolynomial3);
        genPolynomial4 = this.engine.recursiveUnivariateGcd(genPolynomial2, genPolynomial3);
        System.out.println("g_1 = " + genPolynomial4);
        return genPolynomial4.isONE();
    }
}

