/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbsolute;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorComplex<C extends GcdRingElem<C>>
extends FactorAbsolute<Complex<C>> {
    private static final Logger logger = Logger.getLogger(FactorComplex.class);
    private final boolean debug = logger.isDebugEnabled();
    public final FactorAbstract<AlgebraicNumber<C>> factorAlgeb;
    public final AlgebraicNumberRing<C> afac;

    protected FactorComplex() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorComplex(RingFactory<Complex<C>> ringFactory) {
        this((ComplexRing)ringFactory);
    }

    public FactorComplex(ComplexRing<C> complexRing) {
        super(complexRing);
        this.afac = complexRing.algebraicRing();
        this.factorAlgeb = FactorFactory.getImplementation(this.afac);
    }

    public FactorComplex(ComplexRing<C> complexRing, FactorAbstract<AlgebraicNumber<C>> factorAbstract) {
        super(complexRing);
        this.afac = complexRing.algebraicRing();
        this.factorAlgeb = factorAbstract;
    }

    @Override
    public List<GenPolynomial<Complex<C>>> baseFactorsSquarefree(GenPolynomial<Complex<C>> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<Complex<C>>> arrayList = new ArrayList<GenPolynomial<Complex<C>>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.isONE()) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        ComplexRing complexRing = (ComplexRing)genPolynomialRing.coFac;
        if (!this.afac.ring.coFac.equals(complexRing.ring)) {
            throw new IllegalArgumentException("coefficient rings do not match");
        }
        Complex<C> complex = genPolynomial.leadingBaseCoefficient();
        if (!complex.isONE()) {
            genPolynomial = genPolynomial.monic();
            arrayList.add(((GenPolynomial)genPolynomialRing.getONE()).multiply(complex));
        }
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(this.afac, genPolynomialRing);
        GenPolynomial genPolynomial2 = PolyUtil.algebraicFromComplex(genPolynomialRing2, genPolynomial);
        List list = this.factorAlgeb.baseFactorsSquarefree(genPolynomial2);
        if (this.debug) {
            logger.info((Object)("complex afactors = " + list));
        }
        for (GenPolynomial genPolynomial3 : list) {
            GenPolynomial genPolynomial4 = PolyUtil.complexFromAlgebraic(genPolynomialRing, genPolynomial3);
            arrayList.add(genPolynomial4);
        }
        return arrayList;
    }
}

